/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency.dialog;

import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.openmbee.mpspi.exceptions.MPIllegalStateException;

public class TwcTaskProgressDialog
implements Runnable {
    public Logger LOGGER = Logger.getLogger(TwcTaskProgressDialog.class);
    private Shell shell;
    private Display display;
    private String message;
    private String image;
    private volatile boolean exit = false;
    private volatile boolean needToUpdate = false;
    private boolean leavingDialogBox = false;
    private Composite mainComposite;

    public TwcTaskProgressDialog(String message) {
        this.message = message;
    }

    public synchronized Display getDisplay() {
        if (this.display != null) {
            return this.display;
        }
        Thread th = Thread.currentThread();
        this.display = Display.findDisplay((Thread)th);
        if (this.display == null) {
            this.display = new Display();
        }
        return this.display;
    }

    private Shell createShell(Display display) {
        Shell parent = new Shell(this.getDisplay(), 147473);
        this.shell = new Shell(parent);
        InputStream icon = this.getClass().getResourceAsStream("MBSE-Icon-01.png");
        Image iconImage = new Image((Device)this.getDisplay(), icon);
        this.shell.setImage(iconImage);
        this.shell.setText("MapleMBSE");
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TwcTaskProgressDialog.this.stop();
            }
        });
        return this.shell;
    }

    public Shell getShell() {
        if (this.shell == null) {
            this.createShell(this.getDisplay());
        }
        return this.shell;
    }

    private void destoryShell() {
        this.shell.dispose();
    }

    @Override
    public void run() {
        this.open();
        while (!this.exit) {
            if (this.needToUpdate) {
                this.updateShell();
            }
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.close();
        this.leavingDialogBox = true;
    }

    private void updateShell() {
        try {
            this.mainComposite.setVisible(false);
            this.createSecondComposite(this.getDisplay(), this.getShell(), this.message, this.image);
            this.getShell().setSize(360, 115);
        }
        catch (MPIllegalStateException e) {
            this.LOGGER.error((Object)e);
        }
        this.needToUpdate = false;
    }

    public void stop() {
        this.exit = true;
        this.wakeDisplay();
    }

    public boolean isExit() {
        return this.exit;
    }

    private synchronized void open() {
        Shell shell = this.getShell();
        this.singleMessageDialogBoxAutoClose(this.message, "circle.png");
        shell.open();
    }

    public void wakeDisplay() {
        Display display = this.getDisplay();
        if (display != null) {
            display.wake();
        }
    }

    private void createComposite(Display display, Shell shell, String message, String imageName) throws MPIllegalStateException {
        this.mainComposite = new Composite((Composite)shell, 64);
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        Label imageLbl = new Label(this.mainComposite, 64);
        imageLbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        imageLbl.setImage(this.getImage(display, imageName));
        Label messsageLbl = new Label(this.mainComposite, 64);
        messsageLbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        messsageLbl.setText(message);
    }

    private void createSecondComposite(Display display, Shell shell, String message, String imageName) throws MPIllegalStateException {
        Composite composite = new Composite((Composite)shell, 64);
        FormData fd_composite = new FormData();
        fd_composite.top = new FormAttachment(0);
        fd_composite.left = new FormAttachment(0, 5);
        fd_composite.bottom = new FormAttachment(0, 85);
        fd_composite.right = new FormAttachment(100, -5);
        composite.setLayoutData((Object)fd_composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label imageLbl = new Label(composite, 0);
        GridData gd_imageLbl = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_imageLbl.widthHint = 30;
        gd_imageLbl.heightHint = 45;
        imageLbl.setLayoutData((Object)gd_imageLbl);
        imageLbl.setImage(this.getImage(display, imageName));
        Label messageLbl = new Label(composite, 0);
        GridData gd_lblNewLabel_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_1.heightHint = 15;
        gd_lblNewLabel_1.widthHint = 150;
        messageLbl.setLayoutData((Object)gd_lblNewLabel_1);
        messageLbl.setText(message);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        Button okButton = new Button(composite, 0);
        GridData gd_okButton = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_okButton.verticalIndent = -30;
        gd_okButton.heightHint = 60;
        gd_okButton.widthHint = 129;
        okButton.setLayoutData((Object)gd_okButton);
        okButton.setText("OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcTaskProgressDialog.this.stop();
            }
        });
    }

    private Image getImage(Display display, String name) throws MPIllegalStateException {
        InputStream url = this.getClass().getResourceAsStream("circle.png");
        if (url == null) {
            this.LOGGER.error((Object)"Image resource url is null");
            throw new MPIllegalStateException("unable to find the image in the resource");
        }
        return new Image((Device)display, url);
    }

    public void singleMessageDialogBoxAutoClose(String message, String imageName) {
        try {
            this.getShell().setSize(400, 80);
            this.shell.setLayout((Layout)new FormLayout());
            this.createComposite(this.getDisplay(), this.getShell(), message, imageName);
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e);
            this.destoryShell();
        }
    }

    public void updateShellAndSleepTheMainThread(String message, String imageName, Thread currentThread) {
        this.needToUpdate = true;
        this.message = message;
        this.image = imageName;
        this.wakeDisplay();
        while (!this.leavingDialogBox) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

