/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency.dialog;

import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.TwcUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TwcRevisionBrowser
extends Dialog {
    private static final String C_AUTHOR = "Author";
    private static final String C_BRANCH = "Branch";
    private static final String C_COMMENT = "Comment";
    private static final String C_DATE = "Date";
    private static final String C_VERSION = "Version";
    private static final String DATA_NAME = "originalName";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("MMMM dd, yyyy hh:mm:ss aa");
    private static final SimpleDateFormat rangeFormatter = new SimpleDateFormat("yyyy/MM/dd");
    private static Map<UUID, String> branchNames;
    private static TableColumn sortedColumn;
    private static SortedKind sortedKind;
    private FilterComposite filterComposite;
    private int highRevision;
    private int lowRevision = 1;
    private Date[] range = new Date[2];
    private String result = "--head--";
    private Button selectButton;
    private Shell shell;
    private Table table;
    private TableViewer tableViewer;
    private List<String> users;
    private static final Map<String, SortedKind> defaultValues;
    private static final Map<String, ViewerComparator> comparators;
    private static final ViewerComparator authorComparator;
    private static final ViewerComparator branchComparator;
    private static final ViewerComparator commentComparator;
    private static final ViewerComparator dateComparator;
    private static final ViewerComparator revisionComparator;
    private static final BiFunction<Object, Object, Integer> revisionDescendingComparison;
    private SelectionAdapter sortColumnAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (sortedColumn == null) {
                sortedColumn = (TableColumn)widget;
                sortedKind = defaultValues.get(sortedColumn.getText());
            } else if (sortedColumn != widget) {
                sortedColumn.setText((String)sortedColumn.getData(TwcRevisionBrowser.DATA_NAME));
                sortedColumn = (TableColumn)widget;
                sortedKind = defaultValues.get(sortedColumn.getText());
            } else {
                sortedKind = sortedKind == SortedKind.DESC ? SortedKind.ASC : SortedKind.DESC;
            }
            String name = (String)sortedColumn.getData(TwcRevisionBrowser.DATA_NAME);
            sortedColumn.setText(name + " " + sortedKind.getSymbol());
            TwcRevisionBrowser.this.tableViewer.setComparator(comparators.get(name));
            TwcRevisionBrowser.this.tableViewer.refresh();
        }
    };

    public TwcRevisionBrowser(Shell parent, int style) {
        super(parent, style);
    }

    public Object open(String project, Set<Object> revisions, Map<UUID, Object> branches, List<String> users) {
        branchNames = new HashMap<UUID, String>();
        for (Map.Entry<UUID, Object> entry : branches.entrySet()) {
            branchNames.put(entry.getKey(), TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getName, entry.getValue(), new Object[0]));
        }
        this.users = users;
        this.createContents(revisions, project);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents(Set<Object> revisions, String project) {
        this.shell = new Shell(this.getParent().getDisplay(), this.getStyle() | 0x860);
        this.shell.setSize(650, 650);
        this.shell.setText("Revision Browser");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Label lblNewLabel = new Label((Composite)this.shell, 0);
        lblNewLabel.setBackground(Display.getCurrent().getSystemColor(1));
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNewLabel.setText("Please select a revision from " + project);
        Group grpProject = new Group((Composite)this.shell, 0);
        grpProject.setText(project);
        grpProject.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpProject.setLayout((Layout)new GridLayout(1, false));
        this.filterComposite = new FilterComposite((Composite)grpProject, 2048);
        this.filterComposite.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        Composite tableComposite = new Composite((Composite)grpProject, 2048);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(tableComposite, 66304);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TwcRevisionBrowser.this.result = TwcRevisionBrowser.this.table.getItem(TwcRevisionBrowser.this.table.getSelectionIndex()).getText(0);
                TwcRevisionBrowser.this.shell.close();
            }
        });
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tblclmnNewColumn.addSelectionListener((SelectionListener)this.sortColumnAdapter);
        tblclmnNewColumn.setText(C_VERSION);
        tblclmnNewColumn.setData(DATA_NAME, (Object)C_VERSION);
        tableLayout.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(1, 65, false));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, element, new Object[0]));
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
        tblclmnNewColumn_1.addSelectionListener((SelectionListener)this.sortColumnAdapter);
        tblclmnNewColumn_1.setText(C_BRANCH);
        tblclmnNewColumn_1.setData(DATA_NAME, (Object)C_BRANCH);
        tableLayout.setColumnData((Widget)tblclmnNewColumn_1, (ColumnLayoutData)new ColumnWeightData(2, 100, false));
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                UUID id = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getBranchID, element, new Object[0]);
                return branchNames.get(id);
            }
        });
        final ArrayList<String> usertmp = new ArrayList<String>();
        usertmp.addAll(Arrays.asList(this.filterComposite.authorCombo.getItems()));
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
        tblclmnNewColumn_2.addSelectionListener((SelectionListener)this.sortColumnAdapter);
        tblclmnNewColumn_2.setText(C_AUTHOR);
        tblclmnNewColumn_2.setData(DATA_NAME, (Object)C_AUTHOR);
        tableLayout.setColumnData((Widget)tblclmnNewColumn_2, (ColumnLayoutData)new ColumnWeightData(2, 85, false));
        tableViewerColumn_2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String ss = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getAuthor, element, new Object[0]);
                if (!usertmp.contains(ss.toString())) {
                    TwcRevisionBrowser.this.filterComposite.authorCombo.add(ss.toString());
                    usertmp.add(ss.toString());
                }
                return ss.toString();
            }
        });
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
        tblclmnNewColumn_3.addSelectionListener((SelectionListener)this.sortColumnAdapter);
        tblclmnNewColumn_3.setText(C_DATE);
        tblclmnNewColumn_3.setData(DATA_NAME, (Object)C_DATE);
        tableLayout.setColumnData((Widget)tblclmnNewColumn_3, (ColumnLayoutData)new ColumnWeightData(3, 150, false));
        tableViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Date date = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getCreatedDate, element, new Object[0]);
                return dateFormatter.format(date);
            }
        });
        TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
        tblclmnNewColumn_4.addSelectionListener((SelectionListener)this.sortColumnAdapter);
        tblclmnNewColumn_4.setText(C_COMMENT);
        tblclmnNewColumn_4.setData(DATA_NAME, (Object)C_COMMENT);
        tableLayout.setColumnData((Widget)tblclmnNewColumn_4, (ColumnLayoutData)new ColumnWeightData(3, 150, true));
        tableViewerColumn_4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getDescription, element, new Object[0]);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setComparator(revisionComparator);
        this.tableViewer.setInput(revisions);
        this.highRevision = Integer.valueOf(this.table.getItem(0).getText(0));
        this.filterComposite.highSpinner.setMaximum(this.highRevision);
        this.filterComposite.lowSpinner.setMaximum(this.highRevision);
        this.filterComposite.highSpinner.setSelection(this.highRevision);
        Composite footer = new Composite((Composite)this.shell, 0);
        footer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        footer.setLayout((Layout)new FormLayout());
        this.selectButton = new Button(footer, 0);
        Button cancelButton = new Button(footer, 0);
        FormData fd_btnNewButton = new FormData(65, 25);
        fd_btnNewButton.right = new FormAttachment((Control)cancelButton, -5);
        this.selectButton.setLayoutData((Object)fd_btnNewButton);
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TwcRevisionBrowser.this.table.getSelectionIndex();
                if (index != -1) {
                    TableItem item = TwcRevisionBrowser.this.table.getItem(index);
                    TwcRevisionBrowser.this.result = item.getText(0);
                    TwcRevisionBrowser.this.shell.close();
                    return;
                }
                TwcRevisionBrowser.this.result = "--head--";
            }
        });
        this.selectButton.setText("OK");
        this.selectButton.setEnabled(false);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcRevisionBrowser.this.selectButton.setEnabled(true);
            }
        });
        FormData fd_btnNewButton_1 = new FormData(65, 25);
        fd_btnNewButton_1.right = new FormAttachment(100, -5);
        cancelButton.setLayoutData((Object)fd_btnNewButton_1);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcRevisionBrowser.this.shell.close();
            }
        });
        cancelButton.setText("Cancel");
    }

    private String getStringRange(Date[] range) {
        if (range.length != 2) {
            throw new IllegalArgumentException("Range should have 2 dates");
        }
        return String.format("from: %s, to: %s", rangeFormatter.format(range[0]), rangeFormatter.format(range[1]));
    }

    static {
        sortedKind = SortedKind.NONE;
        defaultValues = new HashMap<String, SortedKind>(){
            private static final long serialVersionUID = -1401019242675870913L;
            {
                this.put(TwcRevisionBrowser.C_VERSION, SortedKind.DESC);
                this.put(TwcRevisionBrowser.C_BRANCH, SortedKind.ASC);
                this.put(TwcRevisionBrowser.C_AUTHOR, SortedKind.ASC);
                this.put(TwcRevisionBrowser.C_DATE, SortedKind.DESC);
                this.put(TwcRevisionBrowser.C_COMMENT, SortedKind.ASC);
            }
        };
        revisionDescendingComparison = (e1, e2) -> {
            long r1 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, e1, new Object[0]);
            long r2 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, e2, new Object[0]);
            return Long.compare(r2, r1);
        };
        authorComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int i;
                String a1 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getAuthor, e1, new Object[0]);
                String a2 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getAuthor, e2, new Object[0]);
                int n = i = sortedKind == SortedKind.DESC ? a2.compareTo(a1) : a1.compareTo(a2);
                if (i != 0) {
                    return i;
                }
                return revisionDescendingComparison.apply(e1, e2);
            }
        };
        branchComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int i;
                UUID id1 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getBranchID, e1, new Object[0]);
                UUID id2 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getBranchID, e2, new Object[0]);
                String b1 = branchNames.get(id1);
                String b2 = branchNames.get(id2);
                int n = i = sortedKind == SortedKind.DESC ? b2.compareTo(b1) : b1.compareTo(b2);
                if (i != 0) {
                    return i;
                }
                return revisionDescendingComparison.apply(e1, e2);
            }
        };
        commentComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int i;
                String d1 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getDescription, e1, new Object[0]);
                String d2 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getDescription, e2, new Object[0]);
                int n = i = sortedKind == SortedKind.DESC ? d2.compareTo(d1) : d1.compareTo(d2);
                if (i != 0) {
                    return i;
                }
                return revisionDescendingComparison.apply(e1, e2);
            }
        };
        dateComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Date d1 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getCreatedDate, e1, new Object[0]);
                Date d2 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getCreatedDate, e2, new Object[0]);
                return sortedKind == SortedKind.ASC ? d1.compareTo(d2) : d2.compareTo(d1);
            }
        };
        revisionComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                long r1 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, e1, new Object[0]);
                long r2 = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, e2, new Object[0]);
                return sortedKind == SortedKind.ASC ? Long.compare(r1, r2) : Long.compare(r2, r1);
            }
        };
        comparators = new HashMap<String, ViewerComparator>(){
            private static final long serialVersionUID = 7850652503611645662L;
            {
                this.put(TwcRevisionBrowser.C_VERSION, revisionComparator);
                this.put(TwcRevisionBrowser.C_BRANCH, branchComparator);
                this.put(TwcRevisionBrowser.C_AUTHOR, authorComparator);
                this.put(TwcRevisionBrowser.C_DATE, dateComparator);
                this.put(TwcRevisionBrowser.C_COMMENT, commentComparator);
            }
        };
    }

    private class FilterComposite
    extends Composite {
        private Combo authorCombo;
        private Combo branchCombo;
        private Text commentText;
        private Text dateText;
        private Spinner lowSpinner;
        private Spinner highSpinner;

        public FilterComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(2, false));
            Label versionLabel = new Label((Composite)this, 0);
            versionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            versionLabel.setText(TwcRevisionBrowser.C_VERSION);
            Composite spinnerComposite = new Composite((Composite)this, 0);
            spinnerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            spinnerComposite.setLayout((Layout)new GridLayout(4, false));
            Label versionLabel_from = new Label(spinnerComposite, 0);
            versionLabel_from.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            versionLabel_from.setText("from");
            this.lowSpinner = new Spinner(spinnerComposite, 0);
            this.lowSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.lowSpinner.setSelection(1);
            this.lowSpinner.setMinimum(1);
            this.lowSpinner.setDigits(0);
            this.lowSpinner.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    TwcRevisionBrowser.this.lowRevision = FilterComposite.this.lowSpinner.getSelection();
                    FilterComposite.this.highSpinner.setMinimum(TwcRevisionBrowser.this.lowRevision);
                    if (TwcRevisionBrowser.this.highRevision < TwcRevisionBrowser.this.lowRevision) {
                        TwcRevisionBrowser.this.highRevision = TwcRevisionBrowser.this.lowRevision;
                        FilterComposite.this.highSpinner.setSelection(TwcRevisionBrowser.this.lowRevision);
                    }
                }
            });
            Label versionLabel_to = new Label(spinnerComposite, 0);
            versionLabel_to.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            versionLabel_to.setText("to");
            this.highSpinner = new Spinner(spinnerComposite, 0);
            this.highSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.highSpinner.setMinimum(1);
            this.highSpinner.setDigits(0);
            this.highSpinner.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    TwcRevisionBrowser.this.highRevision = FilterComposite.this.highSpinner.getSelection();
                    FilterComposite.this.lowSpinner.setMaximum(TwcRevisionBrowser.this.highRevision);
                    if (TwcRevisionBrowser.this.lowRevision > TwcRevisionBrowser.this.highRevision) {
                        TwcRevisionBrowser.this.lowRevision = TwcRevisionBrowser.this.highRevision;
                        FilterComposite.this.lowSpinner.setSelection(TwcRevisionBrowser.this.highRevision);
                    }
                }
            });
            Label lblNewLabel = new Label((Composite)this, 0);
            lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblNewLabel.setText(TwcRevisionBrowser.C_BRANCH);
            this.branchCombo = new Combo((Composite)this, 0);
            GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
            gd_combo.minimumWidth = 100;
            this.branchCombo.setLayoutData((Object)gd_combo);
            for (Map.Entry<UUID, String> entry : branchNames.entrySet()) {
                this.branchCombo.add(entry.getValue());
            }
            Label lblNewLabel_1 = new Label((Composite)this, 0);
            lblNewLabel_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblNewLabel_1.setText(TwcRevisionBrowser.C_AUTHOR);
            this.authorCombo = new Combo((Composite)this, 0);
            this.authorCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            TwcRevisionBrowser.this.users.stream().forEach(arg_0 -> ((Combo)this.authorCombo).add(arg_0));
            Label lblNewLabel_2 = new Label((Composite)this, 0);
            lblNewLabel_2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblNewLabel_2.setText(TwcRevisionBrowser.C_DATE);
            this.dateText = new Text((Composite)this, 2056);
            this.dateText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.dateText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    DateRangeDialog dialog = new DateRangeDialog(TwcRevisionBrowser.this.shell, 81920);
                    if (dialog.open()) {
                        FilterComposite.this.dateText.setText(TwcRevisionBrowser.this.getStringRange(TwcRevisionBrowser.this.range));
                    }
                }
            });
            Label lblNewLabel_3 = new Label((Composite)this, 0);
            lblNewLabel_3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblNewLabel_3.setText(TwcRevisionBrowser.C_COMMENT);
            this.commentText = new Text((Composite)this, 2048);
            this.commentText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            new Label((Composite)this, 0);
            Composite buttonComposite = new Composite((Composite)this, 0);
            buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            buttonComposite.setLayout((Layout)new FormLayout());
            Button filterButton = new Button(buttonComposite, 0);
            FormData fd_btnNewButton = new FormData(65, 25);
            fd_btnNewButton.right = new FormAttachment(100);
            filterButton.setLayoutData((Object)fd_btnNewButton);
            filterButton.setText("Filter");
            filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TwcRevisionBrowser.this.tableViewer.resetFilters();
                    if (!FilterComposite.this.authorCombo.getText().isEmpty()) {
                        TwcRevisionBrowser.this.tableViewer.addFilter((ViewerFilter)new AuthorFilter());
                    }
                    if (!FilterComposite.this.branchCombo.getText().isEmpty()) {
                        TwcRevisionBrowser.this.tableViewer.addFilter((ViewerFilter)new BranchFilter());
                    }
                    if (!FilterComposite.this.commentText.getText().isEmpty()) {
                        TwcRevisionBrowser.this.tableViewer.addFilter((ViewerFilter)new CommentFilter(FilterComposite.this.commentText.getText()));
                    }
                    if (TwcRevisionBrowser.this.range[0] != null && TwcRevisionBrowser.this.range[1] != null) {
                        TwcRevisionBrowser.this.tableViewer.addFilter((ViewerFilter)new DateFilter());
                    }
                    if (TwcRevisionBrowser.this.highRevision >= TwcRevisionBrowser.this.lowRevision) {
                        TwcRevisionBrowser.this.tableViewer.addFilter((ViewerFilter)new RevisionFilter());
                    } else {
                        MessageBox error = new MessageBox(TwcRevisionBrowser.this.shell, 65569);
                        error.setText("Error Version Filter");
                        error.setMessage("Version filter ignored, something went wrong");
                    }
                    TwcRevisionBrowser.this.tableViewer.refresh();
                    if (TwcRevisionBrowser.this.table.getSelectionIndex() == -1) {
                        TwcRevisionBrowser.this.selectButton.setEnabled(false);
                    }
                }
            });
            Button resetButton = new Button(buttonComposite, 0);
            FormData fd_btnNewButton_2 = new FormData(65, 25);
            fd_btnNewButton_2.right = new FormAttachment((Control)filterButton, -5);
            resetButton.setLayoutData((Object)fd_btnNewButton_2);
            resetButton.setText("Reset");
            resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterComposite.this.resetRevisionFilter();
                    FilterComposite.this.branchCombo.setText("");
                    FilterComposite.this.authorCombo.setText("");
                    FilterComposite.this.resetDateFilter();
                    FilterComposite.this.commentText.setText("");
                    TwcRevisionBrowser.this.tableViewer.resetFilters();
                    TwcRevisionBrowser.this.table.setSelection(-1);
                    TwcRevisionBrowser.this.selectButton.setEnabled(false);
                    if (sortedColumn != null) {
                        sortedColumn.setText(sortedColumn.getData(TwcRevisionBrowser.DATA_NAME).toString());
                        sortedColumn = null;
                    }
                    sortedKind = SortedKind.NONE;
                    TwcRevisionBrowser.this.tableViewer.setComparator(revisionComparator);
                    TwcRevisionBrowser.this.tableViewer.refresh();
                }
            });
        }

        private void resetRevisionFilter() {
            TwcRevisionBrowser.this.lowRevision = this.lowSpinner.getMinimum();
            TwcRevisionBrowser.this.highRevision = this.highSpinner.getMaximum();
            this.lowSpinner.setSelection(TwcRevisionBrowser.this.lowRevision);
            this.highSpinner.setSelection(TwcRevisionBrowser.this.highRevision);
            this.lowSpinner.setMaximum(TwcRevisionBrowser.this.highRevision);
            this.highSpinner.setMinimum(TwcRevisionBrowser.this.lowRevision);
        }

        private void resetDateFilter() {
            this.dateText.setText("");
            TwcRevisionBrowser.this.range[0] = null;
            TwcRevisionBrowser.this.range[1] = null;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum SortedKind {
        ASC{

            @Override
            char getSymbol() {
                return '\u25b2';
            }
        }
        ,
        DESC{

            @Override
            char getSymbol() {
                return '\u25bc';
            }
        }
        ,
        NONE{

            @Override
            char getSymbol() {
                return '\u0000';
            }
        };


        abstract char getSymbol();
    }

    private class DateRangeDialog
    extends Dialog {
        private SelectionAdapter dateSelectionHandler;
        private DateTime fromDate;
        private Button okButton;
        private Shell shell;
        private Text text;
        private DateTime toDate;
        private boolean valid;
        private Calendar calendar;

        public DateRangeDialog(Shell parent, int style) {
            super(parent, style);
            this.dateSelectionHandler = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateRangeDialog.this.valid = false;
                    DateTime w = (DateTime)e.widget;
                    int index = DateRangeDialog.this.fromDate == w ? 0 : 1;
                    TwcRevisionBrowser.this.range[index] = DateRangeDialog.this.getDate(w, index == 0);
                    DateRangeDialog.this.okButton.setEnabled(TwcRevisionBrowser.this.range[0].compareTo(TwcRevisionBrowser.this.range[1]) <= 0);
                    if (DateRangeDialog.this.okButton.isEnabled()) {
                        DateRangeDialog.this.text.setText(TwcRevisionBrowser.this.getStringRange(TwcRevisionBrowser.this.range));
                    } else {
                        DateRangeDialog.this.text.setText("Invalid range.");
                    }
                }
            };
            this.calendar = Calendar.getInstance();
            this.setText("Pick a range");
        }

        private void createContents() {
            this.shell = new Shell(this.getParent(), this.getStyle() | 0x860);
            this.shell.setSize(310, 175);
            this.shell.setText(this.getText());
            this.shell.setLayout((Layout)new GridLayout(2, false));
            Label fromLabel = new Label((Composite)this.shell, 0x1000010);
            fromLabel.setText("From:");
            this.fromDate = new DateTime((Composite)this.shell, 4);
            this.fromDate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            TwcRevisionBrowser.this.range[0] = this.getDate(this.fromDate, true);
            this.fromDate.addSelectionListener((SelectionListener)this.dateSelectionHandler);
            Label toLabel = new Label((Composite)this.shell, 0x1000010);
            toLabel.setText("To:");
            this.toDate = new DateTime((Composite)this.shell, 4);
            this.toDate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            TwcRevisionBrowser.this.range[1] = this.getDate(this.toDate, false);
            this.toDate.addSelectionListener((SelectionListener)this.dateSelectionHandler);
            this.text = new Text((Composite)this.shell, 2064);
            this.text.setEnabled(false);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.text.setText(TwcRevisionBrowser.this.getStringRange(TwcRevisionBrowser.this.range));
            Composite composite = new Composite((Composite)this.shell, 16);
            composite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 2, 1));
            composite.setLayout((Layout)new FormLayout());
            Button btnNewButton = new Button(composite, 0);
            FormData fd_btnNewButton = new FormData(65, 25);
            fd_btnNewButton.right = new FormAttachment(100);
            btnNewButton.setLayoutData((Object)fd_btnNewButton);
            btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TwcRevisionBrowser.this.range[0] = null;
                    TwcRevisionBrowser.this.range[1] = null;
                    DateRangeDialog.this.shell.close();
                }
            });
            btnNewButton.setText("Cancel");
            this.okButton = new Button(composite, 0);
            FormData fd_btnNewButton_1 = new FormData(65, 25);
            fd_btnNewButton_1.right = new FormAttachment(100, -70);
            this.okButton.setLayoutData((Object)fd_btnNewButton_1);
            this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateRangeDialog.this.valid = true;
                    DateRangeDialog.this.shell.close();
                }
            });
            this.okButton.setText("OK");
        }

        private Date getDate(DateTime dateTime, boolean beggingofDay) {
            if (beggingofDay) {
                this.calendar.set(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0);
            } else {
                this.calendar.set(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 23, 59, 59);
            }
            long time = this.calendar.getTimeInMillis();
            return new Date(time);
        }

        public boolean open() {
            Display display = this.getParent().getDisplay();
            this.createContents();
            this.shell.open();
            this.shell.layout();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.valid;
        }
    }

    private class RevisionFilter
    extends ViewerFilter {
        private RevisionFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Long revision = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, element, new Object[0]);
            int r = revision.intValue();
            return r <= TwcRevisionBrowser.this.highRevision && r >= TwcRevisionBrowser.this.lowRevision;
        }
    }

    private class DateFilter
    extends ViewerFilter {
        private DateFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Date date = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getCreatedDate, element, new Object[0]);
            return TwcRevisionBrowser.this.range[0].before(date) && TwcRevisionBrowser.this.range[1].after(date);
        }
    }

    private class CommentFilter
    extends ViewerFilter {
        Pattern pattern;

        private CommentFilter(String text) {
            this.pattern = Pattern.compile("^.*" + text + ".*$");
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String description = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getDescription, element, new Object[0]);
            return this.pattern.matcher(description).matches();
        }
    }

    private class BranchFilter
    extends ViewerFilter {
        private BranchFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            UUID id = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getBranchID, element, new Object[0]);
            return branchNames.get(id).equals(TwcRevisionBrowser.this.filterComposite.branchCombo.getText());
        }
    }

    private class AuthorFilter
    extends ViewerFilter {
        private AuthorFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String author = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getAuthor, element, new Object[0]);
            return TwcRevisionBrowser.this.filterComposite.authorCombo.getText().equals(author.toString());
        }
    }
}

