/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency.dialog;

import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import java.util.Observable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TwcReloadDialog
implements TwcDialog {
    private static final int LSPAN = 1;
    private static final int MSPAN = 3;
    private static final int BSPAN = 2;
    private boolean applyChanges = true;
    private boolean cancel = false;
    private boolean localSave = false;
    private Button localSaveCheckBox = null;
    private Button okButton;
    private Shell shell;
    private String shellTitle;
    private final boolean update;

    public TwcReloadDialog(boolean update) {
        this.update = update;
    }

    public boolean isApplyChanges() {
        return this.applyChanges;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean isLocalSave() {
        return this.localSave;
    }

    public Shell open(Display display, Observable o) {
        this.shell = new Shell(display, 147504);
        GridLayout layout = new GridLayout(4, true);
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 5;
        this.shell.setLayout((Layout)layout);
        this.shell.setText(this.update ? "Update" : "Reload");
        this.initW();
        this.shell.setSize(305, 195);
        this.shell.setDefaultButton(this.okButton);
        this.shell.open();
        this.shell.setActive();
        return this.shell;
    }

    private void initW() {
        Label label = new Label((Composite)this.shell, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 4, 1));
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        final Button mergeOrSnapshot = new Button((Composite)group, 32);
        label.setText(MessageUtil.msg((MessageEnum)(this.update ? MessageEnum.UPDATE : MessageEnum.RELOAD_SNAP)));
        group.setLayout((Layout)new GridLayout(this.update ? 1 : 2, this.update));
        mergeOrSnapshot.setText(this.update ? "Update model with local changes" : "Apply local saved changes");
        if (this.update) {
            this.localSaveCheckBox = new Button((Composite)group, 32);
            this.localSaveCheckBox.setText("Save current work");
            this.localSaveCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        } else {
            mergeOrSnapshot.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        }
        mergeOrSnapshot.setSelection(true);
        Button okButton = new Button((Composite)this.shell, 0);
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        okButton.setText("Ok");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcReloadDialog.this.applyChanges = mergeOrSnapshot.getSelection();
                if (TwcReloadDialog.this.localSaveCheckBox != null) {
                    TwcReloadDialog.this.localSave = TwcReloadDialog.this.localSaveCheckBox.getSelection();
                }
                TwcReloadDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button((Composite)this.shell, 0);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcReloadDialog.this.cancel = true;
                TwcReloadDialog.this.shell.close();
            }
        });
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        cancelButton.setText("Cancel");
    }
}

