/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency.dialog;

import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcParameters;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialogManager;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.dialog.TwcRevisionBrowser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class TwcLoginDialog
implements TwcDialog,
Observer {
    private static TwcLoginDialog instance;
    private static final String REVISION_HEAD = "--head--";
    public static final Logger LOGGER;
    private static final int LSPAN = 1;
    private static final int MSPAN = 3;
    private static final int RSPAN = 1;
    private static final int BSPAN = 2;
    private static final int TOTALSPAN = 5;
    private final TwcAdapter adapter;
    private Button cacheCheckBox;
    private Button cancelButton;
    private Button sso;
    private Combo cBranch;
    private Combo cCategory;
    private Combo cProject;
    private String currentBranch;
    private Label hLabel;
    private Button okButton;
    private String previousBranch;
    private Button saveSettingCheckbox;
    private Shell shell;
    private Button sslCheckbox;
    private Text tHostPort;
    private Text tPassword;
    private Text tRevision;
    private Text tUsername;
    private String token;

    private TwcLoginDialog(TwcAdapter adapter) {
        this.adapter = adapter;
    }

    private Combo addComboField(Shell shell, String title, boolean fill) {
        this.addLabel(title);
        int span = fill ? 4 : 3;
        GridData gdT = new GridData(4, 0x1000000, true, true, span, 1);
        Combo combo = new Combo((Composite)shell, 2052);
        combo.setLayoutData((Object)gdT);
        if ("Branch:".equals(title)) {
            combo.addListener(15, event -> {
                this.previousBranch = this.cBranch.getText();
            });
            combo.addListener(16, event -> {
                if (!this.previousBranch.equals(this.cBranch.getText())) {
                    this.tRevision.setText(REVISION_HEAD);
                }
                this.tryToLogin((Widget)combo);
            });
        } else {
            combo.addListener(16, event -> this.tryToLogin((Widget)combo));
        }
        return combo;
    }

    private void addLabel(String title) {
        if (title != null && !title.trim().equals("")) {
            Label label = new Label((Composite)this.shell, 0);
            label.setText(title);
            GridData gdL = new GridData(16384, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gdL);
        }
    }

    private Text addTextField(String title, boolean fill) {
        this.addLabel(title);
        int span = fill ? 4 : 3;
        GridData gdT = new GridData(4, 0x1000000, true, true, span, 1);
        Text text = new Text((Composite)this.shell, 2048);
        text.setLayoutData((Object)gdT);
        text.addListener(16, event -> this.tryToLogin((Widget)text));
        return text;
    }

    private URI getUri(Widget widget) {
        String category;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] segments = new String[]{URI.encodeSegment((String)this.cProject.getText(), (boolean)false)};
        if (widget.equals(this.sso) || this.token != null && !this.token.isEmpty()) {
            map.put("token", this.token);
        } else {
            map.put("username", this.tUsername.getText());
            map.put("password", this.tPassword.getText());
            this.token = null;
        }
        map.put("settings_saved", String.valueOf(this.saveSettingCheckbox.getSelection()));
        map.put("cache", String.valueOf(this.cacheCheckBox.getSelection()));
        map.put("ssl", this.sslCheckbox.getSelection() ? "cert" : "");
        boolean unspecified = "UNSPECIFIED".equals(this.cBranch.getText());
        if (this.cCategory.equals(widget)) {
            category = this.cCategory.getText();
            map.put("category", category);
        }
        if (this.okButton.equals(widget)) {
            category = this.cCategory.getText();
            map.put("category", category);
        }
        if (this.cProject.equals(widget) && unspecified) {
            map.put("branch", "");
        }
        String r = "-1";
        if (!this.tRevision.getText().isEmpty()) {
            r = this.tRevision.getText();
        }
        if (this.cBranch.equals(widget) && !unspecified) {
            String branch = this.cBranch.getText();
            map.put("branch", branch);
            map.put("revision", branch.equals(this.currentBranch) ? this.tRevision.getText() : "-1");
        } else if (this.tRevision.equals(widget)) {
            map.put("branch", "");
            map.put("revision", r);
        } else if (this.okButton.equals(widget)) {
            map.put("loaded", "vc8bR40mosFmtQxo35eR");
        }
        if (!REVISION_HEAD.equals(this.tRevision.getText()) && !map.containsKey("revision")) {
            map.put("revision", r);
        } else if (!map.containsKey("revision")) {
            map.put("revision", "-1");
        }
        if (!map.containsKey("branch")) {
            map.put("branch", this.cBranch.getText());
        }
        return URI.createHierarchicalURI((String)"twc", (String)this.tHostPort.getText(), null, (String[])segments, (String)TwcLoginDialog.mapToQuery(map), null);
    }

    private void initW() {
        this.hLabel = new Label((Composite)this.shell, 2112);
        this.hLabel.setLayoutData((Object)new GridData(4, 4, true, true, 5, 2));
        this.tHostPort = this.addTextField("Server:", false);
        this.tHostPort.addListener(15, event -> this.tHostPort.setData("currentHostPort", (Object)this.tHostPort.getText()));
        this.tHostPort.addListener(16, event -> {
            String hh = this.tHostPort.getData("currentHostPort").toString();
            if (!hh.equals(this.tHostPort.getText())) {
                this.tPassword.setEnabled(true);
                this.tUsername.setEnabled(true);
            }
        });
        this.sslCheckbox = new Button((Composite)this.shell, 32);
        this.sslCheckbox.setText("Use SSL");
        this.sslCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcLoginDialog.this.tryToLogin((Widget)TwcLoginDialog.this.sslCheckbox);
            }
        };
        this.sslCheckbox.addSelectionListener((SelectionListener)sl);
        this.tUsername = this.addTextField("Username:", false);
        this.sso = new Button((Composite)this.shell, 0);
        this.sso.setText("Single Sign-On");
        this.sso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TwcLoginDialog.this.tPassword.isEnabled()) {
                    TwcLoginDialog.this.tUsername.setEnabled(true);
                    TwcLoginDialog.this.tPassword.setEnabled(true);
                    TwcLoginDialog.this.token = null;
                    TwcLoginDialog.this.tryToLogin(e.widget);
                } else if (TwcLoginDialog.this.tHostPort.getText() != null && !TwcLoginDialog.this.tHostPort.getText().isEmpty()) {
                    InternalBrowser browser = new InternalBrowser(TwcLoginDialog.this.shell, 81920, TwcLoginDialog.this.tHostPort.getText().split(":")[0]);
                    TwcLoginDialog.this.token = browser.open();
                    TwcLoginDialog.this.tryToLogin(e.widget);
                    TwcLoginDialog.this.tUsername.setEnabled(TwcLoginDialog.this.token == null);
                    TwcLoginDialog.this.tPassword.setEnabled(TwcLoginDialog.this.token == null);
                }
            }
        });
        if (TwcDependencyConstants.SessionConfigurator != null) {
            this.sso.setEnabled(true);
        } else {
            this.sso.setEnabled(false);
        }
        this.tPassword = this.addTextField("Password:", false);
        this.tPassword.setEchoChar('*');
        this.cacheCheckBox = new Button((Composite)this.shell, 32);
        this.cacheCheckBox.setText("Use Cache");
        this.cacheCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.cProject = this.addComboField(this.shell, "Project:", false);
        this.cProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcLoginDialog.this.tryToLogin((Widget)TwcLoginDialog.this.cProject);
            }
        });
        this.cProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TwcLoginDialog.this.cBranch.setText("");
            }
        });
        this.cCategory = new Combo((Composite)this.shell, 0);
        this.cCategory.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.cCategory.addListener(13, event -> this.tryToLogin((Widget)this.cCategory));
        this.cCategory.addListener(16, event -> {
            String category = this.cCategory.getText();
            for (String str : this.cCategory.getItems()) {
                if (!category.equals(str)) continue;
                return;
            }
            this.cProject.setText("");
            this.tryToLogin((Widget)this.cCategory);
        });
        this.cBranch = this.addComboField(this.shell, "Branch:", false);
        this.cBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String n1 = e.text;
                String n2 = TwcLoginDialog.this.cBranch.getText();
                if (Objects.equals(n1, n2)) {
                    return;
                }
                TwcLoginDialog.this.tRevision.setText(TwcLoginDialog.REVISION_HEAD);
            }
        });
        Composite revisionComposite = new Composite((Composite)this.shell, 2048);
        GridLayout layoutRevision = new GridLayout(2, false);
        layoutRevision.marginHeight = 0;
        layoutRevision.marginWidth = 0;
        revisionComposite.setLayout((Layout)layoutRevision);
        this.tRevision = new Text(revisionComposite, 2048);
        this.tRevision.setMessage(REVISION_HEAD);
        this.tRevision.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tRevision.addListener(24, event -> {
            String tmp = this.tRevision.getText();
            if (tmp.isEmpty() || REVISION_HEAD.equals(tmp)) {
                return;
            }
            this.tryToLogin((Widget)this.tRevision);
        });
        this.tRevision.addListener(15, event -> {
            if (REVISION_HEAD.equals(this.tRevision.getText())) {
                this.tRevision.setText("");
            }
        });
        this.tRevision.addListener(16, event -> {
            try {
                Long.valueOf(this.tRevision.getText());
            }
            catch (Exception e) {
                this.tRevision.setText(REVISION_HEAD);
            }
            this.currentBranch = this.cBranch.getText();
        });
        Button revisionBrowserButton = new Button(revisionComposite, 1028);
        revisionBrowserButton.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        revisionBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set set = TwcLoginDialog.this.adapter.getAllCommitInfos();
                if (set.isEmpty()) {
                    return;
                }
                Map branches = TwcLoginDialog.this.adapter.getBranches();
                ArrayList<String> users = new ArrayList<String>();
                try {
                    users.add(TwcLoginDialog.this.adapter.getTwcAccess().getActiveUserName());
                }
                catch (Exception ex) {
                    users.add(TwcLoginDialog.this.adapter.getTwcAccess().getActiveUserName());
                }
                TwcRevisionBrowser dialog = new TwcRevisionBrowser(TwcLoginDialog.this.shell, 81920);
                String projectName = URI.decode((String)TwcLoginDialog.this.adapter.getURI().path().replaceAll("/", ""));
                TwcLoginDialog.this.tRevision.setText(dialog.open(projectName, set, branches, users).toString());
            }
        });
        this.okButton = new Button((Composite)this.shell, 0);
        this.okButton.setText("OK");
        this.okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI uri = TwcLoginDialog.this.getUri((Widget)TwcLoginDialog.this.okButton);
                if (TwcLoginDialog.this.saveSettingCheckbox.getSelection()) {
                    TwcLoginDialog.this.adapter.saveSettings(uri);
                }
                TwcLoginDialog.this.adapter.login(uri);
                TwcLoginDialog.this.shell.close();
                instance = null;
            }
        });
        this.cancelButton = new Button((Composite)this.shell, 0);
        this.cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String query = String.format("loaded=%s", "l9qHghjCLEcuh5T0Hoa3");
                String[] segments = new String[]{""};
                TwcLoginDialog.this.adapter.login(URI.createHierarchicalURI((String[])segments, (String)query, (String)""));
                TwcLoginDialog.this.shell.close();
                instance = null;
            }
        });
        this.saveSettingCheckbox = new Button((Composite)this.shell, 32);
        this.saveSettingCheckbox.setText("Save settings");
        this.saveSettingCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
    }

    public Shell open(Display display, Observable o) {
        if (!(o instanceof TwcParameters)) {
            throw new IllegalArgumentException();
        }
        TwcParameters param = (TwcParameters)o;
        this.shell = new Shell(display, 81968);
        GridLayout layout = new GridLayout(5, true);
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 5;
        this.shell.setLayout((Layout)layout);
        this.shell.setText("Log in to Teamwork Cloud");
        this.initW();
        try {
            this.update((Observable)param, null);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while updating log dialog." + e.getMessage()));
        }
        this.shell.setSize(500, 330);
        this.shell.setDefaultButton(this.okButton);
        this.shell.open();
        this.shell.setActive();
        return this.shell;
    }

    private void setMessage(String mes) {
        if (this.hLabel != null) {
            this.hLabel.setText(mes);
        }
    }

    private void tryToLogin(Widget widget) {
        this.adapter.login(this.getUri(widget));
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(o instanceof TwcParameters)) {
            throw new IllegalArgumentException();
        }
        TwcParameters params = (TwcParameters)o;
        this.setMessage(params.getMessage());
        String tmp = String.format("%s:%s", params.getHost(), params.getPort());
        if (this.tHostPort == null || this.tUsername == null || this.tPassword == null || this.cProject == null || this.cBranch == null) {
            return;
        }
        this.tHostPort.setText(tmp);
        tmp = TwcLoginDialog.getValueOrDefault(params.getUsername());
        this.tUsername.setText(tmp);
        tmp = TwcLoginDialog.getValueOrDefault(params.getPassword());
        this.tPassword.setText(tmp);
        if (params.isProjectListUpdated()) {
            this.cProject.removeAll();
            tmp = TwcLoginDialog.getValueOrDefault(params.getProject());
            this.cProject.setText(tmp);
            for (String project : params.getProjectList()) {
                this.cProject.add(project);
            }
        } else if (params.getProjectList().isEmpty() && params.getProject() != null && !params.getProject().isEmpty()) {
            tmp = TwcLoginDialog.getValueOrDefault(params.getProject());
            this.cProject.setText(tmp);
        }
        if (params.isCategoryListUpdated()) {
            this.cCategory.removeAll();
            ArrayList categorytList = new ArrayList(params.getCategorytList());
            boolean isUncategorizedNeeded = categorytList.remove("Uncategorized");
            this.cCategory.setItems(categorytList.toArray(new String[categorytList.size()]));
            if (isUncategorizedNeeded) {
                this.cCategory.add("Uncategorized");
            }
            this.cCategory.add("");
        }
        tmp = params.getBranch();
        this.cBranch.removeAll();
        this.cBranch.setText(tmp);
        for (String branch : params.getBranchList()) {
            this.cBranch.add(branch);
        }
        if (!this.tRevision.isFocusControl()) {
            long revision = params.getRevision();
            String string = tmp = revision > 0L ? String.valueOf(revision) : REVISION_HEAD;
            if (!tmp.equals(this.tRevision.getText())) {
                this.tRevision.setText(tmp);
            }
        }
        this.sslCheckbox.setSelection(params.isSSLEnabled());
        this.cacheCheckBox.setSelection(params.isCacheEnabled());
        this.okButton.setEnabled(params.isLoaded());
        this.saveSettingCheckbox.setSelection(params.isSettingsSaved());
        if ("UNSPECIFIED".equals(params.getBranch())) {
            this.setMessage(MessageUtil.msg((MessageEnum)MessageEnum.SELECTED_REVISION_DOESNOT_EXIST, (Object[])new Object[]{params.getRevision()}));
        }
        tmp = TwcLoginDialog.getValueOrDefault(params.getCatergory());
        this.cCategory.setText(tmp);
    }

    public static TwcLoginDialog getInstance(TwcAdapter adapter) {
        if (instance == null) {
            instance = new TwcLoginDialog(adapter);
        } else if (!TwcLoginDialog.instance.adapter.equals(adapter)) {
            throw new IllegalArgumentException("An adapter change was detected.");
        }
        return instance;
    }

    private static String getValueOrDefault(String value) {
        return value == null ? "" : value;
    }

    private static String mapToQuery(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            sb.append(String.format("%s=%s&", entry.getKey(), URI.encodeQuery((String)value, (boolean)false)));
        }
        if (!map.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void restart() {
        instance = null;
    }

    static {
        LOGGER = Logger.getLogger(TwcLoginDialog.class);
    }

    private class InternalBrowser
    extends Dialog {
        private final String url;
        private final String redirectURL1 = "https:%2F%2Fmd_redirect";
        private final String redirectURL2 = "https://md_redirect";
        private Shell interanlBrowserShell;

        public InternalBrowser(Shell shell, int style, String url) {
            super(shell, style);
            this.redirectURL1 = "https:%2F%2Fmd_redirect";
            this.redirectURL2 = "https://md_redirect";
            this.url = url;
        }

        private String createLoginUrl(String url) {
            if (!url.contains(":")) {
                url = url.concat(":8555");
            }
            String loginURL = "https://" + url + "/authentication/authorize?scope=openid&response_type=id_token&redirect_uri=https:%2F%2Fmd_redirect&client_id=MAGICDRAW";
            return loginURL;
        }

        public String open() {
            this.createContents();
            return TwcLoginDialog.this.token;
        }

        private void createContents() {
            block16: {
                String defaultBrowserType = System.getProperty("com.maplesoft.maplembse.special.twc.dependency.browser");
                if (defaultBrowserType == null) {
                    TwcDialogManager dialogManager = new TwcDialogManager();
                    dialogManager.messageBoxErr("Please set the Browser in the OSGiBridge.ini file");
                    LOGGER.error((Object)"Please set the Browser in the OSGiBridge.ini file");
                    return;
                }
                if (defaultBrowserType.equals("DEFAULT")) {
                    this.openDefaultBrowser();
                } else {
                    try {
                        String driverFile = System.getProperty("com.maplesoft.maplembse.special.twc.dependency.browser.driver");
                        FirefoxDriver driver = null;
                        if (defaultBrowserType.equals("EDGE")) {
                            if (driverFile != null && !driverFile.isEmpty()) {
                                System.setProperty("webdriver.edge.driver", driverFile);
                            }
                            EdgeDriverService service = EdgeDriverService.createDefaultService();
                            EdgeOptions options = new EdgeOptions();
                            driver = new EdgeDriver(service, options);
                        } else if (defaultBrowserType.equals("FIREFOX")) {
                            if (driverFile != null) {
                                System.setProperty("webdriver.gecko.driver", driverFile);
                            }
                            driver = new FirefoxDriver();
                        } else if (defaultBrowserType.equalsIgnoreCase("CHROME")) {
                            System.setProperty("webdriver.chrome.driver", driverFile);
                            driver = new ChromeDriver();
                        } else {
                            throw new RuntimeException("is not supported Browser");
                        }
                        driver.get(this.createLoginUrl(this.url));
                        WebDriverWait driverWait = new WebDriverWait((WebDriver)driver, 3000L);
                        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

                            public Boolean apply(WebDriver driver) {
                                return driver.getCurrentUrl().startsWith("https://md_redirect") || driver.getTitle().contains("md_redirect") || driver.getCurrentUrl().contains("https://md_redirect/?");
                            }
                        };
                        driverWait.until((Function)condition);
                        String browsreUrl = driver.getCurrentUrl();
                        driver.quit();
                        if (browsreUrl.startsWith("https:%2F%2Fmd_redirect") || browsreUrl.startsWith("https://md_redirect")) {
                            java.net.URI url2 = java.net.URI.create(browsreUrl);
                            this.setToken(url2);
                        } else if (browsreUrl.contains("https://md_redirect/?")) {
                            java.net.URI url2 = java.net.URI.create(browsreUrl);
                            url2 = java.net.URI.create(url2.getFragment().toString());
                            this.setToken(url2);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                        if (!(e instanceof WebDriverException) || !e.getMessage().contains("Cannot find firefox binary in PATH. Make sure firefox is installed.") && !e.getMessage().contains("Cannot find chrome binary in PATH. Make sure chrome is installed.")) break block16;
                        TwcDialogManager dialogManager = new TwcDialogManager();
                        dialogManager.messageBoxErr("Unable to find the Browser, Please make sure you have " + defaultBrowserType + " installed");
                    }
                }
            }
        }

        private void openDefaultBrowser() {
            Display display = this.getParent().getDisplay();
            this.interanlBrowserShell = new Shell(this.getParent().getDisplay(), this.getStyle() | 0x10 | 0x40);
            this.interanlBrowserShell.setSize(300, 500);
            this.interanlBrowserShell.setLayout((Layout)new FillLayout());
            final Browser browser = new Browser((Composite)this.interanlBrowserShell, 0);
            Browser.clearSessions();
            GridData layoutData = new GridData(1808);
            layoutData.horizontalSpan = 2;
            layoutData.verticalSpan = 2;
            browser.setLayoutData((Object)layoutData);
            browser.setUrl(this.createLoginUrl(this.url));
            browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                }

                public void changed(LocationEvent event) {
                    String url;
                    if (event.location != null && ((url = event.location.toString()).startsWith("https:%2F%2Fmd_redirect") || url.startsWith("https://md_redirect"))) {
                        java.net.URI url2 = java.net.URI.create(url);
                        InternalBrowser.this.setToken(url2);
                        if (TwcLoginDialog.this.token != null) {
                            InternalBrowser.this.interanlBrowserShell.close();
                        }
                    }
                }
            });
            browser.addListener(524288, new Listener(){

                public void handleEvent(Event event) {
                    String url = browser.getUrl();
                    if (url.equals("https:%2F%2Fmd_redirect") || url.equals("")) {
                        // empty if block
                    }
                }
            });
            this.interanlBrowserShell.open();
            this.interanlBrowserShell.layout();
            while (!this.interanlBrowserShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }

        private void setToken(java.net.URI url2) {
            if (url2.getQuery().contains("id_token=")) {
                String[] parts = url2.getQuery().split("id_token=");
                String[] aa = parts[1].split("&");
                TwcLoginDialog.this.token = aa[0];
            }
        }
    }
}

