/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency.dialog;

import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import java.util.Observable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TwcCommitDialog
implements TwcDialog {
    private static final String HEADING_EMPTY_COMMIT_MESSAGE = MessageUtil.msg((MessageEnum)MessageEnum.COMMIT_DIALOG_EMPTY_COMMIT_MESSAGE_HEADING);
    private static final String HEADING_NORMAL = MessageUtil.msg((MessageEnum)MessageEnum.COMMIT_DIALOG_HEADING);
    private static final String BRANCH_CREATION_NOT_ALLOWED_MESSAGE = MessageUtil.msg((MessageEnum)MessageEnum.BRANCH_CREATION_NOT_ALLOWED);
    private String branchDescription;
    private String branchName;
    private boolean isNewBranch = false;
    private boolean isOkEnabled;
    private boolean keeplocks;
    private String message;
    private String oldBranchName;
    private boolean canCreateBranch;
    private final boolean isMessageOptional;
    private Button branchCheckbox;

    public TwcCommitDialog(boolean canCreateBranch, String branchName, boolean isMessageOptional) {
        this.canCreateBranch = canCreateBranch;
        this.oldBranchName = branchName;
        this.isMessageOptional = isMessageOptional;
        this.isOkEnabled = isMessageOptional;
    }

    public String getBranchDescription() {
        return this.branchDescription;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isKeeplocks() {
        return this.keeplocks;
    }

    public boolean isNewBranch() {
        return this.isNewBranch;
    }

    public void forceCommitNewBranch(boolean newBranch) {
        this.isNewBranch = newBranch;
    }

    public Shell open(final Display display, Observable o) {
        this.message = null;
        final Shell shell = new Shell(display, 147504);
        GridLayout layout = new GridLayout(2, true);
        layout.verticalSpacing = 15;
        shell.setLayout((Layout)layout);
        shell.setText("Commit to Teamwork Cloud");
        final Label heading = new Label((Composite)shell, 0);
        heading.setText(HEADING_NORMAL);
        GridData gdL1 = new GridData(0x1000000, 4, true, false, 2, 1);
        heading.setLayoutData((Object)gdL1);
        final Text commitCommentText = new Text((Composite)shell, 2818);
        GridData gdText = new GridData(4, 4, true, true, 2, 1);
        commitCommentText.setLayoutData((Object)gdText);
        commitCommentText.setFocus();
        Group group = new Group((Composite)shell, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        group.setLayout((Layout)new GridLayout(4, false));
        Label branchCheckboxLabel = new Label((Composite)group, 0);
        branchCheckboxLabel.setText("Create New Branch");
        branchCheckboxLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.branchCheckbox = new Button((Composite)group, 32);
        this.branchCheckbox.setLayoutData((Object)new GridData(16384, 4, true, false));
        Label keepLocksCheckboxLabel = new Label((Composite)group, 0);
        keepLocksCheckboxLabel.setText("Keep Locks");
        keepLocksCheckboxLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        final Button keepLockscheckbox = new Button((Composite)group, 32);
        keepLockscheckbox.setLayoutData((Object)new GridData(16384, 4, true, false));
        Label branchNameLabel = new Label((Composite)shell, 0);
        branchNameLabel.setText("Branch Name");
        branchNameLabel.setLayoutData((Object)new GridData(16384, 4, false, false));
        final Text branchNameText = new Text((Composite)shell, 2112);
        branchNameText.setEnabled(false);
        branchNameText.setText(this.oldBranchName);
        branchNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label branchDescriptionLabel = new Label((Composite)shell, 0);
        branchDescriptionLabel.setText("Branch Description");
        branchDescriptionLabel.setLayoutData((Object)new GridData(16384, 4, false, false));
        final Text branchDescriptionText = new Text((Composite)shell, 2562);
        branchDescriptionText.setEnabled(false);
        branchDescriptionText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.branchCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TwcCommitDialog.this.branchCheckbox.getSelection()) {
                    keepLockscheckbox.setSelection(false);
                    keepLockscheckbox.setEnabled(false);
                } else {
                    keepLockscheckbox.setEnabled(true);
                }
            }
        });
        final Button okButton = new Button((Composite)shell, 0);
        okButton.setText("OK");
        okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TwcCommitDialog.this.message = commitCommentText.getText();
                TwcCommitDialog.this.isNewBranch = TwcCommitDialog.this.branchCheckbox.getSelection();
                TwcCommitDialog.this.branchName = branchNameText.getText().trim();
                TwcCommitDialog.this.branchDescription = branchDescriptionText.getText().trim();
                TwcCommitDialog.this.keeplocks = keepLockscheckbox.getSelection();
                shell.close();
            }
        });
        okButton.setEnabled(this.isMessageOptional);
        commitCommentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String mes = commitCommentText.getText().trim();
                if (!TwcCommitDialog.this.isMessageOptional && !mes.isEmpty()) {
                    TwcCommitDialog.this.isOkEnabled = !TwcCommitDialog.this.branchCheckbox.getSelection() || branchNameText.getText().trim().isEmpty() && branchDescriptionText.getText().trim().isEmpty();
                    heading.setText(HEADING_NORMAL);
                    heading.setForeground(display.getSystemColor(21));
                } else {
                    TwcCommitDialog.this.isOkEnabled = TwcCommitDialog.this.isMessageOptional;
                    heading.setText(TwcCommitDialog.this.isOkEnabled ? HEADING_NORMAL : HEADING_EMPTY_COMMIT_MESSAGE);
                    heading.setForeground(display.getSystemColor(TwcCommitDialog.this.isOkEnabled ? 21 : 3));
                }
                okButton.setEnabled(TwcCommitDialog.this.isOkEnabled);
                heading.requestLayout();
            }
        });
        if (!this.canCreateBranch) {
            this.branchCheckbox.setEnabled(false);
            this.branchCheckbox.setToolTipText(BRANCH_CREATION_NOT_ALLOWED_MESSAGE);
        }
        this.branchCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TwcCommitDialog.this.branchCheckbox.getSelection()) {
                    branchNameText.setEnabled(true);
                    branchDescriptionText.setEnabled(true);
                    branchNameText.setText("");
                    TwcCommitDialog.this.isOkEnabled = (TwcCommitDialog.this.isMessageOptional || !commitCommentText.getText().trim().isEmpty()) && !branchNameText.getText().trim().isEmpty() && !branchDescriptionText.getText().trim().isEmpty();
                } else {
                    branchNameText.setEnabled(false);
                    branchDescriptionText.setEnabled(false);
                    branchNameText.setText(TwcCommitDialog.this.oldBranchName);
                    TwcCommitDialog.this.isOkEnabled = TwcCommitDialog.this.isMessageOptional || !commitCommentText.getText().trim().isEmpty();
                }
                okButton.setEnabled(TwcCommitDialog.this.isOkEnabled);
            }
        });
        if (this.isNewBranch) {
            this.branchCheckbox.setSelection(this.isNewBranch);
            this.branchCheckbox.setEnabled(!this.isNewBranch);
            branchNameText.setEnabled(true);
            branchDescriptionText.setEnabled(true);
            branchNameText.setText("");
        }
        branchNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TwcCommitDialog.this.isOkEnabled = !branchNameText.getText().trim().isEmpty() ? (TwcCommitDialog.this.isMessageOptional || !commitCommentText.getText().trim().isEmpty()) && !branchDescriptionText.getText().trim().isEmpty() : false;
                okButton.setEnabled(TwcCommitDialog.this.isOkEnabled);
            }
        });
        branchDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TwcCommitDialog.this.isOkEnabled = branchDescriptionText.getText().trim().length() > 0 ? (TwcCommitDialog.this.isMessageOptional || !commitCommentText.getText().trim().isEmpty()) && !branchNameText.getText().trim().isEmpty() : false;
                okButton.setEnabled(TwcCommitDialog.this.isOkEnabled);
            }
        });
        Button cancelButton = new Button((Composite)shell, 0);
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        shell.setSize(400, 350);
        shell.open();
        shell.setActive();
        return shell;
    }
}

