/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency.dialog;

import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import com.maplesoft.maplembse.special.twc.dependency.NoMagicRoot;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NoMagicRootDialog
implements TwcDialog {
    private static final int DIRDIALOG_HEIGHT = 1;
    private static final String FIRST_TIME_MESSAGE = "Please select the No Magic installation in the list.";
    private static final int LIST_HEIGHT = 5;
    private static final int LSPAN = 1;
    private static final int MESSAGE_HEIGHT = 2;
    private static final int OKCANCEL_HEIGHT = 1;
    private static final int RSPAN = 1;
    private static final int TOTALSPAN = 2;
    private static final String UPDATE_MESSAGE = "You recently used a version of the No Magic libraries different to the one MapleMBSE  is configured to use. Would you like to change the No Magic libraries used by MapleMBSE?";
    private Button dirSelectButton;
    private Label hLabel;
    private final Map<String, NoMagicRoot> noMagicRootMap;
    private final List<NoMagicRoot> noMagicRoots;
    private Button okButton;
    private final NoMagicRoot prevNoMagicRoot;
    private NoMagicRoot selected;
    private Shell shell;
    private org.eclipse.swt.widgets.List wList;

    public NoMagicRootDialog(NoMagicRoot prev, List<NoMagicRoot> noMagicRoots) {
        this.prevNoMagicRoot = prev;
        this.noMagicRoots = noMagicRoots;
        this.noMagicRootMap = new HashMap<String, NoMagicRoot>(noMagicRoots.size());
        for (NoMagicRoot nmr : noMagicRoots) {
            this.noMagicRootMap.put(nmr.toString(), nmr);
        }
    }

    public NoMagicRoot getResult() {
        return this.selected;
    }

    public Shell open(Display display, Observable o) {
        this.shell = new Shell(display, 147504);
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 5;
        this.shell.setLayout((Layout)layout);
        this.shell.setText("Select No Magic Library location");
        this.initW();
        this.shell.setSize(500, 400);
        this.shell.setDefaultButton(this.okButton);
        this.shell.open();
        this.shell.setActive();
        return this.shell;
    }

    private void addDir(String path) {
        File d = new File(path);
        if (!d.isDirectory()) {
            return;
        }
        NoMagicRoot nmr = new NoMagicRoot(d, "");
        String label = nmr.toString();
        int idx = this.noMagicRoots.indexOf(nmr);
        if (idx >= 0) {
            this.wList.select(idx);
        } else {
            this.noMagicRootMap.put(label, nmr);
            this.noMagicRoots.add(0, nmr);
            this.wList.add(label, 0);
            this.wList.select(0);
        }
        this.selectItem();
    }

    private NoMagicRoot getCurrentSelection() {
        String[] ss = this.wList.getSelection();
        if (ss.length < 1) {
            return null;
        }
        return this.noMagicRootMap.get(ss[0]);
    }

    private void initW() {
        this.hLabel = new Label((Composite)this.shell, 2112);
        this.hLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 2));
        this.wList = new org.eclipse.swt.widgets.List((Composite)this.shell, 2052);
        this.wList.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        for (NoMagicRoot nmr : this.noMagicRoots) {
            this.wList.add(nmr.toString());
        }
        this.wList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NoMagicRootDialog.this.selected = NoMagicRootDialog.this.getCurrentSelection();
                if (NoMagicRootDialog.this.selected != null) {
                    NoMagicRootDialog.this.shell.close();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                NoMagicRootDialog.this.selectItem();
            }
        });
        this.okButton = new Button((Composite)this.shell, 0);
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NoMagicRootDialog.this.selected = NoMagicRootDialog.this.getCurrentSelection();
                if (NoMagicRootDialog.this.selected != null) {
                    NoMagicRootDialog.this.shell.close();
                }
            }
        });
        Button cancelButton = new Button((Composite)this.shell, 0);
        cancelButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NoMagicRootDialog.this.selected = NoMagicRootDialog.this.prevNoMagicRoot;
                NoMagicRootDialog.this.shell.close();
            }
        });
        if (this.prevNoMagicRoot == null) {
            this.hLabel.setText(FIRST_TIME_MESSAGE);
        } else {
            this.hLabel.setText(UPDATE_MESSAGE);
            int idx = this.noMagicRoots.indexOf(this.prevNoMagicRoot);
            if (idx >= 0) {
                this.wList.select(idx);
                this.okButton.setEnabled(true);
            }
        }
    }

    private void selectItem() {
        this.selected = this.getCurrentSelection();
        boolean flag = this.selected != null;
        this.okButton.setEnabled(flag);
    }
}

