/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.google.common.reflect.Invokable;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.TwcResourceImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;

public class TwcUtils {
    public static final Logger LOGGER = Logger.getLogger(TwcUtils.class);

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Class<?> _class = null;
            try {
                _class = TwcDependencyConstants.urlClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                LOGGER.error((Object)e1);
            }
            return _class;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, String ... arg) {
        Method[] m = clazz.getMethods();
        int nParams = arg != null ? arg.length : 0;
        for (Method method : m) {
            if (method.getParameterCount() != nParams || !method.getName().equals(methodName)) continue;
            if (nParams == 0) {
                return method;
            }
            Parameter[] params = method.getParameters();
            for (int i = 0; i <= params.length - 1 && params[i].getParameterizedType().getTypeName().contains(arg[i]); ++i) {
                if (i != params.length - 1) continue;
                return method;
            }
        }
        throw new RuntimeException("Unable to Find Method :" + methodName + " in Class :" + clazz.getName());
    }

    public static UUID getUUID(Object obj) {
        if (!TwcDependencyConstants.EsiObject.isInstance(obj)) {
            return null;
        }
        return TwcUtils.invoke(TwcDependencyConstants.EsiObject$esiID, obj, new Object[0]);
    }

    public static Object getEnumValue(Class<?> clazz, String expectedValue) {
        try {
            Object[] objs;
            Method method = clazz.getMethod("values", new Class[0]);
            for (Object object : objs = (Object[])method.invoke(null, new Object[0])) {
                if (!object.toString().equalsIgnoreCase(expectedValue)) continue;
                return object;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error((Object)e);
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, String ... arg) {
        Constructor<?>[] con = clazz.getConstructors();
        int nParams = arg != null ? arg.length : 0;
        for (Constructor<?> constructor : con) {
            if (constructor.getParameterCount() != nParams) continue;
            if (nParams == 0) {
                return constructor;
            }
            Parameter[] params = constructor.getParameters();
            for (int i = 0; i <= params.length - 1 && params[i].getParameterizedType().getTypeName().contains(arg[i]); ++i) {
                if (i != params.length - 1) continue;
                return constructor;
            }
        }
        throw new RuntimeException("Unable to Find constructor for :" + clazz.getName());
    }

    public static <T, R> R invoke(Invokable<T, R> invokable, T object, Object ... args) {
        try {
            return (R)invokable.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)e.getTargetException());
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                throw new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
            if (e.getCause() != null) {
                LOGGER.error((Object)e.getCause());
                throw new RuntimeException(e.getCause());
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static Long getLatestRevision(Resource resource) {
        Object bi = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getBranchInfo, resource, new Object[0]);
        return TwcUtils.getbranchLatestRevision(bi);
    }

    @Deprecated
    static Long getbranchLatestRevision(Object branchInfo) {
        return TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getLatestRevision, branchInfo, new Object[0]);
    }

    @Deprecated
    static Object getBranchInfoFromServer(TwcAdapter adapter) {
        TwcResourceImpl resource = (TwcResourceImpl)adapter.getResource();
        UUID resourceUUID = resource.getResourceUUID();
        List<Object> bis = TwcUtils.invoke(TwcDependencyConstants.RepositoryManager$getBranchInfos, adapter.getTwcAccess().getRepositoryManager(), resourceUUID);
        Object branchInfo = resource.getBranchInfo();
        UUID branchId = TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getID, branchInfo, new Object[0]);
        String branchName = TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getName, branchInfo, new Object[0]);
        for (Object object : bis) {
            UUID id = TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getID, object, new Object[0]);
            String name = TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getName, object, new Object[0]);
            if (!id.equals(branchId) || !branchName.equals(name)) continue;
            return object;
        }
        return branchInfo;
    }
}

