/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.TwcLockManager;
import com.maplesoft.maplembse.special.twc.adapter.TwcParameters;
import com.maplesoft.maplembse.special.twc.adapter.TwcResource;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.TwcUtils;
import com.maplesoft.maplembse.special.twc.dependency.dialog.TwcCommitDialog;
import com.maplesoft.maplembse.special.twc.dependency.dialog.TwcFileAttachmentSelection;
import com.maplesoft.maplembse.special.twc.dependency.dialog.TwcProgressManager;
import com.maplesoft.maplembse.special.twc.dependency.dialog.TwcReloadDialog;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPAccessException;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPIllegalStateException;
import org.openmbee.mpspi.exceptions.MPLockException;

public class TwcResourceImpl
extends TwcResource {
    public static Logger LOOGER = Logger.getLogger(TwcResourceImpl.class);
    private static final Collection<EClass> classesProperty = Collections.singleton(M2Element.Property);
    private static final Collection<EClass> classesStereotype = Collections.singleton(TwcConstants.Stereotype);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH.mm.ss.SSSZ");
    private static final String ID_SYNC_SUFFIX = "_sync";
    private static final String ID_TYPE_PREFIX = "local_";
    private static final String MMS_SYNC_PACKAGE_NAME = "__MMSSync__";
    private final TwcAdapter adapter;
    private UUID branchUUID;
    private List<EObject> cachedProperties;
    private List<EObject> cachedStereotypes;
    private Map<String, EObject> calculatedProperties = new HashMap<String, EObject>();
    private TwcCommitDialog commitDialog;
    private EList<EObject> filteredContents = null;
    private EObject mmsPackage;
    private EObject model;
    private UUID resourceUUID;
    private final TransactionalEditingDomain txDomain;
    private boolean versionChangeNotification = false;
    private static final String NO_COMMIT_MESSAGE = "NO_COMMIT_MESSAGE";
    private static final String NO_COMMIT_DIALOG = "NO_COMMIT_DIALOG";
    private static final String commitMessage = "Committed from MapleMBSE";
    private Map<String, EObject> stMap = new HashMap<String, EObject>();
    private Map<String, File> files = new HashMap<String, File>();

    TwcResourceImpl(TwcAdapter adapter, Resource resource) {
        this.adapter = adapter;
        this.resource = resource;
        this.txDomain = TwcResourceImpl.initTransactionalEditingDomain(resource);
    }

    private void addInstanceSpecificationToMMSPackage() {
        if (this.getMMSPackage() == null || this.mmsPackage.eResource() != this.getResource() || !MMS_SYNC_PACKAGE_NAME.equals(this.mmsPackage.eGet(M2Element.NamedElement$name))) {
            this.mmsPackage = null;
            return;
        }
        EObject instanceSpecification = Util.instantiateEClass((String)TwcDependencyConstants.InstanceSpecification.getSimpleName());
        instanceSpecification.eSet(M2Element.NamedElement$name, (Object)(ID_TYPE_PREFIX + ZonedDateTime.now().format(DATE_TIME_FORMATTER)));
        TwcUtils.invoke(TwcDependencyConstants.MDObject$setID, instanceSpecification, TwcResource.generateID() + ID_SYNC_SUFFIX);
        StringBuilder builder = new StringBuilder();
        builder.append("{\"created\":").append(this.makeIDsInJSON(this.getAddedObjects()));
        builder.append(",\"updated\":").append(this.makeIDsInJSON(this.getUpdatedObjects()));
        builder.append(",\"deleted\":").append(this.makeIDsInJSON(this.getDeletedObjects()));
        builder.append("}");
        EObject literalString = Util.instantiateEClass((EClass)M2Element.LiteralString);
        literalString.eSet(M2Element.LiteralString$value, (Object)builder.toString());
        TwcUtils.invoke(TwcDependencyConstants.MDObject$setID, literalString, TwcResource.generateID() + ID_SYNC_SUFFIX);
        TwcUtils.invoke(TwcDependencyConstants.InstanceSpecification$setSpecification, instanceSpecification, literalString);
        Util.getEList((EObject)this.mmsPackage, (EStructuralFeature)M2Element.Element$ownedElement).add(instanceSpecification);
    }

    public void applySnapshot(String username) throws MPException {
        this.checkResource();
        if (this.adapter.getCacheManager().applySnapshot(username)) {
            this.lockCheckingAfterSnapshot(username);
        }
    }

    private void lockCheckingAfterSnapshot(String username) throws MPLockException {
        TwcLockManager lockManager = this.adapter.getLockManager();
        Set<EObject> set = this.getUpdatedObjects();
        List list = set.stream().filter(TwcDependencyConstants.EsiObject::isInstance).map(TwcUtils::getUUID).collect(Collectors.toList());
        List<UUID> unlockables = TwcUtils.invoke(TwcDependencyConstants.LockManager$cannotLock, lockManager.getLockManager(), this.getResourceUUID(), this.getBranchUUID(), list, username);
        if (!unlockables.isEmpty()) {
            this.lockFailureDecision();
            throw new MPLockException(String.format("User %s could not aquire all locks", username));
        }
        try {
            lockManager.lock(list);
        }
        catch (Exception e) {
            lockManager.release();
            this.lockFailureDecision();
            throw new MPLockException("Something went wrong when aquiring locks.%n", e.getCause());
        }
    }

    private void lockFailureDecision() {
        boolean cancel;
        boolean bl = cancel = TwcAdapter.getDialogManager().messageBox(MessageEnum.FAILED_TO_ACQUIRE_SNAPSHOT_LOCKS.toString(), MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_ACQUIRE_SNAPSHOT_LOCKS), 289) == 256;
        if (cancel) {
            this.reset();
        } else {
            this.setFailedToAccquireLockForSnapshot(true);
        }
    }

    private void checkResource() throws MPIllegalStateException {
        if (this.resource == null) {
            throw new MPIllegalStateException("The resource was not loaded properly.");
        }
    }

    public void checkServerlatestRevision() {
        Long latestRevision;
        Object branchInfo = TwcUtils.getBranchInfoFromServer(this.adapter);
        if (!this.versionChangeNotification && !(latestRevision = TwcUtils.getbranchLatestRevision(branchInfo)).equals(TwcUtils.getLatestRevision(this.resource))) {
            this.showTrayMessge();
        }
    }

    private void clearObjects() {
        this.mmsPackage = null;
        this.model = null;
        this.filteredContents = null;
        this.cachedStereotypes = null;
        this.cachedProperties = null;
        this.branchUUID = null;
        this.resourceUUID = null;
        this.txDomain.dispose();
        this.versionChangeNotification = false;
        this.calculatedProperties.clear();
        this.clearFiles();
    }

    public boolean commit(TwcParameters params, Map<MPAdapter.SaveOption, Object> option) throws MPException {
        Object saveOptions;
        Object object = saveOptions = option.isEmpty() ? null : option.get(MPAdapter.SaveOption.SAVE_OPTION1);
        if (saveOptions == null || NO_COMMIT_MESSAGE.equalsIgnoreCase((String)saveOptions)) {
            return this.saveToModel(params, (String)saveOptions);
        }
        if (NO_COMMIT_DIALOG.equalsIgnoreCase((String)saveOptions)) {
            return this.commitToModelWithoutDialog(params);
        }
        return false;
    }

    private void updateSettingsAfterCommit(TwcParameters params) {
        params.updateToHeadRevision(this.adapter);
        this.setFailedToAccquireLockForSnapshot(false);
        this.resetNotification();
    }

    private boolean saveToModel(TwcParameters params, String option) throws MPException {
        boolean isMessageOptional = NO_COMMIT_MESSAGE.equalsIgnoreCase(option);
        Object accessManager = this.adapter.getTwcAccess().getAccessManager();
        boolean canCreateBranch = TwcUtils.invoke(TwcDependencyConstants.AccessManager$canCreateResource, accessManager, new Object[0]);
        this.commitDialog = new TwcCommitDialog(canCreateBranch, this.getBranchName(), isMessageOptional);
        this.commitDialog.forceCommitNewBranch(!params.isHeadRevision() || this.isFailedToAccquireLockForSnapshot());
        this.adapter.display((TwcDialog)this.commitDialog, (Observable)params);
        if (!isMessageOptional && this.commitDialog.getMessage() == null) {
            return false;
        }
        Set<Object> addedElementUUIDs = new HashSet();
        if (this.commitDialog.isKeeplocks()) {
            addedElementUUIDs = this.getAddedObjects().parallelStream().map(TwcUtils::getUUID).collect(Collectors.toSet());
        }
        TwcProgressManager progressManager = new TwcProgressManager("Saving changes...");
        try {
            progressManager.start();
            this.giveIDtoNewObject();
            this.addInstanceSpecificationToMMSPackage();
            if (this.commitDialog.isNewBranch()) {
                List branches = this.adapter.getTwcAccess().getBranches(this.getResourceName());
                if (branches.contains(this.commitDialog.getBranchName())) {
                    TwcAdapter.getDialogManager().messageBoxErr(MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_COMMIT_BRANCH_EXIST_EXCEPTION, (Object[])new Object[]{this.commitDialog.getBranchName()}));
                    return false;
                }
                TwcUtils.invoke(TwcDependencyConstants.EsiResource$commitNewBranch, this.resource, this.commitDialog.getMessage(), this.commitDialog.getBranchName(), this.commitDialog.getBranchDescription());
                params.setBranch(this.commitDialog.getBranchName());
            } else {
                String message = this.commitDialog.getMessage() == null || this.commitDialog.getMessage().isEmpty() ? commitMessage : this.commitDialog.getMessage();
                TwcUtils.invoke(TwcDependencyConstants.EsiResource$commit, this.resource, message);
            }
        }
        catch (IllegalStateException e) {
            progressManager.stop();
            throw new MPAccessException(MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_COMMIT_MERGE_EXCEPTION, (Object[])new Object[]{this.getURI()}), (Throwable)e);
        }
        catch (Throwable th) {
            progressManager.stop();
            String cause = th.getMessage() != null && th.getMessage().contains("isn't the latest revision on branch") ? MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_COMMIT_THE_MODEL_NEW_REVISION_AVAILABLE) : (th.getMessage().contains("com.nomagic.esi.api.exceptions.NotAuthorizedException: Not authorized to process com.nomagic.esi.core.msg.BeginCommitMsg") ? MessageUtil.msg((MessageEnum)MessageEnum.NOT_AUTHORIZED_EXCEPTION) : MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_COMMIT_EXCEPTION, (Object[])new Object[]{this.getURI()}));
            throw new MPAccessException(cause, th);
        }
        if (!this.commitDialog.isKeeplocks()) {
            this.adapter.getLockManager().release();
        } else {
            this.adapter.getLockManager().lock(addedElementUUIDs);
        }
        this.updateSettingsAfterCommit(params);
        progressManager.updateDialogAndStop();
        return true;
    }

    private boolean commitToModelWithoutDialog(TwcParameters params) throws MPException {
        TwcProgressManager progressManager = new TwcProgressManager("Saving changes...");
        try {
            progressManager.start();
            this.giveIDtoNewObject();
            this.addInstanceSpecificationToMMSPackage();
            TwcUtils.invoke(TwcDependencyConstants.EsiResource$commit, this.resource, commitMessage);
            this.updateSettingsAfterCommit(params);
        }
        catch (IllegalStateException e) {
            throw new MPAccessException(MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_COMMIT_MERGE_EXCEPTION, (Object[])new Object[]{this.getURI()}), (Throwable)e);
        }
        catch (Throwable th) {
            String cause = th.getMessage() != null && th.getMessage().contains("isn't the latest revision on branch") ? MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_COMMIT_THE_MODEL_NEW_REVISION_AVAILABLE) : (th.getMessage().contains("com.nomagic.esi.api.exceptions.NotAuthorizedException: Not authorized to process com.nomagic.esi.core.msg.BeginCommitMsg") ? MessageUtil.msg((MessageEnum)MessageEnum.NOT_AUTHORIZED_EXCEPTION) : MessageUtil.msg((MessageEnum)MessageEnum.FAILED_TO_COMMIT_EXCEPTION, (Object[])new Object[]{this.getURI()}));
            throw new MPAccessException(cause, th);
        }
        finally {
            progressManager.stop();
        }
        return true;
    }

    private boolean discardResourceChanges(TwcParameters params) {
        boolean result;
        boolean bl = result = TwcAdapter.getDialogManager().messageBox(MessageEnum.RELOAD.toString(), MessageUtil.msg((MessageEnum)MessageEnum.RELOAD), 290) == 32;
        if (!result) {
            return false;
        }
        this.updateResource(params);
        return true;
    }

    public boolean eq(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        String id1 = this.getID(o1);
        if (id1 == null) {
            return o1.equals(o2);
        }
        String id2 = this.getID(o2);
        return id1.equals(id2);
    }

    public Set<EObject> getAddedObjects() {
        return TwcUtils.invoke(TwcDependencyConstants.EsiResource$getAddedObjects, this.resource, new Object[0]);
    }

    public TreeIterator<EObject> getAllContents() {
        return new EcoreUtil.ContentTreeIterator<EObject>(this.getFilteredContents()){
            private static final long serialVersionUID = 1L;
        };
    }

    Object getBranchInfo() {
        return TwcUtils.invoke(TwcDependencyConstants.EsiResource$getBranchInfo, this.resource, new Object[0]);
    }

    public String getBranchName() {
        Object branchInfo = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getBranchInfo, this.resource, new Object[0]);
        String name = TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getName, branchInfo, new Object[0]);
        return name;
    }

    public UUID getBranchUUID() {
        if (this.branchUUID == null) {
            try {
                this.checkResource();
            }
            catch (Exception e) {
                return null;
            }
            Object branchInfo = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getBranchInfo, this.resource, new Object[0]);
            this.branchUUID = TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getID, branchInfo, new Object[0]);
        }
        return this.branchUUID;
    }

    public EList<EObject> getContents() {
        return this.getFilteredContents();
    }

    public Set<EObject> getDeletedObjects() {
        return TwcUtils.invoke(TwcDependencyConstants.EsiResource$getDeletedObjects, this.resource, new Object[0]);
    }

    private EList<EObject> getFilteredContents() {
        Class<?> modelClazz = TwcDependencyConstants.Model;
        Class<?> esiObject = TwcDependencyConstants.EsiObject;
        if (this.filteredContents != null) {
            return this.filteredContents;
        }
        BasicEList cs = new BasicEList();
        try {
            cs = this.resource.getContents();
        }
        catch (Exception e) {
            LOOGER.error((Object)e);
        }
        int size = cs.size();
        this.filteredContents = new BasicEList(size);
        if (size == 0) {
            return this.filteredContents;
        }
        Set<UUID> rootIds = this.getProjectRootIds((EObject)cs.get(0));
        for (EObject eo : cs) {
            if (!esiObject.isInstance(eo) || !modelClazz.isInstance(eo)) continue;
            if (this.model == null) {
                this.model = eo;
            }
            if (eo.eContainer() != null || !rootIds.contains(TwcUtils.getUUID(eo))) continue;
            this.filteredContents.add((Object)eo);
        }
        return this.filteredContents;
    }

    public String getID(Object o) {
        String id;
        Class<?> mdObject = TwcDependencyConstants.MDObject;
        if (mdObject.isInstance(o) && (id = TwcUtils.invoke(TwcDependencyConstants.MDObject$getID, o, new Object[0])) != null) {
            return id;
        }
        return TwcResourceImpl.getServerID(o);
    }

    private Object getMMSPackage() {
        if (this.mmsPackage == null) {
            EObject model = this.getModel();
            List elems = Util.getEList((EObject)model, (EStructuralFeature)M2Element.Element$ownedElement);
            for (EObject e : elems) {
                if (!Util.isInstanceOf((Object)e, (EClass)M2Element.Package) || !MMS_SYNC_PACKAGE_NAME.equalsIgnoreCase((String)e.eGet(M2Element.NamedElement$name))) continue;
                this.mmsPackage = e;
                break;
            }
        }
        return this.mmsPackage;
    }

    public EObject getModel() {
        if (this.model == null) {
            this.getFilteredContents();
        }
        return this.model;
    }

    public List<EObject> getObjectsByClass(EClassifier classifier) {
        ArrayList<Object> classifiers = new ArrayList<Object>();
        classifiers.add(classifier);
        for (EObject eobj : M2Element.ePACKAGE.eContents()) {
            if (!(eobj instanceof EClass) || !((EClass)eobj).getEAllSuperTypes().contains((Object)classifier)) continue;
            classifiers.add(eobj);
        }
        return TwcUtils.invoke(TwcDependencyConstants.EsiResource$getObjectsByEClass, this.resource, classifiers, null);
    }

    private EObject getPackageFromProject(String name) {
        if (name == null) {
            return this.getModel();
        }
        Class<?> esiObject = TwcDependencyConstants.EsiObject;
        Class<?> modelClazz = TwcDependencyConstants.Model;
        for (EObject eo : this.resource.getContents()) {
            Optional<EObject> tmp;
            if (!esiObject.isInstance(eo) || !modelClazz.isInstance(eo) || !(tmp = Util.getEList((EObject)eo, (EStructuralFeature)M2Element.Package$packagedElement).stream().filter(o -> Util.isInstanceOf((Object)o, (EClass)M2Element.Package) && name.equals(o.eGet(M2Element.NamedElement$name))).findAny()).isPresent()) continue;
            return tmp.get();
        }
        return this.getModel();
    }

    private Set<UUID> getProjectRootIds(EObject first) {
        HashSet<UUID> ret = new HashSet<UUID>();
        Class<?> esiProject = TwcDependencyConstants.EsiProject;
        if (!esiProject.isInstance(first)) {
            return ret;
        }
        List ownedSections = (List)TwcUtils.invoke(TwcDependencyConstants.EsiProject$getOwnedSections, first, new Object[0]);
        for (EObject eds : ownedSections) {
            ret.addAll((Collection)TwcUtils.invoke(TwcDependencyConstants.EsiDataSection$getRootElements, eds, new Object[0]));
        }
        return ret;
    }

    public List<EObject> getProperties() {
        if (this.cachedProperties != null) {
            return this.cachedProperties;
        }
        this.cachedProperties = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getObjectsByEClass, this.resource, classesProperty, null);
        return this.cachedProperties;
    }

    public EObject getProperty(String qname) {
        if (!qname.contains("::")) {
            return null;
        }
        if (this.calculatedProperties.containsKey(qname)) {
            return this.calculatedProperties.get(qname);
        }
        String[] split = qname.split("::");
        EObject current = this.getPackageFromProject(split[0]);
        int i = 1;
        while (i < split.length - 1) {
            int index = i++;
            List list = Util.getEList((EObject)current, (EStructuralFeature)M2Element.Package$packagedElement);
            EObject tmp = list.stream().filter(eo -> split[index].equals(eo.eGet(M2Element.NamedElement$name))).findFirst().orElse(null);
            if (tmp == null) {
                return null;
            }
            current = tmp;
        }
        EObject property = Util.getEList((EObject)current, (EStructuralFeature)M2Element.Element$ownedElement).stream().filter(eo -> Util.isInstanceOf((Object)eo, (EClass)M2Element.Property) && split[split.length - 1].equals(eo.eGet(M2Element.NamedElement$name))).findFirst().orElse(null);
        if (property != null) {
            this.calculatedProperties.put(qname, property);
        }
        return property;
    }

    private String getResourceName() {
        Object resourceInfo = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getResourceInfo, this.resource, new Object[0]);
        String projectName = TwcUtils.invoke(TwcDependencyConstants.ResourceInfo$getName, resourceInfo, new Object[0]);
        return projectName.replace(".MASTER", "");
    }

    public String getCategory() {
        Object resourceInfo = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getResourceInfo, this.resource, new Object[0]);
        return this.adapter.getTwcAccess().getCatergoryName(resourceInfo);
    }

    public UUID getResourceUUID() {
        if (this.resourceUUID == null) {
            try {
                this.checkResource();
            }
            catch (Exception e) {
                return null;
            }
            this.resourceUUID = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getID, this.resource, new Object[0]);
        }
        return this.resourceUUID;
    }

    public List<String> getSnapshotKeys() {
        return TwcUtils.invoke(TwcDependencyConstants.EsiResource$getSnapshotKeys, this.resource, new Object[0]);
    }

    public EObject getStereotype(String qname) {
        if (this.stMap.containsKey(qname)) {
            return this.stMap.get(qname);
        }
        EObject tmp = this.getStereotypes().parallelStream().filter(st -> qname.equals(st.eGet(M2Element.NamedElement$qualifiedName))).findAny().orElse(null);
        this.stMap.put(qname, tmp);
        return tmp;
    }

    public List<EObject> getStereotypes() {
        if (this.cachedStereotypes != null) {
            return this.cachedStereotypes;
        }
        this.cachedStereotypes = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getObjectsByEClass, this.resource, classesStereotype, null);
        return this.cachedStereotypes;
    }

    public TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.txDomain;
    }

    public Set<EObject> getUpdatedObjects() {
        return TwcUtils.invoke(TwcDependencyConstants.EsiResource$getDirtyObjects, this.resource, new Object[0]);
    }

    public URI getURI() {
        return this.adapter.getURI();
    }

    private void giveIDtoNewObject() {
        for (EObject eObj : this.getAddedObjects()) {
            String serverID = TwcUtils.getUUID(eObj).toString();
            String localID = TwcUtils.invoke(TwcDependencyConstants.MDObject$getID, eObj, new Object[0]);
            boolean deliver = eObj.eDeliver();
            if (localID != null) continue;
            if (deliver) {
                eObj.eSetDeliver(false);
            }
            TwcUtils.invoke(TwcDependencyConstants.MDObject$setID, eObj, serverID);
            if (deliver == eObj.eDeliver()) continue;
            eObj.eSetDeliver(deliver);
        }
    }

    private String makeIDsInJSON(Set<EObject> eObjs) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<EObject> it = eObjs.iterator();
        if (it.hasNext()) {
            while (true) {
                EObject eObj = it.next();
                builder.append('\"');
                String serverID = TwcUtils.getUUID(eObj).toString();
                builder.append(serverID);
                builder.append('\"');
                if (!it.hasNext()) break;
                builder.append(',');
            }
        }
        builder.append("]");
        return builder.toString();
    }

    private TwcReloadDialog openReloadDialogBox(boolean isNewRevision, TwcParameters params) {
        if (!isNewRevision && !this.adapter.getCacheManager().hasSnapshot(params.getUsername())) {
            return null;
        }
        TwcReloadDialog boxDialog = new TwcReloadDialog(isNewRevision);
        this.adapter.display((TwcDialog)boxDialog, null);
        return boxDialog;
    }

    private void reapplyChanges(Object changeSet) {
        if (changeSet == null || !TwcDependencyConstants.ChangeSet.isInstance(changeSet)) {
            return;
        }
        Set<Object> problematicContainers = new HashSet();
        HashSet<Object> visitedContainers = new HashSet<Object>();
        List<Object> added = TwcUtils.invoke(TwcDependencyConstants.ChangeSet$getAdded, changeSet, new Object[0]);
        for (Object eObjAdded : added) {
            Object eo = TwcUtils.invoke(TwcDependencyConstants.EObjectAdded$getEObject, eObjAdded, new Object[0]);
            if (!(eo instanceof EObject)) {
                throw new Error("Unidentified object " + eo);
            }
            EObject container = (EObject)TwcUtils.invoke(TwcDependencyConstants.EObjectAdded$getContainer, eObjAdded, new Object[0]);
            Resource r = container.eResource();
            if (this.getResource().equals(r)) {
                visitedContainers.add(eo);
                continue;
            }
            while (container.eContainer() != null) {
                container = container.eContainer();
            }
            problematicContainers.add(container);
        }
        List<Object> changedList = TwcUtils.invoke(TwcDependencyConstants.ChangeSet$getChanged, changeSet, new Object[0]);
        for (Object changedElement : changedList) {
            EObject object = (EObject)TwcUtils.invoke(TwcDependencyConstants.EObjectChanged$getEObject, changedElement, new Object[0]);
            List<Object> featureChangesList = TwcUtils.invoke(TwcDependencyConstants.EObjectChanged$getFeatureChanges, changedElement, new Object[0]);
            for (Object featureChanged : featureChangesList) {
                EStructuralFeature feature = TwcUtils.invoke(TwcDependencyConstants.EFeatureChanged$getFeature, featureChanged, new Object[0]);
                Object newValue = TwcUtils.invoke(TwcDependencyConstants.EFeatureChanged$getNewValue, featureChanged, new Object[0]);
                Object oldValue = TwcUtils.invoke(TwcDependencyConstants.EFeatureChanged$getOldValue, featureChanged, new Object[0]);
                if (feature.isMany()) {
                    List tmp;
                    List newValueList = (List)newValue;
                    List oldValueList = (List)oldValue;
                    for (Object o : newValueList) {
                        if (oldValueList.contains(o)) continue;
                        tmp = (List)object.eGet(feature);
                        if (feature instanceof EReference) {
                            EObject target = (EObject)o;
                            EReference eReference = (EReference)feature;
                            EReference eRef = eReference.getEOpposite();
                            if (eRef.isMany()) {
                                List eList = Util.getEList((EObject)target, (EStructuralFeature)eRef);
                                if (eList.contains(object)) {
                                    eList.remove(object);
                                }
                            } else if (target.eGet((EStructuralFeature)eRef) != null) {
                                target.eUnset((EStructuralFeature)eRef);
                            }
                        }
                        tmp.add(o);
                    }
                    for (Object o : oldValueList) {
                        if (newValueList.contains(o)) continue;
                        tmp = (List)object.eGet(feature);
                        tmp.remove(o);
                    }
                    continue;
                }
                object.eSet(feature, newValue);
            }
        }
        problematicContainers.removeAll(visitedContainers);
        problematicContainers = problematicContainers.stream().filter(c -> c.eContainer() != null).collect(Collectors.toSet());
        if (!problematicContainers.isEmpty()) {
            TwcAdapter.getDialogManager().messageBox("Error while re-applying changes", "Unable to apply the changes: at least one element was deleted in another session.", 34);
            this.reset();
            return;
        }
    }

    public void refresh() {
        this.cachedStereotypes = null;
        this.cachedProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reload(TwcParameters params) {
        this.isLoading = true;
        boolean isDeliver = this.resource.eDeliver();
        Long serverRevision = TwcUtils.getbranchLatestRevision(TwcUtils.getBranchInfoFromServer(this.adapter));
        boolean isNewRevision = !params.isHeadRevision() || !TwcUtils.getLatestRevision(this.resource).equals(serverRevision);
        Object changeSet = null;
        if (!isDeliver) {
            this.resource.eSetDeliver(true);
        }
        try {
            if (!params.isHeadRevision()) {
                boolean bl = this.discardResourceChanges(params);
                return bl;
            }
            TwcReloadDialog boxDialog = this.openReloadDialogBox(isNewRevision, params);
            if (boxDialog == null) {
                boolean bl = this.discardResourceChanges(params);
                return bl;
            }
            if (boxDialog.isCancel()) {
                boolean bl = false;
                return bl;
            }
            if (boxDialog.isLocalSave()) {
                this.adapter.getCacheManager().saveLocally(params.getUsername());
            }
            changeSet = this.updateResource(params);
            this.clearFiles();
            if (!boxDialog.isApplyChanges()) {
                boolean bl = true;
                return bl;
            }
            if (!isNewRevision) {
                this.adapter.getCacheManager().loadLocally(params.getUsername());
                boolean bl = true;
                return bl;
            }
            try {
                this.reapplyChanges(changeSet);
            }
            catch (Throwable th) {
                this.reset();
                TwcAdapter.getDialogManager().messageBox("Erro while re-applying changes", "Something went wrong.\n" + th.getMessage(), 33);
                LOGGER.error((Object)th);
            }
            boolean th = true;
            return th;
        }
        catch (IllegalStateException e) {
            if (!"insert message here.".equals(e.getMessage())) {
                LOGGER.error((Object)e.getMessage());
            }
            boolean bl = true;
            return bl;
        }
        catch (MPException e) {
            LOGGER.error((Object)e.getMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            if (!isDeliver) {
                this.resource.eSetDeliver(false);
            }
            this.isLoading = false;
        }
    }

    protected Object reset() {
        return TwcUtils.invoke(TwcDependencyConstants.EsiResource$reset, this.resource, new Object[0]);
    }

    public void resetNotification() {
        this.versionChangeNotification = false;
    }

    private void showTrayMessge() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().createImage("MapleMBSE.ico");
            TrayIcon trayIcon = new TrayIcon(image, "MapleMBSE");
            trayIcon.setImageAutoSize(true);
            trayIcon.setToolTip("MapleMBSE");
            try {
                tray.add(trayIcon);
                trayIcon.displayMessage(MessageUtil.msg((MessageEnum)MessageEnum.SERVER_MODEL_CHANGE_NOTIFICATION) + ".", "MapleMBSE", TrayIcon.MessageType.INFO);
                this.versionChangeNotification = true;
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    public void unload() {
        try {
            this.resource.getResourceSet().getResources().remove((Object)this.resource);
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
        }
        this.resource.unload();
        this.resource = null;
        this.clearObjects();
    }

    private Object updateResource(TwcParameters params) {
        Object changeSet = TwcUtils.invoke(TwcDependencyConstants.EsiResource$update, this.resource, new Object[0]);
        this.clearObjects();
        this.resource.setModified(false);
        params.updateToHeadRevision(this.adapter);
        this.resetNotification();
        return changeSet;
    }

    private static String getServerID(Object o) {
        UUID uuid = TwcUtils.getUUID(o);
        if (uuid != null) {
            return uuid.toString();
        }
        return null;
    }

    private static TransactionalEditingDomain initTransactionalEditingDomain(Resource r) {
        TransactionalEditingDomain txd = TransactionUtil.getEditingDomain((Resource)r);
        if (txd != null) {
            return txd;
        }
        txd = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        return txd;
    }

    private void clearFiles() {
        this.files.clear();
    }

    public String getFilefromServer(EObject eObject) {
        String fileName = (String)eObject.eGet(M2Element.Comment$body);
        File f = this.files.get(fileName);
        if (f != null) {
            return this.createHyperLink(f);
        }
        List<Object> mdexts = TwcUtils.invoke(TwcDependencyConstants.MDObject$getMdExtensions, eObject, new Object[0]);
        if (!mdexts.isEmpty()) {
            EObject mdExtension = (EObject)mdexts.get(0);
            List streams = (List)TwcUtils.invoke(TwcDependencyConstants.MDExtension$getContents, mdExtension, new Object[0]);
            if (streams.isEmpty()) {
                return "";
            }
            EObject stream = (EObject)streams.get(0);
            try {
                String blobID = TwcUtils.invoke(TwcDependencyConstants.StreamIdentityBinaryObject$getStreamContentID, stream, new Object[0]).replace("BLOB-", "");
                UUID id = UUID.fromString(blobID);
                File file = new File(this.downloadedFilePath() + "\\" + TwcUtils.getUUID(eObject) + "\\" + fileName);
                CompletableFuture.runAsync(() -> {
                    try {
                        Object inputStream = TwcUtils.invoke(TwcDependencyConstants.EsiResource$openBlobStream, this.resource, id);
                        FileUtils.copyInputStreamToFile((InputStream)((InputStream)inputStream), (File)file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    file.setReadOnly();
                    file.setWritable(false);
                    this.files.put(fileName, file);
                });
                return this.createHyperLink(file);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        return "";
    }

    private String createHyperLink(File file) {
        return "=HYPERLINK(\"file://" + file.getAbsolutePath() + "\", \"" + file.getName() + "\")";
    }

    public EObject fileSearchAndGetObject(String fileName) {
        File file = this.files.get(fileName);
        if (file == null) {
            return null;
        }
        String id = file.getParentFile().getName();
        UUID uuid = UUID.fromString(id);
        return (EObject)TwcUtils.invoke(TwcDependencyConstants.EsiResource$getObject, this.resource, uuid);
    }

    public String attachmentFileSelection(String fileName) {
        if (this.fileSearchAndGetObject(fileName) != null) {
            return fileName;
        }
        String[] names = new String[this.files.size()];
        this.files.keySet().toArray(names);
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        TwcFileAttachmentSelection d = new TwcFileAttachmentSelection(names);
        this.adapter.display((TwcDialog)d, null);
        return d.getFileName();
    }
}

