/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.google.common.reflect.Invokable;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcLockManager;
import com.maplesoft.maplembse.special.twc.adapter.TwcResource;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.TwcUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.openmbee.mpspi.exceptions.MPLockException;

public class TwcLockManagerImpl
implements TwcLockManager {
    public static final Logger LOGGER = Logger.getLogger(TwcLockManager.class);
    private final TwcAdapter adapter;
    private final Object lManager;
    private Set<UUID> locks;

    public TwcLockManagerImpl(TwcAdapter adapter) {
        this.adapter = adapter;
        this.lManager = adapter.getTwcAccess().getLockManager();
        this.locks = new HashSet<UUID>();
    }

    public Object getLockManager() {
        return this.lManager;
    }

    public void init(String username) {
        TwcResource resource = (TwcResource)this.adapter.getResource();
        UUID resourceUUID = resource.getResourceUUID();
        UUID branchUUID = resource.getBranchUUID();
        List<Object> list = TwcUtils.invoke(TwcDependencyConstants.LockManager$getLockByResourceBranch, this.lManager, resourceUUID, branchUUID);
        list.parallelStream().filter(TwcLockManagerImpl::isObjectLock).collect(Collectors.toMap(TwcLockManagerImpl::getLockID, TwcLockManagerImpl::getUser));
    }

    public void lock(Collection<UUID> elems) throws MPLockException {
        List<UUID> unlocked;
        Map newLocks;
        TwcResource twcResource;
        block6: {
            elems.removeIf(s -> this.locks.contains(s));
            if (elems.isEmpty()) {
                return;
            }
            twcResource = (TwcResource)this.adapter.getResource();
            final Resource resource = twcResource.getResource();
            Predicate<UUID> p1 = ((Predicate<UUID>)this.locks::contains).negate();
            Predicate<UUID> p2 = new Predicate<UUID>(){

                @Override
                public boolean test(UUID t) {
                    if (t == null) {
                        return false;
                    }
                    try {
                        Object o = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getObject, resource, t);
                        return o != null;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            };
            newLocks = elems.stream().filter(p1).filter(p2).collect(Collectors.toMap(Function.identity(), TwcLockManagerImpl::createLockProperties));
            Class<?> lockTargetReduce = TwcDependencyConstants.LockTargetReduce;
            unlocked = null;
            try {
                Object ltr = lockTargetReduce.getConstructor(UUID.class, UUID.class, String.class, Map.class).newInstance(twcResource.getResourceUUID(), twcResource.getBranchUUID(), null, newLocks);
                unlocked = TwcUtils.invoke(TwcDependencyConstants.LockManager$acquireLocks, this.lManager, ltr, false);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error((Object)e);
            }
            catch (Exception e) {
                if (e.getCause() == null || !e.getCause().toString().contains("com.nomagic.esi.api.exceptions.NotAuthorizedException: Not authorized to process") && !e.getCause().toString().contains("com.nomagic.esi.api.messages.exceptions.NotAuthorizedException: Not authorized to process")) break block6;
                LOGGER.error((Object)e);
                throw new MPLockException(MessageUtil.msg((MessageEnum)MessageEnum.LOCK_ACCESS_EXCEPTION));
            }
        }
        if (unlocked != null && !unlocked.isEmpty()) {
            newLocks.keySet().removeAll(unlocked);
            this.locks.addAll(newLocks.keySet());
            List<Object> oo = TwcUtils.invoke(TwcDependencyConstants.LockManager$getLockByResourceBranchElementIDs, this.lManager, twcResource.getResourceUUID(), twcResource.getBranchUUID(), unlocked);
            HashSet<String> userNames = new HashSet<String>();
            for (Object object : oo) {
                userNames.add(TwcLockManagerImpl.getUser(object));
            }
            String names = String.join((CharSequence)", ", userNames);
            throw new MPLockException(MessageUtil.msg((MessageEnum)MessageEnum.LOCK_ACQUIRE_EXCEPTION, (Object[])new Object[]{unlocked}) + " userNames = " + names);
        }
        this.locks.addAll(newLocks.keySet());
    }

    public void lockParent(EObject eObj) throws MPLockException {
        if (eObj.eContainer() == null) {
            return;
        }
        UUID id = TwcUtils.getUUID(eObj.eContainer());
        ArrayList<UUID> col = new ArrayList<UUID>();
        col.add(id);
        this.lock(col);
    }

    public void release() throws MPLockException {
        TwcResource resource = (TwcResource)this.adapter.getResource();
        UUID resourceUUID = resource.getResourceUUID();
        UUID branchUUID = resource.getBranchUUID();
        Class<?> clazz = TwcDependencyConstants.UnlockTargetReduce;
        Object utr = null;
        try {
            utr = clazz.getConstructor(UUID.class, UUID.class, Collection.class).newInstance(resourceUUID, branchUUID, this.locks);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (utr == null) {
            return;
        }
        List<UUID> locked = TwcUtils.invoke(TwcDependencyConstants.LockManager$releaseLocks, this.lManager, utr, true);
        if (locked != null && !locked.isEmpty()) {
            this.locks.clear();
            this.locks.addAll(locked);
            throw new MPLockException(MessageUtil.msg((MessageEnum)MessageEnum.LOCK_RELEASE_EXCEPTION));
        }
        this.locks.clear();
    }

    public UUID searchLockableElement(EObject eo, Set<EObject> addedObjects) {
        while (eo != null && !Util.isInstanceOf((Object)eo, (EClass)M2Element.Element)) {
            eo = eo.eContainer();
        }
        boolean isLockable = false;
        while (eo != null) {
            if (Util.isInstanceOf((Object)eo, (EClass)M2Element.Model) || eo.eContainer() != null) {
                isLockable = TwcUtils.invoke(TwcDependencyConstants.LockingHelper$isLockable, eo, eo);
            }
            if (isLockable) {
                if (!TwcDependencyConstants.EsiObject.isInstance(eo) || addedObjects.contains(eo)) {
                    return null;
                }
                return TwcUtils.invoke(TwcDependencyConstants.EsiObject$esiID, eo, new Object[0]);
            }
            eo = eo.eContainer();
        }
        return null;
    }

    private static Map<String, String> createLockProperties(UUID elem) {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        ret.put("LOCKTYPE", "ELEMENT");
        ret.put("LOCK_ID_KEY", UUID.randomUUID().toString());
        return ret;
    }

    private static UUID getLockID(Object o) {
        UUID tmp = TwcUtils.invoke(TwcDependencyConstants.LockState$getEsiObjectId, o, new Object[0]);
        return tmp;
    }

    private static String getUser(Object o) {
        String tmp = null;
        Invokable<Object, String> method = TwcDependencyConstants.LockState$getUsername;
        if (method == null) {
            method = TwcDependencyConstants.LockState$getUserId;
        }
        if (method != null) {
            tmp = TwcUtils.invoke(TwcDependencyConstants.LockState$getUsername, o, new Object[0]);
        }
        return tmp;
    }

    private static boolean isObjectLock(Object o) {
        boolean tmp = "OBJECTLOCK".equals(TwcUtils.invoke(TwcDependencyConstants.LockState$getLockType, o, new Object[0]));
        return tmp;
    }
}

