/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.maplesoft.maplembse.special.twc.dependency.Activator;
import com.maplesoft.maplembse.special.twc.dependency.NoMagicRoot;
import com.maplesoft.maplembse.special.twc.dependency.TwcAbstractInstallNoMagicLib;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.openmbee.mpspi.exceptions.MPException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class TwcInstallNoMagicLib21
extends TwcAbstractInstallNoMagicLib {
    public static final Logger LOGGER = Logger.getLogger(TwcInstallNoMagicLib21.class);

    @Override
    boolean installBundles(String path) throws MPException {
        BundleContext bundleContext = FrameworkUtil.getBundle(Activator.class).getBundleContext();
        Bundle svcBundle = this.installSvcBundles(bundleContext);
        File file = new File(path, "classpath.jar");
        if (file.exists()) {
            this.loadMDJar(file);
        }
        if (svcBundle != null) {
            this.isResolved(Arrays.asList(svcBundle));
        }
        return true;
    }

    @Override
    public boolean addPreinstalledNoMagicRoot(List<NoMagicRoot> ret) {
        String preinstalledPath = System.getProperty("com.maplesoft.maplembse.special.twc.dependency.preinstalled.library.dir");
        if (preinstalledPath == null) {
            return false;
        }
        File preinstalledDir = new File(preinstalledPath);
        if (!preinstalledDir.isDirectory()) {
            return false;
        }
        for (File d : preinstalledDir.listFiles()) {
            String name;
            if (!d.isDirectory() || "svc".equals(name = d.getName()) || "19.0".equals(name)) continue;
            NoMagicRoot nmRoot = new NoMagicRoot(d, name, -1L);
            ret.add(nmRoot);
        }
        return true;
    }

    private void loadMDJar(File file) {
        try {
            URL[] urls = new URL[1];
            String path = file.toPath().toString().replaceAll(" ", "%20");
            urls[0] = new URL("jar:file:" + path + "!/");
            TwcDependencyConstants.urlClassLoader = URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)e);
        }
        catch (SecurityException e) {
            LOGGER.error((Object)e);
        }
    }
}

