/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.dependency.Activator;
import com.maplesoft.maplembse.special.twc.dependency.NoMagicRoot;
import com.maplesoft.maplembse.special.twc.dependency.TwcAbstractInstallNoMagicLib;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openmbee.mpspi.exceptions.MPException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class TwcInstallNoMagicLib
extends TwcAbstractInstallNoMagicLib {
    public static final Logger LOGGER = Logger.getLogger(TwcInstallNoMagicLib.class);
    private static final String[] NO_MAGIC_PRODUCTS = new String[]{".cameo.enterprise.architecture", ".cameo.systems.modeler", ".magicdraw"};

    private boolean checkMissingDependency(Bundle bundle, boolean isResolved) {
        String importPackage;
        String required_dependency = (String)bundle.getHeaders().get("Require-Bundle");
        if (required_dependency != null) {
            String[] dNames = required_dependency.split(",");
            for (int i = 0; i <= dNames.length - 1; ++i) {
                dNames[i] = dNames[i].split(";")[0];
            }
            BundleContext bundleContext = bundle.getBundleContext();
            Bundle[] bundles = bundleContext.getBundles();
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(dNames));
            for (Bundle bundle2 : bundles) {
                String bundleName;
                if (bundle2.getSymbolicName() == null || !names.contains(bundleName = bundle2.getSymbolicName())) continue;
                names.remove(bundleName);
            }
            if (!names.isEmpty()) {
                names.forEach(name -> LOGGER.error((Object)MessageUtil.msg((MessageEnum)MessageEnum.MISSING_BUNDLE_EXCEPTION, (Object[])new Object[]{name})));
                return false;
            }
        } else if (isResolved && (importPackage = (String)bundle.getHeaders().get("Import-Package")) != null) {
            LOGGER.error((Object)MessageUtil.msg((MessageEnum)MessageEnum.MISSING_PLUIGN_EXCEPTION, (Object[])new Object[]{importPackage}));
            return false;
        }
        return true;
    }

    private List<NoMagicRoot> digNoMagicRoots() {
        ArrayList<NoMagicRoot> nmRoots = new ArrayList<NoMagicRoot>();
        List<File> pDirs = this.listNMProfiles();
        for (File pDir : pDirs) {
            for (File vDir : pDir.listFiles()) {
                String nmInstallRoot;
                File nmRootDir;
                File asPropFile;
                if (!vDir.isDirectory() || !(asPropFile = new File(vDir, "applicationstate.properties")).canRead()) continue;
                Properties asProps = new Properties();
                try {
                    FileInputStream fis = new FileInputStream(asPropFile);
                    asProps.load(fis);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (IOException e) {
                    continue;
                }
                String version = asProps.getProperty("STARTED_VERSION");
                if (version == null || version.isEmpty() || !version.contains("19.0") || !(nmRootDir = new File(nmInstallRoot = asProps.getProperty("INSTALL_ROOT"))).isDirectory()) continue;
                NoMagicRoot nmRoot = new NoMagicRoot(nmRootDir, vDir.getName(), asPropFile.lastModified());
                nmRoots.add(nmRoot);
            }
        }
        Collections.sort(nmRoots);
        return nmRoots;
    }

    private List<File> getFilesToInstall(String path) {
        File dir = new File(path);
        HashMap versionMap = new HashMap();
        ArrayList<String> keys = new ArrayList<String>();
        String jarName = null;
        for (File file : dir.listFiles()) {
            String fName = file.getName();
            String[] nameParts = fName.split("_");
            jarName = nameParts[0];
            Map<Long, File> map = new HashMap<Long, File>();
            Object date = null;
            if (nameParts.length > 1 && nameParts[1].contains("v")) {
                String[] nums = nameParts[1].split("v");
                if (nums[1].contains("-")) {
                    nums = nums[1].split("-");
                    a = nums[0].substring(0, 4) + "-" + nums[0].substring(4, 6) + "-" + nums[0].substring(6, 8);
                    date = LocalDate.parse(a);
                } else {
                    a = nums[1].substring(0, 4) + "-" + nums[1].substring(4, 6) + "-" + nums[1].substring(6, 8);
                    date = LocalDate.parse(a);
                }
            } else if (nameParts.length > 1) {
                String sec = null;
                sec = nameParts[1].contains("jar") ? nameParts[1].replaceAll(".jar", "") : nameParts[1];
                String[] strs = sec.split("\\.");
                if (strs.length >= 3 && strs[strs.length - 1].contains("20") && strs[strs.length - 1].length() > 7) {
                    String a = strs[strs.length - 1].substring(0, 4) + "-" + strs[strs.length - 1].substring(4, 6) + "-" + strs[strs.length - 1].substring(6, 8);
                    date = LocalDate.parse(a);
                }
                if (date == null) {
                    date = nameParts[1].replaceAll(".jar", "");
                }
            }
            if (versionMap.containsKey(jarName)) {
                map = (Map)versionMap.get(jarName);
            }
            if (date == null) {
                date = file.lastModified();
            }
            map.put((Long)date, file);
            versionMap.put(jarName, map);
            if (keys.contains(jarName)) continue;
            keys.add(jarName);
        }
        ArrayList<File> filesToInstall = new ArrayList<File>();
        for (String key : keys) {
            Map map = (Map)versionMap.get(key);
            Object[] obj = map.keySet().toArray();
            if (obj.length == 1) {
                filesToInstall.add((File)map.get(obj[0]));
                continue;
            }
            Object latest = obj[0];
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] instanceof LocalDate) {
                    boolean af = ((LocalDate)latest).isBefore((LocalDate)obj[i]);
                    if (!af) continue;
                    latest = obj[i];
                    continue;
                }
                if (obj[i] instanceof Long) {
                    if ((Long)obj[i] <= (Long)latest) continue;
                    latest = obj[i];
                    continue;
                }
                if (!(obj[i] instanceof String)) continue;
                String[] num1 = ((String)latest).split("\\.");
                String[] num2 = ((String)obj[i]).split("\\.");
                if (Float.valueOf(num2[0] + "." + num2[1]).floatValue() > Float.valueOf(num1[0] + "." + num1[1]).floatValue()) {
                    latest = obj[i];
                    continue;
                }
                if (Integer.valueOf(num2[2]) <= Integer.valueOf(num1[2])) continue;
                latest = obj[i];
            }
            filesToInstall.add((File)map.get(latest));
        }
        return filesToInstall;
    }

    @Override
    public boolean addPreinstalledNoMagicRoot(List<NoMagicRoot> ret) {
        String preinstalledPath = System.getProperty("com.maplesoft.maplembse.special.twc.dependency.preinstalled.library.dir");
        if (preinstalledPath == null) {
            return false;
        }
        File preinstalledDir = new File(preinstalledPath);
        if (!preinstalledDir.isDirectory()) {
            return false;
        }
        for (File d : preinstalledDir.listFiles()) {
            String name;
            if (!d.isDirectory() || "svc".equals(name = d.getName()) || !"19.0".equals(name)) continue;
            NoMagicRoot nmRoot = new NoMagicRoot(d, name, -1L);
            ret.add(nmRoot);
        }
        return true;
    }

    @Override
    public NoMagicRoot getNoMagicRoot(NoMagicRoot prev, String envRootPath, boolean alwaysChoose) {
        File d;
        NoMagicRoot envRoot = null;
        if (envRootPath != null && (d = new File(envRootPath)).isDirectory()) {
            envRoot = new NoMagicRoot(d, "", -2L);
            if (!alwaysChoose) {
                return envRoot;
            }
        }
        List<NoMagicRoot> nmRoots = this.digNoMagicRoots();
        if (envRoot != null) {
            nmRoots.add(envRoot);
        }
        this.addPreinstalledNoMagicRoot(nmRoots);
        Collections.reverse(nmRoots);
        if (prev != null && !nmRoots.isEmpty()) {
            NoMagicRoot recent = nmRoots.get(0);
            if (!recent.isRecentlyUsed(prev)) {
                if (!alwaysChoose) {
                    return prev;
                }
            } else {
                prev = null;
            }
        }
        if (alwaysChoose && TwcAdapter.getDialogManager().messageBox(MessageEnum.LIBRARY_SELECTION.toString(), MessageUtil.msg((MessageEnum)MessageEnum.NOMAGIC_SHIFT_KEY_PRESS), 194) == 128) {
            if (envRoot != null) {
                return envRoot;
            }
            if (prev != null) {
                return prev;
            }
        }
        return this.chooseNoMagicRoot(prev, nmRoots);
    }

    @Override
    boolean installBundles(String path) throws MPException {
        BundleContext bundleContext = FrameworkUtil.getBundle(Activator.class).getBundleContext();
        Bundle svcBundle = this.installSvcBundles(bundleContext);
        List<File> files = this.getFilesToInstall(path);
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (File file : files) {
            try {
                String name = file.getName();
                if (name.startsWith("org.eclipse.core") || name.startsWith("org.eclipse.osgi") || name.startsWith("org.eclipse.equinox") || name.startsWith("org.eclipse.emf") || name.startsWith("org.eclipse.uml2") || name.startsWith("org.apache.commons.io") || name.startsWith("com.google.guava") || name.startsWith("com.nomagic.magicdraw.platform.feature") || name.startsWith("com.nomagic.magicdraw.product.feature") || name.startsWith("com.teamdev.jxbrowser") || name.startsWith("com.nomagic.magicdraw.core.project.options")) continue;
                Bundle bundle = bundleContext.installBundle("reference:file:/" + file.getAbsolutePath());
                bundles.add(bundle);
            }
            catch (BundleException e) {
                if (e.getMessage().contains("A bundle is already installed with the name")) continue;
                LOGGER.error((Object)e);
            }
        }
        if (path.contains("lib\\bundles")) {
            this.loadMDJar(path.replace("\\bundles", ""));
        }
        if (svcBundle != null) {
            this.isResolved(Arrays.asList(svcBundle));
        }
        boolean is = this.isResolved(bundles);
        return this.checkMissingDependency(bundleContext.getBundle(), is);
    }

    private List<File> listNMProfiles() {
        String[] fns;
        String localAppData = System.getenv("LOCALAPPDATA");
        File localAppDataFile = new File(localAppData);
        ArrayList<File> files = new ArrayList<File>();
        if (!localAppDataFile.isDirectory()) {
            return files;
        }
        for (String fn : fns = localAppDataFile.list()) {
            for (String nmProd : NO_MAGIC_PRODUCTS) {
                File d;
                if (!fn.startsWith(nmProd) || !(d = new File(localAppDataFile, fn)).isDirectory()) continue;
                files.add(d);
            }
        }
        return files;
    }

    private void loadMDJar(String magicPath) {
        try {
            String[] jarNames = new String[]{"\\md.jar", "\\md_api.jar", "\\md_common_api.jar", "\\md_common.jar"};
            URL[] urls = new URL[jarNames.length];
            for (int i = 0; i < jarNames.length; ++i) {
                urls[i] = new URL("jar:file:" + Paths.get(magicPath + jarNames[i], new String[0]) + "!/");
            }
            TwcDependencyConstants.urlClassLoader = URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)e);
        }
        catch (SecurityException e) {
            LOGGER.error((Object)e);
        }
    }
}

