/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcCacheManager;
import com.maplesoft.maplembse.special.twc.adapter.TwcResource;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialogManager;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.TwcUtils;
import com.maplesoft.maplembse.special.twc.dependency.dialog.TwcProgressManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.openmbee.mpspi.exceptions.MPAccessException;

public class TwcCacheManagerImpl
implements TwcCacheManager {
    public static final Logger LOGGER = Logger.getLogger(TwcCacheManagerImpl.class);
    public static final String UNCOMMITTED_MODIFICATIONS_ERROR = "insert message here.";
    protected static final String localAutosavetSnapshotKey = "Autosave-MapleMBSE-TWC-Snapshot-01-";
    protected static final String localDefaultSnapshotKey = "MapleMBSE-TWC-Snapshot-01-";
    private final Object snapShot_Mode = TwcUtils.getEnumValue(TwcDependencyConstants.SnapshotMode, "CHANGES");
    private final Object cachingStyle = TwcUtils.getEnumValue(TwcDependencyConstants.CachingStyle, "IMMEDIATE");
    private final Object cachingStyleIncremental = TwcUtils.getEnumValue(TwcDependencyConstants.CachingStyle, "INCREMENTAL");
    private final Object cacheManager;
    private final TwcAdapter adapter;
    private boolean createCache = false;
    private static final int maintianSnap = 10;

    public TwcCacheManagerImpl(TwcAdapter adapter) {
        this.adapter = adapter;
        this.cacheManager = adapter.getTwcAccess().getCacheManager();
        this.createCache = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCache() throws MPAccessException {
        Resource resource = this.getResource();
        UUID resourceID = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getID, resource, new Object[0]);
        Object commitInfo = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getCommitInfo, resource, new Object[0]);
        long commitId = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, commitInfo, new Object[0]);
        Boolean isCached = TwcUtils.invoke(TwcDependencyConstants.CacheManager$isCached, this.cacheManager, resourceID, commitId);
        if (isCached.booleanValue()) {
            this.updateLocalCache();
        } else {
            this.checkCacheFile();
            TwcProgressManager dialogManager = new TwcProgressManager("Caching the model...");
            try {
                if (this.createCache) {
                    dialogManager.start();
                    this.createCache = false;
                }
                TwcUtils.invoke(TwcDependencyConstants.CacheManager$cache, this.cacheManager, resourceID, commitId, this.cachingStyle);
            }
            catch (Throwable e) {
                LOGGER.error((Object)e);
            }
            finally {
                dialogManager.stop();
            }
        }
    }

    private boolean checkCacheFile() {
        try {
            Object path = TwcUtils.invoke(TwcDependencyConstants.CacheManager$getCachePath, this.cacheManager, new Object[0]);
            URI uri = this.getResource().getURI();
            String[] splitUri = uri.segments();
            String revision = splitUri[splitUri.length - 1].replace("C", "");
            path = (String)path + "\\" + splitUri[0].replace("R", "R_");
            File resourceCacheFolder = new File((String)path);
            if (resourceCacheFolder.exists()) {
                for (File file : resourceCacheFolder.listFiles()) {
                    if (!file.getName().contains(revision) || !file.getName().contains("dat")) continue;
                    this.deleteCacheFiles(file);
                    return false;
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            return false;
        }
        return false;
    }

    public void updateLocalCache() throws MPAccessException {
        try {
            Resource resource = this.getResource();
            UUID resourceID = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getID, resource, new Object[0]);
            Object commitInfo = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getCommitInfo, resource, new Object[0]);
            long commitId = TwcUtils.invoke(TwcDependencyConstants.CommitInfo$getID, commitInfo, new Object[0]);
            Boolean isCached = TwcUtils.invoke(TwcDependencyConstants.CacheManager$isCached, this.cacheManager, resourceID, commitId);
            if (isCached.booleanValue()) {
                LOGGER.warn((Object)"Model is already cached.");
                return;
            }
            TwcUtils.invoke(TwcDependencyConstants.CacheManager$setUpdateOnLocalCommit, this.cacheManager, true);
            UUID id = TwcUtils.invoke(TwcDependencyConstants.EsiResource$getID, resource, new Object[0]);
            List<Object> list = TwcUtils.invoke(TwcDependencyConstants.CacheManager$getCachedRevisions, this.cacheManager, new Object[0]);
            Class<?> clazz = TwcDependencyConstants.IdAndRev;
            Object idAndRev = clazz.getConstructor(UUID.class, Long.TYPE).newInstance(id, commitId);
            if (list.contains(idAndRev)) {
                TwcUtils.invoke(TwcDependencyConstants.CacheManager$cacheByUpdate, this.cacheManager, id, commitId);
            } else {
                TwcUtils.invoke(TwcDependencyConstants.CacheManager$cache, this.cacheManager, id, commitId, this.cachingStyleIncremental);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error((Object)e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error((Object)e);
            throw new MPAccessException(MessageUtil.msg((MessageEnum)MessageEnum.CACHE_EXCEPTION), (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
        }
    }

    public void removeCache() {
        String cachePath = TwcUtils.invoke(TwcDependencyConstants.CacheManager$getCachePath, this.cacheManager, new Object[0]);
        try {
            File cacheFolder = new File(cachePath);
            this.deleteCacheFiles(cacheFolder);
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
        }
    }

    private void deleteCacheFiles(File file) {
        block7: {
            block8: {
                if (file == null) break block7;
                if (!file.isFile()) break block8;
                if (!file.getName().contains("cxs")) {
                    this.fileDelete(file);
                } else {
                    File folder = file.getParentFile();
                    ArrayList<File> snapShotFiles = new ArrayList<File>();
                    File[] files = folder.listFiles();
                    Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
                    for (File cxsFile : files) {
                        if (cxsFile.getName().contains("cxs")) {
                            snapShotFiles.add(cxsFile);
                            continue;
                        }
                        this.fileDelete(cxsFile);
                    }
                    if (snapShotFiles.isEmpty() || snapShotFiles.size() <= 10) {
                        return;
                    }
                    for (int i = 10; i < snapShotFiles.size(); ++i) {
                        this.fileDelete((File)snapShotFiles.get(i));
                    }
                }
                break block7;
            }
            if (!file.isDirectory()) break block7;
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteCacheFiles(files[i]);
            }
        }
    }

    private void fileDelete(File file) {
        try {
            file.delete();
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
        }
    }

    private Resource getResource() {
        TwcResource resource = (TwcResource)this.adapter.getResource();
        return resource.getResource();
    }

    private String getAutosaveSnapshotKey(String username) {
        return localAutosavetSnapshotKey + username.replaceAll("_", "");
    }

    private String getLocalSnapshotKey(String username) {
        return localDefaultSnapshotKey + username.replaceAll("_", "");
    }

    public void saveLocally(String username) throws MPAccessException {
        try {
            TwcUtils.invoke(TwcDependencyConstants.EsiResource$takeSnapshot, this.getResource(), this.snapShot_Mode, this.getLocalSnapshotKey(username));
            this.removeAutoSave(username);
        }
        catch (Exception e) {
            throw new MPAccessException("Failed to save the model locally.", (Throwable)e);
        }
    }

    public void removeAutoSave(String username) {
        String autosaveSnapshotKey = this.getAutosaveSnapshotKey(username);
        try {
            TwcUtils.invoke(TwcDependencyConstants.EsiResource$removeSnapshot, this.getResource(), autosaveSnapshotKey);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to delete autosave snapshot: " + autosaveSnapshotKey));
        }
    }

    public void loadLocally(String username) {
        block2: {
            try {
                TwcUtils.invoke(TwcDependencyConstants.EsiResource$loadSnapshot, this.getResource(), this.getLocalSnapshotKey(username));
            }
            catch (Throwable e) {
                if (!(e.getCause() instanceof IllegalStateException) || !"resource has uncommitted modifications; cannot load local state".equals(e.getMessage())) break block2;
                throw new IllegalStateException(UNCOMMITTED_MODIFICATIONS_ERROR);
            }
        }
    }

    public boolean hasAutosavedSnapshot(String username) {
        ArrayList keys = new ArrayList();
        try {
            keys.addAll(TwcUtils.invoke(TwcDependencyConstants.EsiResource$getSnapshotKeys, this.getResource(), new Object[0]));
            return keys.contains(this.getAutosaveSnapshotKey(username));
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public boolean hasSnapshot(String username) {
        ArrayList keys = new ArrayList();
        try {
            keys.addAll(TwcUtils.invoke(TwcDependencyConstants.EsiResource$getSnapshotKeys, this.getResource(), new Object[0]));
            return keys.contains(this.getLocalSnapshotKey(username));
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public boolean applySnapshot(String username) {
        TwcDialogManager dm = TwcAdapter.getDialogManager();
        String key = "";
        if (this.hasAutosavedSnapshot(username)) {
            boolean result;
            boolean bl = result = dm.messageBox(MessageEnum.APPLY_AUTOSAVE.toString(), MessageUtil.msg((MessageEnum)MessageEnum.APPLY_AUTOSAVE), 194) == 64;
            if (result) {
                key = this.getAutosaveSnapshotKey(username);
            }
        } else if ("".equals(key) && this.hasSnapshot(username)) {
            boolean result;
            boolean bl = result = dm.messageBox(MessageEnum.APPLY_SNAPSHOT.toString(), MessageUtil.msg((MessageEnum)MessageEnum.APPLY_SNAPSHOT), 194) == 64;
            if (result) {
                key = this.getLocalSnapshotKey(username);
            }
        }
        if ("".equals(key)) {
            return false;
        }
        TwcUtils.invoke(TwcDependencyConstants.EsiResource$loadSnapshot, this.getResource(), key);
        return true;
    }

    public void takeAutoSave(String username) throws MPAccessException {
        try {
            TwcUtils.invoke(TwcDependencyConstants.EsiResource$takeSnapshot, this.getResource(), this.snapShot_Mode, this.getAutosaveSnapshotKey(username));
        }
        catch (Exception e) {
            throw new MPAccessException(MessageUtil.msg((MessageEnum)MessageEnum.AUTO_SAVE_EXCEPTION), (Throwable)e);
        }
    }
}

