/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAccess;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcParameters;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.TwcUtils;
import com.maplesoft.maplembse.special.twc.dependency.dialog.TwcLoginDialog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.openmbee.mpspi.exceptions.MPAccessException;

public class TwcAccessImpl
implements TwcAccess {
    public static final Logger LOGGER = Logger.getLogger(TwcAccessImpl.class);
    private static final NotificationFilter notificationFilterForChangeMgr = NotificationFilter.createNotifierTypeFilter((EClassifier)M2Element.Element);
    static final int RETRY_MAX = 5;
    public static final String STRING = String.class.getSimpleName();
    private static final String SUFFIX_PROJECT_NAME = ".MASTER";
    private TwcAdapter adapter;
    private TwcLoginDialog login;
    private Map<String, Object> map;
    private Object repositoryManager;
    private Object userManager;
    private ResourceSet resourceSet;
    private Object session;
    private Object accessManager;
    private final Object sessionStateEnum = TwcUtils.getEnumValue(TwcDependencyConstants.SessionState, "OPEN");
    private final Collector<Map.Entry<String, Object>, ?, Set<String>> collector = Collector.of(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER), (set, entry) -> set.add((String)entry.getKey()), (first, second) -> {
        first.addAll(second);
        return first;
    }, new Collector.Characteristics[0]);

    public Object getAccessManager() {
        if (this.accessManager != null) {
            return this.accessManager;
        }
        if (this.session != null) {
            this.accessManager = TwcUtils.invoke(TwcDependencyConstants.Session$getAccessManager, this.session, new Object[0]);
            return this.accessManager;
        }
        return null;
    }

    TwcAccessImpl(TwcAdapter adapter) {
        this.adapter = adapter;
    }

    private void checkSession() {
        if (!this.isOpened()) {
            throw new IllegalStateException(MessageUtil.msg((MessageEnum)MessageEnum.SESSION_INVALID_EXCEPTION), null);
        }
    }

    public void close() {
        if (this.session != null) {
            try {
                TwcUtils.invoke(TwcDependencyConstants.Session$close, this.session, new Object[0]);
                this.session = null;
                this.map = null;
                this.repositoryManager = null;
                this.userManager = null;
                this.accessManager = null;
                this.resourceSet = null;
            }
            catch (Throwable th) {
                LOGGER.error((Object)th);
            }
        }
    }

    public void ensureConnection() throws MPAccessException {
        this.checkSession();
        if (TwcUtils.invoke(TwcDependencyConstants.Session$getState, this.session, new Object[0]) == this.sessionStateEnum) {
            return;
        }
        TwcUtils.invoke(TwcDependencyConstants.Session$reconnect, this.session, new Object[0]);
    }

    public List<String> getBranches(String project) {
        this.checkSession();
        this.getProjectMap();
        Object p = this.map.get(project);
        if (p == null) {
            return Collections.emptyList();
        }
        UUID u = TwcUtils.invoke(TwcDependencyConstants.ResourceInfo$getID, p, new Object[0]);
        List<Object> list = TwcUtils.invoke(TwcDependencyConstants.RepositoryManager$getBranchInfos, this.getRepositoryManager(), u);
        List<String> result = list.stream().map(o -> TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getName, o, new Object[0])).collect(Collectors.toList());
        Collections.sort(result);
        return result;
    }

    public UUID getBranchID(String project, String branch) {
        Object p = this.getProjectMap().get(project);
        UUID u = TwcUtils.invoke(TwcDependencyConstants.ResourceInfo$getID, p, new Object[0]);
        List<Object> list = TwcUtils.invoke(TwcDependencyConstants.RepositoryManager$getBranchInfos, this.getRepositoryManager(), u);
        for (Object bi : list) {
            String bn = TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getName, bi, new Object[0]);
            boolean isSameBranch = branch == null || branch.equals("") ? "trunk".equals(bn) : bn.equals(branch);
            if (!isSameBranch) continue;
            return TwcUtils.invoke(TwcDependencyConstants.BranchInfo$getID, bi, new Object[0]);
        }
        return null;
    }

    public Object getCacheManager() {
        this.checkSession();
        return TwcUtils.invoke(TwcDependencyConstants.Session$getCacheManager, this.session, new Object[0]);
    }

    public TwcDialog getDialog() {
        if (this.login == null) {
            this.login = TwcLoginDialog.getInstance(this.adapter);
        }
        return this.login;
    }

    public Object getLockManager() {
        this.checkSession();
        return TwcUtils.invoke(TwcDependencyConstants.Session$getLockManager, this.session, new Object[0]);
    }

    public Map<String, Object> getProjectMap() {
        this.checkSession();
        try {
            if (this.map == null) {
                Class<?> rbacClass = TwcDependencyConstants.RbacConstants;
                UUID id = (UUID)rbacClass.getField("PERMISSION_ID_READ_RESOURCE").get(UUID.class);
                Object repositoryManager = TwcUtils.invoke(TwcDependencyConstants.Session$getRepositoryManager, this.session, new Object[0]);
                List<Object> resourcesInfo = TwcUtils.invoke(TwcDependencyConstants.RepositoryManager$getResourceInfos, repositoryManager, id, false);
                this.map = new HashMap<String, Object>(resourcesInfo.size());
                int SUFFIX_LEN = SUFFIX_PROJECT_NAME.length();
                for (Object ri : resourcesInfo) {
                    String pn = TwcUtils.invoke(TwcDependencyConstants.ResourceInfo$getName, ri, new Object[0]);
                    if (!pn.endsWith(SUFFIX_PROJECT_NAME)) continue;
                    String tmp = pn.substring(0, pn.length() - SUFFIX_LEN);
                    this.map.put(tmp, ri);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            this.map = Collections.emptyMap();
        }
        return this.map;
    }

    public Collection<String> getProjects(String category) {
        this.checkSession();
        if (category == null || category.isEmpty()) {
            return this.getProjectMap().keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        }
        Predicate<Map.Entry> hasSameCategory = e -> {
            String str = this.getCatergoryName(e.getValue());
            return Objects.equals(category, str);
        };
        Map<Boolean, Set<String>> map = this.getProjectMap().entrySet().stream().collect(Collectors.partitioningBy(hasSameCategory, this.collector));
        ArrayList<String> result = new ArrayList<String>();
        Set<String> matchingProjects = map.get(true);
        Set<String> unmatchingProjects = map.get(false);
        if (!matchingProjects.isEmpty()) {
            result.addAll(matchingProjects);
            if (!unmatchingProjects.isEmpty()) {
                result.add("");
            }
        }
        if (!unmatchingProjects.isEmpty()) {
            result.add("=== Select project from another category below ===");
            result.add("");
            result.addAll(unmatchingProjects);
        }
        return result;
    }

    public String getCatergoryName(Object resourceInfo) {
        if (resourceInfo instanceof String) {
            String projectName = (String)resourceInfo;
            resourceInfo = this.getProjectMap().entrySet().stream().filter(e -> projectName.equals(e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
        }
        UUID uuid = null;
        try {
            uuid = TwcUtils.invoke(TwcDependencyConstants.ResourceInfo$getCategoryID, resourceInfo, new Object[0]);
        }
        catch (Exception e2) {
            return null;
        }
        Optional<UUID> opt = Optional.ofNullable(uuid);
        if (!opt.isPresent()) {
            return "Uncategorized";
        }
        Object category = TwcUtils.invoke(TwcDependencyConstants.RepositoryManager$getCategoryInfo, this.getRepositoryManager(), opt.get());
        String str = TwcUtils.invoke(TwcDependencyConstants.CategoryInfo$getName, category, new Object[0]);
        return str;
    }

    public Collection<String> getCategories() {
        this.checkSession();
        return this.getProjectMap().values().stream().map(this::getCatergoryName).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
    }

    public Object getRepositoryManager() {
        this.checkSession();
        if (this.repositoryManager == null) {
            this.repositoryManager = TwcUtils.invoke(TwcDependencyConstants.Session$getRepositoryManager, this.session, new Object[0]);
        }
        return this.repositoryManager;
    }

    public Object getUserManager() {
        this.checkSession();
        if (this.userManager == null) {
            this.userManager = TwcUtils.invoke(TwcDependencyConstants.Session$getUserManager, this.session, new Object[0]);
        }
        return this.userManager;
    }

    public ResourceSet getResourceSet() {
        this.checkSession();
        if (this.resourceSet == null) {
            TwcUtils.invoke(TwcDependencyConstants.Session$setAutoReconnectEnabled, this.session, true);
            this.resourceSet = TwcUtils.invoke(TwcDependencyConstants.Session$getResourceSet, this.session, new Object[0]);
            EPackage.Registry registry = this.resourceSet.getPackageRegistry();
            registry.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
            if (this.adapter != null) {
                registry.putAll((Map)this.adapter.getPackageRegistry());
            }
        }
        return this.resourceSet;
    }

    public boolean isOpened() {
        return this.session != null;
    }

    public void login(TwcParameters params) throws MPAccessException {
        if (!this.isOpened()) {
            this.openSession(params);
        } else {
            this.ensureConnection();
        }
    }

    private void openSession(TwcParameters params) throws MPAccessException {
        Class<?> esiUtilClass = TwcDependencyConstants.EsiUtil;
        Object esi = TwcUtils.invoke(TwcDependencyConstants.EsiUtil$getESI, esiUtilClass, new Object[0]);
        assert (esi != null);
        Object sessionFactory = TwcUtils.invoke(TwcDependencyConstants.ESI$getSessionFactory, esi, new Object[0]);
        Object sessionConfiguratorInstance = null;
        if (TwcDependencyConstants.SessionConfigurator != null) {
            Object licenseMode = TwcUtils.getEnumValue(TwcDependencyConstants.LicenseMode, "FULL");
            try {
                sessionConfiguratorInstance = TwcDependencyConstants.SessionConfigurator.getConstructor(new Class[0]).newInstance(new Object[0]);
                TwcUtils.invoke(TwcDependencyConstants.SessionConfigurator$host, sessionConfiguratorInstance, params.getHost());
                TwcUtils.invoke(TwcDependencyConstants.SessionConfigurator$port, sessionConfiguratorInstance, (int)Integer.valueOf(params.getPort()));
                TwcUtils.invoke(TwcDependencyConstants.SessionConfigurator$mode, sessionConfiguratorInstance, licenseMode);
                if (params.isSSO()) {
                    TwcUtils.invoke(TwcDependencyConstants.SessionConfigurator$token, sessionConfiguratorInstance, params.getToken());
                } else {
                    TwcUtils.invoke(TwcDependencyConstants.SessionConfigurator$username, sessionConfiguratorInstance, params.getUsername(), params.getPassword());
                }
                if (params.isSSLEnabled()) {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    TwcSslClientConfig tscc = new TwcSslClientConfig(params.getSSLKeyName());
                    ks.load(new ByteArrayInputStream(tscc.getClientKeystore()), tscc.getClientPass().toCharArray());
                    TwcUtils.invoke(TwcDependencyConstants.SessionConfigurator$keystore, sessionConfiguratorInstance, ks);
                    TwcUtils.invoke(TwcDependencyConstants.SessionConfigurator$tls, sessionConfiguratorInstance, true);
                }
                this.session = TwcUtils.invoke(TwcDependencyConstants.SessionFactory$createSession, sessionFactory, new Object[0]);
                TwcUtils.invoke(TwcDependencyConstants.Session$open, this.session, sessionConfiguratorInstance);
                assert (this.sessionStateEnum.equals(TwcUtils.invoke(TwcDependencyConstants.Session$getState, this.session, new Object[0])));
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                this.relaunchDialogBox(e, params, "Failed to open TWC session: ");
            }
        } else {
            throw new UnsupportedOperationException("login is not allowed please check you are using right MD libs");
        }
    }

    private void relaunchDialogBox(Exception e, TwcParameters params, String message) throws MPAccessException {
        LOGGER.error((Object)e);
        if (e instanceof RuntimeException && e.getMessage() != null && e.getMessage().contains("Please make sure you use the correct ip:port")) {
            params.setCannotLogin();
        }
        this.close();
        params.setMessage(e.getMessage());
        if (!"main".equals(Thread.currentThread().getName())) {
            throw new MPAccessException(message + e.getMessage().replace("(null)", ""), (Throwable)e);
        }
        this.adapter.display(this.getDialog(), (Observable)params);
    }

    public String getActiveUserName() {
        if (this.session != null && TwcDependencyConstants.Session$getUsername != null) {
            return (String)TwcUtils.invoke(TwcDependencyConstants.Session$getUsername, this.session, new Object[0]);
        }
        return "";
    }

    private static class TwcSslClientConfig {
        private static final String TWC_CERTS_PROPERTY = "com.maplesoft.maplembse.twc.adapter.certs";
        private final String sslKeyName;
        private final String sslKeyPass;
        private final byte[] sslKeyStore;

        TwcSslClientConfig(String sslKeyName) throws IllegalArgumentException {
            this.sslKeyName = sslKeyName;
            String path = System.getProperty(TWC_CERTS_PROPERTY);
            if (path == null) {
                throw new IllegalArgumentException("Not specified certifications in com.maplesoft.maplembse.twc.adapter.certs");
            }
            File certPath = new File(path);
            if (!certPath.isDirectory()) {
                throw new IllegalArgumentException("Certifications " + path + " does not exist");
            }
            try {
                int i;
                this.sslKeyStore = this.readCert(certPath, ".jks");
                byte[] pass = this.readCert(certPath, ".pass");
                for (i = 0; i < pass.length && pass[i] >= 32; ++i) {
                }
                this.sslKeyPass = new String(pass, 0, i);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read " + sslKeyName + " certifications", e);
            }
        }

        public byte[] getClientKeystore() {
            return this.sslKeyStore;
        }

        public String getClientPass() {
            return this.sslKeyPass;
        }

        private byte[] readCert(File base, String suffix) throws IOException {
            int size;
            File f = new File(base, this.sslKeyName + suffix);
            FileInputStream fis = new FileInputStream(f);
            byte[] ret = new byte[]{};
            while ((size = fis.available()) > 0) {
                byte[] ret2 = new byte[ret.length + size];
                System.arraycopy(ret, 0, ret2, 0, ret.length);
                fis.read(ret2, ret.length, size);
                ret = ret2;
            }
            fis.close();
            return ret;
        }
    }

    static class SslClientHandler
    implements InvocationHandler {
        private TwcSslClientConfig clientConfig;

        public SslClientHandler(TwcSslClientConfig clientConfig) {
            this.clientConfig = clientConfig;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            if (method.getName().equalsIgnoreCase("getClientPass")) {
                return this.clientConfig.getClientPass();
            }
            if (method.getName().equalsIgnoreCase("getClientKeystore")) {
                return this.clientConfig.getClientKeystore();
            }
            return method.invoke((Object)this.clientConfig, args);
        }
    }

    public class ChangeMgr
    implements ResourceSetListener {
        public NotificationFilter getFilter() {
            return notificationFilterForChangeMgr;
        }

        public boolean isAggregatePrecommitListener() {
            return true;
        }

        public boolean isPostcommitOnly() {
            return false;
        }

        public boolean isPrecommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            List ns = event.getNotifications();
            HashSet<UUID> lockElems = new HashSet<UUID>(ns.size());
            for (Notification n : ns) {
                Object notifier;
                Class<?> esiObject;
                int eventType = n.getEventType();
                if (eventType == 9 || eventType == 8 || !(esiObject = TwcDependencyConstants.EsiObject).isInstance(notifier = n.getNotifier())) continue;
                UUID id = TwcUtils.invoke(TwcDependencyConstants.EsiObject$esiID, notifier, new Object[0]);
                lockElems.add(id);
            }
            return null;
        }
    }
}

