/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialogManager;
import com.maplesoft.maplembse.special.twc.dependency.Activator;
import com.maplesoft.maplembse.special.twc.dependency.NoMagicRoot;
import com.maplesoft.maplembse.special.twc.dependency.dialog.NoMagicRootDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.openmbee.mpspi.exceptions.MPAccessException;
import org.openmbee.mpspi.exceptions.MPException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.FrameworkWiring;

public abstract class TwcAbstractInstallNoMagicLib {
    public static final Logger LOGGER = Logger.getLogger(TwcAbstractInstallNoMagicLib.class);
    public static final String preinstalledPathDir = "com.maplesoft.maplembse.special.twc.dependency.preinstalled.library.dir";

    public String checkPath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        File md = new File(path);
        if (!md.exists()) {
            return null;
        }
        File libBundlesDir19 = new File(md, "lib/bundles");
        if (libBundlesDir19.isDirectory() && libBundlesDir19.exists()) {
            return libBundlesDir19.getAbsolutePath();
        }
        File libBundlesDir = new File(md, "lib");
        if (libBundlesDir.isDirectory() && libBundlesDir.exists()) {
            return libBundlesDir.getAbsolutePath();
        }
        File pluginsDir = new File(md, "plugins");
        if (pluginsDir.isDirectory() && pluginsDir.exists()) {
            return pluginsDir.getAbsolutePath();
        }
        return null;
    }

    abstract boolean installBundles(String var1) throws MPException;

    abstract boolean addPreinstalledNoMagicRoot(List<NoMagicRoot> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NoMagicRoot chooseNoMagicRoot(NoMagicRoot prev, List<NoMagicRoot> nmRoots) {
        NoMagicRootDialog nmrd = new NoMagicRootDialog(prev, nmRoots);
        TwcDialogManager dialogManager = new TwcDialogManager();
        dialogManager.open((TwcDialog)nmrd, null);
        try {
            dialogManager.stop();
        }
        catch (Throwable throwable) {
        }
        finally {
            dialogManager = null;
        }
        return nmrd.getResult();
    }

    public NoMagicRoot getNoMagicRoot(NoMagicRoot prev, String envRootPath, boolean alwaysChoose) {
        File d;
        NoMagicRoot envRoot = null;
        if (envRootPath != null && (d = new File(envRootPath)).isDirectory()) {
            envRoot = new NoMagicRoot(d, "", -2L);
            if (!alwaysChoose) {
                return envRoot;
            }
        }
        ArrayList<NoMagicRoot> nmRoots = new ArrayList<NoMagicRoot>();
        if (envRoot != null) {
            nmRoots.add(envRoot);
        }
        this.addPreinstalledNoMagicRoot(nmRoots);
        Collections.reverse(nmRoots);
        if (prev != null && !nmRoots.isEmpty()) {
            NoMagicRoot recent = (NoMagicRoot)nmRoots.get(0);
            if (!recent.isRecentlyUsed(prev)) {
                if (!alwaysChoose) {
                    return prev;
                }
            } else {
                prev = null;
            }
        }
        if (alwaysChoose && TwcAdapter.getDialogManager().messageBox(MessageEnum.LIBRARY_SELECTION.toString(), MessageUtil.msg((MessageEnum)MessageEnum.NOMAGIC_SHIFT_KEY_PRESS), 194) == 128) {
            if (envRoot != null) {
                return envRoot;
            }
            if (prev != null) {
                return prev;
            }
        }
        return this.chooseNoMagicRoot(prev, nmRoots);
    }

    public void installNoMagicLib() throws MPException {
        String nmRootPath = System.getenv("MAPLEMBSE_MD_INSTALL_ROOT");
        NoMagicRoot cur = null;
        boolean alwaysChoose = TwcAdapter.getDialogManager().isShiftPressed();
        if (alwaysChoose || nmRootPath == null) {
            NoMagicRoot prev = NoMagicRoot.load();
            cur = this.getNoMagicRoot(prev, nmRootPath, alwaysChoose);
            if (cur == null) {
                NoMagicRoot.clear();
                throw new Error(MessageUtil.msg((MessageEnum)MessageEnum.NOMAGIC_LIBRARY_EXCEPTION));
            }
            nmRootPath = cur.rootDir.getAbsolutePath();
        }
        if ((nmRootPath = this.checkPath(nmRootPath)) == null) {
            NoMagicRoot.clear();
            cur = this.getNoMagicRoot(null, null, alwaysChoose);
            if (cur == null) {
                NoMagicRoot.clear();
                throw new Error(MessageUtil.msg((MessageEnum)MessageEnum.NOMAGIC_LIBRARY_EXCEPTION));
            }
            nmRootPath = this.checkPath(cur.rootDir.getAbsolutePath());
        }
        if (nmRootPath == null) {
            throw new Error(MessageUtil.msg((MessageEnum)MessageEnum.NOMAGIC_LIBRARY_EXCEPTION));
        }
        if (cur == null) {
            cur = new NoMagicRoot(new File(nmRootPath).getParentFile(), "");
        }
        if (this.installBundles(nmRootPath)) {
            if (cur != null) {
                cur.save();
            }
        } else {
            NoMagicRoot.clear();
        }
        LOGGER.info((Object)"DONE with TWCInstallNoMagicLib Class");
    }

    protected Bundle installSvcBundles(BundleContext bundleContext) throws MPException {
        String path = System.getProperty("com.maplesoft.maplembse.special.twc.dependency.service.library.path");
        try {
            File file = new File(path);
            String name = file.getName();
            LOGGER.info((Object)("Install:" + name));
            return bundleContext.installBundle("reference:file:/" + file.getAbsolutePath());
        }
        catch (Exception e) {
            if (e instanceof BundleException && !e.getMessage().contains("A bundle is already installed with the name")) {
                throw new MPAccessException(e.getMessage(), e.getCause());
            }
            LOGGER.error((Object)e);
            return null;
        }
    }

    protected boolean isResolved(List<Bundle> bundles) throws MPException {
        FrameworkWiring wiring = (FrameworkWiring)this.getSystemBundle().adapt(FrameworkWiring.class);
        return wiring.resolveBundles(bundles);
    }

    protected Bundle getSystemBundle() throws MPException {
        Bundle[] bundles;
        BundleContext bundleContext = FrameworkUtil.getBundle(Activator.class).getBundleContext();
        for (Bundle bun : bundles = bundleContext.getBundles()) {
            if (!bun.getSymbolicName().contains("org.eclipse.osgi")) continue;
            return bun;
        }
        throw new MPAccessException(MessageUtil.msg((MessageEnum)MessageEnum.OSGI_BUNDLE_EXCEPTION));
    }
}

