/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.maplesoft.maplembse.special.twc.adapter.Activator;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class NoMagicRoot
implements Comparable<NoMagicRoot>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final File rootDir;
    public final long lastModified;
    public final String version;
    private long lastSelected;
    private static final String NO_MAGIC_ROOT_DATAOBJECT_NAME = "nomagic.root";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NoMagicRoot load() {
        try (ObjectInputStream ois = Activator.getDefault().getDataObjectInputStream(NO_MAGIC_ROOT_DATAOBJECT_NAME);){
            Object obj = ois.readObject();
            if (!(obj instanceof NoMagicRoot)) return null;
            NoMagicRoot noMagicRoot = (NoMagicRoot)obj;
            return noMagicRoot;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void select() {
        this.lastSelected = System.currentTimeMillis();
    }

    public void save() {
        this.select();
        Activator.getDefault().saveDataObject(NO_MAGIC_ROOT_DATAOBJECT_NAME, (Object)this);
    }

    public static void clear() {
        Activator.getDefault().clearDataObject(NO_MAGIC_ROOT_DATAOBJECT_NAME);
    }

    public boolean isRecentlyUsed(NoMagicRoot prev) {
        return this.lastModified > prev.lastSelected;
    }

    NoMagicRoot(File rootDir, String version, long lastModified) {
        this.rootDir = rootDir;
        this.version = version;
        this.lastModified = lastModified;
    }

    public NoMagicRoot(File rootDir, String version) {
        this.rootDir = rootDir;
        this.version = version;
        this.lastModified = 0L;
    }

    @Override
    public int compareTo(NoMagicRoot other) {
        if (this.lastModified < other.lastModified) {
            return 1;
        }
        if (this.lastModified > other.lastModified) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof NoMagicRoot)) {
            return false;
        }
        NoMagicRoot other = (NoMagicRoot)arg0;
        return this.rootDir.equals(other.rootDir);
    }

    public int hashCode() {
        return this.rootDir.hashCode();
    }

    public String toString() {
        if (this.lastModified == -2L) {
            return "System Environment - " + this.rootDir.toString();
        }
        if (this.lastModified == -1L) {
            return "Preinstalled - " + this.rootDir.toString();
        }
        if (this.lastModified == 0L) {
            return "Added - " + this.rootDir.toString();
        }
        return this.rootDir.toString();
    }
}

