/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.dependency;

import com.google.common.reflect.Invokable;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.annotation.TwcJavaPackage;
import com.maplesoft.maplembse.special.twc.dependency.TwcDependencyConstants;
import com.maplesoft.maplembse.special.twc.dependency.TwcUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPAccessException;
import org.openmbee.mpspi.exceptions.MPException;

public class M2ElementInject {
    public static final Logger LOGGER = Logger.getLogger(M2ElementInject.class);
    static EPackage eINSTANCE;

    private static EPackage getEPackage(String fqdn) throws Exception {
        Class<?> pkgClass = TwcUtils.getClass(fqdn);
        if (pkgClass == null) {
            throw new MPAccessException("Unable to find the " + fqdn + " class");
        }
        Field f = pkgClass.getField("eINSTANCE");
        EPackage ePkg = (EPackage)f.get(null);
        return ePkg;
    }

    public static void inject() throws MPException {
        block2: {
            try {
                M2Element.ePACKAGE = eINSTANCE = M2ElementInject.getEPackage("com.nomagic.uml2.ext.magicdraw.metadata.UMLPackage");
                TwcConstants.mdFoundationPackage = M2ElementInject.getEPackage("com.nomagic.magicdraw.foundation.MDFoundationPackage");
                TwcConstants.esiProjectEPackage = M2ElementInject.getEPackage("com.nomagic.magicdraw.esi.esiproject.EsiprojectPackage");
                TwcConstants.diagramPackage = M2ElementInject.getEPackage("com.nomagic.magicdraw.foundation.diagram.DiagramPackage");
                TwcConstants.coreDiagramPackage = M2ElementInject.getEPackage("com.nomagic.magicdraw.core.diagram.DiagramPackage");
                TwcConstants.BinaryPackage = M2ElementInject.getEPackage("com.nomagic.magicdraw.esi.binary.metamodel.BinaryPackage");
                TwcConstants.BinaryPackage1 = M2ElementInject.getEPackage("com.nomagic.ci.metamodel.binary.BinaryPackage");
                M2ElementInject.injectEcore(M2Element.class);
                M2ElementInject.injectEcore(TwcConstants.class);
                M2ElementInject.injectLockingHelper();
                M2ElementInject.injectEcore(TwcDependencyConstants.class);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                if (!(e instanceof MPException)) break block2;
                throw new MPAccessException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void injectLockingHelper() {
        if (TwcDependencyConstants.urlClassLoader == null) {
            return;
        }
        try {
            Invokable target;
            TwcDependencyConstants.LockingHelper = TwcDependencyConstants.urlClassLoader.loadClass("com.nomagic.magicdraw.teamwork2.locks.LockingHelper");
            String[] params = TwcDependencyConstants.class.getField("LockingHelper$isLockable").getAnnotation(TwcJavaPackage.class).params();
            String[] methodName = TwcDependencyConstants.class.getField("LockingHelper$isLockable").getName().split("\\$");
            TwcDependencyConstants.LockingHelper$isLockable = target = Invokable.from((Method)TwcUtils.getMethod(TwcDependencyConstants.LockingHelper, methodName[1], params));
        }
        catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
            LOGGER.error((Object)e);
        }
    }

    private static boolean isNotinitializedField(Field f) {
        try {
            boolean optional = false;
            if (f.isAnnotationPresent(TwcJavaPackage.class)) {
                optional = f.getAnnotation(TwcJavaPackage.class).isOptional();
            }
            return f.get(Object.class) == null && !optional;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return true;
        }
    }

    private static void injectEcore(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getFields()) {
            Class<?> fieldClass = field.getType();
            String fieldName = field.getName();
            try {
                if (field.get(Object.class) != null || fieldClass.equals(EPackage.class)) continue;
                String[] splitFieldName = fieldName.split("\\$");
                String[] packages = new String[]{};
                String[] methods = new String[]{};
                Class<?> cls = null;
                Object injectTarget = null;
                TwcJavaPackage annotation = field.getAnnotation(TwcJavaPackage.class);
                if (annotation != null) {
                    packages = annotation.Package();
                    methods = annotation.params();
                }
                if (fieldClass.equals(Invokable.class)) {
                    String str;
                    if (splitFieldName.length < 2) {
                        throw new IllegalArgumentException("Invalid field name:" + fieldName);
                    }
                    var14_15 = packages;
                    var15_16 = var14_15.length;
                    for (var16_17 = 0; var16_17 < var15_16 && (cls = TwcUtils.getClass((str = var14_15[var16_17]).concat(".").concat(splitFieldName[0]))) == null; ++var16_17) {
                    }
                    if (cls != null) {
                        injectTarget = Invokable.from((Method)TwcUtils.getMethod(cls, splitFieldName[1], methods));
                    }
                } else if (fieldClass.equals(Class.class)) {
                    String pack;
                    String clazzName;
                    var14_15 = packages;
                    var15_16 = var14_15.length;
                    for (var16_17 = 0; var16_17 < var15_16 && (injectTarget = TwcUtils.getClass(clazzName = (pack = var14_15[var16_17]) + "." + fieldName)) == null; ++var16_17) {
                    }
                } else if (fieldClass.equals(EStructuralFeature.class)) {
                    if (splitFieldName.length != 2) {
                        throw new IllegalArgumentException("Invalid field name:" + fieldName);
                    }
                    EClass eCls = (EClass)eINSTANCE.getEClassifier(splitFieldName[0]);
                    injectTarget = eCls.getEStructuralFeature(splitFieldName[1]);
                } else if (EClassifier.class.isAssignableFrom(fieldClass)) {
                    injectTarget = eINSTANCE.getEClassifier(splitFieldName[0]);
                } else {
                    new NoSuchFieldException(fieldClass + " is not supported yet");
                }
                if (injectTarget == null) continue;
                field.set(null, injectTarget);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to inject " + field + " : " + fieldClass + " due to " + e));
            }
        }
        List<String> missingFields = Arrays.asList(clazz.getFields()).stream().filter(M2ElementInject::isNotinitializedField).map(Field::getName).collect(Collectors.toList());
        if (!missingFields.isEmpty()) {
            missingFields.forEach(s -> LOGGER.error((Object)String.format("Field %s is not initialized", s)));
            throw new ExceptionInInitializerError("There are some fields non-initialized in " + clazz);
        }
    }
}

