/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.event;

public interface ExceptionHandlingPolicy {
    public static final ExceptionHandlingPolicy IGNORE = new ExceptionHandlingPolicy(){

        @Override
        public boolean logBeforeHandle() {
            return true;
        }

        @Override
        public void handleException(Throwable throwable) {
        }
    };
    public static final ExceptionHandlingPolicy RETHROW = new ExceptionHandlingPolicy(){

        @Override
        public boolean logBeforeHandle() {
            return false;
        }

        @Override
        public void handleException(Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    };

    public boolean logBeforeHandle();

    public void handleException(Throwable var1);
}

