/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.event;

import com.nomagic.ci.event.EventSubProgressMonitor;
import com.nomagic.ci.event.EventWithProgress;
import com.nomagic.ci.event.ExceptionHandlingPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractEventSupport<L, E> {
    public static final Logger LOG = Logger.getLogger(AbstractEventSupport.class);
    protected final CopyOnWriteArrayList<L> listeners = new CopyOnWriteArrayList();
    private final IProgressMonitor EMPTY_PROGRESS = new NullProgressMonitor();
    private final int DEFAULT_PROGRESS_TIC = 100;
    private ExceptionHandlingPolicy exceptionHandlingPolicy = ExceptionHandlingPolicy.IGNORE;

    public AbstractEventSupport() {
        this(ExceptionHandlingPolicy.IGNORE);
    }

    public AbstractEventSupport(ExceptionHandlingPolicy exceptionHandlingPolicy) {
        this.exceptionHandlingPolicy = exceptionHandlingPolicy;
    }

    public void addListener(L l) {
        this.listeners.addIfAbsent(l);
    }

    public void removeListener(L l) {
        this.listeners.remove(l);
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public List<L> getListeners() {
        return new ArrayList<L>(this.listeners);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fireEvent(E e, IProgressMonitor iProgressMonitor) {
        boolean bl = e instanceof EventWithProgress;
        iProgressMonitor.beginTask("", this.listeners.size() * 100);
        try {
            EventSubProgressMonitor eventSubProgressMonitor = null;
            for (L l : this.listeners) {
                if (bl) {
                    eventSubProgressMonitor = new EventSubProgressMonitor(iProgressMonitor, 100, 2);
                    ((EventWithProgress)e).setProgressMonitor((IProgressMonitor)eventSubProgressMonitor);
                }
                try {
                    this.notify(l, e);
                }
                catch (Throwable throwable) {
                    LOG.debug((Object)"Listener failed on notification:", throwable);
                    if (this.exceptionHandlingPolicy.logBeforeHandle()) {
                        LOG.error((Object)"Listener failed on notification:", throwable);
                    }
                    this.exceptionHandlingPolicy.handleException(throwable);
                }
                if (eventSubProgressMonitor != null) {
                    if (eventSubProgressMonitor.isDone()) continue;
                    if (eventSubProgressMonitor.isBegin()) {
                        eventSubProgressMonitor.done();
                        continue;
                    }
                    iProgressMonitor.worked(100);
                    continue;
                }
                iProgressMonitor.worked(100);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public final void fireEvent(E e) {
        this.fireEvent(e, this.EMPTY_PROGRESS);
    }

    protected abstract void notify(L var1, E var2);
}

