/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;

public class StringIntern {
    @CheckForNull
    private static volatile Map<String, String> optionalInternMap = null;
    private static Map<String, String> internMap = new ConcurrentHashMap<String, String>();
    private static volatile boolean optionalInternEnabled;

    static {
        StringIntern.setOptionalInternEnabled(Boolean.valueOf(System.getProperty("magicdraw.string.intern.enabled", "false")));
    }

    public static void setOptionalInternEnabled(boolean bl) {
        if (optionalInternEnabled != bl) {
            optionalInternEnabled = bl;
            StringIntern.clearOptionalIntern();
        }
    }

    public static void clearOptionalIntern() {
        optionalInternMap = optionalInternEnabled ? new ConcurrentHashMap() : null;
    }

    @CheckForNull
    public static String optionalIntern(@CheckForNull String string2) {
        Map<String, String> map = optionalInternMap;
        if (string2 != null && map != null) {
            return map.computeIfAbsent(string2, string -> string);
        }
        return string2;
    }

    @CheckForNull
    public static String intern(@CheckForNull String string2) {
        return string2 != null ? internMap.computeIfAbsent(string2, string -> string) : null;
    }

    @CheckForNull
    public static List<?> intern(@CheckForNull List<?> list) {
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                Object obj = list.get(n);
                if (obj instanceof String) {
                    list.set(n, StringIntern.intern(obj.toString()));
                }
                ++n;
            }
        }
        return list;
    }

    public static boolean isOptionalInternEnabled() {
        return optionalInternEnabled;
    }
}

