/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.common.tools.api.query.IllegalStateExceptionQuery;
import org.eclipse.sirius.common.ui.business.api.views.properties.tabbed.ILabelProviderProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.utils.NamingHelper;

public class TabbedPropertiesLabelProvider
extends MDEAdapterFactoryLabelProvider
implements ILabelProviderProvider {
    public String getText(Object element) {
        String title = "<unknown>";
        EObject modelElement = this.getModel(element);
        if (modelElement != null) {
            title = NamingHelper.getDefaultTitle((EObject)modelElement);
        } else if (element instanceof StructuredSelection) {
            Object selection = ((IStructuredSelection)element).getFirstElement();
            if (selection instanceof AbstractGraphicalEditPart) {
                return this.getTextForEditPart((AbstractGraphicalEditPart)selection);
            }
            if (selection instanceof IResource) {
                return NamingHelper.getTextForResource((IResource)((IResource)selection));
            }
        }
        return this.encode(title);
    }

    private String getTextForEditPart(AbstractGraphicalEditPart editPart) {
        StringBuilder sb = new StringBuilder("");
        Object model = editPart.getModel();
        if (editPart instanceof NoteEditPart) {
            sb.append(((Shape)model).getType());
            return sb.toString();
        }
        if (editPart instanceof TextEditPart) {
            sb.append(((Shape)model).getType());
            return sb.toString();
        }
        if (editPart instanceof NoteAttachmentEditPart) {
            sb.append(((Connector)model).getType());
            return sb.toString();
        }
        return sb.toString();
    }

    protected String encode(String str) {
        return str.replaceAll("&", "&&");
    }

    public Image getImage(Object element) {
        Image result;
        block3: {
            result = null;
            EObject model = this.getModel(element);
            if (model != null) {
                try {
                    result = super.getImage((Object)model);
                }
                catch (IllegalStateException e) {
                    if (new IllegalStateExceptionQuery(e).isAConnectionLostException()) break block3;
                    throw e;
                }
            }
        }
        return result;
    }

    private EObject getModel(Object element) {
        if (element instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)element;
            return CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)selection.getFirstElement());
        }
        return null;
    }

    public ILabelProvider getLabelProvider() {
        return this;
    }

    public boolean provides(Object selection) {
        return true;
    }
}

