/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.ManifestResource;
import aQute.bnd.osgi.Resource;
import java.io.InputStream;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.bnd.FileResource;
import org.eclipse.pde.internal.core.project.PDEProject;

public class ProjectJar
extends Jar {
    private final IContainer outputFolder;

    public ProjectJar(IProject project, Predicate<IResource> filter) throws CoreException {
        super(project.getName());
        this.outputFolder = PDEProject.getBundleRoot(project);
        FileResource.addResources(this, this.outputFolder, filter);
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IPath location;
                IClasspathEntry cp = iClasspathEntryArray[n2];
                if (cp.getEntryKind() == 3 && !cp.isTest() && (location = cp.getOutputLocation()) != null) {
                    IFolder otherOutputFolder = workspaceRoot.getFolder(location);
                    FileResource.addResources(this, (IContainer)otherOutputFolder, filter);
                }
                ++n2;
            }
        }
    }

    public void setManifest(Manifest manifest) {
        super.setManifest(manifest);
        this.putResource("META-INF/MANIFEST.MF", (Resource)new ManifestResource(manifest));
    }

    public boolean putResource(String path, Resource resource, boolean overwrite) {
        IFile file;
        block23: {
            if (resource instanceof FileResource) {
                return super.putResource(path, resource, overwrite);
            }
            file = this.outputFolder.getFile((IPath)new Path(path));
            try {
                if (file.exists()) {
                    if (!overwrite) break block23;
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (InputStream stream = resource.openInputStream();){
                        file.setContents(stream, true, false, null);
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.mkdirs((IResource)file);
                Throwable throwable = null;
                Object var6_13 = null;
                try (InputStream stream = resource.openInputStream();){
                    file.create(stream, true, null);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.putResource(path, (Resource)new FileResource(file), overwrite);
    }

    /*
     * WARNING - void declaration
     */
    private void mkdirs(IResource resource) throws CoreException {
        if (resource == null) {
            return;
        }
        this.mkdirs((IResource)resource.getParent());
        IResource iResource = resource;
        if (iResource instanceof IFolder) {
            void folder;
            IFolder iFolder = (IFolder)iResource;
            IFolder cfr_ignored_0 = (IFolder)iResource;
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
        }
    }
}

