/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel.util;

import com.google.common.base.Function;
import com.ibm.trinity.syncmodel.AbstractDimension;
import com.ibm.trinity.syncmodel.AttributeColumn;
import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.DimensionMember;
import com.ibm.trinity.syncmodel.ReferenceDecomposition;
import com.ibm.trinity.syncmodel.RootDimension;
import com.ibm.trinity.syncmodel.SuccessiveDimension;
import com.ibm.trinity.syncmodel.SyncTableSchema;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class SyncModelUtil {
    public static List<Column> getColumns(SyncTableSchema syncTable) {
        return SyncModelUtil.getColumns(syncTable, null);
    }

    public static List<Column> getColumns(SyncTableSchema syncTable, Function<Column, Boolean> filter) {
        ArrayList<Column> columns = new ArrayList<Column>();
        SyncModelUtil.addTargetColumns(columns, syncTable, filter);
        return columns;
    }

    private static void addTargetColumns(List<Column> columns, SyncTableSchema syncTable, Function<Column, Boolean> filter) {
        RootDimension rootDim = syncTable.getRootDimension();
        EList<DimensionMember> members = rootDim.getMembers();
        SyncModelUtil.addColumns(columns, members, filter);
        EList<AbstractDimension> dims = syncTable.getSuccessiveDimensions();
        for (AbstractDimension dim : dims) {
            if (!(dim instanceof SuccessiveDimension)) continue;
            members = ((SuccessiveDimension)dim).getMembers();
            SyncModelUtil.addColumns(columns, members, filter);
        }
    }

    private static void addColumns(List<Column> result, EList<DimensionMember> members, Function<Column, Boolean> filter) {
        for (DimensionMember member : members) {
            if (member instanceof AttributeColumn) {
                if (filter != null && !((Boolean)filter.apply((Object)((AttributeColumn)member))).booleanValue()) continue;
                result.add((AttributeColumn)member);
                continue;
            }
            if (!(member instanceof ReferenceDecomposition)) continue;
            ReferenceDecomposition containerMap = (ReferenceDecomposition)member;
            SyncModelUtil.addContainerTableColumns(result, containerMap, filter);
        }
    }

    private static void addContainerTableColumns(List<Column> columns, ReferenceDecomposition containerMap, Function<Column, Boolean> filter) {
        for (Column column : containerMap.getColumns()) {
            if (filter != null && !((Boolean)filter.apply((Object)column)).booleanValue()) continue;
            columns.add(column);
        }
    }
}

