/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel.impl;

import com.ibm.trinity.syncmodel.AbstractDimension;
import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.Dimension;
import com.ibm.trinity.syncmodel.DimensionGroup;
import com.ibm.trinity.syncmodel.KeyColumn;
import com.ibm.trinity.syncmodel.ReferenceDecomposition;
import com.ibm.trinity.syncmodel.RootDimension;
import com.ibm.trinity.syncmodel.SuccessiveDimension;
import com.ibm.trinity.syncmodel.SyncModelElement;
import com.ibm.trinity.syncmodel.SyncModelElementVisitor;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.SyncTableParam;
import com.ibm.trinity.syncmodel.SyncTableSchema;
import com.ibm.trinity.syncmodel.impl.TypedSyncTableImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class SyncTableSchemaImpl
extends TypedSyncTableImpl
implements SyncTableSchema {
    protected EList<SyncTableParam> parameters;
    protected RootDimension rootDimension;
    protected EList<AbstractDimension> successiveDimensions;
    private EList<Dimension> dimensions = null;
    private EList<Column> columns = null;
    private EList<KeyColumn> keyColumns = null;

    protected SyncTableSchemaImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SyncModelPackage.Literals.SYNC_TABLE_SCHEMA;
    }

    @Override
    public EList<SyncTableParam> getParameters() {
        if (this.parameters == null) {
            this.parameters = new EObjectContainmentWithInverseEList(SyncTableParam.class, (InternalEObject)this, 2, 2);
        }
        return this.parameters;
    }

    @Override
    public RootDimension getRootDimension() {
        return this.rootDimension;
    }

    public NotificationChain basicSetRootDimension(RootDimension newRootDimension, NotificationChain msgs) {
        RootDimension oldRootDimension = this.rootDimension;
        this.rootDimension = newRootDimension;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldRootDimension, (Object)newRootDimension);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setRootDimension(RootDimension newRootDimension) {
        if (newRootDimension != this.rootDimension) {
            NotificationChain msgs = null;
            if (this.rootDimension != null) {
                msgs = ((InternalEObject)this.rootDimension).eInverseRemove((InternalEObject)this, 9, RootDimension.class, msgs);
            }
            if (newRootDimension != null) {
                msgs = ((InternalEObject)newRootDimension).eInverseAdd((InternalEObject)this, 9, RootDimension.class, msgs);
            }
            if ((msgs = this.basicSetRootDimension(newRootDimension, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newRootDimension, (Object)newRootDimension));
        }
    }

    @Override
    public EList<AbstractDimension> getSuccessiveDimensions() {
        if (this.successiveDimensions == null) {
            this.successiveDimensions = new EObjectContainmentWithInverseEList(AbstractDimension.class, (InternalEObject)this, 4, 1);
        }
        return this.successiveDimensions;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getParameters()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                if (this.rootDimension != null) {
                    msgs = ((InternalEObject)this.rootDimension).eInverseRemove((InternalEObject)this, -4, null, msgs);
                }
                return this.basicSetRootDimension((RootDimension)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getSuccessiveDimensions()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return this.basicSetRootDimension(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getSuccessiveDimensions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getParameters();
            }
            case 3: {
                return this.getRootDimension();
            }
            case 4: {
                return this.getSuccessiveDimensions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setRootDimension((RootDimension)newValue);
                return;
            }
            case 4: {
                this.getSuccessiveDimensions().clear();
                this.getSuccessiveDimensions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getParameters().clear();
                return;
            }
            case 3: {
                this.setRootDimension(null);
                return;
            }
            case 4: {
                this.getSuccessiveDimensions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
            case 3: {
                return this.rootDimension != null;
            }
            case 4: {
                return this.successiveDimensions != null && !this.successiveDimensions.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int getRecordSize() {
        return this.columns.size();
    }

    @Override
    public Column getColumn(int index) {
        RootDimension rootDim = this.getRootDimension();
        if (rootDim == null) {
            return null;
        }
        int lastIdx = rootDim.getLastColumnIndex();
        if (index <= lastIdx) {
            return rootDim.getColumn(index);
        }
        for (AbstractDimension dim : this.getSuccessiveDimensions()) {
            if (index > dim.getLastColumnIndex()) continue;
            return dim.getColumn(index);
        }
        return null;
    }

    @Override
    public Column getColumn(String name) {
        for (Column col : this.getColumns()) {
            if (!name.equals(col.getName())) continue;
            return col;
        }
        return null;
    }

    @Override
    public void initIndex() {
        DimensionCollector dimCollector = new DimensionCollector();
        this.acceptVisitor(dimCollector);
        this.dimensions = dimCollector.getDimensions();
        ColumnCollector columnCollector = new ColumnCollector();
        this.acceptVisitor(columnCollector);
        this.columns = columnCollector.getColumns();
    }

    @Override
    public EList<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.initIndex();
        }
        return this.dimensions;
    }

    @Override
    public EList<Column> getColumns() {
        if (this.columns == null) {
            this.initIndex();
        }
        return this.columns;
    }

    @Override
    public EList<KeyColumn> getKeyColumns() {
        if (this.keyColumns == null) {
            ArrayList<KeyColumn> keys = new ArrayList<KeyColumn>();
            EList<Column> columns = this.getColumns();
            for (Column col : columns) {
                if (!col.isKey()) continue;
                keys.add((KeyColumn)col);
            }
            this.keyColumns = new BasicEList.UnmodifiableEList(keys.size(), (Object[])keys.toArray(new KeyColumn[0]));
        }
        return this.keyColumns;
    }

    @Override
    public boolean isUpdatable() {
        if (!this.rootDimension.isUpdatable()) {
            return false;
        }
        for (AbstractDimension dim : this.getSuccessiveDimensions()) {
            if (dim.isUpdatable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public EModelElement getModelAccessAdapterTarget() {
        return this.getRootDimension().getModelAccessAdapterTarget();
    }

    private static class DimensionCollector
    extends SyncModelElementVisitor {
        private List<Dimension> dimensions = new ArrayList<Dimension>();

        DimensionCollector() {
        }

        EList<Dimension> getDimensions() {
            BasicEList.UnmodifiableEList result = new BasicEList.UnmodifiableEList(this.dimensions.size(), (Object[])this.dimensions.toArray(new Dimension[0]));
            return result;
        }

        @Override
        public List<? extends SyncModelElement> caseSyncTableSchema(SyncTableSchema object) {
            RootDimension rootDim = object.getRootDimension();
            EList<AbstractDimension> successiveDims = object.getSuccessiveDimensions();
            ArrayList<AbstractDimension> children = new ArrayList<AbstractDimension>();
            if (rootDim != null) {
                children.add(rootDim);
            }
            if (successiveDims != null) {
                children.addAll((Collection<AbstractDimension>)successiveDims);
            }
            return children;
        }

        @Override
        public List<? extends SyncModelElement> caseDimensionGroup(DimensionGroup object) {
            return object.getMembers();
        }

        @Override
        public List<? extends SyncModelElement> caseRootDimension(RootDimension object) {
            object.setIndex(0);
            this.dimensions.add(object);
            return null;
        }

        @Override
        public List<? extends SyncModelElement> caseSuccessiveDimension(SuccessiveDimension object) {
            int dimIndex = this.dimensions.size();
            object.setIndex(dimIndex);
            this.dimensions.add(object);
            return null;
        }
    }

    private static class ColumnCollector
    extends DimensionCollector {
        private List<Column> columns = new ArrayList<Column>();

        ColumnCollector() {
        }

        EList<Column> getColumns() {
            BasicEList.UnmodifiableEList result = new BasicEList.UnmodifiableEList(this.columns.size(), (Object[])this.columns.toArray(new Column[0]));
            return result;
        }

        @Override
        public List<? extends SyncModelElement> caseRootDimension(RootDimension object) {
            return object.getMembers();
        }

        @Override
        public List<? extends SyncModelElement> caseSuccessiveDimension(SuccessiveDimension object) {
            return object.getMembers();
        }

        @Override
        public List<? extends SyncModelElement> caseReferenceDecomposition(ReferenceDecomposition object) {
            return object.getColumns();
        }

        @Override
        public List<? extends SyncModelElement> caseColumn(Column object) {
            int columnIndex = this.columns.size();
            object.setIndex(columnIndex);
            this.columns.add(object);
            return null;
        }
    }
}

