/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel.impl;

import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.ForeignColumn;
import com.ibm.trinity.syncmodel.KeyForeignColumn;
import com.ibm.trinity.syncmodel.LocalQuery;
import com.ibm.trinity.syncmodel.ReferenceDecomposition;
import com.ibm.trinity.syncmodel.ReferrableSyncTable;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.impl.DimensionMemberImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ReferenceDecompositionImpl
extends DimensionMemberImpl
implements ReferenceDecomposition {
    protected EList<ForeignColumn> columns;
    protected ReferrableSyncTable foreignTable;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected LocalQuery localQuery;
    protected static final boolean CREATE_TARGET_EDEFAULT = false;
    protected boolean createTarget = false;
    private EList<KeyForeignColumn> keyColumnsCache = null;
    private List<Column> targetKeyColumns = null;

    protected ReferenceDecompositionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SyncModelPackage.Literals.REFERENCE_DECOMPOSITION;
    }

    @Override
    public EList<ForeignColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new EObjectContainmentWithInverseEList(ForeignColumn.class, (InternalEObject)this, 1, 4);
        }
        return this.columns;
    }

    @Override
    public ReferrableSyncTable getForeignTable() {
        if (this.foreignTable != null && this.foreignTable.eIsProxy()) {
            InternalEObject oldForeignTable = (InternalEObject)this.foreignTable;
            this.foreignTable = (ReferrableSyncTable)this.eResolveProxy(oldForeignTable);
            if (this.foreignTable != oldForeignTable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldForeignTable, (Object)this.foreignTable));
            }
        }
        return this.foreignTable;
    }

    public ReferrableSyncTable basicGetForeignTable() {
        return this.foreignTable;
    }

    @Override
    public void setForeignTable(ReferrableSyncTable newForeignTable) {
        ReferrableSyncTable oldForeignTable = this.foreignTable;
        this.foreignTable = newForeignTable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldForeignTable, (Object)this.foreignTable));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public LocalQuery getLocalQuery() {
        if (this.localQuery != null && this.localQuery.eIsProxy()) {
            InternalEObject oldLocalQuery = (InternalEObject)this.localQuery;
            this.localQuery = (LocalQuery)this.eResolveProxy(oldLocalQuery);
            if (this.localQuery != oldLocalQuery && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldLocalQuery, (Object)this.localQuery));
            }
        }
        return this.localQuery;
    }

    public LocalQuery basicGetLocalQuery() {
        return this.localQuery;
    }

    public NotificationChain basicSetLocalQuery(LocalQuery newLocalQuery, NotificationChain msgs) {
        LocalQuery oldLocalQuery = this.localQuery;
        this.localQuery = newLocalQuery;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldLocalQuery, (Object)newLocalQuery);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLocalQuery(LocalQuery newLocalQuery) {
        if (newLocalQuery != this.localQuery) {
            NotificationChain msgs = null;
            if (this.localQuery != null) {
                msgs = ((InternalEObject)this.localQuery).eInverseRemove((InternalEObject)this, 6, LocalQuery.class, msgs);
            }
            if (newLocalQuery != null) {
                msgs = ((InternalEObject)newLocalQuery).eInverseAdd((InternalEObject)this, 6, LocalQuery.class, msgs);
            }
            if ((msgs = this.basicSetLocalQuery(newLocalQuery, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newLocalQuery, (Object)newLocalQuery));
        }
    }

    @Override
    public boolean isCreateTarget() {
        return this.createTarget;
    }

    @Override
    public void setCreateTarget(boolean newCreateTarget) {
        boolean oldCreateTarget = this.createTarget;
        this.createTarget = newCreateTarget;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldCreateTarget, this.createTarget));
        }
    }

    @Override
    public EList<KeyForeignColumn> getKeyColumns() {
        if (this.keyColumnsCache == null) {
            SortedMap<Integer, KeyForeignColumn> keyMap = new TreeMap<Integer, KeyForeignColumn>();
            for (ForeignColumn col : this.getColumns()) {
                if (!(col instanceof KeyForeignColumn)) continue;
                int foreignIndex = col.getRef().getIndex();
                keyMap.put(foreignIndex, (KeyForeignColumn)col);
            }
            Object[] keys = new KeyForeignColumn[keyMap.size()];
            int i = 0;
            while (!keyMap.isEmpty()) {
                Integer idx = (Integer)keyMap.firstKey();
                KeyForeignColumn col = (KeyForeignColumn)keyMap.get(idx);
                keys[i] = col;
                keyMap = keyMap.tailMap(idx + 1);
                ++i;
            }
            this.keyColumnsCache = new BasicEList.UnmodifiableEList(keys.length, keys);
        }
        return this.keyColumnsCache;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getColumns()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                if (this.localQuery != null) {
                    msgs = ((InternalEObject)this.localQuery).eInverseRemove((InternalEObject)this, 6, LocalQuery.class, msgs);
                }
                return this.basicSetLocalQuery((LocalQuery)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return this.basicSetLocalQuery(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getColumns();
            }
            case 2: {
                if (resolve) {
                    return this.getForeignTable();
                }
                return this.basicGetForeignTable();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                if (resolve) {
                    return this.getLocalQuery();
                }
                return this.basicGetLocalQuery();
            }
            case 5: {
                return this.isCreateTarget();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getColumns().clear();
                this.getColumns().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setForeignTable((ReferrableSyncTable)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.setLocalQuery((LocalQuery)newValue);
                return;
            }
            case 5: {
                this.setCreateTarget((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getColumns().clear();
                return;
            }
            case 2: {
                this.setForeignTable(null);
                return;
            }
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setLocalQuery(null);
                return;
            }
            case 5: {
                this.setCreateTarget(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.columns != null && !this.columns.isEmpty();
            }
            case 2: {
                return this.foreignTable != null;
            }
            case 3: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 4: {
                return this.localQuery != null;
            }
            case 5: {
                return this.createTarget;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", createTarget: ");
        result.append(this.createTarget);
        result.append(')');
        return result.toString();
    }

    @Override
    public List<Column> getTargetKeyColumnList() {
        if (this.targetKeyColumns == null) {
            EList<KeyForeignColumn> keyColumns = this.getKeyColumns();
            if (keyColumns.isEmpty()) {
                this.targetKeyColumns = Collections.emptyList();
            } else {
                this.targetKeyColumns = new ArrayList<Column>(keyColumns.size());
                SortedMap<Integer, Column> colMap = new TreeMap<Integer, Column>();
                for (KeyForeignColumn fcol : keyColumns) {
                    Column col = fcol.getRef();
                    colMap.put(col.getIndex(), col);
                }
                while (!colMap.isEmpty()) {
                    Integer idx = (Integer)colMap.firstKey();
                    Column col = (Column)colMap.get(idx);
                    this.targetKeyColumns.add(col);
                    colMap = colMap.tailMap(idx + 1);
                }
            }
        }
        return this.targetKeyColumns;
    }

    @Override
    public Column getColumn(int index) {
        EList<ForeignColumn> columns = this.getColumns();
        if (columns == null) {
            return null;
        }
        int numColumns = columns.size();
        if (numColumns == 0) {
            return null;
        }
        assert (numColumns >= 1);
        ForeignColumn first = (ForeignColumn)columns.get(0);
        int firstIndex = first.getIndex();
        if (index == firstIndex) {
            return first;
        }
        if (index < firstIndex) {
            return null;
        }
        ForeignColumn last = (ForeignColumn)columns.get(numColumns - 1);
        int lastIndex = last.getIndex();
        if (index == lastIndex) {
            return last;
        }
        if (index > lastIndex) {
            return null;
        }
        for (int i = 1; i < numColumns - 1; ++i) {
            ForeignColumn col = (ForeignColumn)columns.get(i);
            if (index != col.getIndex()) continue;
            return col;
        }
        throw new IllegalStateException();
    }

    @Override
    public int getFirstColumnIndex() {
        EList<ForeignColumn> columns = this.getColumns();
        if (columns == null) {
            return Integer.MAX_VALUE;
        }
        int numColumns = columns.size();
        if (numColumns == 0) {
            return Integer.MAX_VALUE;
        }
        ForeignColumn first = (ForeignColumn)columns.get(0);
        return first.getIndex();
    }

    @Override
    public int getLastColumnIndex() {
        EList<ForeignColumn> columns = this.getColumns();
        if (columns == null) {
            return Integer.MIN_VALUE;
        }
        int numColumns = columns.size();
        if (numColumns == 0) {
            return Integer.MIN_VALUE;
        }
        ForeignColumn last = (ForeignColumn)columns.get(numColumns - 1);
        return last.getIndex();
    }
}

