/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel.impl;

import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.JoinedSyncTableSchema;
import com.ibm.trinity.syncmodel.KeyColumn;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.SyncTableSchema;
import com.ibm.trinity.syncmodel.TypedSyncTable;
import com.ibm.trinity.syncmodel.impl.TypedSyncTableImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class JoinedSyncTableSchemaImpl
extends TypedSyncTableImpl
implements JoinedSyncTableSchema {
    protected EList<TypedSyncTable> targetTypes;
    private JoinedSyncTableSchema.JSchema[] topJSchemata;
    private JoinedSyncTableSchema.JColumn[] topJColumns;
    private Map<String, Column> columnMap;
    private EList<Column> columns;
    private EList<KeyColumn> keyColumns;

    protected JoinedSyncTableSchemaImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SyncModelPackage.Literals.JOINED_SYNC_TABLE_SCHEMA;
    }

    @Override
    public EList<TypedSyncTable> getTargetTypes() {
        if (this.targetTypes == null) {
            this.targetTypes = new EObjectResolvingEList(TypedSyncTable.class, (InternalEObject)this, 2);
        }
        return this.targetTypes;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getTargetTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getTargetTypes().clear();
                this.getTargetTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getTargetTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.targetTypes != null && !this.targetTypes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public JoinedSyncTableSchema.JSchema[] getTopJSchemata() {
        return this.topJSchemata;
    }

    @Override
    public JoinedSyncTableSchema.JColumn[] getTopJColumns() {
        return this.topJColumns;
    }

    private List<SyncTableSchema> computeSchemaList(List<SyncTableSchema> ret) {
        for (TypedSyncTable tst : this.getTargetTypes()) {
            if (tst instanceof SyncTableSchema) {
                if (ret.contains(tst)) {
                    throw new IllegalArgumentException("Cyclic JoinedSyncTableSchema:" + tst);
                }
                tst.initIndex();
                ret.add((SyncTableSchema)tst);
                continue;
            }
            if (!(tst instanceof JoinedSyncTableSchemaImpl)) continue;
            JoinedSyncTableSchemaImpl jsts = (JoinedSyncTableSchemaImpl)tst;
            return jsts.computeSchemaList(ret);
        }
        return ret;
    }

    @Override
    public int getRecordSize() {
        return this.topJColumns.length;
    }

    private static Column reindexedColumn(JoinedSyncTableSchema.JColumn jc) {
        Column col = (Column)EcoreUtil.copy((EObject)jc.column);
        col.setIndex(jc.jIndex);
        return col;
    }

    @Override
    public void initIndex() {
        if (this.topJSchemata != null) {
            return;
        }
        HashMap<String, JoinedSyncTableSchema.JColumn> jcDic = new HashMap<String, JoinedSyncTableSchema.JColumn>();
        List<SyncTableSchema> stss = this.computeSchemaList(new ArrayList<SyncTableSchema>());
        int sSize = stss.size();
        this.topJSchemata = new JoinedSyncTableSchema.JSchema[sSize];
        int j = 0;
        for (int i = 0; i < sSize; ++i) {
            SyncTableSchema sts = stss.get(i);
            EList<Column> cols = sts.getColumns();
            JoinedSyncTableSchema.JColumn prev = null;
            for (Column col : cols) {
                String name = col.getName();
                JoinedSyncTableSchema.JColumn up = (JoinedSyncTableSchema.JColumn)jcDic.get(name);
                if (up == null) {
                    ++j;
                }
                prev = new JoinedSyncTableSchema.JColumn(col, i, j, up, prev);
                jcDic.put(name, prev);
                if (this.topJSchemata[i] != null) continue;
                this.topJSchemata[i] = new JoinedSyncTableSchema.JSchema(i, sts, prev);
            }
        }
        this.topJColumns = new JoinedSyncTableSchema.JColumn[j];
        this.columnMap = new HashMap<String, Column>(j);
        this.columns = new BasicEList(j);
        this.keyColumns = new BasicEList();
        for (JoinedSyncTableSchema.JColumn jcol : jcDic.values()) {
            while (jcol.up != null) {
                jcol = jcol.up;
            }
            this.topJColumns[jcol.jIndex] = jcol;
            Column col = JoinedSyncTableSchemaImpl.reindexedColumn(jcol);
            this.columnMap.put(col.getName(), col);
            this.columns.add((Object)col);
            if (col.isKey()) {
                this.keyColumns.add((Object)((KeyColumn)col));
                continue;
            }
            KeyColumn kcol = this.searchKeyJCol(jcol);
            if (kcol == null) continue;
            this.keyColumns.add((Object)kcol);
        }
    }

    private KeyColumn searchKeyJCol(JoinedSyncTableSchema.JColumn jcol) {
        assert (jcol.up == null);
        do {
            Column c;
            if (!(c = jcol.column).isKey()) continue;
            c = JoinedSyncTableSchemaImpl.reindexedColumn(jcol);
            return (KeyColumn)c;
        } while ((jcol = jcol.getDown()) != null);
        return null;
    }

    @Override
    public Column getColumn(String name) {
        return this.columnMap.get(name);
    }

    @Override
    public EList<Column> getColumns() {
        return this.columns;
    }

    @Override
    public EList<KeyColumn> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public KeyColumn getKeyColumn(String name) {
        for (KeyColumn kc : this.keyColumns) {
            if (!kc.getName().equals(name)) continue;
            return kc;
        }
        return null;
    }
}

