/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel.impl;

import com.ibm.trinity.syncmodel.AttributeColumn;
import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.Dimension;
import com.ibm.trinity.syncmodel.DimensionMember;
import com.ibm.trinity.syncmodel.KeyAttributeColumn;
import com.ibm.trinity.syncmodel.KeyColumn;
import com.ibm.trinity.syncmodel.LocalQuery;
import com.ibm.trinity.syncmodel.ObjectQueryPath;
import com.ibm.trinity.syncmodel.PropertyMapping;
import com.ibm.trinity.syncmodel.Qualifier;
import com.ibm.trinity.syncmodel.ReferenceDecomposition;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.impl.AbstractDimensionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class DimensionImpl
extends AbstractDimensionImpl
implements Dimension {
    protected static final boolean READ_ONLY_EDEFAULT = false;
    protected boolean readOnly = false;
    protected static final boolean MAPPED_TO_RECORD_EDEFAULT = false;
    protected boolean mappedToRecord = false;
    protected EList<DimensionMember> members;
    protected static final int INDEX_EDEFAULT = -1;
    protected int index = -1;
    protected static final boolean ALLOW_EMPTY_EDEFAULT = false;
    protected boolean allowEmpty = false;
    private EList<Column> columnsCached = null;
    private EList<KeyColumn> keyColumnsCached = null;

    protected DimensionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SyncModelPackage.Literals.DIMENSION;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean newReadOnly) {
        boolean oldReadOnly = this.readOnly;
        this.readOnly = newReadOnly;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldReadOnly, this.readOnly));
        }
    }

    @Override
    public boolean isMappedToRecord() {
        return this.mappedToRecord || this.getSuccessors().isEmpty();
    }

    @Override
    public void setMappedToRecord(boolean newMappedToRecord) {
        boolean oldMappedToRecord = this.mappedToRecord;
        this.mappedToRecord = newMappedToRecord;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldMappedToRecord, this.mappedToRecord));
        }
    }

    @Override
    public EList<DimensionMember> getMembers() {
        if (this.members == null) {
            this.members = new EObjectContainmentWithInverseEList(DimensionMember.class, (InternalEObject)this, 4, 0);
        }
        return this.members;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int newIndex) {
        int oldIndex = this.index;
        this.index = newIndex;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldIndex, this.index));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getMembers()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getMembers()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.isReadOnly();
            }
            case 3: {
                return this.isMappedToRecord();
            }
            case 4: {
                return this.getMembers();
            }
            case 5: {
                return this.getIndex();
            }
            case 6: {
                return this.getReferenceDecompositions();
            }
            case 7: {
                return this.isAllowEmpty();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setReadOnly((Boolean)newValue);
                return;
            }
            case 3: {
                this.setMappedToRecord((Boolean)newValue);
                return;
            }
            case 4: {
                this.getMembers().clear();
                this.getMembers().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setIndex((Integer)newValue);
                return;
            }
            case 7: {
                this.setAllowEmpty((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setReadOnly(false);
                return;
            }
            case 3: {
                this.setMappedToRecord(false);
                return;
            }
            case 4: {
                this.getMembers().clear();
                return;
            }
            case 5: {
                this.setIndex(-1);
                return;
            }
            case 7: {
                this.setAllowEmpty(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.readOnly;
            }
            case 3: {
                return this.mappedToRecord;
            }
            case 4: {
                return this.members != null && !this.members.isEmpty();
            }
            case 5: {
                return this.index != -1;
            }
            case 6: {
                return !this.getReferenceDecompositions().isEmpty();
            }
            case 7: {
                return this.allowEmpty;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (readOnly: ");
        result.append(this.readOnly);
        result.append(", mappedToRecord: ");
        result.append(this.mappedToRecord);
        result.append(", index: ");
        result.append(this.index);
        result.append(", allowEmpty: ");
        result.append(this.allowEmpty);
        result.append(')');
        return result.toString();
    }

    @Override
    public abstract ObjectQueryPath getQueryPath();

    @Override
    public abstract EClassifier getEClassifier();

    public Qualifier getQualifier() {
        LocalQuery localQuery;
        ObjectQueryPath queryPath = this.getQueryPath();
        if (queryPath != null && (localQuery = queryPath.getLocalQuery()) != null) {
            return localQuery.getQualifier();
        }
        return null;
    }

    @Override
    public EList<Dimension> getHeadDimensions() {
        BasicEList result = new BasicEList(1);
        result.add((Object)this);
        return result;
    }

    @Override
    public EList<Dimension> getTailDimensions() {
        BasicEList result = new BasicEList(1);
        result.add((Object)this);
        return result;
    }

    @Override
    public int getFirstColumnIndex() {
        int n;
        EList<DimensionMember> members = this.getMembers();
        if (members != null && (n = members.size()) > 0) {
            for (DimensionMember m : members) {
                int idx = m.getFirstColumnIndex();
                if (idx == Integer.MAX_VALUE) continue;
                return idx;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getLastColumnIndex() {
        EList<DimensionMember> members = this.getMembers();
        if (members != null) {
            int n = members.size();
            while (--n >= 0) {
                int idx = ((DimensionMember)members.get(n)).getLastColumnIndex();
                if (idx == Integer.MIN_VALUE) continue;
                return idx;
            }
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public EList<Column> getColumns() {
        if (this.columnsCached == null) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (DimensionMember member : this.getMembers()) {
                if (member instanceof AttributeColumn) {
                    columns.add((AttributeColumn)member);
                    continue;
                }
                if (!(member instanceof ReferenceDecomposition)) continue;
                ReferenceDecomposition mapping = (ReferenceDecomposition)member;
                columns.addAll((Collection<Column>)mapping.getColumns());
            }
            this.columnsCached = new BasicEList.UnmodifiableEList(columns.size(), (Object[])columns.toArray(new Column[0]));
        }
        return this.columnsCached;
    }

    @Override
    public EList<KeyColumn> getKeyColumns() {
        if (this.keyColumnsCached != null) {
            return this.keyColumnsCached;
        }
        ArrayList<KeyColumn> columns = new ArrayList<KeyColumn>();
        for (DimensionMember member : this.getMembers()) {
            PropertyMapping propMap;
            if (!(member instanceof PropertyMapping) || !(propMap = (PropertyMapping)member).isKey()) continue;
            if (propMap instanceof KeyAttributeColumn) {
                KeyAttributeColumn col = (KeyAttributeColumn)member;
                columns.add(col);
            }
            for (ReferenceDecomposition decomposition : propMap.getReferenceDecompositions()) {
                if (this != decomposition.getOwnerDimension()) continue;
                columns.addAll((Collection<KeyColumn>)decomposition.getKeyColumns());
            }
        }
        if (this.getQueryPath() != null) {
            for (ReferenceDecomposition decomposition : this.getQueryPath().getReferenceDecompositions()) {
                columns.addAll((Collection<KeyColumn>)decomposition.getKeyColumns());
            }
        }
        Collections.sort(columns, Column.COLUMN_COMPARATOR);
        this.keyColumnsCached = new BasicEList.UnmodifiableEList(columns.size(), (Object[])columns.toArray(new KeyColumn[0]));
        return this.keyColumnsCached;
    }

    @Override
    public Column getColumn(int index) {
        int lastIdx;
        int firstIdx = this.getFirstColumnIndex();
        if (index >= firstIdx && index <= (lastIdx = this.getLastColumnIndex())) {
            for (DimensionMember member : this.getMembers()) {
                if (index > member.getLastColumnIndex()) continue;
                return member.getColumn(index);
            }
            throw new IllegalStateException();
        }
        return null;
    }

    @Override
    public EList<ReferenceDecomposition> getReferenceDecompositions() {
        ObjectQueryPath queryPath = this.getQueryPath();
        if (queryPath == null) {
            return new BasicEList.UnmodifiableEList(0, (Object[])new ReferenceDecomposition[0]);
        }
        return queryPath.getReferenceDecompositions();
    }

    @Override
    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    @Override
    public void setAllowEmpty(boolean newAllowEmpty) {
        boolean oldAllowEmpty = this.allowEmpty;
        this.allowEmpty = newAllowEmpty;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldAllowEmpty, this.allowEmpty));
        }
    }
}

