/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel.impl;

import com.ibm.trinity.syncmodel.AbstractDimension;
import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.Dimension;
import com.ibm.trinity.syncmodel.DimensionGroup;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.impl.AbstractDimensionImpl;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class DimensionGroupImpl
extends AbstractDimensionImpl
implements DimensionGroup {
    protected static final boolean ALTERNATIVE_EDEFAULT = false;
    protected boolean alternative = false;
    protected static final boolean OPTIONAL_EDEFAULT = false;
    protected boolean optional = false;
    protected EList<AbstractDimension> members;

    protected DimensionGroupImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SyncModelPackage.Literals.DIMENSION_GROUP;
    }

    @Override
    public boolean isAlternative() {
        return this.alternative;
    }

    @Override
    public void setAlternative(boolean newAlternative) {
        boolean oldAlternative = this.alternative;
        this.alternative = newAlternative;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldAlternative, this.alternative));
        }
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(boolean newOptional) {
        boolean oldOptional = this.optional;
        this.optional = newOptional;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldOptional, this.optional));
        }
    }

    @Override
    public EList<AbstractDimension> getMembers() {
        if (this.members == null) {
            this.members = new EObjectContainmentWithInverseEList(AbstractDimension.class, (InternalEObject)this, 4, 0);
        }
        return this.members;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getMembers()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getMembers()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.isAlternative();
            }
            case 3: {
                return this.isOptional();
            }
            case 4: {
                return this.getMembers();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setAlternative((Boolean)newValue);
                return;
            }
            case 3: {
                this.setOptional((Boolean)newValue);
                return;
            }
            case 4: {
                this.getMembers().clear();
                this.getMembers().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setAlternative(false);
                return;
            }
            case 3: {
                this.setOptional(false);
                return;
            }
            case 4: {
                this.getMembers().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.alternative;
            }
            case 3: {
                return this.optional;
            }
            case 4: {
                return this.members != null && !this.members.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (alternative: ");
        result.append(this.alternative);
        result.append(", optional: ");
        result.append(this.optional);
        result.append(')');
        return result.toString();
    }

    @Override
    public EList<Dimension> getHeadDimensions() {
        BasicEList result = new BasicEList();
        if (this.isAlternative()) {
            for (AbstractDimension member : this.getMembers()) {
                result.addAll(member.getHeadDimensions());
            }
        } else {
            for (AbstractDimension member : this.getMembers()) {
                result.addAll(member.getHeadDimensions());
                boolean opt = member instanceof Dimension ? false : ((DimensionGroup)member).isOptional();
                if (opt) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public EList<Dimension> getTailDimensions() {
        AbstractDimension prev;
        BasicEList result = new BasicEList();
        if (this.isAlternative()) {
            for (AbstractDimension member : this.getMembers()) {
                result.addAll(member.getTailDimensions());
            }
        } else {
            EList<AbstractDimension> members = this.getMembers();
            for (int i = members.size() - 1; i >= 0; --i) {
                boolean opt;
                AbstractDimension member = (AbstractDimension)members.get(i);
                result.addAll(member.getTailDimensions());
                boolean bl = opt = member instanceof Dimension ? false : ((DimensionGroup)member).isOptional();
                if (opt) {
                    continue;
                }
                break;
            }
        }
        if (this.isOptional() && (prev = this.getPrev()) != null) {
            result.addAll(prev.getTailDimensions());
        }
        return result;
    }

    @Override
    public boolean isUpdatable() {
        for (AbstractDimension member : this.getMembers()) {
            if (member instanceof DimensionGroup) {
                if (!member.isUpdatable()) {
                    return false;
                }
            } else if (member instanceof Dimension) {
                Dimension dim = (Dimension)member;
                if (dim.isMappedToRecord() && !dim.isUpdatable()) {
                    return false;
                }
            } else {
                throw new AssertionError((Object)("Unexpected object: " + member));
            }
            if (member.isUpdatable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Column getColumn(int index) {
        int lastIdx;
        int firstIdx = this.getFirstColumnIndex();
        if (index >= firstIdx && index <= (lastIdx = this.getLastColumnIndex())) {
            for (AbstractDimension member : this.getMembers()) {
                if (index > member.getLastColumnIndex()) continue;
                return member.getColumn(index);
            }
            throw new IllegalStateException();
        }
        return null;
    }

    @Override
    public int getFirstColumnIndex() {
        int n;
        EList<AbstractDimension> members = this.getMembers();
        if (members != null && (n = members.size()) > 0) {
            return ((AbstractDimension)members.get(0)).getFirstColumnIndex();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getLastColumnIndex() {
        int n;
        EList<AbstractDimension> members = this.getMembers();
        if (members != null && (n = members.size()) > 0) {
            return ((AbstractDimension)members.get(n - 1)).getLastColumnIndex();
        }
        return Integer.MIN_VALUE;
    }
}

