/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel.impl;

import com.ibm.trinity.syncmodel.AbstractDimension;
import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.Dimension;
import com.ibm.trinity.syncmodel.DimensionGroup;
import com.ibm.trinity.syncmodel.RootDimension;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.SyncTableSchema;
import com.ibm.trinity.syncmodel.impl.SyncModelElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractDimensionImpl
extends SyncModelElementImpl
implements AbstractDimension {
    protected AbstractDimensionImpl() {
    }

    protected EClass eStaticClass() {
        return SyncModelPackage.Literals.ABSTRACT_DIMENSION;
    }

    @Override
    public DimensionGroup getOwnerGroup() {
        if (this.eContainerFeatureID() != 0) {
            return null;
        }
        return (DimensionGroup)this.eInternalContainer();
    }

    public NotificationChain basicSetOwnerGroup(DimensionGroup newOwnerGroup, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newOwnerGroup, 0, msgs);
        return msgs;
    }

    @Override
    public void setOwnerGroup(DimensionGroup newOwnerGroup) {
        if (newOwnerGroup != this.eInternalContainer() || this.eContainerFeatureID() != 0 && newOwnerGroup != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newOwnerGroup)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwnerGroup != null) {
                msgs = ((InternalEObject)newOwnerGroup).eInverseAdd((InternalEObject)this, 4, DimensionGroup.class, msgs);
            }
            if ((msgs = this.basicSetOwnerGroup(newOwnerGroup, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newOwnerGroup, (Object)newOwnerGroup));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwnerGroup((DimensionGroup)otherEnd, msgs);
            }
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwner((SyncTableSchema)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetOwnerGroup(null, msgs);
            }
            case 1: {
                return this.basicSetOwner(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 0: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 4, DimensionGroup.class, msgs);
            }
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 4, SyncTableSchema.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getOwnerGroup();
            }
            case 1: {
                return this.getOwner();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setOwnerGroup((DimensionGroup)newValue);
                return;
            }
            case 1: {
                this.setOwner((SyncTableSchema)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setOwnerGroup(null);
                return;
            }
            case 1: {
                this.setOwner(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getOwnerGroup() != null;
            }
            case 1: {
                return this.getOwner() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public abstract boolean isOptional();

    @Override
    public abstract EList<Dimension> getHeadDimensions();

    @Override
    public abstract EList<Dimension> getTailDimensions();

    @Override
    public SyncTableSchema getOwnerSchema() {
        if (this.getOwner() != null) {
            return this.getOwner();
        }
        DimensionGroup group = this.getOwnerGroup();
        while (group.getOwnerGroup() != null) {
            group = group.getOwnerGroup();
        }
        return group.getOwner();
    }

    @Override
    public AbstractDimension getNext() {
        EList<AbstractDimension> brothers;
        DimensionGroup group = this.getOwnerGroup();
        if (group != null) {
            brothers = group.getMembers();
        } else {
            EObject container = this.eContainer();
            if (container instanceof SyncTableSchema) {
                brothers = ((SyncTableSchema)container).getSuccessiveDimensions();
            } else {
                return null;
            }
        }
        int myIndex = brothers.indexOf((Object)this);
        int nextIndex = myIndex + 1;
        if (nextIndex < brothers.size()) {
            return (AbstractDimension)brothers.get(nextIndex);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AbstractDimension getPrev() {
        int myIndex;
        EList<AbstractDimension> brothers;
        DimensionGroup group = this.getOwnerGroup();
        if (group == null) {
            SyncTableSchema schema = this.getOwnerSchema();
            if (schema == null) return null;
            brothers = schema.getSuccessiveDimensions();
        } else {
            brothers = group.getMembers();
        }
        if ((myIndex = brothers.indexOf((Object)this)) == 0) {
            if (group != null) {
                return null;
            }
            SyncTableSchema schema = this.getOwnerSchema();
            return schema.getRootDimension();
        }
        int prevIndex = myIndex - 1;
        if (prevIndex < 0) throw new IllegalStateException();
        return (AbstractDimension)brothers.get(prevIndex);
    }

    private AbstractDimension getNextAbstractDimension(AbstractDimension dim) {
        EList<AbstractDimension> members;
        int size;
        if (dim == null) {
            return null;
        }
        if (dim instanceof DimensionGroup && (size = (members = ((DimensionGroup)dim).getMembers()).size()) > 0) {
            return (AbstractDimension)members.get(0);
        }
        AbstractDimension adim = dim;
        do {
            if (adim.getNext() == null) continue;
            return adim.getNext();
        } while ((adim = adim.getOwnerGroup()) != null);
        return null;
    }

    private AbstractDimension getPrevAbstractDimension(AbstractDimension dim) {
        EList<AbstractDimension> members;
        int size;
        if (dim == null) {
            return null;
        }
        if (dim instanceof DimensionGroup && (size = (members = ((DimensionGroup)dim).getMembers()).size()) > 0) {
            return (AbstractDimension)members.get(size - 1);
        }
        AbstractDimension adim = dim;
        do {
            if (adim.getPrev() == null) continue;
            return adim.getPrev();
        } while ((adim = adim.getOwnerGroup()) != null);
        return null;
    }

    @Override
    public EList<Dimension> getPredecessors() {
        HashSet<Dimension> predecessors = new HashSet<Dimension>();
        AbstractDimension prev = this.getPrev();
        DimensionGroup ownerGroup = this.getOwnerGroup();
        if (prev == null || ownerGroup != null && ownerGroup.isAlternative()) {
            if (ownerGroup != null) {
                EList<Dimension> parentPredecessors = ownerGroup.getPredecessors();
                predecessors.addAll((Collection<Dimension>)parentPredecessors);
            } else {
                RootDimension rootDim;
                SyncTableSchema schema = this.getOwnerSchema();
                if (schema != null && this != (rootDim = schema.getRootDimension())) {
                    predecessors.add(rootDim);
                }
            }
        } else {
            boolean opt;
            do {
                EList<Dimension> tails = prev.getTailDimensions();
                predecessors.addAll((Collection<Dimension>)tails);
            } while ((opt = prev.isOptional()) && (prev = prev.getPrev()) != null);
            if (prev == null && opt && ownerGroup != null) {
                EList<Dimension> parentsPredecessors = ownerGroup.getPredecessors();
                predecessors.addAll((Collection<Dimension>)parentsPredecessors);
            }
        }
        BasicEList.UnmodifiableEList result = new BasicEList.UnmodifiableEList(predecessors.size(), (Object[])predecessors.toArray(new Dimension[0]));
        return result;
    }

    @Override
    public SyncTableSchema getOwner() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (SyncTableSchema)this.eInternalContainer();
    }

    public NotificationChain basicSetOwner(SyncTableSchema newOwner, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newOwner, 1, msgs);
        return msgs;
    }

    @Override
    public void setOwner(SyncTableSchema newOwner) {
        if (newOwner != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newOwner != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newOwner)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwner != null) {
                msgs = ((InternalEObject)newOwner).eInverseAdd((InternalEObject)this, 4, SyncTableSchema.class, msgs);
            }
            if ((msgs = this.basicSetOwner(newOwner, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newOwner, (Object)newOwner));
        }
    }

    @Override
    public EList<Dimension> getSuccessors() {
        ArrayList<Dimension> successors = new ArrayList<Dimension>();
        DimensionGroup ownerGroup = this.getOwnerGroup();
        if (ownerGroup != null && ownerGroup.isAlternative()) {
            return ownerGroup.getSuccessors();
        }
        AbstractDimension next = this.getNext();
        if (next == null) {
            if (ownerGroup != null) {
                EList<Dimension> parentsSuccessors = ownerGroup.getSuccessors();
                successors.addAll((Collection<Dimension>)parentsSuccessors);
            }
        } else {
            boolean opt;
            do {
                EList<Dimension> heads = next.getHeadDimensions();
                successors.addAll((Collection<Dimension>)heads);
            } while ((opt = next.isOptional()) && (next = next.getNext()) != null);
            if (next == null && opt && ownerGroup != null) {
                EList<Dimension> parentsSuccessors = ownerGroup.getSuccessors();
                successors.addAll((Collection<Dimension>)parentsSuccessors);
            }
        }
        BasicEList.UnmodifiableEList result = new BasicEList.UnmodifiableEList(successors.size(), (Object[])successors.toArray(new Dimension[0]));
        return result;
    }

    @Override
    public abstract boolean isUpdatable();

    @Override
    public abstract Column getColumn(int var1);

    @Override
    public abstract int getFirstColumnIndex();

    @Override
    public abstract int getLastColumnIndex();

    public Dimension getSuccessor() {
        AbstractDimension dim = this;
        while ((dim = this.getNextAbstractDimension(dim)) != null && !(dim instanceof Dimension)) {
        }
        return (Dimension)dim;
    }

    public Dimension getPredecessor() {
        AbstractDimension dim = this;
        while ((dim = this.getPrevAbstractDimension(dim)) != null && !(dim instanceof Dimension)) {
        }
        return (Dimension)dim;
    }
}

