/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LazyLoadStrategy implements Enumerator
{
    NORMAL(0, "Normal", "Normal"),
    AUTOMATIC(1, "Automatic", "Automatic"),
    MANUAL(2, "Manual", "Manual");

    public static final int NORMAL_VALUE = 0;
    public static final int AUTOMATIC_VALUE = 1;
    public static final int MANUAL_VALUE = 2;
    private static final LazyLoadStrategy[] VALUES_ARRAY;
    public static final List<LazyLoadStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LazyLoadStrategy get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LazyLoadStrategy result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LazyLoadStrategy getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LazyLoadStrategy result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LazyLoadStrategy get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return AUTOMATIC;
            }
            case 2: {
                return MANUAL;
            }
        }
        return null;
    }

    private LazyLoadStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LazyLoadStrategy[]{NORMAL, AUTOMATIC, MANUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

