/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.syncmodel;

import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.KeyColumn;
import com.ibm.trinity.syncmodel.SyncTableSchema;
import com.ibm.trinity.syncmodel.TypedSyncTable;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

public interface JoinedSyncTableSchema
extends TypedSyncTable {
    public EList<TypedSyncTable> getTargetTypes();

    public JSchema[] getTopJSchemata();

    public JColumn[] getTopJColumns();

    public KeyColumn getKeyColumn(String var1);

    public static class JColumn {
        public final Column column;
        public final int mtIndex;
        public final int jIndex;
        public final JColumn up;
        private JColumn down;
        public final JColumn prev;
        private JColumn next;

        public JColumn getDown() {
            return this.down;
        }

        public JColumn getNext() {
            return this.next;
        }

        public JColumn find(int mtIdx) {
            if (mtIdx > this.mtIndex) {
                JColumn jc = this.down;
                while (jc != null) {
                    if (jc.mtIndex == mtIdx) {
                        return jc;
                    }
                    jc = jc.down;
                }
            } else if (mtIdx < this.mtIndex) {
                JColumn jc = this.up;
                while (jc != null) {
                    if (jc.mtIndex == mtIdx) {
                        return jc;
                    }
                    jc = jc.up;
                }
            } else {
                return this;
            }
            return null;
        }

        public JColumn(Column column, int mtIndex, int jIndex, JColumn up, JColumn prev) {
            this.column = column;
            this.mtIndex = mtIndex;
            this.jIndex = jIndex;
            this.up = up;
            if (up != null) {
                up.down = this;
            }
            this.prev = prev;
            if (prev != null) {
                prev.next = this;
            }
        }

        private static String toIdxStr(JColumn jc) {
            if (jc == null) {
                return "N";
            }
            return Integer.toString(jc.jIndex) + "!" + Integer.toString(jc.mtIndex);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("JColumn(");
            sb.append(this.jIndex);
            sb.append('|');
            sb.append(this.mtIndex);
            sb.append("):");
            sb.append(this.column.toString());
            sb.append('<');
            sb.append(JColumn.toIdxStr(this.prev));
            sb.append('>');
            sb.append(JColumn.toIdxStr(this.next));
            sb.append('^');
            sb.append(JColumn.toIdxStr(this.up));
            sb.append('|');
            sb.append(JColumn.toIdxStr(this.down));
            return sb.toString();
        }
    }

    public static class JSchema {
        public final int mtIndex;
        public final JColumn jColumn;
        public final SyncTableSchema syncTableSchema;
        public final JColumn[] joinedColumns;

        private static JColumn[] collectJoinedColumns(JColumn jc) {
            ArrayList<JColumn> jcs = new ArrayList<JColumn>();
            while (jc != null) {
                if (jc.up != null || jc.getDown() != null) {
                    jcs.add(jc);
                }
                jc = jc.getNext();
            }
            JColumn[] ret = new JColumn[jcs.size()];
            return jcs.toArray(ret);
        }

        public JSchema(int mtIndex, SyncTableSchema syncTableSchema, JColumn jColumn) {
            this.mtIndex = mtIndex;
            this.syncTableSchema = syncTableSchema;
            this.jColumn = jColumn;
            this.joinedColumns = JSchema.collectJoinedColumns(jColumn);
        }
    }
}

