/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.transaction;

import com.nomagic.annotation.InternalApi;
import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.ext.RepositoryUtil;
import com.nomagic.uml2.ext.jmi.ModifiedElements;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import com.nomagic.uml2.ext.jmi.reflect.ModelBridge;
import com.nomagic.uml2.transaction.InvalidModelHandler;
import com.nomagic.uml2.transaction.ModelListener;
import com.nomagic.uml2.transaction.ModelTransaction;
import com.nomagic.uml2.transaction.ModelValidator;
import com.nomagic.uml2.transaction.RollbackException;
import com.nomagic.uml2.transaction.TransactionAlreadyCommitedException;
import com.nomagic.uml2.transaction.TransactionAlreadyStartedException;
import com.nomagic.uml2.transaction.TransactionCommitListener;
import com.nomagic.uml2.transaction.TransactionManager;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;

@InternalApi(reason="No Magic internal API. This code can change without any notification.")
@Deprecated
public class TransactionManagerImpl
implements TransactionManager,
ModelListener {
    private static final boolean DEVELOPER = Boolean.getBoolean("DEVELOPER");
    private volatile ModelTransaction mCurrentTransaction;
    private final ModelTransaction mRooTransaction;
    private final AbstractRepository mAbstractRepository;
    private InvalidModelHandler mInvalidModelHandler;
    private final Collection<TransactionCommitListener> mListeners = new CopyOnWriteArrayList<TransactionCommitListener>();
    private final Collection<TransactionCommitListener> mNotDeliveredEventsListener = new CopyOnWriteArrayList<TransactionCommitListener>();
    private final Collection<InternalTransactionCommitListener> mInternalListeners = new CopyOnWriteArrayList<InternalTransactionCommitListener>();
    private ModelValidator mModelValidator;
    private ModelTransaction mCommitting;
    private boolean mEventDeliveryOn = true;

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    public TransactionManagerImpl(AbstractRepository abstractRepository) {
        this.mAbstractRepository = abstractRepository;
        this.mRooTransaction = new ModelTransaction(this.mAbstractRepository, this);
    }

    @Override
    public boolean isStarted() {
        return this.mCurrentTransaction != null && this.mCurrentTransaction.isStarted();
    }

    @Override
    public synchronized void runTransaction(Runnable r, TransactionManager.TransactionOptions options) throws RollbackException, TransactionAlreadyStartedException {
        this.start(options);
        try {
            r.run();
        }
        finally {
            try {
                this.commit();
            }
            catch (TransactionAlreadyCommitedException e) {
                ModelBridge.getBridge().getLog().error((Object)e, (Throwable)e);
            }
        }
    }

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    public void runInTransaction(Runnable r, TransactionManager.TransactionOptions options) throws RollbackException {
        if (this.isStarted()) {
            r.run();
        } else {
            try {
                this.runTransaction(r, options);
            }
            catch (TransactionAlreadyStartedException e) {
                ModelBridge.getBridge().getLog().error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    public void setInvalidModelHandler(InvalidModelHandler handler) {
        this.mInvalidModelHandler = handler;
    }

    @Override
    public void setModelValidator(ModelValidator handler) {
        this.mModelValidator = handler;
    }

    @Override
    public ModelValidator getModelValidator() {
        return this.mModelValidator;
    }

    @Override
    public synchronized void start() throws TransactionAlreadyStartedException {
        this.start(TransactionManager.TransactionOptions.DEFAULT);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void commit() throws RollbackException, TransactionAlreadyCommitedException {
        if (!this.isStarted()) {
            throw new TransactionAlreadyCommitedException();
        }
        if (this.mCommitting != null) {
            throw new TransactionAlreadyCommitedException();
        }
        this.mCommitting = this.mCurrentTransaction;
        try {
            this.mCurrentTransaction.commit();
            this.notifyInternalCommitListeners();
        }
        finally {
            this.mCommitting = null;
            this.setCurrentTransaction(null);
            ** for (listener : this.getListenersForFiring())
        }
lbl-1000:
        // 1 sources

        {
            listener.allTransactionsCommitted();
            continue;
        }
lbl16:
        // 1 sources

        if (!this.mEventDeliveryOn && (logger = this.getLogger()) != null) {
            logger.warn((Object)"Transaction commit should not be performed if event delivery is switched off", (Throwable)new Exception("Stack trace"));
        }
    }

    private void notifyInternalCommitListeners() {
        try {
            this.mInternalListeners.forEach(InternalTransactionCommitListener::transactionCommitted);
        }
        catch (Exception e) {
            ModelBridge.getBridge().getLog().error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void beforeChange(RefObject abstractRefObject, String featureName) {
        if (this.mCurrentTransaction != null) {
            this.mCurrentTransaction.beforeChange();
        }
    }

    @Override
    public void modelChanged(PropertyChangeEvent evt) {
        Logger log;
        ModelBridge modelBridge;
        String propertyName;
        if (this.mCurrentTransaction != null) {
            this.mCurrentTransaction.modelChanged(evt);
        } else if (DEVELOPER && !RepositoryUtil.isDummyRepository(this.mAbstractRepository) && !(propertyName = evt.getPropertyName()).startsWith("edit_") && (modelBridge = ModelBridge.getInstance()) != null && (log = modelBridge.getLog()) != null) {
            log.warn((Object)("model change without session " + evt.getSource() + ' ' + propertyName));
        }
    }

    @Override
    public void changed(RefObject object) {
        if (this.mCurrentTransaction != null) {
            this.mCurrentTransaction.changed(object);
        }
    }

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    void setCurrentTransaction(@CheckForNull ModelTransaction t) {
        this.mCurrentTransaction = t;
        if (this.mCurrentTransaction != null) {
            this.mCurrentTransaction.setModelValidator(this.mModelValidator);
            this.mCurrentTransaction.setInvalidModelHandler(this.mInvalidModelHandler);
        }
    }

    @Override
    public void runTransaction(Runnable r) throws RollbackException, TransactionAlreadyStartedException {
        this.runTransaction(r, TransactionManager.TransactionOptions.DEFAULT);
    }

    @Override
    public void addTransactionCommitListener(TransactionCommitListener listener) {
        TransactionManagerImpl.checkForNull(listener);
        this.mListeners.remove(listener);
        this.mListeners.add(listener);
    }

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    public void addNotDeliveredEventsListener(TransactionCommitListener listener) {
        TransactionManagerImpl.checkForNull(listener);
        this.mNotDeliveredEventsListener.remove(listener);
        this.mNotDeliveredEventsListener.add(listener);
    }

    @Override
    public void removeTransactionCommitListener(TransactionCommitListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public Collection<TransactionCommitListener> getListenersForFiring() {
        return Collections.unmodifiableCollection(this.mListeners);
    }

    @Override
    public Collection<TransactionCommitListener> getListeners() {
        return Collections.unmodifiableCollection(this.mListeners);
    }

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    public void addInternalCommitListener(InternalTransactionCommitListener listener) {
        TransactionManagerImpl.checkForNull(listener);
        this.mInternalListeners.remove(listener);
        this.mInternalListeners.add(listener);
    }

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    public void removeInternalCommitListener(InternalTransactionCommitListener listener) {
        this.mInternalListeners.remove(listener);
    }

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    public Collection<InternalTransactionCommitListener> getInternalListeners() {
        return this.mInternalListeners;
    }

    @Override
    public void start(TransactionManager.TransactionOptions options) throws TransactionAlreadyStartedException {
        if (this.isStarted()) {
            throw new TransactionAlreadyStartedException();
        }
        if (options.firePostCommit && !this.mEventDeliveryOn) {
            this.throwOrLogError("transaction with post commit event firing starting whereas event delivery is turned off");
        }
        this.setCurrentTransaction(this.mRooTransaction);
        if (options.readonly) {
            this.mCurrentTransaction.startReadOnly();
        } else {
            this.mCurrentTransaction.start();
        }
        this.mCurrentTransaction.setFirePostCommit(options.firePostCommit);
    }

    private void throwOrLogError(String error) {
        if (DEVELOPER) {
            throw new IllegalStateException(error);
        }
        this.logError(error);
    }

    private void logError(String error) {
        Logger log = this.getLogger();
        if (log != null) {
            log.error((Object)error);
        }
    }

    @CheckForNull
    private Logger getLogger() {
        Logger log = null;
        ModelBridge modelBridge = ModelBridge.getInstance();
        if (modelBridge != null) {
            log = modelBridge.getLog();
        }
        return log;
    }

    @Override
    public synchronized void eventDeliveryStopped() {
        this.mEventDeliveryOn = false;
        if (this.isStarted() && this.mCurrentTransaction.isFirePostCommit()) {
            this.throwOrLogError("event delivery has stopped in the middle of transaction that fires post commit events");
        }
    }

    @Override
    public synchronized void eventDeliveryRestored(ModifiedElements modifiedElements, List<PropertyChangeEvent> propertyChangeEvents) {
        this.mEventDeliveryOn = true;
        if (this.mCurrentTransaction != null) {
            this.mCurrentTransaction.setModifiedElements(modifiedElements);
        }
        this.notifyNotDeliveredListeners(propertyChangeEvents);
    }

    private void notifyNotDeliveredListeners(List<PropertyChangeEvent> propertyChangeEvents) {
        for (TransactionCommitListener transactionCommitListener : this.mNotDeliveredEventsListener) {
            try {
                Runnable runnable = transactionCommitListener.transactionCommited(propertyChangeEvents);
                if (runnable == null) continue;
                runnable.run();
            }
            catch (Throwable e) {
                if (this.getLogger() == null) continue;
                this.getLogger().error((Object)e, e);
            }
        }
    }

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    protected static void checkForNull(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Can not add null listener");
        }
    }

    @OpenApiAll
    public static interface InternalTransactionCommitListener {
        public void transactionCommitted();
    }
}

