/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.transaction;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.transaction.InvalidModelHandler;
import com.nomagic.uml2.transaction.ModelValidator;
import com.nomagic.uml2.transaction.RollbackException;
import com.nomagic.uml2.transaction.TransactionAlreadyCommitedException;
import com.nomagic.uml2.transaction.TransactionAlreadyStartedException;
import com.nomagic.uml2.transaction.TransactionCommitListener;
import java.util.Collection;

@OpenApiAll
public interface TransactionManager {
    public void runTransaction(Runnable var1, TransactionOptions var2) throws RollbackException, TransactionAlreadyStartedException;

    public void runTransaction(Runnable var1) throws RollbackException, TransactionAlreadyStartedException;

    public void start() throws TransactionAlreadyStartedException;

    public boolean isStarted();

    public void commit() throws RollbackException, TransactionAlreadyCommitedException;

    public void start(TransactionOptions var1) throws TransactionAlreadyStartedException;

    public void setInvalidModelHandler(InvalidModelHandler var1);

    public void setModelValidator(ModelValidator var1);

    public ModelValidator getModelValidator();

    public void addTransactionCommitListener(TransactionCommitListener var1);

    public void removeTransactionCommitListener(TransactionCommitListener var1);

    public Collection<TransactionCommitListener> getListeners();

    public Collection<TransactionCommitListener> getListenersForFiring();

    @OpenApiAll
    public static class TransactionOptions {
        final boolean readonly;
        final boolean firePostCommit;
        public static TransactionOptions DEFAULT = new TransactionOptions(false, true);
        public static TransactionOptions READONLY = new TransactionOptions(true, true);
        public static TransactionOptions NO_POSTCOMMIT = new TransactionOptions(false, false);

        public TransactionOptions(boolean readonly, boolean firePostCommit) {
            this.firePostCommit = firePostCommit;
            this.readonly = readonly;
        }
    }
}

