/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.transaction;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml.BaseElement;
import com.nomagic.magicdraw.uml2.util.TimeTracker;
import com.nomagic.magicdraw.uml2.util.TimeTrackerFactory;
import com.nomagic.uml2.ext.event.DerivedPropertyEvent;
import com.nomagic.uml2.ext.jmi.ModifiedElements;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Element;
import com.nomagic.uml2.transaction.InvalidModelHandler;
import com.nomagic.uml2.transaction.ModelValidationResult;
import com.nomagic.uml2.transaction.ModelValidator;
import com.nomagic.uml2.transaction.ReadOnlyModelException;
import com.nomagic.uml2.transaction.RollbackException;
import com.nomagic.uml2.transaction.TransactionCommitListener;
import com.nomagic.uml2.transaction.TransactionManagerImpl;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

@OpenApiAll
public class ModelTransaction {
    Logger LOG = Logger.getLogger(ModelTransaction.class);
    private volatile Collection<PropertyChangeEvent> mCollectedEvents;
    private boolean mReadOnlyMode = false;
    private ModelValidator mModelValidator;
    private InvalidModelHandler mInvalidModelHandler;
    private final AbstractRepository mRepository;
    private final TransactionManagerImpl mTransactionsManager;
    private final boolean mModelFixTransaction;
    private boolean mFirePostCommit = true;
    protected Map<Element, String> mChangedElements;
    private ModifiedElements mModifiedElements;

    public ModelTransaction(AbstractRepository repository, TransactionManagerImpl manager) {
        this(repository, manager, false);
    }

    private ModelTransaction(AbstractRepository repository, TransactionManagerImpl manager, boolean modelFixTransaction) {
        this.mRepository = repository;
        this.mTransactionsManager = manager;
        this.mModelFixTransaction = modelFixTransaction;
    }

    public void start() {
        this.mCollectedEvents = new ArrayList<PropertyChangeEvent>();
        this.mChangedElements = new IdentityHashMap<Element, String>();
    }

    public void commit() throws RollbackException {
        Collection<ModelValidationResult> notValid;
        boolean fireEvents = this.mFirePostCommit;
        if (this.mModifiedElements != null) {
            this.addAllElementsToChanged(this.mModifiedElements);
        }
        boolean hasErrors = (notValid = this.validateModel()) != null && !notValid.isEmpty();
        Collection<Runnable> runAfterFire = null;
        try {
            if (hasErrors) {
                if (this.mModelFixTransaction) {
                    throw new RollbackException(notValid);
                }
                InvalidModelHandler.Result fixResult = this.fixModel(notValid, this.mCollectedEvents);
                if (fixResult == InvalidModelHandler.Result.ROLLBACK_TRANSACTION) {
                    throw new RollbackException(notValid);
                }
            }
            if (fireEvents) {
                runAfterFire = this.fireEvents(this.mCollectedEvents);
            }
        }
        finally {
            this.mCollectedEvents = null;
            this.mChangedElements = null;
            this.mReadOnlyMode = false;
        }
        if (runAfterFire != null && !runAfterFire.isEmpty()) {
            this.runCodeAfterFire(runAfterFire);
        }
    }

    private void runInNestedTransaction(Runnable r, boolean readonly) throws RollbackException {
        ModelTransaction tr = this.createNestedTransaction(false);
        if (readonly) {
            tr.startReadOnly();
        } else {
            tr.start();
        }
        try {
            r.run();
        }
        finally {
            try {
                tr.commit();
            }
            finally {
                this.destroyNestedTransaction();
            }
        }
    }

    private void runModelFixInNestedTransaction(Runnable r, Collection<PropertyChangeEvent> collectedEventsInParent, InvalidModelHandler.Result[] result) throws RollbackException {
        ModelTransaction tr = this.createNestedTransaction(true);
        tr.start();
        try {
            r.run();
        }
        finally {
            try {
                if (result[0] != InvalidModelHandler.Result.UNABLE_TO_FIX && collectedEventsInParent != null) {
                    tr.mCollectedEvents.addAll(collectedEventsInParent);
                }
                tr.commit();
            }
            finally {
                this.destroyNestedTransaction();
            }
        }
    }

    private void runCodeAfterFire(Collection<Runnable> run) throws RollbackException {
        Runnable runnable = () -> {
            TimeTracker timeTracker = TimeTrackerFactory.create("Transaction listener run ", this.LOG);
            for (Runnable r : run) {
                try {
                    TimeTracker.TrackedOperation operation = timeTracker.start(r);
                    r.run();
                    operation.finish();
                }
                catch (RuntimeException ex) {
                    System.err.println("Bogus transaction update runnable " + r);
                    ex.printStackTrace();
                }
            }
            timeTracker.dumpLongest(5);
        };
        boolean enabled = this.mRepository.getEventSupport().isEnableEventFiring();
        this.mRepository.getEventSupport().setEnableEventFiring(true);
        try {
            this.runInNestedTransaction(runnable, false);
        }
        finally {
            this.mRepository.getEventSupport().setEnableEventFiring(enabled);
        }
    }

    private Collection<Runnable> fireEvents(Collection<PropertyChangeEvent> collectedEvents) {
        ArrayList<Runnable> runCode = new ArrayList<Runnable>();
        if (collectedEvents.size() > 0) {
            Runnable runnable = () -> {
                TimeTracker timeTracker = TimeTrackerFactory.create("Transaction listeners", this.LOG);
                for (TransactionCommitListener listener : this.mTransactionsManager.getListenersForFiring()) {
                    TimeTracker.TrackedOperation op = timeTracker.start(listener);
                    Runnable run = listener.transactionCommited(collectedEvents);
                    op.finish();
                    if (run == null) continue;
                    runCode.add(run);
                }
                timeTracker.dumpLongest(5);
            };
            try {
                this.runInNestedTransaction(runnable, true);
            }
            catch (RollbackException e) {
                e.printStackTrace();
            }
        }
        return runCode;
    }

    private InvalidModelHandler.Result fixModel(Collection<ModelValidationResult> notValid, Collection<PropertyChangeEvent> collectedEvents) throws RollbackException {
        InvalidModelHandler.Result[] result = new InvalidModelHandler.Result[1];
        Runnable runnable = () -> {
            boolean enableEventFiring = this.mRepository.getEventSupport().isEnableEventFiring();
            try {
                this.mRepository.getEventSupport().setEnableEventFiring(true);
                resultArray[0] = this.mInvalidModelHandler.handleInvalidElements(notValid);
            }
            finally {
                this.mRepository.getEventSupport().setEnableEventFiring(enableEventFiring);
            }
        };
        this.runModelFixInNestedTransaction(runnable, collectedEvents, result);
        return result[0];
    }

    private Collection<ModelValidationResult> validateModel() throws RollbackException {
        if (this.mReadOnlyMode) {
            return Collections.emptyList();
        }
        ArrayList<ModelValidationResult> ret = new ArrayList<ModelValidationResult>();
        Runnable runnable = () -> {
            Collection<Element> changedElements;
            if (this.mFirePostCommit) {
                changedElements = this.getChangedElements(this.mCollectedEvents);
            } else {
                ArrayList<Element> existingOnly = new ArrayList<Element>();
                for (Map.Entry<Element, String> changedEntry : this.mChangedElements.entrySet()) {
                    Element element;
                    RefObject elementById;
                    if ("INSTANCE_DELETED".equals(changedEntry.getValue()) || (elementById = this.mRepository.getElementById((element = changedEntry.getKey()).getID())) != element) continue;
                    existingOnly.add(element);
                }
                changedElements = existingOnly;
            }
            Collection<ModelValidationResult> validationResult = this.mModelValidator.validateChanges(changedElements);
            if (validationResult != null) {
                ret.addAll(validationResult);
            }
        };
        this.runInNestedTransaction(runnable, true);
        return ret;
    }

    private void destroyNestedTransaction() {
        this.mTransactionsManager.setCurrentTransaction(this);
    }

    private ModelTransaction createNestedTransaction(boolean modelFix) {
        ModelTransaction nested = new ModelTransaction(this.mRepository, this.mTransactionsManager, modelFix);
        this.mTransactionsManager.setCurrentTransaction(nested);
        return nested;
    }

    public void modelChanged(PropertyChangeEvent evt) {
        if (!this.isStarted()) {
            System.out.println(this + "model change without session " + evt.getSource() + ' ' + evt.getPropertyName());
            return;
        }
        if (this.mFirePostCommit) {
            this.mCollectedEvents.add(evt);
        } else {
            Object source = evt.getSource();
            if (source instanceof Element) {
                Element element = (Element)source;
                this.mChangedElements.put(element, evt.getPropertyName());
            }
        }
    }

    public void changed(RefObject object) {
        if (!this.isStarted()) {
            System.out.println(this + "model state changed without session " + object);
            return;
        }
        if (!this.mFirePostCommit && object instanceof Element) {
            Element element = (Element)object;
            this.mChangedElements.put(element, "");
        }
    }

    private void addAllElementsToChanged(ModifiedElements modifiedElements) {
        this.mChangedElements.clear();
        for (EObject e : modifiedElements.getModified()) {
            if (!(e instanceof Element)) continue;
            this.mChangedElements.put((Element)e, "");
        }
    }

    public boolean isStarted() {
        return this.mCollectedEvents != null;
    }

    public boolean isFirePostCommit() {
        return this.mFirePostCommit;
    }

    public void setInvalidModelHandler(InvalidModelHandler handler) {
        this.mInvalidModelHandler = handler;
    }

    public void setModelValidator(ModelValidator handler) {
        this.mModelValidator = handler;
    }

    public void startReadOnly() {
        this.mReadOnlyMode = true;
        this.start();
    }

    public void beforeChange() {
        if (this.mReadOnlyMode) {
            throw new ReadOnlyModelException("Can not make changes in read-only transaction");
        }
    }

    public void setFirePostCommit(boolean firePostCommit) {
        this.mFirePostCommit = firePostCommit;
    }

    private Collection<Element> getChangedElements(Collection<PropertyChangeEvent> changes) {
        if (changes.isEmpty()) {
            return Collections.emptySet();
        }
        Set deleted = Collections.emptySet();
        ArrayList<PropertyChangeEvent> notDerivedPropertyEvents = new ArrayList<PropertyChangeEvent>(changes.size());
        for (PropertyChangeEvent event : changes) {
            Object source = event.getSource();
            if (source instanceof Element && "INSTANCE_DELETED".equals(event.getPropertyName())) {
                if (deleted.isEmpty()) {
                    deleted = new HashSet();
                }
                deleted.add((Element)source);
            }
            if (event instanceof DerivedPropertyEvent) continue;
            notDerivedPropertyEvents.add(event);
        }
        HashSet<Element> result = new HashSet<Element>();
        for (PropertyChangeEvent event : notDerivedPropertyEvents) {
            BaseElement baseElement;
            Element elementByID;
            Object source = event.getSource();
            if (!(source instanceof Element) || deleted.contains(source) || (elementByID = (Element)this.mRepository.getElementById((baseElement = (BaseElement)source).getID())) == null) continue;
            result.add(elementByID);
        }
        return result;
    }

    public void setModifiedElements(ModifiedElements modifiedElements) {
        this.mModifiedElements = modifiedElements;
    }
}

