/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.impl.jmi;

import com.nomagic.annotation.InternalApi;
import com.nomagic.uml2.ext.jmi.reflect.VisitorContext;
import com.nomagic.uml2.ext.magicdraw.auxiliaryconstructs.mdtemplates.StringExpression;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Element;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.ElementValue;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Expression;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.InstanceSpecification;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.InstanceValue;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralBoolean;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralInteger;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralNull;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralReal;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralString;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralUnlimitedNatural;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.NamedElement;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.OpaqueExpression;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.ValueSpecification;
import com.nomagic.uml2.ext.magicdraw.commonbehaviors.mdsimpletime.Duration;
import com.nomagic.uml2.ext.magicdraw.commonbehaviors.mdsimpletime.Interval;
import com.nomagic.uml2.ext.magicdraw.commonbehaviors.mdsimpletime.TimeExpression;
import com.nomagic.uml2.impl.ModelHierarchyVisitor;
import java.util.Iterator;
import java.util.List;

@InternalApi(reason="No Magic internal API. This code can change without any notification.")
@Deprecated
public class ValueRetriever
extends ModelHierarchyVisitor {
    private static ValueRetriever mInstance = new ValueRetriever();
    private ThreadLocal<String> mValue = new ThreadLocal();

    @InternalApi(reason="No Magic internal API. This code can change without any notification.")
    @Deprecated
    public static String getValue(ValueSpecification specification) {
        return mInstance.getValueIntern(specification);
    }

    private String getValueIntern(ValueSpecification vs) {
        this.mValue.set("");
        try {
            vs.accept(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mValue.get();
    }

    private String createText(ValueSpecification expr) {
        return new ValueRetriever().getValueIntern(expr);
    }

    @Override
    public void visitExpression(Expression element, VisitorContext context) {
        if (element.hasOperand()) {
            String symbol = element.getSymbol();
            Iterator<ValueSpecification> it = element.getOperand().iterator();
            while (it.hasNext()) {
                ValueSpecification vs = it.next();
                String value = this.createText(vs);
                if (it.hasNext()) {
                    value = String.valueOf(value) + symbol;
                }
                this.mValue.set(String.valueOf(this.mValue.get()) + value);
            }
        } else {
            this.mValue.set(element.getSymbol());
        }
    }

    @Override
    public void visitOpaqueExpression(OpaqueExpression element, VisitorContext context) {
        if (element.getBody().size() > 0) {
            for (String body : element.getBody()) {
                this.mValue.set(String.valueOf(this.mValue.get()) + body);
            }
        }
    }

    @Override
    public void visitLiteralBoolean(LiteralBoolean element, VisitorContext context) {
        this.mValue.set(Boolean.toString(element.isValue()));
    }

    @Override
    public void visitLiteralInteger(LiteralInteger element, VisitorContext context) {
        this.mValue.set(Integer.toString(element.getValue()));
    }

    @Override
    public void visitLiteralString(LiteralString element, VisitorContext context) {
        this.mValue.set(element.getValue());
    }

    @Override
    public void visitLiteralNull(LiteralNull element, VisitorContext context) {
        this.mValue.set("null");
    }

    @Override
    public void visitLiteralUnlimitedNatural(LiteralUnlimitedNatural element, VisitorContext context) {
        int value = element.getValue();
        if (value < 0) {
            this.mValue.set("*");
        } else {
            this.mValue.set(Integer.toString(value));
        }
    }

    @Override
    public void visitInstanceValue(InstanceValue element, VisitorContext context) {
        InstanceSpecification instance = element.getInstance();
        if (instance != null) {
            this.mValue.set(instance.getName());
        }
    }

    @Override
    public void visitDuration(Duration element, VisitorContext context) {
        ValueSpecification expr = element.getExpr();
        if (expr != null) {
            this.mValue.set(this.createText(expr));
        }
    }

    @Override
    public void visitTimeExpression(TimeExpression element, VisitorContext context) {
        ValueSpecification expr = element.getExpr();
        if (expr != null) {
            this.mValue.set(this.createText(expr));
        }
    }

    @Override
    public void visitLiteralReal(LiteralReal element, VisitorContext context) {
        this.mValue.set(Double.toString(element.getValue()));
    }

    @Override
    public void visitStringExpression(StringExpression element, VisitorContext context) {
        block3: {
            block2: {
                this.mValue.set("");
                if (!element.hasSubExpression()) break block2;
                for (StringExpression expression : element.getSubExpression()) {
                    this.mValue.set(String.valueOf(this.mValue.get()) + this.createText(expression));
                }
                break block3;
            }
            if (!element.hasOperand()) break block3;
            List<ValueSpecification> list = element.getOperand();
            for (ValueSpecification valueSpecification : list) {
                this.mValue.set(String.valueOf(this.mValue.get()) + this.createText(valueSpecification));
            }
        }
    }

    @Override
    public void visitElementValue(ElementValue value, VisitorContext context) {
        Element element = value.getElement();
        if (element instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)element;
            this.mValue.set(namedElement.getName());
        } else if (element != null) {
            String humanType;
            String humanName = element.getHumanName();
            if (humanName.startsWith(humanType = element.getHumanType())) {
                int length = humanType.length();
                this.mValue.set(humanName.length() > length ? humanName.substring(length + 1) : humanName);
            } else {
                this.mValue.set(humanName.substring(humanName.indexOf(" ") + 1));
            }
        }
    }

    @Override
    public void visitInterval(Interval element, VisitorContext context) {
        String max;
        if (element.getMin() != null) {
            this.mValue.set(String.valueOf(this.mValue.get()) + this.createText(element.getMin()));
        }
        if (element.getMax() != null && (max = this.createText(element.getMax())).length() != 0) {
            this.mValue.set(String.valueOf(this.mValue.get()) + ".." + max);
        }
    }
}

