/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.ext.jmi.reflect.CollectionValueSetter;
import com.nomagic.uml2.ext.jmi.reflect.ValueSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jmi.reflect.RefObject;

@OpenApiAll
public class ValueSetterUtils {
    public static void setValue(RefObject object, ValueSetter valueSetter, boolean multiple, Object value, Object oldValue) {
        if (valueSetter instanceof CollectionValueSetter && multiple && !((CollectionValueSetter)valueSetter).isAtomic()) {
            List<Object> valueAsCollection;
            Collection oldValueCol = (Collection)oldValue;
            if (value == null) {
                valueAsCollection = Collections.emptyList();
            } else if (value instanceof Collection) {
                valueAsCollection = (Collection)value;
            } else {
                valueAsCollection = new ArrayList(oldValueCol);
                valueAsCollection.add(value);
            }
            ValueSetterUtils.addNewAndRemoveOldCollectionValues((CollectionValueSetter)valueSetter, object, oldValueCol, valueAsCollection);
        } else {
            valueSetter.setValue(object, value);
        }
    }

    public static void removeValue(RefObject object, ValueSetter valueSetter, Object oldValue) {
        if (valueSetter instanceof CollectionValueSetter) {
            ValueSetterUtils.addNewAndRemoveOldCollectionValues((CollectionValueSetter)valueSetter, object, (Collection)oldValue, Collections.emptyList());
        }
    }

    private static void addNewAndRemoveOldCollectionValues(CollectionValueSetter valueSetter, RefObject object, Collection<Object> oldValue, Collection<Object> newValue) {
        ArrayList<Object> added = new ArrayList<Object>(newValue);
        added.removeAll(oldValue);
        if (!added.isEmpty()) {
            for (Object e : added) {
                valueSetter.setValue(object, e);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(oldValue);
        arrayList.removeAll(newValue);
        if (!arrayList.isEmpty()) {
            for (Object e : arrayList) {
                valueSetter.removeValue(object, e);
            }
        }
    }
}

