/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.io_software.catools.tas.mof.model.ReferenceImpl;
import com.io_software.jmi.reflect.AbstractRefBaseObject;
import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.UML2ModelUtil;
import com.nomagic.uml2.ext.jmi.Log;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefClass;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefObject;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefPackage;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import com.nomagic.uml2.ext.jmi.reflect.ClassTypes;
import com.nomagic.uml2.ext.jmi.reflect.HardCodedRule;
import com.nomagic.uml2.ext.jmi.reflect.ModelBridge;
import com.nomagic.uml2.ext.jmi.reflect.RefClassProvider;
import com.nomagic.uml2.ext.jmi.reflect.RefClassProviderImpl;
import com.nomagic.uml2.ext.jmi.reflect.ReflectionHelperCache;
import com.nomagic.uml2.ext.jmi.reflect.ReflectionMultiKeyMap;
import com.nomagic.uml2.ext.jmi.reflect.RepositoryProvider;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Element;
import com.nomagic.uml2.ext.magicdraw.metadata.UMLPackage;
import com.nomagic.uml2.impl.TASRepositoryImpl;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.omg.mof.model.AggregationKindEnum;
import org.omg.mof.model.AssociationEnd;
import org.omg.mof.model.Classifier;
import org.omg.mof.model.EnumerationType;
import org.omg.mof.model.Feature;
import org.omg.mof.model.GeneralizableElement;
import org.omg.mof.model.ModelElement;
import org.omg.mof.model.MofAttribute;
import org.omg.mof.model.MultiplicityType;
import org.omg.mof.model.Reference;
import org.omg.mof.model.StructuralFeature;

@OpenApiAll
public class RepositoryReflection {
    protected static SoftReference<TASRepositoryImpl> mDummyRepository;
    private final AbstractRepository mRepository;
    private final RefClassProvider mRefClassProvider;
    private static final List<String> INTEGER_QUALIFIED_NAME;
    private static final List<String> UNLIMITED_NATURALNAME;
    private static final List<String> BOOLEAN_QUALIFIED_NAME;
    private static final List<String> STRING_QUALIFIED_NAME;
    private static final List<String> REAL_QUALIFIED_NAME;
    private static StructuralFeature NULL_STRUCTURAL_FEATURE;

    static {
        INTEGER_QUALIFIED_NAME = Collections.singletonList("Integer");
        UNLIMITED_NATURALNAME = Collections.singletonList("UnlimitedNatural");
        BOOLEAN_QUALIFIED_NAME = Collections.singletonList("Boolean");
        STRING_QUALIFIED_NAME = Collections.singletonList("String");
        REAL_QUALIFIED_NAME = Collections.singletonList("Real");
        NULL_STRUCTURAL_FEATURE = new ReferenceImpl(null, null, null);
    }

    public static RepositoryReflection create(@CheckForNull AbstractRepository repository) {
        return new RepositoryReflection(repository, null);
    }

    protected RepositoryReflection(AbstractRepository repository, RefClassProvider refClassProvider) {
        this.mRepository = repository == null ? RepositoryReflection.internalGetRepository() : repository;
        this.mRefClassProvider = refClassProvider == null ? new RefClassProviderImpl() : refClassProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<org.omg.mof.model.Class> getSupperTypes(org.omg.mof.model.Class metaClass) {
        Map<org.omg.mof.model.Class, List<org.omg.mof.model.Class>> map;
        Map<org.omg.mof.model.Class, List<org.omg.mof.model.Class>> map2 = map = RepositoryReflection.getCache((RefBaseObject)metaClass).getCachedSuperTypes();
        synchronized (map2) {
            List<org.omg.mof.model.Class> cached = map.get(metaClass);
            if (cached == null) {
                cached = new ArrayList<org.omg.mof.model.Class>(metaClass.getSupertypes());
                int i = 0;
                while (i < cached.size()) {
                    org.omg.mof.model.Class c1 = cached.get(i);
                    List ss = c1.getSupertypes();
                    int j = 0;
                    while (j < ss.size()) {
                        org.omg.mof.model.Class superType = (org.omg.mof.model.Class)ss.get(j);
                        if (!cached.contains(superType)) {
                            cached.add(superType);
                        }
                        ++j;
                    }
                    ++i;
                }
                cached = Collections.unmodifiableList(cached);
                map.put(metaClass, cached);
            }
            return cached;
        }
    }

    public static boolean isSuperType(org.omg.mof.model.Class type, org.omg.mof.model.Class superType) {
        ReflectionMultiKeyMap<org.omg.mof.model.Class, org.omg.mof.model.Class, Boolean> cached = RepositoryReflection.getCache((RefBaseObject)type).getCachedIsSuperType();
        Boolean aBoolean = cached.get(type, superType);
        if (aBoolean == null) {
            aBoolean = RepositoryReflection.getSupperTypes(type).contains(superType);
            cached.put(type, superType, aBoolean);
        }
        return aBoolean;
    }

    public List<Object> getAllContents(org.omg.mof.model.Class metaClass) {
        return RepositoryReflection.getAllContents(this.getRepository(), metaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getAllContents(AbstractRepository repository, org.omg.mof.model.Class metaClass) {
        Map<org.omg.mof.model.Class, List<Object>> map;
        Map<org.omg.mof.model.Class, List<Object>> map2 = map = RepositoryReflection.getCache((RefBaseObject)metaClass).getCachedContents();
        synchronized (map2) {
            List<Object> cached = map.get(metaClass);
            if (cached == null) {
                TreeSet<Object> cachedS = new TreeSet<Object>(new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        boolean stf1 = o1 instanceof StructuralFeature;
                        boolean stf2 = o2 instanceof StructuralFeature;
                        if (!stf1 && !stf2) {
                            return o1.hashCode() - o2.hashCode();
                        }
                        if (stf1 && stf2) {
                            return ((StructuralFeature)o1).getName().compareTo(((StructuralFeature)o2).getName());
                        }
                        return stf1 ? -1 : 1;
                    }
                });
                cachedS.addAll(metaClass.getContents());
                AbstractRefClass classProxy = RepositoryReflection.getClassProxy(repository, metaClass);
                if (classProxy != null) {
                    TreeSet<Object> redefinedFeatures = new TreeSet<Object>(new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return o1.hashCode() - o2.hashCode();
                        }
                    });
                    redefinedFeatures.addAll(classProxy.getRedefinedFeatures());
                    List<org.omg.mof.model.Class> supperTypes = RepositoryReflection.getSupperTypes(metaClass);
                    int supperTypesSize = supperTypes.size();
                    int i = 0;
                    while (i < supperTypesSize) {
                        org.omg.mof.model.Class c = supperTypes.get(i);
                        List contents = c.getContents();
                        int contentsSize = contents.size();
                        int j = 0;
                        while (j < contentsSize) {
                            Object content = contents.get(j);
                            if (!cachedS.contains(content)) {
                                if (content instanceof StructuralFeature) {
                                    StructuralFeature sf = (StructuralFeature)content;
                                    String name = RepositoryReflection.getFullName(sf);
                                    if (!redefinedFeatures.contains(name)) {
                                        cachedS.add(content);
                                    }
                                } else {
                                    cachedS.add(content);
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                cached = new ArrayList<Object>(cachedS);
                cached = Collections.unmodifiableList(cached);
                map.put(metaClass, cached);
            }
            return cached;
        }
    }

    public static String getFullName(StructuralFeature sf) {
        return String.valueOf(sf.getContainer().getName()) + '.' + sf.getName();
    }

    public static List<StructuralFeature> getAttributesAndReferences(org.omg.mof.model.Class metaClass) {
        return RepositoryReflection.getAttributesAndReferences(metaClass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MofAttribute> getAttributes(org.omg.mof.model.Class metaClass) {
        Map<org.omg.mof.model.Class, List<MofAttribute>> cacheMap;
        Map<org.omg.mof.model.Class, List<MofAttribute>> map = cacheMap = RepositoryReflection.getCache((RefBaseObject)metaClass).getCachedChangeableAttributes();
        synchronized (map) {
            List<MofAttribute> cached = cacheMap.get(metaClass);
            if (cached == null) {
                List<Object> allContents = this.getAllContents(metaClass);
                cached = new ArrayList<MofAttribute>();
                int i = allContents.size() - 1;
                while (i >= 0) {
                    MofAttribute attribute;
                    Object o = allContents.get(i);
                    if (o instanceof MofAttribute && (attribute = (MofAttribute)o).isChangeable()) {
                        cached.add(attribute);
                    }
                    --i;
                }
                cached = Collections.unmodifiableList(cached);
                cacheMap.put(metaClass, cached);
            }
            return cached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StructuralFeature> getAttributesAndReferences(org.omg.mof.model.Class metaClass, boolean onlyChangeable) {
        Map<org.omg.mof.model.Class, List<StructuralFeature>> cacheMap;
        AbstractRepository.MofRepository mofRepository = RepositoryReflection.getMofRepository((RefBaseObject)metaClass);
        ReflectionHelperCache cache = RepositoryReflection.getCache(mofRepository);
        Map<org.omg.mof.model.Class, List<StructuralFeature>> map = cacheMap = onlyChangeable ? cache.getCachedChangeableAttributesAndReferences() : cache.getCachedAttributesAndReferences();
        synchronized (map) {
            List<StructuralFeature> cached = cacheMap.get(metaClass);
            if (cached == null) {
                List<Object> allContents = RepositoryReflection.getAllContents(mofRepository.getRepository(), metaClass);
                cached = new ArrayList<StructuralFeature>();
                int i = allContents.size() - 1;
                while (i >= 0) {
                    Object o = allContents.get(i);
                    if (o instanceof StructuralFeature) {
                        StructuralFeature feature = (StructuralFeature)o;
                        if (!onlyChangeable || feature.isChangeable()) {
                            cached.add(feature);
                        }
                    }
                    --i;
                }
                cached = Collections.unmodifiableList(cached);
                cacheMap.put(metaClass, cached);
            }
            return cached;
        }
    }

    public static StructuralFeature getFeature(String featureName, AbstractRefClass proxyClass) {
        return RepositoryReflection.getFeature(featureName, proxyClass, true);
    }

    public static StructuralFeature getFeature(String featureName, AbstractRefClass proxyClass, boolean onlyChangeable) {
        org.omg.mof.model.Class metaClass = (org.omg.mof.model.Class)proxyClass.refMetaObject();
        return RepositoryReflection.getFeature(featureName, onlyChangeable, metaClass);
    }

    public StructuralFeature getFeature(String featureName, Element element, boolean onlyChangeable) {
        return RepositoryReflection.getFeature(featureName, (AbstractRefClass)this.getRefClass(element), onlyChangeable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructuralFeature getFeature(String featureName, boolean onlyChangeable, org.omg.mof.model.Class metaClass) {
        Map<String, Map<String, StructuralFeature>> featuresByClassMap;
        ReflectionHelperCache cache = RepositoryReflection.getCache((RefBaseObject)metaClass);
        Map<String, Map<String, StructuralFeature>> map = featuresByClassMap = cache.getCachedFeatures();
        synchronized (map) {
            String key = String.valueOf(metaClass.getName()) + onlyChangeable;
            Map<String, StructuralFeature> featuresByNameMap = featuresByClassMap.get(key);
            if (featuresByNameMap == null) {
                featuresByNameMap = new HashMap<String, StructuralFeature>();
                featuresByClassMap.put(key, featuresByNameMap);
            }
            StructuralFeature f = null;
            if (featuresByNameMap.containsKey(featureName)) {
                f = featuresByNameMap.get(featureName);
            } else {
                for (StructuralFeature feature : RepositoryReflection.getAttributesAndReferences(metaClass, onlyChangeable)) {
                    if (!feature.getName().equals(featureName)) continue;
                    f = feature;
                    break;
                }
                featuresByNameMap.put(featureName, f);
            }
            return f;
        }
    }

    public static List<Reference> getReferences(org.omg.mof.model.Class metaClass) {
        return RepositoryReflection.getReferences(metaClass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Reference> getReferences(org.omg.mof.model.Class metaClass, boolean onlyChangeable) {
        Map<String, List<Reference>> map;
        Map<String, List<Reference>> map2 = map = RepositoryReflection.getCache((RefBaseObject)metaClass).getCachedReferences();
        synchronized (map2) {
            String key = String.valueOf(metaClass.getName()) + onlyChangeable;
            List<Reference> cached = map.get(key);
            if (cached == null) {
                List<StructuralFeature> attributesAndReferences = RepositoryReflection.getAttributesAndReferences(metaClass, false);
                cached = new ArrayList<Reference>();
                int i = attributesAndReferences.size() - 1;
                while (i >= 0) {
                    StructuralFeature feature = attributesAndReferences.get(i);
                    if (feature instanceof Reference && (feature.isChangeable() || !onlyChangeable)) {
                        cached.add((Reference)feature);
                    }
                    --i;
                }
                cached = Collections.unmodifiableList(cached);
                map.put(key, cached);
            }
            return cached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StructuralFeature> getCompositeReferences(org.omg.mof.model.Class metaClass) {
        Map<org.omg.mof.model.Class, List<StructuralFeature>> map;
        Map<org.omg.mof.model.Class, List<StructuralFeature>> map2 = map = RepositoryReflection.getCache((RefBaseObject)metaClass).getCachedCompositeReferences();
        synchronized (map2) {
            List<StructuralFeature> cached = map.get(metaClass);
            if (cached == null) {
                cached = new ArrayList<Reference>(RepositoryReflection.getReferences(metaClass));
                int i = 0;
                while (i < cached.size()) {
                    if (!RepositoryReflection.isCompositeReference(cached.get(i))) {
                        cached.remove(i);
                        --i;
                    }
                    ++i;
                }
                cached = Collections.unmodifiableList(cached);
                map.put(metaClass, cached);
            }
            return cached;
        }
    }

    public static boolean isCompositeReference(StructuralFeature f) {
        if (f instanceof Reference) {
            Reference reference = (Reference)f;
            return AggregationKindEnum.COMPOSITE.equals((Object)reference.getExposedEnd().getAggregation());
        }
        return false;
    }

    public static boolean isComposedByReference(StructuralFeature f) {
        if (f instanceof Reference) {
            Reference reference = (Reference)f;
            return AggregationKindEnum.COMPOSITE.equals((Object)reference.getReferencedEnd().getAggregation());
        }
        return false;
    }

    public List<String> getCompositeRelationPropertyName(Element owner, Class ownedType) {
        return RepositoryReflection.getCompositeRelationPropertyName(((AbstractRefObject)((Object)owner)).getRepository(), (AbstractRefClass)this.getRefClass(owner), ownedType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCompositeRelationPropertyName(AbstractRepository repository, AbstractRefClass ownerType, Class ownedType, boolean onlyMultiple) {
        ReflectionHelperCache cache = RepositoryReflection.getCache(ownerType);
        ReflectionMultiKeyMap<AbstractRefClass, Class, List<String>> cachedCompositeRelationsPropertyNames = onlyMultiple ? cache.getCachedCompositeRelationsPropertyNamesOnlyMultiple() : cache.getCachedCompositeRelationsPropertyNames();
        ReflectionMultiKeyMap<AbstractRefClass, Class, List<String>> reflectionMultiKeyMap = cachedCompositeRelationsPropertyNames;
        synchronized (reflectionMultiKeyMap) {
            if (cachedCompositeRelationsPropertyNames.containsKeys(ownerType, ownedType)) {
                return cachedCompositeRelationsPropertyNames.get(ownerType, ownedType);
            }
            List<String> subsets = RepositoryReflection.getFeatureSubsetsDeep("ownedElement", ownerType);
            List<String> ret = null;
            AbstractRefClass classProxy = RepositoryReflection.getMetamodelClassProxy(repository, ownedType);
            if (classProxy != null) {
                org.omg.mof.model.Class metaOwnedType = (org.omg.mof.model.Class)classProxy.refMetaObject();
                List<Reference> reference = RepositoryReflection.findReferencesByType(ownerType, "ownedElement", subsets, (Classifier)metaOwnedType, onlyMultiple);
                if (reference != null) {
                    ret = new ArrayList<String>(reference.size());
                    for (Reference r : reference) {
                        ret.add(r.getName());
                    }
                }
                cachedCompositeRelationsPropertyNames.put(ownerType, ownedType, ret);
            }
            return ret != null ? Collections.unmodifiableList(ret) : ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getComposedByReferences(org.omg.mof.model.Class metaClass) {
        Map<org.omg.mof.model.Class, List<Reference>> cachedComposedByReferences;
        Map<org.omg.mof.model.Class, List<Reference>> map = cachedComposedByReferences = RepositoryReflection.getCache((RefBaseObject)metaClass).getCachedComposedByReferences();
        synchronized (map) {
            List<Reference> cached = cachedComposedByReferences.get(metaClass);
            if (cached == null) {
                cached = new ArrayList<Reference>(RepositoryReflection.getReferences(metaClass));
                int i = 0;
                while (i < cached.size()) {
                    Reference ref = cached.get(i);
                    if (!ref.getReferencedEnd().getAggregation().equals((Object)AggregationKindEnum.COMPOSITE)) {
                        cached.remove(i);
                        --i;
                    }
                    ++i;
                }
                cached = Collections.unmodifiableList(cached);
                cachedComposedByReferences.put(metaClass, cached);
            }
            return cached;
        }
    }

    public static List<String> convertFeaturesToNames(List<? extends Feature> features) {
        ArrayList<String> ret = new ArrayList<String>(features.size());
        for (Feature feature : features) {
            ret.add(feature.getName());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCompositeFeaturesNames(org.omg.mof.model.Class metaClass) {
        ReflectionHelperCache cache;
        ReflectionHelperCache reflectionHelperCache = cache = RepositoryReflection.getCache((RefBaseObject)metaClass);
        synchronized (reflectionHelperCache) {
            Map<org.omg.mof.model.Class, List<String>> names = cache.getCompositeFeaturesNames();
            return names.computeIfAbsent(metaClass, k -> Collections.unmodifiableList(RepositoryReflection.convertFeaturesToNames(RepositoryReflection.getCompositeReferences(metaClass))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static AbstractRefClass getMetamodelClassProxy(AbstractRepository repository, Class metamodelClass) {
        Map<Class, AbstractRefClass> pc;
        Map<Class, AbstractRefClass> map = pc = RepositoryReflection.getCache(repository).getCachedProxies();
        synchronized (map) {
            AbstractRefClass ref = pc.get(metamodelClass);
            if (ref != null) {
                return ref;
            }
            final String className = metamodelClass.getName();
            AbstractRefClass found = RepositoryReflection.findAbstractRefClass(repository, new RefClassMatcher(){

                @Override
                public boolean matches(AbstractRefClass refClass) {
                    return className.endsWith(RepositoryReflection.convertToString(((org.omg.mof.model.Class)refClass.refMetaObject()).getQualifiedName()));
                }
            });
            if (found != null) {
                pc.put(metamodelClass, found);
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractRefClass getClassProxy(AbstractRepository repository, final org.omg.mof.model.Class mofClass) {
        Map<org.omg.mof.model.Class, AbstractRefClass> mofClassToProxy;
        Map<org.omg.mof.model.Class, AbstractRefClass> map = mofClassToProxy = RepositoryReflection.getCache(repository).getMofClassToProxy();
        synchronized (map) {
            AbstractRefClass refClass = mofClassToProxy.get(mofClass);
            if (refClass == null && !mofClassToProxy.containsKey(mofClass)) {
                refClass = RepositoryReflection.findAbstractRefClass(repository, new RefClassMatcher(){

                    @Override
                    public boolean matches(AbstractRefClass refClass) {
                        return mofClass == refClass.refMetaObject();
                    }
                });
                mofClassToProxy.put(mofClass, refClass);
            }
            return refClass;
        }
    }

    public static Set getAllClassProxies(AbstractRepository repository) {
        return RepositoryReflection.collectAllClassProxies(repository, new HashSet());
    }

    private static Set collectAllClassProxies(AbstractRefPackage refPackage, Set classes) {
        Collection packages = refPackage.refAllPackages();
        for (Object p : packages) {
            AbstractRefPackage pack = (AbstractRefPackage)p;
            classes.addAll(pack.refAllClasses());
            RepositoryReflection.collectAllClassProxies(pack, classes);
        }
        return classes;
    }

    public static String convertToString(List qName) {
        StringBuilder qStrName = new StringBuilder(20);
        int begin = 0;
        if (qName.size() > 2) {
            begin = 1;
        }
        int i = begin;
        while (i < qName.size()) {
            String name = (String)qName.get(i);
            qStrName.append('.');
            if (i + 1 < qName.size()) {
                name = name.toLowerCase(Locale.ENGLISH);
            }
            qStrName.append(name);
            ++i;
        }
        return qStrName.toString();
    }

    public List<Reference> findReferencesByType(AbstractRefObject objectTypeProvider, AbstractRefObject owner, String excludeName, Collection<String> validReferences, boolean returnOnlyMultiple) {
        AbstractRefClass classProxy;
        Classifier refMetaObject = (Classifier)this.getRefClass(objectTypeProvider).refMetaObject();
        if (objectTypeProvider.getRepository() != owner.getRepository() && (classProxy = RepositoryReflection.getMetamodelClassProxy(owner.getRepository(), objectTypeProvider.getClassType())) != null) {
            refMetaObject = (Classifier)classProxy.refMetaObject();
        }
        return this.findReferencesByType(owner, excludeName, validReferences, refMetaObject, returnOnlyMultiple);
    }

    public static List<Reference> findReferencesByType(AbstractRefClass type, AbstractRefClass owner, String excludeName, Collection<String> validReferences, boolean returnOnlyMultiple) {
        return RepositoryReflection.findReferencesByType(owner, excludeName, validReferences, (Classifier)type.refMetaObject(), returnOnlyMultiple);
    }

    private List<Reference> findReferencesByType(AbstractRefObject owner, String excludeName, Collection<String> validReferences, Classifier refMetaObject, boolean returnOnlyMultiple) {
        return RepositoryReflection.findReferencesByType((AbstractRefClass)this.getRefClass(owner), excludeName, validReferences, refMetaObject, returnOnlyMultiple);
    }

    private static List<Reference> findReferencesByType(AbstractRefClass owner, String excludeName, Collection<String> validReferences, Classifier refMetaObject, boolean returnOnlyMultiple) {
        ArrayList<Reference> foundRef = new ArrayList<Reference>();
        ArrayList<Reference> singleRef = new ArrayList<Reference>();
        List<Reference> references = RepositoryReflection.getReferences((org.omg.mof.model.Class)owner.refMetaObject());
        AbstractRepository repository = owner.getRepository();
        List<GeneralizableElement> superTypes = RepositoryReflection.getSuperTypes((GeneralizableElement)refMetaObject);
        int i = 0;
        while (i < references.size()) {
            Reference oppositeFeature;
            Classifier availableType;
            Reference ref = references.get(i);
            String refName = ref.getName();
            if (!(excludeName != null && refName.equals(excludeName) || validReferences != null && !validReferences.contains(refName) || !superTypes.contains(availableType = ref.getType()) || (oppositeFeature = RepositoryReflection.getOpposite(RepositoryReflection.getClassProxy(repository, (org.omg.mof.model.Class)refMetaObject), ref)) == null)) {
                boolean stereotypeProperty;
                boolean bl = stereotypeProperty = refName.equals("appliedStereotypeInstance") || refName.equals("stereotypedElement");
                if (!stereotypeProperty && (foundRef.isEmpty() || RepositoryReflection.getSuperTypes((GeneralizableElement)ref.getType()).contains(((Reference)foundRef.get(foundRef.size() - 1)).getType()))) {
                    if (!RepositoryReflection.isMultiple((StructuralFeature)ref)) {
                        if (!returnOnlyMultiple) {
                            singleRef.add(0, ref);
                        }
                    } else {
                        foundRef.add(0, ref);
                    }
                }
            }
            ++i;
        }
        if (!foundRef.isEmpty()) {
            return foundRef;
        }
        if (!singleRef.isEmpty()) {
            return singleRef;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GeneralizableElement> getSuperTypes(GeneralizableElement refMetaObject) {
        Map<GeneralizableElement, List<GeneralizableElement>> elementListMap;
        Map<GeneralizableElement, List<GeneralizableElement>> map = elementListMap = RepositoryReflection.getCache((RefBaseObject)refMetaObject).getCachedMofSuperTypes();
        synchronized (map) {
            List<GeneralizableElement> cached = elementListMap.get(refMetaObject);
            if (cached != null) {
                return cached;
            }
            List allSupertypes = refMetaObject.allSupertypes();
            ArrayList<GeneralizableElement> list = new ArrayList<GeneralizableElement>(allSupertypes.size() + 1);
            list.addAll(allSupertypes);
            list.add(refMetaObject);
            list = Collections.unmodifiableList(list);
            elementListMap.put(refMetaObject, list);
            return list;
        }
    }

    public boolean isFeatureEnumeration(String propertyName, AbstractRefObject owner) {
        StructuralFeature feature = RepositoryReflection.getFeature(propertyName, (AbstractRefClass)this.getRefClass(owner));
        if (feature != null) {
            return RepositoryReflection.isFeatureEnumeration(feature);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFeatureEnumeration(StructuralFeature feature) {
        Map<StructuralFeature, Boolean> enumFeatures;
        Map<StructuralFeature, Boolean> map = enumFeatures = RepositoryReflection.getCache((RefBaseObject)feature).getEnumFeatures();
        synchronized (map) {
            Boolean o = enumFeatures.get(feature);
            if (o == null) {
                Classifier type = feature.getType();
                o = type instanceof EnumerationType;
                enumFeatures.put(feature, o);
            }
            return o;
        }
    }

    public static boolean instanceOf(GeneralizableElement generalizableElement, List qualifiedName) {
        if (qualifiedName.equals(RepositoryReflection.getQualifiedName((ModelElement)generalizableElement))) {
            return true;
        }
        List<GeneralizableElement> list = RepositoryReflection.getSuperTypes(generalizableElement);
        int i = list.size() - 1;
        while (i >= 0) {
            if (qualifiedName.equals(RepositoryReflection.getQualifiedName((ModelElement)list.get(i)))) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean instanceOf(GeneralizableElement generalizableElement, GeneralizableElement type) {
        if (type == generalizableElement) {
            return true;
        }
        List<GeneralizableElement> list = RepositoryReflection.getSuperTypes(generalizableElement);
        int i = list.size() - 1;
        while (i >= 0) {
            if (type == list.get(i)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static List getQualifiedName(ModelElement refObject) {
        return refObject.getQualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnumProperty(StructuralFeature feature, @CheckForNull String enumValue, AbstractRefObject owner) {
        RefEnum enumeration = null;
        if (enumValue != null) {
            ReflectionMultiKeyMap<StructuralFeature, String, RefEnum> enums;
            ReflectionMultiKeyMap<StructuralFeature, String, RefEnum> reflectionMultiKeyMap = enums = RepositoryReflection.getCache((RefBaseObject)feature).getEnums();
            synchronized (reflectionMultiKeyMap) {
                enumeration = enums.get(feature, enumValue);
                if (enumeration == null) {
                    Classifier type = feature.getType();
                    enumeration = owner.getRepository().refGetEnum(type.getName(), enumValue);
                    enums.put(feature, enumValue, enumeration);
                }
            }
        }
        owner.refSetValue(feature.getName(), enumeration);
    }

    public boolean isFeatureContainer(String propertyName, RefObject owner) {
        StructuralFeature f = RepositoryReflection.getFeature(propertyName, (AbstractRefClass)this.getRefClass(owner), false);
        if (f != null) {
            int upper = f.getMultiplicity().getUpper();
            return upper > 1 || upper < 0;
        }
        throw new RuntimeException("property " + propertyName + " not found in " + owner);
    }

    public boolean isFeatureReference(String propertyName, RefObject owner) {
        StructuralFeature f = RepositoryReflection.getFeature(propertyName, (AbstractRefClass)this.getRefClass(owner));
        if (f != null) {
            return f instanceof Reference;
        }
        return false;
    }

    public static boolean isMultiplicityMany(MultiplicityType multiplicity) {
        return multiplicity != null && multiplicity.getUpper() != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getFeatureSubsets(String propertyName, AbstractRefClass cz) {
        Map<Class<? extends AbstractRefClass>, Map<String, Collection<String>>> cachedFeatureSubsets;
        Class<?> clazz = cz.getClass();
        Map<Class<? extends AbstractRefClass>, Map<String, Collection<String>>> map = cachedFeatureSubsets = RepositoryReflection.getCache(cz).getCachedFeatureSubsets();
        synchronized (map) {
            Collection result;
            Map<String, Collection<String>> map2 = cachedFeatureSubsets.get(clazz);
            if (map2 == null) {
                map2 = new HashMap<String, Collection<String>>();
                cachedFeatureSubsets.put(clazz, map2);
            }
            if ((result = map2.get(propertyName)) == null && !map2.containsKey(propertyName)) {
                String methodName = "getSubsetsOf" + propertyName;
                Method[] methods = clazz.getMethods();
                int i = 0;
                while (i < methods.length) {
                    Method m = methods[i];
                    if (m.getName().equals(methodName)) {
                        try {
                            result = (Collection)m.invoke((Object)cz, new Object[0]);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                if (result != null) {
                    result = Collections.unmodifiableCollection(result);
                }
                map2.put(propertyName, result);
            }
            return result;
        }
    }

    public static List<String> getFeatureSubsetsAll(String propertyName, AbstractRefClass clazz) {
        ArrayList<String> all = new ArrayList<String>();
        Collection<String> featureSubsets = RepositoryReflection.getFeatureSubsets(propertyName, clazz);
        if (featureSubsets != null) {
            for (String subsets : featureSubsets) {
                if (all.contains(subsets)) continue;
                all.add(subsets);
                List<String> featureSubsetsAll = RepositoryReflection.getFeatureSubsetsAll(subsets, clazz);
                int i = featureSubsetsAll.size() - 1;
                while (i >= 0) {
                    String subsubsets = featureSubsetsAll.get(i);
                    if (!all.contains(subsubsets)) {
                        all.add(subsubsets);
                    }
                    --i;
                }
            }
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSubsetedFeatures(AbstractRefObject owner) {
        Map<Class, List<String>> map;
        Class<?> clazz = owner.getClass();
        Map<Class, List<String>> map2 = map = RepositoryReflection.getCache(owner).getCachedSubsetedFeatures();
        synchronized (map2) {
            List<String> cached = map.get(clazz);
            if (cached == null) {
                ArrayList<String> rez = new ArrayList<String>();
                List<StructuralFeature> attributesAndReferences = RepositoryReflection.getAttributesAndReferences((org.omg.mof.model.Class)this.getRefClass(owner).refMetaObject());
                int i = 0;
                while (i < attributesAndReferences.size()) {
                    String name = attributesAndReferences.get(i).getName();
                    if (RepositoryReflection.getFeatureSubsets(name, (AbstractRefClass)this.getRefClass(owner)) != null) {
                        rez.add(name);
                    }
                    ++i;
                }
                map.put(clazz, rez);
                cached = rez;
            }
            return Collections.unmodifiableList(cached);
        }
    }

    public static Collection<Object> getActualCollection(Collection<Object> col) {
        if (col instanceof DerivedUnionEObjectEList) {
            return Collections.emptyList();
        }
        return col;
    }

    public List<String> getFeatureSubsetsDeep(String propertyName, RefObject owner) {
        return RepositoryReflection.getFeatureSubsetsDeep(propertyName, (AbstractRefClass)this.getRefClass(owner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFeatureSubsetsDeep(String propertyName, AbstractRefClass clazz) {
        Map<Class<? extends AbstractRefClass>, Map<String, List<String>>> cachedFeatureSubsetsDeep;
        Map<Class<? extends AbstractRefClass>, Map<String, List<String>>> map = cachedFeatureSubsetsDeep = RepositoryReflection.getCache(clazz).getCachedFeatureSubsetsDeep();
        synchronized (map) {
            List<String> l;
            Map<String, List<String>> map2 = cachedFeatureSubsetsDeep.get(clazz.getClass());
            if (map2 == null) {
                map2 = new HashMap<String, List<String>>();
                cachedFeatureSubsetsDeep.put(clazz.getClass(), map2);
            }
            if ((l = map2.get(propertyName)) == null) {
                l = Collections.emptyList();
                Collection<String> featureSubsets = RepositoryReflection.getFeatureSubsets(propertyName, clazz);
                if (featureSubsets != null) {
                    Collection ownerDerivedFeatures = clazz.getDerivedFeatures();
                    l = new ArrayList<String>(featureSubsets);
                    int i = 0;
                    while (i < l.size()) {
                        String f = l.get(i);
                        Collection<String> ss = RepositoryReflection.getFeatureSubsets(f, clazz);
                        if (ss != null) {
                            RepositoryReflection.append(l, ss);
                        }
                        ++i;
                    }
                    List<Reference> allContents = RepositoryReflection.getReferences((org.omg.mof.model.Class)clazz.refMetaObject(), false);
                    int i2 = l.size() - 1;
                    while (i2 >= 0) {
                        String object = l.get(i2);
                        if (object == null || ownerDerivedFeatures.contains(object)) {
                            l.remove(i2);
                        }
                        boolean exitsInContents = false;
                        for (Reference reference : allContents) {
                            if (!reference.getName().equals(object)) continue;
                            exitsInContents = true;
                            break;
                        }
                        if (!exitsInContents) {
                            l.remove(i2);
                        }
                        --i2;
                    }
                }
                l = Collections.unmodifiableList(l);
                map2.put(propertyName, l);
            }
            return l;
        }
    }

    private static <T> void append(List<T> l, Collection<T> ss) {
        for (T t : ss) {
            if (l.contains(t)) continue;
            l.add(t);
        }
    }

    public synchronized List<String> findReferencesByType(AbstractRefObject objectTypeProvider, AbstractRefObject owner, String excludeName, Collection<String> validReferences, String oppositeName, boolean onlyMultiple) {
        List<String> refName = this.findReferencesByType2(objectTypeProvider, owner, excludeName, validReferences, oppositeName, onlyMultiple);
        if (refName == null || refName.isEmpty()) {
            String objectTypeProviderRepresentation = objectTypeProvider == null ? null : String.valueOf(objectTypeProvider.getClass().getName()) + " " + objectTypeProvider;
            throw new IllegalArgumentException("can not find container for:" + objectTypeProviderRepresentation + " candidates are:" + validReferences);
        }
        return refName;
    }

    public synchronized List<String> findReferencesByType2(AbstractRefObject objectTypeProvider, AbstractRefObject owner, String excludeName, Collection<String> validReferences, String oppositeName, boolean onlyMultiple) {
        List<Reference> findReferenceByType;
        StructuralFeature feature;
        String hardCodedName;
        HardCodedRule hardcodedrule = RepositoryReflection.getCache(objectTypeProvider).getCachedDerivedReferences().get(owner.getClassType(), excludeName);
        if (hardcodedrule != null && (hardCodedName = hardcodedrule.getHardCodedName(owner, objectTypeProvider)) != null && validReferences.contains(hardCodedName) && (feature = RepositoryReflection.getFeature(hardCodedName, (AbstractRefClass)this.getRefClass(owner))) != null) {
            Classifier availableType = feature.getType();
            Classifier refMetaObject = (Classifier)this.getRefClass(objectTypeProvider).refMetaObject();
            if (RepositoryReflection.getSuperTypes((GeneralizableElement)refMetaObject).contains(availableType)) {
                return Collections.singletonList(hardCodedName);
            }
        }
        if ((findReferenceByType = this.findReferencesByType(objectTypeProvider, owner, excludeName, validReferences, onlyMultiple)) == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Reference reference : findReferenceByType) {
            ret.add(reference.getName());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInteger(StructuralFeature describingFeature) {
        Map<StructuralFeature, Boolean> integerFeatures;
        Map<StructuralFeature, Boolean> map = integerFeatures = RepositoryReflection.getCache((RefBaseObject)describingFeature).getIntegerFeatures();
        synchronized (map) {
            Boolean o = integerFeatures.get(describingFeature);
            if (o == null) {
                Classifier type = describingFeature.getType();
                List qualifiedName = type.getQualifiedName();
                o = qualifiedName.equals(INTEGER_QUALIFIED_NAME) || qualifiedName.equals(UNLIMITED_NATURALNAME);
                integerFeatures.put(describingFeature, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReal(StructuralFeature describingFeature) {
        Map<StructuralFeature, Boolean> realFeatures;
        Map<StructuralFeature, Boolean> map = realFeatures = RepositoryReflection.getCache((RefBaseObject)describingFeature).getRealFeatures();
        synchronized (map) {
            Boolean o = realFeatures.get(describingFeature);
            if (o == null) {
                Classifier type = describingFeature.getType();
                o = type.getQualifiedName().equals(REAL_QUALIFIED_NAME);
                realFeatures.put(describingFeature, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBoolean(StructuralFeature describingFeature) {
        Map<StructuralFeature, Boolean> booleanFeatures;
        Map<StructuralFeature, Boolean> map = booleanFeatures = RepositoryReflection.getCache((RefBaseObject)describingFeature).getBooleanFeatures();
        synchronized (map) {
            Boolean o = booleanFeatures.get(describingFeature);
            if (o == null) {
                Classifier type = describingFeature.getType();
                o = type.getQualifiedName().equals(BOOLEAN_QUALIFIED_NAME);
                booleanFeatures.put(describingFeature, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isString(StructuralFeature describingFeature) {
        Map<StructuralFeature, Boolean> stringFeatures;
        Map<StructuralFeature, Boolean> map = stringFeatures = RepositoryReflection.getCache((RefBaseObject)describingFeature).getStringFeatures();
        synchronized (map) {
            Boolean o = stringFeatures.get(describingFeature);
            if (o == null) {
                Classifier type = describingFeature.getType();
                o = type.getQualifiedName().equals(STRING_QUALIFIED_NAME);
                stringFeatures.put(describingFeature, o);
            }
            return o;
        }
    }

    public boolean isInteger(AbstractRefObject owner, String featureName) {
        return RepositoryReflection.isInteger(RepositoryReflection.getFeature(featureName, (AbstractRefClass)this.getRefClass(owner)));
    }

    public boolean isBoolean(AbstractRefObject owner, String featureName) {
        return RepositoryReflection.isBoolean(RepositoryReflection.getFeature(featureName, (AbstractRefClass)this.getRefClass(owner)));
    }

    public boolean isString(AbstractRefObject owner, String featureName) {
        return RepositoryReflection.isString(RepositoryReflection.getFeature(featureName, (AbstractRefClass)this.getRefClass(owner)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static StructuralFeature getStructuralFeatureInDerived(AbstractRepository repository, Class metaClass, String property) {
        ReflectionMultiKeyMap<Class, String, StructuralFeature> cachedDerivedFeatures;
        ReflectionHelperCache cache = RepositoryReflection.getCache(repository);
        ReflectionMultiKeyMap<Class, String, StructuralFeature> reflectionMultiKeyMap = cachedDerivedFeatures = cache.getCachedDerivedFeatures();
        synchronized (reflectionMultiKeyMap) {
            StructuralFeature value;
            block5: {
                value = cachedDerivedFeatures.get(metaClass, property);
                if (value == null) {
                    value = RepositoryReflection.getStructuralFeatureInDerivedInternal(repository, metaClass, property);
                    cachedDerivedFeatures.put(metaClass, property, value);
                }
                if (value != NULL_STRUCTURAL_FEATURE) break block5;
                return null;
            }
            return value;
        }
    }

    public static StructuralFeature getStructuralFeatureInDerivedInternal(AbstractRepository repository, Class metaClass, String property) {
        List<Class> types = ClassTypes.getSubtypes(metaClass, false);
        for (Class type : types) {
            AbstractRefClass refClass = RepositoryReflection.getMetamodelClassProxy(repository, type);
            StructuralFeature feature = RepositoryReflection.getFeature(property, refClass);
            if (feature == null) continue;
            return feature;
        }
        return NULL_STRUCTURAL_FEATURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractRefClass getMetaClassProxy(final String shortName) {
        Map<String, AbstractRefClass> classProxy;
        AbstractRepository repository = this.getRepository();
        Map<String, AbstractRefClass> map = classProxy = RepositoryReflection.getCache(repository).getMetaClassProxy();
        synchronized (map) {
            AbstractRefClass c = classProxy.get(shortName);
            if (c != null) {
                return c;
            }
            AbstractRefClass result = RepositoryReflection.findAbstractRefClass(repository, new RefClassMatcher(){

                @Override
                public boolean matches(AbstractRefClass refClass) {
                    return shortName.equals(((org.omg.mof.model.Class)refClass.refMetaObject()).getName());
                }
            });
            classProxy.put(shortName, result);
            return result;
        }
    }

    public List<String> getElementProperties(Element element, boolean derivedProperties, boolean privateProperties, boolean onlyChangeable) {
        return this.getAttributesAndReferences(element, derivedProperties, privateProperties, onlyChangeable).stream().map(ModelElement::getName).collect(Collectors.toList());
    }

    public List<StructuralFeature> getAttributesAndReferences(Element element, boolean derivedProperties, boolean privateProperties, boolean onlyChangeable) {
        Collection derivedFeatures = ((AbstractRefObject)((Object)element)).getDerivedFeatures();
        return RepositoryReflection.getAttributesAndReferences((org.omg.mof.model.Class)this.getRefClass(element).refMetaObject(), onlyChangeable).stream().filter(feature -> {
            String name = feature.getName();
            return !(!privateProperties && name.charAt(0) == '_' || !derivedProperties && derivedFeatures.contains(name));
        }).collect(Collectors.toList());
    }

    public static Collection<Object> getElementPropertyCollectionValue(Element element, String name) {
        if (((AbstractRefObject)((Object)element)).isSet(name)) {
            return (Collection)element.refGetValue(name);
        }
        return Collections.emptyList();
    }

    public Object getElementPropertyValue(Element element, String name) {
        StructuralFeature feature = RepositoryReflection.getFeature(name, (AbstractRefClass)this.getRefClass(element), false);
        if (feature != null) {
            if (RepositoryReflection.isMultiplicityMany(feature.getMultiplicity())) {
                return RepositoryReflection.getElementPropertyCollectionValue(element, name);
            }
            return element.refGetValue(name);
        }
        return null;
    }

    public void setAddElementPropertyValue(Element element, String name, Element value) {
        StructuralFeature feature = RepositoryReflection.getFeature(name, (AbstractRefClass)this.getRefClass(element), false);
        if (feature != null) {
            if (RepositoryReflection.isMultiplicityMany(feature.getMultiplicity())) {
                if (value != null) {
                    ((Collection)element.refGetValue(name)).add(value);
                }
            } else {
                element.refSetValue(name, value);
            }
        }
    }

    public boolean isAbstract(Class classType) {
        return ((org.omg.mof.model.Class)this.getMetaClassProxy(ClassTypes.getShortName(classType)).refMetaObject()).isAbstract();
    }

    public synchronized void clearReflectionCache() {
        RepositoryReflection.getCache(this.getRepository()).clear();
    }

    private static ReflectionHelperCache getCache(RefBaseObject o) {
        AbstractRepository.MofRepository mofRepository = RepositoryReflection.getMofRepository(o);
        if (mofRepository == null) {
            throw new IllegalArgumentException("CAN NOT RETRIEVE META REPOSITORY FOR REFLECTION HELPER CACHE");
        }
        return RepositoryReflection.getCache(mofRepository);
    }

    private static ReflectionHelperCache getCache(AbstractRepository.MofRepository mofRepository) {
        return mofRepository.getReflectionHelperCache();
    }

    static AbstractRepository.MofRepository getMofRepository(RefBaseObject o) {
        AbstractRepository.MofRepository mofRepository = null;
        if (o instanceof RepositoryProvider) {
            mofRepository = (AbstractRepository.MofRepository)((RepositoryProvider)o).getRepository().getMofRepository();
        } else if (o instanceof AbstractRefBaseObject) {
            mofRepository = (AbstractRepository.MofRepository)((AbstractRefBaseObject)o).mof_getRepository();
        }
        return mofRepository;
    }

    public static List<StructuralFeature> removeDeprecatedFeatures(List features, AbstractRefObject element, boolean removeExtensions) {
        Collection derivedFeatures = element.getDerivedFeatures();
        ArrayList<StructuralFeature> result = new ArrayList<StructuralFeature>(features.size());
        int i = 0;
        while (i < features.size()) {
            StructuralFeature f = (StructuralFeature)features.get(i);
            String featureName = f.getName();
            if (!(removeExtensions && featureName.length() > 0 && featureName.charAt(0) == '_' || derivedFeatures.contains(featureName))) {
                boolean alreadyExists = false;
                int j = result.size() - 1;
                while (j >= 0) {
                    StructuralFeature f2 = (StructuralFeature)result.get(j);
                    if (f2.getName().equals(featureName)) {
                        alreadyExists = true;
                        break;
                    }
                    --j;
                }
                if (!alreadyExists) {
                    result.add(f);
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean isMultiple(StructuralFeature f) {
        return RepositoryReflection.isMultiplicityMany(f.getMultiplicity());
    }

    public boolean isSubset(String subsetName, String unionName, AbstractRefObject refObject) {
        return RepositoryReflection.getFeatureSubsetsDeep(unionName, (AbstractRefClass)this.getRefClass(refObject)).contains(subsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean shouldDisposeReference(Reference r) {
        Map<Reference, Boolean> map;
        Map<Reference, Boolean> map2 = map = RepositoryReflection.getCache((RefBaseObject)r).getCachedDisposableReferences();
        synchronized (map2) {
            Boolean b = map.get(r);
            if (b == null) {
                b = Boolean.FALSE;
                if ("_slotOfDefiningFeature".equals(r.getName())) {
                    b = Boolean.TRUE;
                } else if ("_templateParameterSubstitutionOfFormal".equals(r.getName())) {
                    b = Boolean.TRUE;
                } else if ("_activityEdgeOfGuard".equals(r.getName())) {
                    b = Boolean.FALSE;
                } else {
                    Class classType = ClassTypes.getClassType(r.getType());
                    if (classType == null) {
                        return true;
                    }
                    if (ModelBridge.getBridge().isRelationship(classType)) {
                        b = Boolean.TRUE;
                    }
                }
                map.put(r, b);
            }
            return b;
        }
    }

    public void resetOtherComposites(Object objectToReset, String doNotResetThis) {
        AbstractRefObject ro = (AbstractRefObject)objectToReset;
        Collection derivedFeatures = ro.getDerivedFeatures();
        List compositeReferences = RepositoryReflection.getComposedByReferences((org.omg.mof.model.Class)this.getRefClass(ro).refMetaObject());
        int i = compositeReferences.size() - 1;
        while (i >= 0) {
            Reference r = (Reference)compositeReferences.get(i);
            String name = r.getName();
            if (r.isChangeable() && !name.equals(doNotResetThis) && !derivedFeatures.contains(name)) {
                ro.unSet(name);
            }
            --i;
        }
    }

    public List leaveSubsettedWithValue(List<String> features, AbstractRefObject owner, boolean ignorePrivate) {
        ArrayList<String> res = new ArrayList<String>(features);
        int i = 0;
        while (i < features.size()) {
            String f = features.get(i);
            if (this.getSubsetedPropertyWithValue(owner, f, null, ignorePrivate) != null) {
                res.remove(f);
            }
            ++i;
        }
        return res;
    }

    public String getSubsetedPropertyWithValue(AbstractRefObject element, String property, @CheckForNull Object value, boolean ignorePrivate) {
        List<String> subsets = RepositoryReflection.getFeatureSubsetsDeep(property, (AbstractRefClass)this.getRefClass(element));
        int i = 0;
        while (i < subsets.size()) {
            String o = subsets.get(i);
            if ((!ignorePrivate || o.charAt(0) != '_') && element.isSet(o)) {
                if (value == null) {
                    return o;
                }
                Object tmp = element.refGetValue(o);
                if (tmp instanceof Collection) {
                    return ((Collection)tmp).contains(value) ? o : null;
                }
                return tmp == value ? o : null;
            }
            ++i;
        }
        return null;
    }

    public static Set<AbstractRefObject> getReferencedObjects(AbstractRefObject referencer, List<Reference> references) {
        HashSet<AbstractRefObject> objects = null;
        int i = 0;
        while (i < references.size()) {
            Reference reference = references.get(i);
            if (referencer.isSet(reference.getName())) {
                Object value;
                if (objects == null) {
                    objects = new HashSet<AbstractRefObject>();
                }
                if ((value = referencer.refGetValue(reference.getName())) instanceof Collection) {
                    Iterator iterator = ((Collection)value).iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (object != null) continue;
                        ModelBridge.getInstance().getLog().error((Object)("reference in collection is null " + reference.getName() + " from object " + referencer));
                        iterator.remove();
                    }
                    objects.addAll((Collection)value);
                } else if (value != null) {
                    objects.add((AbstractRefObject)value);
                } else {
                    ModelBridge.getInstance().getLog().error((Object)("reference is set but return null " + reference.getName() + " from object " + referencer));
                }
            }
            ++i;
        }
        return objects == null ? Collections.emptySet() : objects;
    }

    public Set getReferencedObjects(AbstractRefObject object, String reference) {
        StructuralFeature feature = RepositoryReflection.getFeature(reference, (AbstractRefClass)this.getRefClass(object));
        HashSet<Object> objects = null;
        if (feature instanceof Reference && object.isSet(reference)) {
            objects = new HashSet<Object>();
            Object value = object.refGetValue(reference);
            if (value instanceof Collection) {
                objects.addAll((Collection)value);
            } else {
                objects.add(value);
            }
        }
        return objects == null ? Collections.EMPTY_SET : objects;
    }

    public AbstractRepository getRepository() {
        return this.mRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class> getContainerTypes(Class clazz) {
        Map<Class, List<Class>> byClassType;
        if (this.isAbstract(clazz)) {
            return Collections.emptyList();
        }
        AbstractRepository project = this.getRepository();
        Map<Class, List<Class>> map = byClassType = RepositoryReflection.getCache(project).getCachedContainersByClassType();
        synchronized (map) {
            List<Class> cached = byClassType.get(clazz);
            if (cached == null) {
                cached = new ArrayList<Class>();
                AbstractRefClass refClass = RepositoryReflection.getMetamodelClassProxy(project, clazz);
                if (refClass != null) {
                    Collection derivedFeatures = refClass.getDerivedFeatures();
                    List features = RepositoryReflection.getComposedByReferences((org.omg.mof.model.Class)refClass.refMetaObject());
                    int i = features.size() - 1;
                    while (i >= 0) {
                        StructuralFeature feature = (StructuralFeature)features.get(i);
                        if (!derivedFeatures.contains(feature.getName())) {
                            List qualifiedName = feature.getType().getQualifiedName();
                            String qName = (String)qualifiedName.get(qualifiedName.size() - 1);
                            Class classType = ClassTypes.getClassType(qName);
                            List<Class> allPossibleContainers = ClassTypes.getSubtypes(classType);
                            for (Class candidate : allPossibleContainers) {
                                if (this.isAbstract(candidate) || cached.contains(candidate)) continue;
                                cached.add(candidate);
                            }
                        }
                        --i;
                    }
                }
                cached = Collections.unmodifiableList(cached);
                byClassType.put(clazz, cached);
            }
            return cached;
        }
    }

    public List<Class> getContainerTypes(Collection<Class> types) {
        ArrayList<Class> allContainers = new ArrayList<Class>();
        for (Class clazz : types) {
            List<Class> containers = this.getContainerTypes(clazz);
            int i = containers.size() - 1;
            while (i >= 0) {
                Class o = containers.get(i);
                if (!allContainers.contains(o)) {
                    allContainers.add(o);
                }
                --i;
            }
        }
        return allContainers;
    }

    public void collectContainersRecursively(Collection<Class> types, Set<Class> all, Set<Class> checked) {
        if (types.size() > 0) {
            List<Class> containers = this.getContainerTypes(types);
            checked.addAll(types);
            all.addAll(containers);
            ArrayList<Class> containersToCheck = new ArrayList<Class>();
            int i = containers.size() - 1;
            while (i >= 0) {
                Class clazz = containers.get(i);
                if (!checked.contains(clazz)) {
                    containersToCheck.add(clazz);
                }
                --i;
            }
            this.collectContainersRecursively(containersToCheck, all, checked);
        }
    }

    public static String replace(String src, String pattern, String replaceWith) {
        int found;
        StringBuilder buf = null;
        int begin = 0;
        while ((found = src.indexOf(pattern, begin)) >= 0) {
            if (buf == null) {
                buf = new StringBuilder();
            }
            buf.append(src.substring(begin, found));
            buf.append(replaceWith);
            begin = found + pattern.length();
        }
        if (buf != null) {
            buf.append(src.substring(begin));
            return buf.toString();
        }
        return src;
    }

    public static boolean isDerivedUnion(AbstractRefClass rc, String featureName) {
        String name = ((org.omg.mof.model.Class)rc.refMetaObject()).getName();
        EClassifier classifier = UMLPackage.eINSTANCE.getEClassifier(name);
        EClass eClass = (EClass)classifier;
        String privateFeatureName = UML2ModelUtil.getPrivateFeatureName(eClass, featureName);
        EStructuralFeature feature = eClass.getEStructuralFeature(privateFeatureName);
        return UML2ModelUtil.isDerivedUnion(feature);
    }

    public boolean isDerivedUnion(RefObject rc, String featureName) {
        return RepositoryReflection.isDerivedUnion((AbstractRefClass)this.getRefClass(rc), featureName);
    }

    public static boolean isPureDerived(AbstractRefClass rc, String featureName) {
        String name = ((org.omg.mof.model.Class)rc.refMetaObject()).getName();
        EClassifier classifier = UMLPackage.eINSTANCE.getEClassifier(name);
        EClass eClass = (EClass)classifier;
        String privateFeatureName = UML2ModelUtil.getPrivateFeatureName(eClass, featureName);
        EStructuralFeature feature = eClass.getEStructuralFeature(privateFeatureName);
        return UML2ModelUtil.isDerivedButNotUnion(feature);
    }

    public static boolean isDerived(AbstractRefClass rc, String featureName) {
        return RepositoryReflection.isPureDerived(rc, featureName) || RepositoryReflection.isDerivedUnion(rc, featureName);
    }

    public static Map<String, String> getAnnotations(ModelElement element) {
        if (element == null) {
            return null;
        }
        String annotationStr = element.getAnnotation();
        if (annotationStr == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String[] annotations = annotationStr.split("(?<=[^\\\\]),");
        int i = 0;
        while (i < annotations.length) {
            String annotation = annotations[i];
            String[] strings = annotation.split("(?<=[^\\\\])=");
            if (strings.length == 2) {
                result.put(RepositoryReflection.capture(strings[0]), RepositoryReflection.capture(strings[1]));
            } else {
                result.put(RepositoryReflection.capture(annotation), null);
            }
            ++i;
        }
        return result;
    }

    public static void setAnnotations(ModelElement element, Map<String, String> annotationMap) {
        if (element == null) {
            return;
        }
        if (annotationMap == null || annotationMap.isEmpty()) {
            element.setAnnotation(null);
            return;
        }
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<String, String>> entries = annotationMap.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            buffer.append(RepositoryReflection.escape(entry.getKey()));
            String value = entry.getValue();
            if (value != null) {
                buffer.append('=');
                buffer.append(RepositoryReflection.escape(value));
            }
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        element.setAnnotation(buffer.toString());
    }

    public static void addAnnotations(ModelElement element, Map<String, String> annotationMap) {
        if (element == null) {
            return;
        }
        if (annotationMap == null || annotationMap.isEmpty()) {
            return;
        }
        Map<String, String> annotations = RepositoryReflection.getAnnotations(element);
        if (annotations == Collections.emptyMap()) {
            annotations = annotationMap;
        } else {
            annotations.putAll(annotationMap);
        }
        RepositoryReflection.setAnnotations(element, annotations);
    }

    public static void setAnnotation(ModelElement element, String annotationName, String value) {
        if (element == null) {
            return;
        }
        Map<String, String> annotations = RepositoryReflection.getAnnotations(element);
        if (annotations == Collections.emptyMap()) {
            annotations = Collections.singletonMap(annotationName, value);
        } else {
            annotations.put(annotationName, value);
        }
        RepositoryReflection.setAnnotations(element, annotations);
    }

    public static void unsetAnnotation(ModelElement element, String annotationName) {
        if (element == null) {
            return;
        }
        Map<String, String> annotations = RepositoryReflection.getAnnotations(element);
        annotations.remove(annotationName);
        RepositoryReflection.setAnnotations(element, annotations);
    }

    public static String getAnnotationValue(ModelElement element, String annotation) {
        if (element == null) {
            return null;
        }
        Map<String, String> annotations = RepositoryReflection.getAnnotations(element);
        return annotations.get(annotation);
    }

    public static boolean hasAnnotation(ModelElement element, String annotation) {
        if (element == null) {
            return false;
        }
        Map<String, String> annotations = RepositoryReflection.getAnnotations(element);
        return annotations.containsKey(annotation);
    }

    private static String escape(String value) {
        if (value == null) {
            return "<null>";
        }
        value = value.replace(",", "\\,");
        value = value.replace("=", "\\=");
        value = value.replace("<", "\\<");
        value = value.replace(">", "\\>");
        return value;
    }

    private static String capture(String value) {
        if (value == null || "<null>".equals(value)) {
            return null;
        }
        value = value.replace("\\,", ",");
        value = value.replace("\\=", "=");
        value = value.replace("\\<", "<");
        value = value.replace("\\>", ">");
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAttributesAndReferencesAsString(org.omg.mof.model.Class metaClass, boolean onlyChangeable) {
        Map<org.omg.mof.model.Class, Set<String>> cacheMap;
        ReflectionHelperCache cache = RepositoryReflection.getCache((RefBaseObject)metaClass);
        Map<org.omg.mof.model.Class, Set<String>> map = cacheMap = onlyChangeable ? cache.getCachedChangeableAttributesAndReferencesAsString() : cache.getCachedAttributesAndReferencesAsString();
        synchronized (map) {
            Set<String> cached = cacheMap.get(metaClass);
            if (cached == null) {
                List<StructuralFeature> references = RepositoryReflection.getAttributesAndReferences(metaClass, onlyChangeable);
                cached = new HashSet<String>(references.size());
                int i = 0;
                while (i < references.size()) {
                    StructuralFeature feature = references.get(i);
                    cached.add(feature.getName());
                    ++i;
                }
                cached = Collections.unmodifiableSet(cached);
                cacheMap.put(metaClass, cached);
            }
            return cached;
        }
    }

    public static String getCompositeReferenceName(AbstractRepository project, Class parent, Class child) {
        AbstractRefClass parentRefClass = RepositoryReflection.getMetamodelClassProxy(project, parent);
        List<String> compositeRelationPropertyName = RepositoryReflection.getCompositeRelationPropertyName(project, parentRefClass, child, false);
        if (compositeRelationPropertyName == null || compositeRelationPropertyName.isEmpty()) {
            return "";
        }
        return compositeRelationPropertyName.get(0);
    }

    public static boolean hasFeature(String name, AbstractRefClass proxyClass) {
        org.omg.mof.model.Class metaClass = (org.omg.mof.model.Class)proxyClass.refMetaObject();
        return RepositoryReflection.getAttributesAndReferencesAsString(metaClass, false).contains(name);
    }

    private RefClass getRefClass(RefObject refObject) {
        return this.mRefClassProvider.getRefClass(refObject);
    }

    private static AbstractRefClass findAbstractRefClass(AbstractRefPackage refPackage, RefClassMatcher matcher) {
        AbstractRefClass refClass;
        for (Object o : refPackage.refAllClasses()) {
            refClass = (AbstractRefClass)o;
            if (!matcher.matches(refClass)) continue;
            return refClass;
        }
        for (Object o : refPackage.refAllPackages()) {
            refClass = RepositoryReflection.findAbstractRefClass((AbstractRefPackage)o, matcher);
            if (refClass == null) continue;
            return refClass;
        }
        return null;
    }

    public static Reference getOpposite(AbstractRefClass refClass, Reference reference) {
        String qlfName;
        AssociationEnd exposedEnd = reference.getExposedEnd();
        if (exposedEnd == null) {
            return null;
        }
        String name = exposedEnd.getName();
        Collection<String> redefinedFeatures = refClass.getRedefinedFeatures();
        if (redefinedFeatures.contains(qlfName = String.valueOf(reference.getType().getName()) + '.' + name)) {
            name = refClass.getRedefinedFeaturesMap().get(qlfName);
        }
        return (Reference)RepositoryReflection.getFeature(name, refClass, false);
    }

    private static synchronized AbstractRepository internalGetRepository() {
        ModelBridge bridge = ModelBridge.getBridge();
        AbstractRepository ar = null;
        if (bridge != null) {
            ar = bridge.getRepository(null);
        }
        if (ar == null) {
            if (mDummyRepository != null) {
                ar = mDummyRepository.get();
            }
            if (ar == null) {
                Log.info("ReflectionHelper.getElementsFactory CREATING A NEW TEMPORAL REPOSITORY INSTANCE");
                TASRepositoryImpl tasRepository = new TASRepositoryImpl();
                ar = tasRepository;
                mDummyRepository = new SoftReference<TASRepositoryImpl>(tasRepository);
            }
        }
        return ar;
    }

    public static boolean isMultiplicityOfPropertyMany(@CheckForNull Element element, StructuralFeature feature) {
        EStructuralFeature eStructuralFeature;
        if (element != null && (eStructuralFeature = UML2ModelUtil.getEStructuralFeature(element.eClass(), feature.getName())) != null) {
            return UML2ModelUtil.isMDMultiplicityMany(eStructuralFeature);
        }
        return RepositoryReflection.isMultiplicityMany(feature.getMultiplicity());
    }

    @OpenApiAll
    private static interface RefClassMatcher {
        public boolean matches(AbstractRefClass var1);
    }
}

