/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.nomagic.annotation.OpenApiAll;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

@OpenApiAll
public class ReflectionMultiKeyMap<K1, K2, V> {
    private final Map<K1, Map<K2, V>> mMainMap = new HashMap<K1, Map<K2, V>>();

    @CheckForNull
    public V get(K1 key1, K2 key2) {
        Map<K2, V> m2 = this.mMainMap.get(key1);
        if (m2 != null) {
            return m2.get(key2);
        }
        return null;
    }

    public V put(K1 key1, K2 key2, V value) {
        Map<K2, V> m2 = this.mMainMap.get(key1);
        if (m2 == null) {
            m2 = new HashMap<K2, V>();
            this.mMainMap.put(key1, m2);
        }
        return m2.put(key2, value);
    }

    @CheckForNull
    public V remove(K1 key1, K2 key2) {
        Map<K2, V> m2 = this.mMainMap.get(key1);
        if (m2 != null) {
            return m2.remove(key2);
        }
        return null;
    }

    public boolean containsKeys(K1 key1, K2 key2) {
        Map<K2, V> m2 = this.mMainMap.get(key1);
        return m2 != null && m2.containsKey(key2);
    }

    public void clear() {
        this.mMainMap.clear();
    }
}

