/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.jmi.reflect.RefObject;

@OpenApiAll
@ThreadSafe
public class ExpressionEvaluationManager {
    private static final Map<AbstractRepository, ExpressionEvaluationManager> mInstances = new WeakHashMap<AbstractRepository, ExpressionEvaluationManager>();
    private ThreadLocal<Collection<Key>> mThreadLocal = new ThreadLocal();

    private ExpressionEvaluationManager() {
    }

    public static ExpressionEvaluationManager getInstance(AbstractRepository repository) {
        return mInstances.get(repository);
    }

    static void create(AbstractRepository repository) {
        mInstances.put(repository, new ExpressionEvaluationManager());
    }

    private Collection<Key> getEvaluated() {
        Collection<Key> keys = this.mThreadLocal.get();
        if (keys == null) {
            keys = new HashSet<Key>();
            this.mThreadLocal.set(keys);
        }
        return keys;
    }

    public boolean isEvaluated(RefObject object, String property) {
        Collection<Key> keys = this.getEvaluated();
        Key key = new Key(object, property);
        return keys.contains(key);
    }

    public Collection<Key> getEvaluatedProperties() {
        return this.mThreadLocal.get();
    }

    public void setAsEvaluated(RefObject object, String property) {
        Key key;
        Collection<Key> keys = this.getEvaluated();
        if (!keys.add(key = new Key(object, property))) {
            throw new IllegalStateException("Programming bug. Marking an object as evaluated twice.");
        }
    }

    public void clearEvaluationStatus(RefObject object, String property) {
        this.getEvaluated().remove(new Key(object, property));
    }

    @OpenApiAll
    public static class Key {
        private final RefObject mRefObject;
        private final String mProperty;

        private Key(RefObject refObject, String property) {
            this.mRefObject = refObject;
            this.mProperty = property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.mProperty != null ? !this.mProperty.equals(key.mProperty) : key.mProperty != null) {
                return false;
            }
            return !(this.mRefObject != null ? !this.mRefObject.equals((Object)key.mRefObject) : key.mRefObject != null);
        }

        public int hashCode() {
            int result = this.mRefObject != null ? this.mRefObject.hashCode() : 0;
            result = 31 * result + (this.mProperty != null ? this.mProperty.hashCode() : 0);
            return result;
        }
    }
}

