/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml.BaseElement;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefClass;
import com.nomagic.uml2.ext.jmi.reflect.RepositoryReflection;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Classifier;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Namespace;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Package;
import com.nomagic.uml2.ext.magicdraw.mdprofiles.Profile;
import com.nomagic.uml2.impl.ClassNames;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.jmi.reflect.RefBaseObject;
import org.eclipse.emf.ecore.EClass;
import org.omg.mof.model.ModelElement;

@OpenApiAll
public class ClassTypes {
    private static final Class NULL_CLASS = ClassTypes.class;
    public static final String BASE_PACKAGE = "com.nomagic.uml2.ext.magicdraw";
    public static Comparator<Class> CLASS_COMPARATOR = Comparator.comparing(ClassTypes::getShortName);
    private static Map<Class, List<Class>> mSubtypes = new HashMap<Class, List<Class>>();
    private static Map<Class, List<Class>> mSubtypesNoAbstract = new HashMap<Class, List<Class>>();
    private static Map<Class, List<Class>> mSuperTypes = new HashMap<Class, List<Class>>();
    private static final Map<String, Class> mClassTypesByShortName = new HashMap<String, Class>();
    private static List<Class> mNameSpaces;
    private static List<Class> mClassifiers;

    public static synchronized List<Class> getNameSpaces() {
        if (mNameSpaces == null) {
            mNameSpaces = new ArrayList<Class>(ClassTypes.getSubtypes(Namespace.class, false));
            mNameSpaces.sort(CLASS_COMPARATOR);
            mNameSpaces = Collections.unmodifiableList(mNameSpaces);
        }
        return mNameSpaces;
    }

    public static synchronized List<Class> getClassifiers() {
        if (mClassifiers == null) {
            mClassifiers = new ArrayList<Class>(ClassTypes.getSubtypes(Classifier.class, false));
            mClassifiers.sort(CLASS_COMPARATOR);
            mClassifiers = Collections.unmodifiableList(mClassifiers);
        }
        return mClassifiers;
    }

    public static Collection<Class> getPackagesNotProfile() {
        List<Class> packages = ClassTypes.getSubtypes(Package.class);
        packages.remove(Profile.class);
        return packages;
    }

    public static Set<Class> getSubtypes(Collection<Class> types) {
        HashSet<Class> s = new HashSet<Class>();
        for (Class type : types) {
            s.addAll(ClassTypes.getSubtypes(type));
        }
        return s;
    }

    public static Set<Class> getSubtypes(Collection<Class> types, boolean includeAbstract) {
        HashSet<Class> s = new HashSet<Class>();
        for (Class type : types) {
            s.addAll(ClassTypes.getSubtypes(type, includeAbstract));
        }
        return s;
    }

    public static List<Class> getSubtypes(Class type) {
        return ClassTypes.getSubtypes(type, true);
    }

    public static List<Class> getSubtypes(Class type, boolean includeAbstract) {
        Map<Class, List<Class>> map = includeAbstract ? mSubtypes : mSubtypesNoAbstract;
        List<Class> subtypes = map.get(type);
        if (subtypes == null) {
            RepositoryReflection repositoryReflection = RepositoryReflection.create(null);
            Field[] fields = ClassNames.class.getFields();
            subtypes = new ArrayList<Class>();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!ClassTypes.isIDField(field)) {
                    Class val = null;
                    try {
                        val = (Class)field.get(ClassNames.class);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (type.isAssignableFrom(val) && (includeAbstract || !repositoryReflection.isAbstract(val))) {
                        subtypes.add(val);
                    }
                }
                ++n2;
            }
            map.put(type, subtypes);
        }
        return new ArrayList<Class>(subtypes);
    }

    public static Class[] getSubtypesArray(Collection<Class> type) {
        Set<Class> subtypes = ClassTypes.getSubtypes(type);
        return subtypes.toArray(new Class[subtypes.size()]);
    }

    public static Class[] getSubtypesArray(Collection<Class> type, boolean includeAbstract) {
        Set<Class> subtypes = ClassTypes.getSubtypes(type, includeAbstract);
        return subtypes.toArray(new Class[subtypes.size()]);
    }

    public static Class[] getSubtypesArray(Class type) {
        List<Class> subtypes = ClassTypes.getSubtypes(type);
        return subtypes.toArray(new Class[0]);
    }

    public static Class[] getSubtypesArray(Class type, boolean includeAbstract) {
        List<Class> subtypes = ClassTypes.getSubtypes(type, includeAbstract);
        return subtypes.toArray(new Class[0]);
    }

    public static List<Class> getDirectSubtypes(Class type, boolean includeAbstract) {
        List<Class> subClasses = ClassTypes.getSubtypes(type, includeAbstract);
        subClasses.removeIf(subType -> !ClassTypes.isDirectSubType(subType, type));
        return subClasses;
    }

    private static boolean isIDField(Field field) {
        return field.getName().endsWith("_ID") || "CLASSES_COUNT".equals(field.getName());
    }

    private static boolean isDirectSubType(Class sub, Class sup) {
        Type[] typeArray = sub.getGenericInterfaces();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            if (t == sup) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<Class> getSupertypes(Class type) {
        List<Class> supertypes = mSuperTypes.get(type);
        if (supertypes == null) {
            Field[] fields;
            supertypes = new ArrayList<Class>();
            Field[] fieldArray = fields = ClassNames.class.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!ClassTypes.isIDField(field)) {
                    Class val = null;
                    try {
                        val = (Class)field.get(ClassNames.class);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!type.equals(val) && val.isAssignableFrom(type)) {
                        supertypes.add(val);
                    }
                }
                ++n2;
            }
            mSuperTypes.put(type, supertypes);
        }
        return new ArrayList<Class>(supertypes);
    }

    public static Class getClassType(org.omg.mof.model.Classifier metatype) {
        return ClassTypes.getClassType(metatype.getQualifiedName());
    }

    private static Class getMDClassType(List<String> qualifiedName) {
        qualifiedName = new ArrayList<String>(qualifiedName);
        Collections.reverse(qualifiedName);
        String className = qualifiedName.get(0);
        String mdPack = qualifiedName.get(1);
        String superPack = ".";
        if (qualifiedName.size() > 2) {
            superPack = qualifiedName.get(2);
            superPack = "uml2".equals(superPack) ? "." : String.valueOf('.') + superPack.toLowerCase(Locale.ENGLISH) + '.';
        }
        if (!mdPack.startsWith("md")) {
            mdPack = "md" + mdPack;
        }
        mdPack = mdPack.toLowerCase(Locale.ENGLISH);
        try {
            String fullClassname = BASE_PACKAGE + superPack + mdPack + '.' + className;
            return Class.forName(fullClassname);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getClassType(List<String> qualifiedName) {
        String className = qualifiedName.get(qualifiedName.size() - 1);
        return ClassTypes.getClassType(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getClassType(String shortName) {
        Map<String, Class> map = mClassTypesByShortName;
        synchronized (map) {
            Class aClass = mClassTypesByShortName.get(shortName);
            if (aClass == null) {
                AbstractRefClass metaClassProxy = RepositoryReflection.create(null).getMetaClassProxy(shortName);
                if (metaClassProxy != null) {
                    EClass eClass = metaClassProxy.getEClass();
                    if (eClass != null) {
                        aClass = eClass.getInstanceClass();
                    } else {
                        org.omg.mof.model.Class mofClass = (org.omg.mof.model.Class)metaClassProxy.refMetaObject();
                        List qualifiedName = mofClass.getQualifiedName();
                        aClass = ClassTypes.getMDClassType(qualifiedName);
                    }
                }
                if (aClass == null) {
                    aClass = NULL_CLASS;
                }
                mClassTypesByShortName.put(shortName, aClass);
            }
            return aClass == NULL_CLASS ? null : aClass;
        }
    }

    @CheckForNull
    public static String getShortName(@CheckForNull Class type) {
        if (type == null) {
            return null;
        }
        String name = type.getName();
        return name != null ? name.substring(name.lastIndexOf(46) + 1) : null;
    }

    public static Set<Class> getClassTypesForElements(Collection<? extends BaseElement> elements) {
        return elements.stream().map(BaseElement::getClassType).collect(Collectors.toSet());
    }

    public static Set<String> getShortNameForClassTypes(Collection<Class> types) {
        HashSet<String> res = new HashSet<String>();
        for (Class type : types) {
            String shortName = ClassTypes.getShortName(type);
            if (shortName == null) continue;
            res.add(shortName);
        }
        return res;
    }

    public static Set<Class> getClassTypeForShortNames(Collection<String> names) {
        HashSet<Class> res = new HashSet<Class>();
        for (String name : names) {
            Class classType = ClassTypes.getClassType(name);
            if (classType == null) continue;
            res.add(classType);
        }
        return res;
    }

    public static void removeAbstract(Collection<Class> classTypes) {
        RepositoryReflection repositoryReflection = RepositoryReflection.create(null);
        Iterator<Class> it = classTypes.iterator();
        while (it.hasNext()) {
            if (!repositoryReflection.isAbstract(it.next())) continue;
            it.remove();
        }
    }

    public static Collection<Class> expandToConcreteMetaClasses(Collection<Class> metaClasses) {
        RepositoryReflection repositoryReflection = RepositoryReflection.create(null);
        HashSet<Class> result = new HashSet<Class>();
        for (Class metaClass : metaClasses) {
            if (repositoryReflection.isAbstract(metaClass)) {
                List<Class> subClasses = ClassTypes.getDirectSubtypes(metaClass, true);
                result.addAll(ClassTypes.expandToConcreteMetaClasses(subClasses));
                continue;
            }
            result.add(metaClass);
        }
        return result;
    }

    public static List<String> getTypeQualifiedName(RefBaseObject refBaseObject) {
        return RepositoryReflection.getQualifiedName((ModelElement)refBaseObject.refMetaObject());
    }
}

