/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.io_software.catools.tas.marks.TASTypeHandle;
import com.io_software.catools.tas.mof.TASMofRepository;
import com.io_software.catools.tas.mof.TASMofRepositoryImpl;
import com.io_software.catools.tas.mof.TASRepository;
import com.io_software.catools.tas.repository.TASRepositoryDescriptor;
import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml.BaseElement;
import com.nomagic.uml2.ext.jmi.EventSupport;
import com.nomagic.uml2.ext.jmi.MapOwner;
import com.nomagic.uml2.ext.jmi.MetaModelMap;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefPackage;
import com.nomagic.uml2.ext.jmi.reflect.ElementRegistry;
import com.nomagic.uml2.ext.jmi.reflect.ExpressionEvaluationManager;
import com.nomagic.uml2.ext.jmi.reflect.ModelBridge;
import com.nomagic.uml2.ext.jmi.reflect.ReflectionHelperCache;
import com.nomagic.uml2.ext.magicdraw.base.ModelObject;
import com.nomagic.uml2.impl.ElementsFactory;
import com.nomagic.uml2.impl.ValuesTable;
import com.nomagic.uml2.transaction.ModelListener;
import com.nomagic.uml2.transaction.TransactionManager;
import com.nomagic.uml2.transaction.TransactionManagerImpl;
import com.nomagic.utils.Counter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.omg.mof.model.EnumerationType;
import org.omg.mof.model.ModelElement;
import org.omg.mof.model.Package;

@OpenApiAll
public abstract class AbstractRepository
extends AbstractRefPackage {
    private HashMap<Calculators, Calculator> mCalculators = new HashMap();
    private Map<RefBaseObject, RefBaseObject> mObjectWeakHashMap = Collections.synchronizedMap(new WeakHashMap());
    private IDProxy mIDProxy = IDProxy.LOCAL;
    private final AtomicLong version = new AtomicLong();
    private Map<String, RefEnum> mEnumMap = new HashMap<String, RefEnum>();
    protected Map interfacePackagePrefixToRefPackage;
    protected Collection interfacePackagePrefixes;
    private EventSupport mEventSupport;
    protected TASMofRepository mofRepository;
    private boolean mAlive;
    private ElementRegistry mProject;
    private boolean mCanSetID = true;
    private Counter mIDCounter = null;
    private ModelListener mModelListener;
    private TransactionManager mModelTransaction;
    private ValuesTable mValuesTable;
    private boolean mRawMode;
    private Set<RefObject> mCandidatesForDispose = new HashSet<RefObject>();
    private ElementsFactory elementsFactory;
    private CandidatesForDisposeEventSupport candidatesForDisposeEventSupport = new CandidatesForDisposeEventSupport();

    public boolean isFullPreLoad() {
        ElementRegistry project = this.getProject();
        return project == null || project.isPreloadProject();
    }

    public IDProxy getIDProxy() {
        return this.mIDProxy;
    }

    public void setIDProxy(IDProxy useEsiID) {
        this.mIDProxy = useEsiID;
    }

    public long getVersion() {
        return this.version.get() + this.getEventSupport().getEventsCount();
    }

    public void nextVersion() {
        this.version.incrementAndGet();
    }

    public AbstractRepository() {
        super(null);
        this.setRepository(this);
        this.mEventSupport = new EventSupport(this);
        this.mAlive = true;
        this.mValuesTable = new ValuesTable();
        TransactionManagerImpl modelTransactionImpl = new TransactionManagerImpl(this);
        this.setTransactionManager(modelTransactionImpl);
        ExpressionEvaluationManager.create(this);
    }

    protected void setEventSupport(EventSupport eventSupport) {
        this.mEventSupport = eventSupport;
    }

    public ElementsFactory getElementsFactory() {
        return this.elementsFactory;
    }

    public void setElementsFactory(ElementsFactory elementsFactory) {
        this.elementsFactory = elementsFactory;
    }

    public void setTransactionManager(TransactionManager modelTransactionImpl) {
        this.mModelTransaction = modelTransactionImpl;
        if (modelTransactionImpl instanceof ModelListener) {
            this.setTransactionModelListener((ModelListener)((Object)modelTransactionImpl));
        }
    }

    @CheckForNull
    public RefObject getElementById(String id) {
        this.checkAlive();
        ElementRegistry project = this.getProject();
        if (project != null) {
            return (RefObject)project.getElementByID(id);
        }
        return null;
    }

    protected void checkAlive() {
        if (!this.mAlive) {
            throw new IllegalArgumentException("Repository is killed.");
        }
    }

    public boolean isAlive() {
        return this.mAlive;
    }

    public void kill() {
        this.mAlive = false;
    }

    protected void classProxies() {
        Collection packs = this.refAllPackages();
        for (RefPackage pack : packs) {
            Collection classes = pack.refAllClasses();
            for (RefClass cl : classes) {
                cl.refMetaObject();
            }
        }
    }

    public TASMofRepository getMofRepository() {
        if (this.mofRepository == null) {
            this.mofRepository = new MofRepository();
        }
        return this.mofRepository;
    }

    public Map createMap(MapOwner owner, String mapName) {
        return new MetaModelMap(owner, mapName);
    }

    public EventSupport getEventSupport() {
        this.checkAlive();
        return this.mEventSupport;
    }

    public void registerElement(RefBaseObject object) {
        String id = object.refMofId();
        if (id != null) {
            ElementRegistry project = this.getProject();
            if (project != null) {
                project.addElementByID((BaseElement)object, null);
            }
            this.mObjectWeakHashMap.put(object, null);
        }
    }

    public int getObjectsCount() {
        return this.mObjectWeakHashMap.size();
    }

    public void unRegisterElement(RefBaseObject object) {
        ElementRegistry project;
        String id = object.refMofId();
        if (id != null && (project = this.getProject()) != null) {
            project.removeElementByID((BaseElement)object);
        }
        this.mObjectWeakHashMap.remove(object);
    }

    @Override
    public AbstractRepository getRepository() {
        return this;
    }

    public ElementRegistry getProject() {
        return this.mProject;
    }

    public void setProject(ElementRegistry project) {
        this.mProject = project;
    }

    @Override
    @CheckForNull
    public RefEnum refGetEnum(String enumName, String args) {
        String key = String.valueOf(enumName) + args;
        RefEnum o = this.mEnumMap.get(key);
        if (o == null) {
            for (RefPackage pack : this.refAllPackages()) {
                Package object = (Package)pack.refMetaObject();
                List contents = object.getContents();
                for (ModelElement mo : contents) {
                    if (!(mo instanceof EnumerationType) || !mo.getName().equals(enumName)) continue;
                    o = pack.refGetEnum(enumName, args);
                    this.mEnumMap.put(key, o);
                    return o;
                }
            }
        }
        return o;
    }

    public TASRepository getMetamodelProvider() {
        return null;
    }

    public Counter getCounter() {
        return this.mIDCounter;
    }

    public void setCounter(Counter count) {
        this.mIDCounter = count;
    }

    public boolean canSetID() {
        return this.mCanSetID;
    }

    public void setCanSetID(boolean canSetID) {
        this.mCanSetID = canSetID;
    }

    public ValuesTable getValuesTable() {
        return this.mValuesTable;
    }

    public void invokeAfterTransaction(Runnable r) {
        this.getEventSupport().invokeAfterTransaction(r);
    }

    public boolean isRawMode() {
        return this.mRawMode;
    }

    public void setRawMode(boolean rawMode) {
        this.mRawMode = rawMode;
    }

    public ModelListener getTransactionModelListener() {
        return this.mModelListener;
    }

    public TransactionManager getTransactionManager() {
        return this.mModelTransaction;
    }

    public void setTransactionModelListener(ModelListener listener) {
        this.mModelListener = listener;
    }

    public void addCandidateForDispose(RefObject object) {
        this.mCandidatesForDispose.add(object);
        this.candidatesForDisposeEventSupport.candidateAdded(object);
    }

    public void removeCandidateForDispose(RefObject object) {
        this.mCandidatesForDispose.remove(object);
        this.candidatesForDisposeEventSupport.candidateRemoved(object);
    }

    public Set<RefObject> getCandidatesForDispose() {
        return Collections.unmodifiableSet(this.mCandidatesForDispose);
    }

    public void clearCandidatesForDispose() {
        this.mCandidatesForDispose.clear();
    }

    public void addCandidatesForDisposeListener(CandidatesForDisposeListener listener) {
        this.candidatesForDisposeEventSupport.addListener(listener);
    }

    public void removeCandidatesForDisposeListener(CandidatesForDisposeListener listener) {
        this.candidatesForDisposeEventSupport.removeListener(listener);
    }

    public Calculator getCalculator(Calculators calculatorName) {
        return this.mCalculators.get((Object)calculatorName);
    }

    public Calculator addCalculator(Calculators id, Calculator calculator) {
        return this.mCalculators.put(id, calculator);
    }

    @OpenApiAll
    public static interface Calculator {
        @CheckForNull
        public AtomicReference getValue(Object var1);
    }

    @OpenApiAll
    public static enum Calculators {
        BEHAVIOR_CONTEXT;

    }

    @OpenApiAll
    private static class CandidatesForDisposeEventSupport
    implements CandidatesForDisposeListener {
        protected final CopyOnWriteArrayList<CandidatesForDisposeListener> listeners = new CopyOnWriteArrayList();

        private CandidatesForDisposeEventSupport() {
        }

        @Override
        public void candidateAdded(RefObject candidate) {
            this.invokeForAllListeners(listener -> listener.candidateAdded(candidate));
        }

        public void removeListener(CandidatesForDisposeListener listener) {
            this.listeners.remove(listener);
        }

        public void addListener(CandidatesForDisposeListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void candidateRemoved(RefObject candidate) {
            this.invokeForAllListeners(listener -> listener.candidateRemoved(candidate));
        }

        private void invokeForAllListeners(ListenerRunnable run) {
            for (CandidatesForDisposeListener listener : this.listeners) {
                try {
                    run.run(listener);
                }
                catch (Exception e) {
                    ModelBridge.getInstance().getLog().error((Object)("Failed to notify listener " + listener), (Throwable)e);
                }
            }
        }

        @OpenApiAll
        private static interface ListenerRunnable {
            public void run(CandidatesForDisposeListener var1);
        }
    }

    @OpenApiAll
    public static interface CandidatesForDisposeListener {
        public void candidateAdded(RefObject var1);

        public void candidateRemoved(RefObject var1);
    }

    @OpenApiAll
    public static interface IDProxy {
        public static final IDProxy LOCAL = new IDProxy(){

            @Override
            public String getID(ModelObject object) {
                return object.getLocalID();
            }

            @Override
            public String sGetID(ModelObject object) {
                return object.sGetLocalID();
            }

            @Override
            public void setID(String id, ModelObject object) {
                object.setLocalID(id);
            }
        };

        public String getID(ModelObject var1);

        public String sGetID(ModelObject var1);

        public void setID(String var1, ModelObject var2);
    }

    @OpenApiAll
    public final class MofRepository
    extends TASMofRepositoryImpl {
        private ReflectionHelperCache mCache;

        public ReflectionHelperCache getReflectionHelperCache() {
            if (this.mCache == null) {
                this.mCache = new ReflectionHelperCache();
            }
            return this.mCache;
        }

        public String toString() {
            return String.valueOf(super.toString()) + AbstractRepository.this.mProject;
        }

        public AbstractRepository getRepository() {
            return AbstractRepository.this;
        }

        public TASTypeHandle getTypeHandle(RefObject refObject) {
            return null;
        }

        public TASTypeHandle getTypeHandle(String s, Map map) {
            return null;
        }

        public TASTypeHandle getTypeHandle(RefObject refObject, Map map) {
            return null;
        }

        public TASRepositoryDescriptor getRepositoryDescriptor() {
            return null;
        }
    }
}

