/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefBaseObject;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefBaseObjectImpl;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefClass;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jmi.reflect.InvalidCallException;
import javax.jmi.reflect.InvalidNameException;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;

@OpenApiAll
public abstract class AbstractRefPackage
extends AbstractRefBaseObjectImpl
implements RefPackage {
    private Map mClasses = this.getRepository().createMap(this, "Classes");
    private Map mAssociations = this.getRepository().createMap(this, "Associations");
    private Map mMetaObjects = this.getRepository().createMap(this, "MetaObjects");
    private Map mPackages = this.getRepository().createMap(this, "Packages");

    public void addAssociation(String name, RefAssociation assoc) {
        this.mAssociations.put(name, assoc);
        ((AbstractRefBaseObject)assoc).setOwner(this);
    }

    public AbstractRefPackage(AbstractRepository repository) {
        super(repository);
    }

    public Collection refAllAssociations() {
        return this.mAssociations.values();
    }

    public Collection refAllClasses() {
        return this.mClasses.values();
    }

    public RefAssociation refAssociation(RefObject association) {
        return null;
    }

    public RefAssociation refAssociation(String associationName) {
        RefAssociation refAssociation = (RefAssociation)this.mAssociations.get(associationName);
        if (refAssociation == null) {
            throw new InvalidNameException(associationName);
        }
        return refAssociation;
    }

    public RefClass refClass(RefObject type) {
        return null;
    }

    public RefClass refClass(String className) {
        RefClass refClass = (RefClass)this.mClasses.get(className);
        if (refClass == null) {
            throw new InvalidNameException(className);
        }
        return refClass;
    }

    public RefStruct refCreateStruct(RefObject structType, List name) {
        return null;
    }

    public RefStruct refCreateStruct(String structName, List args) {
        return null;
    }

    public void refDelete() {
        for (RefClass claz : this.refAllClasses()) {
            for (RefObject ro : claz.refAllOfClass()) {
                ro.refDelete();
            }
        }
        for (RefPackage pack : this.refAllPackages()) {
            pack.refDelete();
        }
    }

    public RefEnum refGetEnum(RefObject enumType, String args) {
        return null;
    }

    public RefEnum refGetEnum(String enumName, String args) {
        return null;
    }

    public RefPackage refPackage(RefObject nestedPackage) {
        return null;
    }

    public RefPackage refPackage(String nestedPackageName) {
        String name = nestedPackageName.toLowerCase(Locale.ENGLISH);
        RefPackage refPackage = (RefPackage)this.mPackages.get(name);
        if (refPackage == null) {
            throw new InvalidNameException(nestedPackageName);
        }
        return refPackage;
    }

    public void internalError(String string, InvalidCallException ex) {
        System.err.println("internal error " + string);
        ex.printStackTrace();
    }

    public Map getMetaObjects() {
        return this.mMetaObjects;
    }

    public void addClass(String name, RefClass clazz) {
        this.mClasses.put(name, clazz);
        ((AbstractRefBaseObject)clazz).setOwner(this);
    }

    public void removeClass(AbstractRefClass clazz) {
        if (this.mClasses.values().remove(clazz)) {
            clazz.setOwner(null);
        }
    }

    public void addPackage(String name, RefBaseObject pack) {
        this.mPackages.put(name.toLowerCase(Locale.ENGLISH), pack);
        ((AbstractRefBaseObject)pack).setOwner(this);
    }

    public void removePackage(RefBaseObject pack) {
        if (this.mPackages.values().remove(pack)) {
            ((AbstractRefBaseObject)pack).setOwner(null);
        }
    }

    public Collection refAllPackages() {
        return this.mPackages.values();
    }
}

