/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.io_software.jmi.util.Util;
import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.ext.RepositoryUtil;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefFeaturedImpl;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import com.nomagic.uml2.ext.jmi.reflect.ElementRegistry;
import com.nomagic.uml2.ext.jmi.reflect.Expression;
import com.nomagic.uml2.ext.jmi.reflect.ValueSetter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import org.eclipse.emf.ecore.EClass;
import org.omg.mof.model.StructuralFeature;

@OpenApiAll
public abstract class AbstractRefClass
extends AbstractRefFeaturedImpl
implements RefClass {
    public AbstractRefClass(AbstractRepository repository) {
        super(repository);
    }

    public final Collection refAllOfClass() {
        if (this.repository != null) {
            return this.repository.getProject().refAllOfClasses(Collections.singleton(this));
        }
        return Collections.EMPTY_LIST;
    }

    public abstract EClass getEClass();

    public Collection refAllOfType() {
        if (this.repository != null) {
            HashSet<AbstractRefClass> allSubtypes = new HashSet<AbstractRefClass>();
            AbstractRefClass.collectSubtypes(this, allSubtypes);
            return this.repository.getProject().refAllOfClasses(allSubtypes);
        }
        return Collections.EMPTY_LIST;
    }

    private static void collectSubtypes(AbstractRefClass type, Collection<AbstractRefClass> allSubtypes) {
        allSubtypes.add(type);
        Collection subtypes = Util.getSubtypes((RefObject)type.refMetaObject());
        for (RefObject t : subtypes) {
            AbstractRefClass p = (AbstractRefClass)Util.getProxyForMetaObject((RefPackage)type.mof_getRepository(), (RefObject)t);
            AbstractRefClass.collectSubtypes(p, allSubtypes);
        }
    }

    public RefStruct refCreateStruct(RefObject structType, List args) {
        return null;
    }

    public RefStruct refCreateStruct(String structname, List args) {
        return null;
    }

    public RefEnum refGetEnum(RefObject enumType, String args) {
        return null;
    }

    public RefEnum refGetEnum(String enumName, String args) {
        return null;
    }

    protected void checkCreate() {
        this.getRepository().getTransactionModelListener().beforeChange(null, "INSTANCE_CREATED");
    }

    public void commitCreate(RefObject instance) {
        this.getRepository().getEventSupport().firePropertyChange((RefBaseObject)instance, "INSTANCE_CREATED", null, instance);
    }

    public synchronized void addInstance(RefBaseObject instance) {
        ElementRegistry registry;
        if (this.repository != null && (registry = this.repository.getProject()) != null && !RepositoryUtil.isDummyRepository(this.repository)) {
            registry.refAddInstance(instance);
        }
    }

    public synchronized void removeInstance(RefBaseObject instance) {
        ElementRegistry registry;
        if (this.repository != null && (registry = this.repository.getProject()) != null) {
            registry.refRemoveInstance(instance);
        }
    }

    public RefObject refCreateInstance(@CheckForNull List args) {
        throw new RuntimeException("Cannot create abstract class " + this);
    }

    public Collection getDerivedFeatures() {
        return null;
    }

    public Collection<String> getRedefinedFeatures() {
        return Collections.emptyList();
    }

    public abstract Map<String, String> getRedefinedFeaturesMap();

    @Override
    public void setExpression(String featureName, Expression expression) {
        if (this.isClassScopeFeature(featureName)) {
            super.setExpression(featureName, expression);
        }
    }

    @Override
    public void setValueSetter(String featureName, ValueSetter setter) {
        if (this.isClassScopeFeature(featureName)) {
            super.setValueSetter(featureName, setter);
        }
    }

    @Override
    public Expression getExpression(String featureName) {
        if (this.isClassScopeFeature(featureName)) {
            return super.getExpression(featureName);
        }
        return null;
    }

    @Override
    public ValueSetter getValueSetter(String featureName) {
        if (this.isClassScopeFeature(featureName)) {
            return super.getValueSetter(featureName);
        }
        return null;
    }

    private boolean isClassScopeFeature(String featureName) {
        StructuralFeature feature = this.getFeature(featureName);
        return feature != null && AbstractRefClass.isClassScopeFeature(feature);
    }
}

