/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi.reflect;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.ext.jmi.AssociationLink;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefBaseObjectImpl;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.TypeMismatchException;

@OpenApiAll
public abstract class AbstractRefAssociation
extends AbstractRefBaseObjectImpl
implements RefAssociation {
    private final String mRoleName1;
    private final String mReferenceName1;
    private final boolean mNavigable1;
    private final boolean mMultivalued1;
    private final Class mClass1;
    private final String mRoleName2;
    private final String mReferenceName2;
    private final boolean mNavigable2;
    private final Class mClass2;

    public AbstractRefAssociation(AbstractRepository repository, String roleName1, String referenceName1, boolean navigable1, boolean multivalued1, Class class1, String roleName2, String referenceName2, boolean navigable2, boolean multivalued2, Class class2) {
        super(repository);
        this.mRoleName1 = roleName1;
        this.mReferenceName1 = referenceName1;
        this.mNavigable1 = navigable1;
        this.mMultivalued1 = multivalued1;
        this.mClass1 = class1;
        this.mRoleName2 = roleName2;
        this.mReferenceName2 = referenceName2;
        this.mNavigable2 = navigable2;
        this.mClass2 = class2;
    }

    public boolean refAddLink(RefObject endOne, RefObject endTwo) {
        if (this.mClass1.isInstance(endOne) && this.mClass2.isInstance(endTwo)) {
            endOne.refSetValue(this.mRoleName2, (Object)endTwo);
            return true;
        }
        if (this.mClass1.isInstance(endTwo) && this.mClass2.isInstance(endOne)) {
            endOne.refSetValue(this.mRoleName1, (Object)endTwo);
            return true;
        }
        throw new TypeMismatchException(this.mClass1, (Object)this, null);
    }

    public Collection refAllLinks() {
        ArrayList<AssociationLink> result = null;
        RefClass class1 = this.getRefClass(this.mClass1);
        Collection collection = class1.refAllOfType();
        for (RefFeatured el : collection) {
            Object object = el.refGetValue(this.mRoleName2);
            if (object == null) continue;
            if (result == null) {
                result = new ArrayList<AssociationLink>();
            }
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                for (RefFeatured el2 : col) {
                    result.add(new AssociationLink((RefObject)el, (RefObject)el2));
                }
                continue;
            }
            result.add(new AssociationLink((RefObject)el, (RefObject)object));
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private RefClass getRefClass(Class cl1) {
        String packName = cl1.getPackage().getName();
        if (packName.indexOf(46) >= 0) {
            packName = packName.substring(packName.lastIndexOf(46) + 1);
        }
        RefPackage pack = this.repository.refPackage(packName);
        String className = cl1.getName();
        if (className.indexOf(46) >= 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        RefClass class1 = pack.refClass(className);
        return class1;
    }

    public boolean refLinkExists(RefObject endOne, RefObject endTwo) {
        Collection col;
        Object object;
        boolean typeValid = false;
        if (this.mClass1.isInstance(endOne)) {
            object = endOne.refGetValue(this.mRoleName2);
            if (object instanceof Collection && (col = (Collection)object).contains(endTwo)) {
                return true;
            }
            if (endTwo == object) {
                return true;
            }
            typeValid = true;
        }
        if (this.mClass1.isInstance(endTwo)) {
            object = endTwo.refGetValue(this.mRoleName2);
            if (object instanceof Collection && (col = (Collection)object).contains(endOne)) {
                return true;
            }
            if (endOne == object) {
                return true;
            }
            typeValid = true;
        }
        if (!typeValid) {
            throw new TypeMismatchException(this.mClass1, (Object)this, null);
        }
        return false;
    }

    public Collection refQuery(RefObject queryEnd, RefObject queryObject) {
        return this.refQuery((String)queryEnd.refGetValue("name"), queryObject);
    }

    public Collection refQuery(String queryEndName, RefObject queryObject) {
        Object result = queryObject.refGetValue(queryEndName);
        return this.asCollction(result);
    }

    private Collection asCollction(Object result) {
        if (result instanceof Collection) {
            return (Collection)result;
        }
        return Arrays.asList(result);
    }

    public boolean refRemoveLink(RefObject endOne, RefObject endTwo) {
        Collection col;
        Object object;
        boolean typesValid = false;
        if (this.mClass1.isInstance(endOne)) {
            object = endOne.refGetValue(this.mRoleName2);
            if (object instanceof Collection && (col = (Collection)object).contains(endTwo)) {
                return col.remove(endTwo);
            }
            if (endTwo == object) {
                endOne.refSetValue(this.mRoleName2, null);
                return true;
            }
            typesValid = true;
        }
        if (this.mClass1.isInstance(endTwo)) {
            object = endTwo.refGetValue(this.mRoleName2);
            if (object instanceof Collection && (col = (Collection)object).contains(endOne)) {
                return col.remove(endOne);
            }
            if (endOne == object) {
                endTwo.refSetValue(this.mReferenceName2, null);
                return true;
            }
            typesValid = true;
        }
        if (!typesValid) {
            throw new TypeMismatchException(this.mClass1, (Object)this, null);
        }
        return false;
    }
}

