/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.esi.api.EsiObject;
import com.nomagic.esi.api.State;
import com.nomagic.magicdraw.uml.BaseElement;
import com.nomagic.uml2.ext.jmi.ModelPropertyChangeListeners;
import com.nomagic.uml2.ext.jmi.NonMaskedPropertyChangeListener;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRefClass;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import com.nomagic.uml2.ext.jmi.reflect.ClassTypes;
import com.nomagic.uml2.ext.jmi.reflect.RepositoryReflection;
import com.nomagic.uml2.ext.magicdraw.auxiliaryconstructs.mdtemplates.TemplateParameter;
import com.nomagic.uml2.ext.magicdraw.auxiliaryconstructs.mdtemplates.TemplateSignature;
import com.nomagic.uml2.ext.magicdraw.auxiliaryconstructs.mdtemplates.TemplateableElement;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Element;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.NamedElement;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Namespace;
import com.nomagic.uml2.impl.jmi.UML2ModelHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;

@OpenApiAll
class QualifiedNameListener
implements PropertyChangeListener {
    private final ModelPropertyChangeListeners listeners;
    private final Set<NamedElement> elements = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Element> elementWithOwners = Collections.newSetFromMap(new IdentityHashMap());
    private boolean dirty;

    public QualifiedNameListener(ModelPropertyChangeListeners modelPropertyChangeListeners) {
        modelPropertyChangeListeners.addPropertyChangeListener(this, null, "name");
        HashSet<Class> types = new HashSet<Class>();
        AbstractRepository repository = modelPropertyChangeListeners.getRepository();
        for (Class type : ClassTypes.getSubtypes(Element.class, false)) {
            if (!types.add(type)) continue;
            AbstractRefClass metaModelClassProxy = RepositoryReflection.getMetamodelClassProxy(repository, type);
            List<String> featureSubsetsDeep = RepositoryReflection.getFeatureSubsetsDeep("owner", metaModelClassProxy);
            for (String name : featureSubsetsDeep) {
                if (name == null) continue;
                modelPropertyChangeListeners.addPropertyChangeListener(this, null, name);
            }
        }
        this.registerNonMaskedPropertyChangeEventListener(repository);
        this.listeners = modelPropertyChangeListeners;
    }

    private void registerNonMaskedPropertyChangeEventListener(AbstractRepository repository) {
        repository.getEventSupport().getNonMaskedModelListeners().addPropertyChangeListener(new NonMaskedPropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }

            @Override
            public void eventDeliveryStopped() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventDeliveryRestored() {
                Set set = QualifiedNameListener.this.elements;
                synchronized (set) {
                    if (QualifiedNameListener.this.elements.removeIf(el -> el instanceof EsiObject && ((EsiObject)el).esiState() == State.GONE)) {
                        QualifiedNameListener.this.setDirty(true);
                    }
                }
            }
        }, null, "name");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object sourceObject = evt.getSource();
        if ("name".equals(evt.getPropertyName())) {
            Element source = (Element)sourceObject;
            if (this.getElementWithOwners().contains(source)) {
                NamedElement ne = (NamedElement)source;
                String qn = ne.getQualifiedName();
                String old = (String)oldValue;
                String qNameOld = UML2ModelHelper.getQualifiedName(ne, old);
                this.notifyChildren(source, qNameOld, qn);
            }
        } else {
            Object newValue = evt.getNewValue();
            if (newValue instanceof Element || oldValue instanceof Element) {
                Element oldParent = (Element)oldValue;
                Element source = (Element)sourceObject;
                Set<Element> elementWithOwners = this.getElementWithOwners();
                boolean b = elementWithOwners.contains(source);
                if (b) {
                    String name;
                    if (oldParent != null || !elementWithOwners.contains(newValue)) {
                        this.setDirty(true);
                    }
                    String string = name = source instanceof NamedElement ? ((NamedElement)source).getName() : "";
                    String qNameOld = oldParent == null ? null : (oldParent.getOwner() == null ? name : String.valueOf(QualifiedNameListener.getQualifiedName(oldParent)) + "::" + name);
                    this.notifyChildren(source, qNameOld, QualifiedNameListener.getQualifiedName(source));
                }
            }
        }
    }

    @CheckForNull
    private static String getQualifiedName(Element e) {
        if (e instanceof NamedElement) {
            return ((NamedElement)e).getQualifiedName();
        }
        Element p = QualifiedNameListener.findNamedElementParent(e);
        if (p != null) {
            return ((NamedElement)p).getQualifiedName();
        }
        return null;
    }

    @CheckForNull
    private static Element findNamedElementParent(Element e) {
        while (e != null) {
            if (e instanceof NamedElement) {
                return e;
            }
            e = e.getOwner();
        }
        return null;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private Set<Element> getElementWithOwners() {
        if (this.isDirty()) {
            this.updateTree();
        }
        return this.elementWithOwners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChildren(Element source, @CheckForNull String qNameOld, @CheckForNull String qNameNew) {
        ArrayList<NamedElement> list;
        Set<NamedElement> set = this.elements;
        synchronized (set) {
            list = new ArrayList<NamedElement>(this.elements);
        }
        for (NamedElement element : list) {
            String oldName;
            String newName;
            if (element != source && !source.isParentOf((BaseElement)element)) continue;
            if (source == element) {
                newName = qNameNew;
                oldName = qNameOld;
            } else {
                newName = element.getQualifiedName();
                oldName = QualifiedNameListener.getOldQualifiedName(source, qNameOld, qNameNew, element, newName);
            }
            this.listeners.notifyListeners(new PropertyChangeEvent(element, "qualifiedName", oldName, newName));
        }
    }

    @CheckForNull
    private static String getOldQualifiedName(Element source, @CheckForNull String qNameOld, @CheckForNull String qNameNew, NamedElement element, String newName) {
        String oldName;
        if (qNameOld == null) {
            oldName = null;
        } else if (qNameNew != null && newName != null) {
            oldName = qNameNew.length() <= newName.length() ? String.valueOf(qNameOld) + newName.substring(qNameNew.length()) : qNameOld;
        } else {
            ArrayList<String> namesUpToChanged = new ArrayList<String>();
            Namespace namespace = QualifiedNameListener.getNamespaceForQualifiedName(element);
            while (namespace != null && namespace != source) {
                namesUpToChanged.add(namespace.getName());
                namespace = QualifiedNameListener.getNamespaceForQualifiedName(namespace);
            }
            StringBuilder tmp = new StringBuilder(qNameOld);
            for (String name : namesUpToChanged) {
                tmp.append("::");
                tmp.append(name);
            }
            if (tmp.length() > 0) {
                tmp.append("::");
            }
            tmp.append(element.getName());
            oldName = tmp.toString();
        }
        return oldName;
    }

    @CheckForNull
    private static Namespace getNamespaceForQualifiedName(NamedElement element) {
        TemplateableElement template;
        TemplateParameter templateParameter;
        TemplateSignature signature;
        Element owner = element.getOwner();
        if (owner instanceof TemplateParameter && (signature = (templateParameter = (TemplateParameter)owner).getSignature()) != null && (template = signature.getTemplate()) instanceof Namespace) {
            return (Namespace)((Object)template);
        }
        return element.getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NamedElement element) {
        Set<NamedElement> set = this.elements;
        synchronized (set) {
            if (this.elements.add(element)) {
                this.setDirty(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(NamedElement element) {
        Set<NamedElement> set = this.elements;
        synchronized (set) {
            if (this.elements.remove(element)) {
                this.setDirty(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateTree() {
        Set<NamedElement> set = this.elements;
        synchronized (set) {
            this.elementWithOwners.clear();
            for (Element element : this.elements) {
                void var2_3;
                while (var2_3 != null && this.elementWithOwners.add((Element)var2_3)) {
                    Element element2 = var2_3.getOwner();
                }
            }
            this.setDirty(false);
        }
    }
}

