/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi;

import com.nomagic.annotation.OpenApiAll;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@OpenApiAll
public abstract class OptimizedForSingleValueSet<T> {
    private boolean holderArray;
    @CheckForNull
    private Object holder;

    public synchronized boolean add(T object) {
        if (object != null) {
            if (this.holderArray) {
                return this.addToArray(object);
            }
            return this.addSingle(object);
        }
        return false;
    }

    public synchronized boolean remove(T object) {
        if (object != null) {
            if (this.holderArray) {
                return this.removeFromArray(object);
            }
            return this.removeSingle(object);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.holder == null;
    }

    public T[] toArray() {
        if (this.holderArray) {
            return this.holderToArray();
        }
        if (this.holder == null) {
            return this.newArray(0);
        }
        T[] array = this.newArray(1);
        array[0] = this.holder;
        return array;
    }

    private boolean addSingle(T object) {
        if (this.holder != object) {
            if (this.holder == null) {
                this.holder = object;
            } else {
                T[] array = this.newArray(2);
                array[0] = this.holder;
                array[1] = object;
                this.holder = array;
                this.holderArray = true;
            }
            return true;
        }
        return false;
    }

    private boolean addToArray(T object) {
        T[] array;
        T[] TArray = array = this.holderToArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (object == t) {
                return false;
            }
            ++n2;
        }
        T[] newArray = this.newArray(array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = object;
        this.holder = newArray;
        return true;
    }

    protected abstract T[] newArray(int var1);

    private boolean removeSingle(T object) {
        if (this.holder == object) {
            this.holder = null;
            return true;
        }
        return false;
    }

    private boolean removeFromArray(T object) {
        T[] array = this.holderToArray();
        int index = 0;
        while (index < array.length) {
            if (object == array[index]) {
                if (array.length == 2) {
                    this.holder = array[index == 0 ? 1 : 0];
                    this.holderArray = false;
                } else {
                    T[] newArray = this.newArray(array.length - 1);
                    if (index > 0) {
                        System.arraycopy(array, 0, newArray, 0, index);
                    }
                    System.arraycopy(array, index + 1, newArray, index, newArray.length - index);
                    this.holder = newArray;
                }
                return true;
            }
            ++index;
        }
        return false;
    }

    @Nonnull
    private T[] holderToArray() {
        return (Object[])this.holder;
    }
}

