/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.TimeTracker;
import com.nomagic.magicdraw.uml2.util.TimeTrackerFactory;
import com.nomagic.uml2.ext.jmi.Log;
import com.nomagic.uml2.ext.jmi.OptimizedForSingleValueSet;
import com.nomagic.uml2.ext.jmi.QualifiedNameListener;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.NamedElement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;

@OpenApiAll
public class ModelPropertyChangeListeners {
    private static final Logger LOG = Logger.getLogger(ModelPropertyChangeListeners.class);
    private final Object ELEMENTS_LISTENERS_LOCK = new Object();
    private final Map<String, Map<RefObject, ListenerContainer>> listeners = new HashMap<String, Map<RefObject, ListenerContainer>>();
    private final Map<PropertyChangeListener, ListenerContainerSet> listenerContainers = new LinkedHashMap<PropertyChangeListener, ListenerContainerSet>();
    private QualifiedNameListener qualifiedNameListener;
    private final AbstractRepository repository;

    ModelPropertyChangeListeners(AbstractRepository abstractRepository) {
        this.repository = abstractRepository;
    }

    AbstractRepository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(PropertyChangeEvent event) {
        ListenerContainer s = null;
        ListenerContainer s1 = null;
        ListenerContainer s2 = null;
        ListenerContainer s3 = null;
        Object object = this.ELEMENTS_LISTENERS_LOCK;
        synchronized (object) {
            Map<RefObject, ListenerContainer> map = this.listeners.get(null);
            if (map != null) {
                s = map.get(null);
                s1 = map.get(event.getSource());
            }
            if ((map = this.listeners.get(event.getPropertyName())) != null) {
                s2 = map.get(null);
                s3 = map.get(event.getSource());
            }
        }
        if (s != null) {
            ModelPropertyChangeListeners.notifyListeners((PropertyChangeListener[])s.toArray(), event);
        }
        if (s1 != null) {
            ModelPropertyChangeListeners.notifyListeners((PropertyChangeListener[])s1.toArray(), event);
        }
        if (s2 != null) {
            ModelPropertyChangeListeners.notifyListeners((PropertyChangeListener[])s2.toArray(), event);
        }
        if (s3 != null) {
            ModelPropertyChangeListeners.notifyListeners((PropertyChangeListener[])s3.toArray(), event);
        }
    }

    private static void notifyListeners(PropertyChangeListener[] listeners, PropertyChangeEvent event) {
        if (listeners.length > 0) {
            TimeTracker timeTracker = TimeTrackerFactory.create("Event listeners", LOG);
            PropertyChangeListener[] propertyChangeListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener listener = propertyChangeListenerArray[n2];
                try {
                    TimeTracker.TrackedOperation tracker = timeTracker.start(listener);
                    listener.propertyChange(event);
                    tracker.finish();
                }
                catch (RuntimeException ex) {
                    Log.error("exception while delegating property change to:" + listener, ex);
                }
                ++n2;
            }
            timeTracker.dumpLongest(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PropertyChangeListener> getAllListeners() {
        Object object = this.ELEMENTS_LISTENERS_LOCK;
        synchronized (object) {
            return new ArrayList<PropertyChangeListener>(this.listenerContainers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener, @CheckForNull RefObject attachTo, @CheckForNull String propertyName) {
        Object object = this.ELEMENTS_LISTENERS_LOCK;
        synchronized (object) {
            ListenerContainer container;
            Map<RefObject, ListenerContainer> map = this.listeners.get(propertyName);
            if (map == null) {
                map = attachTo == null ? new HashMap() : new WeakHashMap();
                this.listeners.put(propertyName, map);
            }
            if ((container = map.get(attachTo)) == null) {
                container = new ListenerContainer(attachTo, propertyName);
                map.put(attachTo, container);
            }
            container.add(listener);
            this.getListenerContainers(listener).add(container);
        }
        if (attachTo instanceof NamedElement && "qualifiedName".equals(propertyName)) {
            this.getQualifiedNameListener().add((NamedElement)attachTo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerContainerSet getListenerContainers(PropertyChangeListener listener) {
        Object object = this.ELEMENTS_LISTENERS_LOCK;
        synchronized (object) {
            ListenerContainerSet c = this.listenerContainers.get(listener);
            if (c == null) {
                c = new ListenerContainerSet();
                this.listenerContainers.put(listener, c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener, @CheckForNull RefObject removeFrom, @CheckForNull String propertyName) {
        Object object = this.ELEMENTS_LISTENERS_LOCK;
        synchronized (object) {
            ListenerContainer container;
            Map<RefObject, ListenerContainer> map = this.listeners.get(propertyName);
            if (map != null && (container = map.get(removeFrom)) != null && container.remove(listener)) {
                this.removeListenerFromListenerContainer(listener, container);
                if (removeFrom instanceof NamedElement && "qualifiedName".equals(propertyName) && container.isEmpty()) {
                    this.getQualifiedNameListener().remove((NamedElement)removeFrom);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPropertyChangeListeners(RefObject removeFrom) {
        Object object = this.ELEMENTS_LISTENERS_LOCK;
        synchronized (object) {
            for (Map<RefObject, ListenerContainer> map : this.listeners.values()) {
                ListenerContainer container = map.remove(removeFrom);
                if (container == null) continue;
                PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])container.toArray();
                int n = propertyChangeListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyChangeListener listener = propertyChangeListenerArray[n2];
                    this.removeListenerFromListenerContainer(listener, container);
                    ++n2;
                }
            }
        }
        if (removeFrom instanceof NamedElement) {
            this.getQualifiedNameListener().remove((NamedElement)removeFrom);
        }
    }

    private void removeListenerFromListenerContainer(PropertyChangeListener listener, ListenerContainer container) {
        ListenerContainerSet containers = this.getListenerContainers(listener);
        containers.remove(container);
        if (containers.isEmpty()) {
            this.listenerContainers.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PropertyChangeListener listener) {
        Object object = this.ELEMENTS_LISTENERS_LOCK;
        synchronized (object) {
            ListenerContainerSet containers = this.listenerContainers.get(listener);
            if (containers != null) {
                ListenerContainer[] listenerContainerArray = (ListenerContainer[])containers.toArray();
                int n = listenerContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ListenerContainer container = listenerContainerArray[n2];
                    container.remove(listener);
                    if ("qualifiedName".equals(container.getPropertyName()) && container.isEmpty() && container.getElement() instanceof NamedElement) {
                        this.getQualifiedNameListener().remove((NamedElement)container.getElement());
                    }
                    ++n2;
                }
                this.listenerContainers.remove(listener);
            }
        }
    }

    private QualifiedNameListener getQualifiedNameListener() {
        if (this.qualifiedNameListener == null) {
            this.qualifiedNameListener = new QualifiedNameListener(this);
        }
        return this.qualifiedNameListener;
    }

    @OpenApiAll
    public class ListenerContainer
    extends OptimizedForSingleValueSet<PropertyChangeListener> {
        @CheckForNull
        private RefObject element;
        @CheckForNull
        private String propertyName;

        public ListenerContainer(@CheckForNull RefObject element, String propertyName) {
            this.element = element;
            this.propertyName = propertyName;
        }

        protected PropertyChangeListener[] newArray(int length) {
            return new PropertyChangeListener[length];
        }

        @CheckForNull
        public String getPropertyName() {
            return this.propertyName;
        }

        @CheckForNull
        public RefObject getElement() {
            return this.element;
        }

        @Override
        public synchronized boolean remove(PropertyChangeListener listener) {
            boolean b = super.remove(listener);
            if (b && this.isEmpty() && this.element != null) {
                ((Map)ModelPropertyChangeListeners.this.listeners.get(this.propertyName)).remove(this.element);
            }
            return b;
        }
    }

    @OpenApiAll
    public class ListenerContainerSet
    extends OptimizedForSingleValueSet<ListenerContainer> {
        protected ListenerContainer[] newArray(int length) {
            return new ListenerContainer[length];
        }
    }
}

