/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.uml2.ext.jmi;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.TimeTracker;
import com.nomagic.magicdraw.uml2.util.TimeTrackerFactory;
import com.nomagic.uml2.ModelStateTrackerImpl;
import com.nomagic.uml2.ext.jmi.ChangeElementPositionPropertyChangeEvent;
import com.nomagic.uml2.ext.jmi.IndexedPropertyChangeEvent;
import com.nomagic.uml2.ext.jmi.InstanceDeletedEvent;
import com.nomagic.uml2.ext.jmi.Log;
import com.nomagic.uml2.ext.jmi.ModelPropertyChangeListeners;
import com.nomagic.uml2.ext.jmi.ModelStateTracker;
import com.nomagic.uml2.ext.jmi.ModifiedElements;
import com.nomagic.uml2.ext.jmi.NonMaskedEventSupport;
import com.nomagic.uml2.ext.jmi.NonMaskedEventSupportImpl;
import com.nomagic.uml2.ext.jmi.NonMaskedPropertyChangeListener;
import com.nomagic.uml2.ext.jmi.RepositoryChangesRegistry;
import com.nomagic.uml2.ext.jmi.RepositoryListenerRegistry;
import com.nomagic.uml2.ext.jmi.reflect.AbstractRepository;
import com.nomagic.uml2.ext.jmi.reflect.ModelBridge;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Element;
import com.nomagic.uml2.transaction.ModelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

@OpenApiAll
public class EventSupport
implements RepositoryListenerRegistry {
    public static final Logger LOG = Logger.getLogger(EventSupport.class);
    private final ModelPropertyChangeListeners mModelListeners;
    private final NonMaskedEventSupportImpl mNonMaskedEventSupport;
    private boolean mEventDeliveryOn = true;
    private boolean mEnableEventFiring = true;
    private List<PropertyChangeEvent> mEventsToBeFired = new ArrayList<PropertyChangeEvent>();
    private int mLockEventsRequestsCount;
    private List<PropertyChangeEvent> mDispatchLaterEventsCache = new ArrayList<PropertyChangeEvent>(100);
    private final Object CHANGE_REGISTRY_LOCK = new Object();
    private RepositoryChangesRegistry[] mChangesRegistry;
    private List<Runnable> mInvokeAfterTransaction = new ArrayList<Runnable>();
    private final AbstractRepository mAbstractRepository;
    private final Collection<PropertyChangeListener> mRepositoryListeners = new LinkedHashSet<PropertyChangeListener>();
    private NotDeliveredEventsSupport mNotDeliveredEventsSupport;
    private long mEventsCount;
    @CheckForNull
    private ModelStateTracker mModelStateTracker;

    public EventSupport(AbstractRepository abstractRepository) {
        this.mAbstractRepository = abstractRepository;
        this.mModelListeners = new ModelPropertyChangeListeners(abstractRepository);
        this.mNonMaskedEventSupport = new NonMaskedEventSupportImpl(new ModelPropertyChangeListeners(abstractRepository));
    }

    public void startLogEvents() {
        ++this.mLockEventsRequestsCount;
    }

    public void stopLogEvents() {
        --this.mLockEventsRequestsCount;
        if (this.mLockEventsRequestsCount == 0) {
            PropertyChangeEvent[] cloned = this.mDispatchLaterEventsCache.toArray(new PropertyChangeEvent[this.mDispatchLaterEventsCache.size()]);
            this.mEventsToBeFired.addAll(this.mDispatchLaterEventsCache);
            this.mDispatchLaterEventsCache.clear();
            int i = 0;
            while (i < cloned.length) {
                PropertyChangeEvent info = cloned[i];
                this.firePropertyChange(info);
                this.mEventsToBeFired.remove(info);
                ++i;
            }
            while (this.mInvokeAfterTransaction.size() > 0) {
                Runnable r = this.mInvokeAfterTransaction.get(0);
                this.mInvokeAfterTransaction.remove(0);
                r.run();
            }
        }
    }

    public void firePropertyChange(RefBaseObject source, String propertyName, @CheckForNull Object oldValue, @CheckForNull Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.firePropertyChange(source, propertyName, oldValue, newValue, -1);
    }

    public void fireInstanceDeletedEvent(RefBaseObject source, Object deleted, @CheckForNull Object oldDirectContainer) {
        this.registerChange(source, "INSTANCE_DELETED", deleted, null, -1, -1);
        InstanceDeletedEvent evt = new InstanceDeletedEvent(source, deleted, oldDirectContainer);
        this.firePropertyChange(evt);
    }

    public void firePropertyChange(RefBaseObject source, String propertyName, @CheckForNull Object oldValue, @CheckForNull Object newValue, int index) {
        this.firePropertyChange(source, propertyName, oldValue, newValue, index, -1);
    }

    public void firePropertyChange(RefBaseObject source, String propertyName, Object oldValue, Object newValue, int index, List oldList) {
        this.firePropertyChange(source, propertyName, oldValue, newValue, index, -1, oldList);
    }

    public void firePropertyChange(RefBaseObject source, String propertyName, @CheckForNull Object oldValue, @CheckForNull Object newValue, int index, int newIndex) {
        this.firePropertyChange(source, propertyName, oldValue, newValue, index, newIndex, null);
    }

    public void firePropertyChange(RefBaseObject source, String propertyName, @CheckForNull Object oldValue, @CheckForNull Object newValue, int index, int newIndex, @CheckForNull List oldList) {
        this.registerChange(source, propertyName, oldValue, newValue, index, newIndex);
        PropertyChangeEvent evt = EventSupport.createPropertyChangeEvent(source, propertyName, oldValue, newValue, index, newIndex, oldList);
        this.firePropertyChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChange(RefBaseObject source, String propertyName, @CheckForNull Object oldValue, @CheckForNull Object newValue, int index, int newIndex) {
        ++this.mEventsCount;
        Object object = this.CHANGE_REGISTRY_LOCK;
        synchronized (object) {
            if (this.mChangesRegistry != null) {
                int i = 0;
                while (i < this.mChangesRegistry.length) {
                    this.mChangesRegistry[i].registerChange(source, propertyName, oldValue, newValue, index, newIndex);
                    ++i;
                }
            }
        }
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        if (this.mLockEventsRequestsCount > 0) {
            int i = this.mEventsToBeFired.size() - 1;
            while (i >= 0) {
                PropertyChangeEvent ei = this.mEventsToBeFired.get(i);
                if (ei.getSource() == evt.getSource() && ei.getPropertyName().equals(evt.getPropertyName())) {
                    String message = "Concurrent model change for :" + evt.getSource() + " property: " + evt.getPropertyName() + " please execute your code using: project.getRepository().invokeAfterTransaction(runnable); ";
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException(message);
                    if (ModelBridge.getBridge().isDeveloper()) {
                        throw concurrentModificationException;
                    }
                    LOG.error((Object)message, (Throwable)concurrentModificationException);
                }
                --i;
            }
            this.mDispatchLaterEventsCache.add(evt);
        } else {
            if (this.mModelStateTracker != null) {
                this.mModelStateTracker.trackEvent(evt);
            }
            if (this.mEventDeliveryOn) {
                ModelListener transactionModelListener;
                this.mNonMaskedEventSupport.notifyListeners(evt);
                if (this.isEnableEventFiring()) {
                    this.mModelListeners.notifyListeners(evt);
                }
                if ((transactionModelListener = this.mAbstractRepository.getTransactionModelListener()) != null) {
                    transactionModelListener.modelChanged(evt);
                }
            } else {
                this.mNotDeliveredEventsSupport.modelChanged(evt);
            }
        }
    }

    private static PropertyChangeEvent createPropertyChangeEvent(RefBaseObject source, String propertyName, @CheckForNull Object oldValue, @CheckForNull Object newValue, int index, int newIndex, @CheckForNull List oldList) {
        if (index >= 0) {
            if (newIndex >= 0) {
                return new ChangeElementPositionPropertyChangeEvent(source, propertyName, oldValue, newValue, index, newIndex, oldList);
            }
            return new IndexedPropertyChangeEvent(source, propertyName, oldValue, newValue, index, oldList);
        }
        return new PropertyChangeEvent(source, propertyName, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener, @CheckForNull RefObject attachTo) {
        this.addPropertyChangeListener(listener, attachTo, (String)null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener, String propertyName) {
        this.addPropertyChangeListener(listener, null, propertyName);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener, @CheckForNull RefObject attachTo, List propertyNames) {
        int i = 0;
        while (i < propertyNames.size()) {
            this.addPropertyChangeListener(listener, attachTo, (String)propertyNames.get(i));
            ++i;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener, @CheckForNull RefObject attachTo, @CheckForNull String propertyName) {
        this.mModelListeners.addPropertyChangeListener(listener, attachTo, propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener, @CheckForNull RefObject removeFrom) {
        this.removePropertyChangeListener(listener, removeFrom, (String)null);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener, RefObject removeFrom, List propertyNames) {
        int i = 0;
        while (i < propertyNames.size()) {
            String propertyName = (String)propertyNames.get(i);
            this.removePropertyChangeListener(listener, removeFrom, propertyName);
            ++i;
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener, @CheckForNull String propertyName) {
        this.mModelListeners.removePropertyChangeListener(listener, null, propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener, @CheckForNull RefObject removeFrom, @CheckForNull String propertyName) {
        this.mModelListeners.removePropertyChangeListener(listener, removeFrom, propertyName);
    }

    public boolean isEnableEventFiring() {
        return this.mEnableEventFiring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoryListener(PropertyChangeListener listener) {
        Collection<PropertyChangeListener> collection = this.mRepositoryListeners;
        synchronized (collection) {
            if (!this.mRepositoryListeners.contains(listener)) {
                this.mRepositoryListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryListener(PropertyChangeListener listener) {
        Collection<PropertyChangeListener> collection = this.mRepositoryListeners;
        synchronized (collection) {
            this.mRepositoryListeners.remove(listener);
        }
    }

    public void setEnableEventFiring(boolean enableEventFiring) {
        if (this.mEnableEventFiring != enableEventFiring) {
            boolean willEventsBeFired;
            boolean areEventsFired = this.mEventDeliveryOn && this.mEnableEventFiring;
            boolean bl = willEventsBeFired = this.mEventDeliveryOn && enableEventFiring;
            if (areEventsFired != willEventsBeFired) {
                this.fireChangedEventFiring(willEventsBeFired);
            }
            this.mEnableEventFiring = enableEventFiring;
            Log.info(String.valueOf(enableEventFiring ? "Enabled" : "Disabled") + " event firing");
            if (enableEventFiring && !this.mEventDeliveryOn) {
                Log.error("Event firing enabled whereas event delivery is disabled");
            }
        }
    }

    private void fireChangedEventFiring(boolean enabled) {
        PropertyChangeEvent propertyChangeEvent;
        if (enabled) {
            propertyChangeEvent = new EventFireStartEvent(this.mAbstractRepository, this.mModelStateTracker);
            this.mModelStateTracker = null;
        } else {
            this.mModelStateTracker = new ModelStateTrackerImpl();
            propertyChangeEvent = new PropertyChangeEvent(this.mAbstractRepository, "EVENT_FIRE_STOP", Boolean.TRUE, Boolean.FALSE);
        }
        TimeTracker timeTracker = TimeTrackerFactory.create("Firing " + propertyChangeEvent.getPropertyName(), LOG);
        for (PropertyChangeListener pl : this.getRepositoryListeners()) {
            TimeTracker.TrackedOperation operation = timeTracker.start(pl);
            try {
                try {
                    pl.propertyChange(propertyChangeEvent);
                }
                catch (Throwable e) {
                    Log.error("exception on listener", e);
                    operation.finish();
                    continue;
                }
            }
            catch (Throwable throwable) {
                operation.finish();
                throw throwable;
            }
            operation.finish();
        }
        timeTracker.dumpLongest(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<PropertyChangeListener> getRepositoryListeners() {
        Collection<PropertyChangeListener> collection = this.mRepositoryListeners;
        synchronized (collection) {
            return new ArrayList<PropertyChangeListener>(this.mRepositoryListeners);
        }
    }

    private boolean willChangeEventFiring(boolean eventDeliveryOn) {
        boolean areEventsFired = this.mEventDeliveryOn && this.mEnableEventFiring;
        boolean willEventsBeFired = eventDeliveryOn && this.mEnableEventFiring;
        return areEventsFired ^ willEventsBeFired;
    }

    public void stopEventDelivery() {
        if (this.mEventDeliveryOn) {
            if (this.willChangeEventFiring(false)) {
                this.fireChangedEventFiring(false);
            }
            for (NonMaskedPropertyChangeListener listener : this.mNonMaskedEventSupport.getAllListeners()) {
                try {
                    listener.eventDeliveryStopped();
                }
                catch (RuntimeException e) {
                    Log.error("Exception in NonMaskedPropertyChangeListener.eventDeliveryStopped()", e);
                }
            }
            ModelListener transactionModelListener = this.mAbstractRepository.getTransactionModelListener();
            if (transactionModelListener != null) {
                try {
                    transactionModelListener.eventDeliveryStopped();
                }
                catch (RuntimeException e) {
                    Log.error("Exception in ModelListener.eventDeliveryStopped()", e);
                }
            }
            this.mNotDeliveredEventsSupport = new NotDeliveredEventsSupport();
            this.mEventDeliveryOn = false;
            Log.info("Stopped event delivery");
        }
    }

    public void restoreEventDelivery(ModifiedElements modifiedElements) {
        if (!this.mEventDeliveryOn) {
            if (this.willChangeEventFiring(false)) {
                this.fireChangedEventFiring(false);
            }
            for (NonMaskedPropertyChangeListener listener : this.mNonMaskedEventSupport.getAllListeners()) {
                try {
                    listener.eventDeliveryRestored();
                }
                catch (RuntimeException e) {
                    Log.error("Exception in NonMaskedPropertyChangeListener.eventDeliveryRestored()", e);
                }
            }
            ModelListener transactionModelListener = this.mAbstractRepository.getTransactionModelListener();
            if (transactionModelListener != null) {
                try {
                    this.notifyAboutRestoredDelivery(modifiedElements, transactionModelListener);
                    this.mNotDeliveredEventsSupport = null;
                }
                catch (RuntimeException e) {
                    Log.error("Exception in ModelListener.eventDeliveryRestored()", e);
                }
            }
            this.mEventDeliveryOn = true;
            Log.info("Restored event delivery");
        }
    }

    private void notifyAboutRestoredDelivery(ModifiedElements modifiedElements, ModelListener transactionModelListener) {
        while (true) {
            transactionModelListener.eventDeliveryRestored(modifiedElements, this.getNotDeliveredEvents());
            List<PropertyChangeEvent> notDeliveredEvents = this.getNotDeliveredEvents();
            if (notDeliveredEvents.isEmpty()) break;
            modifiedElements = EventSupport.getModifiedElementsFromNotDeliveredEvents(notDeliveredEvents, modifiedElements);
        }
    }

    private static ModifiedElements getModifiedElementsFromNotDeliveredEvents(final List<PropertyChangeEvent> notDeliveredEvents, final ModifiedElements modifiedElements) {
        return new ModifiedElements(){

            @Override
            public Collection<EObject> getModified() {
                HashSet<EObject> ret = new HashSet<EObject>(modifiedElements.getModified());
                for (PropertyChangeEvent notDeliveredEvent : notDeliveredEvents) {
                    Object source = notDeliveredEvent.getSource();
                    if (!(source instanceof Element)) continue;
                    ret.add((EObject)((Element)source));
                }
                return ret;
            }
        };
    }

    private List<PropertyChangeEvent> getNotDeliveredEvents() {
        List<PropertyChangeEvent> propertyChangeEvents;
        if (this.mNotDeliveredEventsSupport != null) {
            propertyChangeEvents = this.mNotDeliveredEventsSupport.getPropertyChangeEvents();
            this.mNotDeliveredEventsSupport = new NotDeliveredEventsSupport();
        } else {
            propertyChangeEvents = Collections.emptyList();
        }
        return propertyChangeEvents;
    }

    @Override
    public void removeAllPropertyChangeListeners(RefObject removeFrom) {
        this.mModelListeners.removeAllPropertyChangeListeners(removeFrom);
    }

    @Override
    public void removeListener(PropertyChangeListener listener) {
        this.mModelListeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addChangesRegistry(RepositoryChangesRegistry changesRegistry) {
        Object object = this.CHANGE_REGISTRY_LOCK;
        synchronized (object) {
            boolean alreadyAdded = false;
            if (this.mChangesRegistry == null) {
                this.mChangesRegistry = new RepositoryChangesRegistry[1];
            } else {
                int i = 0;
                while (i < this.mChangesRegistry.length && !alreadyAdded) {
                    alreadyAdded = this.mChangesRegistry[i] == changesRegistry;
                    ++i;
                }
                if (!alreadyAdded) {
                    RepositoryChangesRegistry[] tmp = this.mChangesRegistry;
                    this.mChangesRegistry = new RepositoryChangesRegistry[this.mChangesRegistry.length + 1];
                    System.arraycopy(tmp, 0, this.mChangesRegistry, 0, tmp.length);
                }
            }
            if (!alreadyAdded) {
                this.mChangesRegistry[this.mChangesRegistry.length - 1] = changesRegistry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeChangeRegistry(RepositoryChangesRegistry changesRegistry) {
        Object object = this.CHANGE_REGISTRY_LOCK;
        synchronized (object) {
            int index = -1;
            if (this.mChangesRegistry != null) {
                int i = 0;
                while (i < this.mChangesRegistry.length && index == -1) {
                    if (this.mChangesRegistry[i] == changesRegistry) {
                        index = i;
                    }
                    ++i;
                }
            }
            if (index != -1) {
                RepositoryChangesRegistry[] tmp = this.mChangesRegistry;
                this.mChangesRegistry = new RepositoryChangesRegistry[this.mChangesRegistry.length - 1];
                int i = 0;
                int j = 0;
                while (i < tmp.length && j < this.mChangesRegistry.length) {
                    if (i != index) {
                        this.mChangesRegistry[j] = tmp[i];
                    } else {
                        --j;
                    }
                    ++i;
                    ++j;
                }
            }
        }
    }

    public void invokeAfterTransaction(Runnable r) {
        if (this.mEventsToBeFired.size() > 0) {
            this.mInvokeAfterTransaction.add(r);
        } else {
            r.run();
        }
    }

    public long getEventsCount() {
        return this.mEventsCount;
    }

    public NonMaskedEventSupport getNonMaskedModelListeners() {
        return this.mNonMaskedEventSupport;
    }

    public static boolean isModelCleanAfterEventsStopped(PropertyChangeEvent event) {
        if (event instanceof EventFireStartEvent) {
            EventFireStartEvent eventFireStartEvent = (EventFireStartEvent)event;
            return eventFireStartEvent.isClean();
        }
        return false;
    }

    @OpenApiAll
    private static class EventFireStartEvent
    extends PropertyChangeEvent {
        @CheckForNull
        private final ModelStateTracker mModelStateTracker;

        EventFireStartEvent(Object mRepository, @CheckForNull ModelStateTracker modelStateTracker) {
            super(mRepository, "EVENT_FIRE_STARTED", Boolean.FALSE, Boolean.TRUE);
            this.mModelStateTracker = modelStateTracker;
        }

        boolean isClean() {
            return this.mModelStateTracker != null && this.mModelStateTracker.modelStateClean();
        }
    }

    @OpenApiAll
    static class NotDeliveredEventsSupport {
        private ArrayList<PropertyChangeEvent> mPropertyChangeEvents = new ArrayList();

        NotDeliveredEventsSupport() {
        }

        public void modelChanged(PropertyChangeEvent evt) {
            this.mPropertyChangeEvents.add(evt);
        }

        public ArrayList<PropertyChangeEvent> getPropertyChangeEvents() {
            return this.mPropertyChangeEvents;
        }
    }
}

