/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.UML2ModelUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

@OpenApiAll
public class UMLCopier
extends EcoreUtil.Copier {
    public UMLCopier() {
    }

    public UMLCopier(boolean resolveProxies) {
        super(resolveProxies);
    }

    public UMLCopier(boolean resolveProxies, boolean useOriginalReferences) {
        super(resolveProxies, useOriginalReferences);
    }

    public EObject copy(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EObject copyEObject = this.createCopy(eObject);
        this.put(eObject, copyEObject);
        EClass eClass = eObject.eClass();
        EList attributes = eClass.getEAllAttributes();
        for (EAttribute attribute : attributes) {
            if (!attribute.isChangeable() || attribute.isDerived()) continue;
            this.copyAttribute(attribute, eObject, copyEObject);
        }
        List<EReference> sortedReferences = UML2ModelUtil.getSortedReferences(eClass);
        for (EReference reference : sortedReferences) {
            if (!reference.isChangeable() || reference.isDerived() || !reference.isContainment()) continue;
            this.copyContainment(reference, eObject, copyEObject);
        }
        this.copyProxyURI(eObject, copyEObject);
        return copyEObject;
    }

    public void copyReferences() {
        for (Map.Entry entry : this.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            EClass eClass = eObject.eClass();
            List<EStructuralFeature> features = UML2ModelUtil.getSortedFeatures(eClass);
            for (EStructuralFeature eStructuralFeature : features) {
                if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) continue;
                if (eStructuralFeature instanceof EReference) {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment() || eReference.isContainer()) continue;
                    this.copyReference(eReference, eObject, copyEObject);
                    continue;
                }
                if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) continue;
                FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
                FeatureMap copyFeatureMap = (FeatureMap)copyEObject.eGet(this.getTarget(eStructuralFeature));
                int copyFeatureMapSize = copyFeatureMap.size();
                int k = 0;
                int featureMapSize = featureMap.size();
                while (k < featureMapSize) {
                    block8: {
                        block9: {
                            Object copyReferencedEObject;
                            EStructuralFeature feature;
                            block10: {
                                feature = featureMap.getEStructuralFeature(k);
                                if (!(feature instanceof EReference)) break block9;
                                Object referencedEObject = featureMap.getValue(k);
                                copyReferencedEObject = this.get(referencedEObject);
                                if (copyReferencedEObject != null || referencedEObject == null) break block10;
                                EReference reference = (EReference)feature;
                                if (!this.useOriginalReferences || reference.isContainment() || reference.getEOpposite() != null) break block8;
                                copyReferencedEObject = referencedEObject;
                            }
                            if (!copyFeatureMap.add(feature, copyReferencedEObject)) {
                                int l = 0;
                                while (l < copyFeatureMapSize) {
                                    if (copyFeatureMap.getEStructuralFeature(l) == feature && copyFeatureMap.getValue(l) == copyReferencedEObject) {
                                        copyFeatureMap.move(copyFeatureMap.size() - 1, l);
                                        --copyFeatureMapSize;
                                        break block8;
                                    }
                                    ++l;
                                }
                            }
                            break block8;
                        }
                        copyFeatureMap.add((Object)((FeatureMap.Entry)featureMap.get(k)));
                    }
                    ++k;
                }
            }
        }
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (!UML2ModelUtil.isRedefinition((EStructuralFeature)eReference)) {
            super.copyContainment(eReference, eObject, copyEObject);
        }
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            if (eReference.isMany()) {
                InternalEList source = (InternalEList)eObject.eGet((EStructuralFeature)eReference);
                InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    EReference eOpposite = eReference.getEOpposite();
                    boolean isBidirectional = eOpposite != null;
                    IndexTracker indexTracker = null;
                    if (isBidirectional) {
                        indexTracker = new IndexTracker((InternalEList<EObject>)target);
                    }
                    int index = 0;
                    Iterator k = this.resolveProxies ? source.iterator() : source.basicIterator();
                    while (k.hasNext()) {
                        EObject referencedEObject = (EObject)k.next();
                        EObject copyReferencedEObject = (EObject)this.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (!this.useOriginalReferences || isBidirectional) continue;
                            target.addUnique(index, (Object)referencedEObject);
                            ++index;
                            continue;
                        }
                        if (isBidirectional) {
                            this.addToTargetWhenBidirectional(copyEObject, (InternalEList<EObject>)target, eOpposite, index, copyReferencedEObject, indexTracker);
                        } else {
                            target.addUnique(index, (Object)copyReferencedEObject);
                        }
                        ++index;
                    }
                }
            } else {
                Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
                if (referencedEObject == null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
                } else {
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject == null) {
                        if (this.useOriginalReferences) {
                            copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), referencedEObject);
                        }
                    } else {
                        copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                    }
                }
            }
        }
    }

    private void addToTargetWhenBidirectional(EObject copyEObject, InternalEList<EObject> targetList, EReference eOpposite, int index, EObject copyReferencedEObject, IndexTracker indexTracker) {
        Boolean add = this.addOrMoveOrNone(copyEObject, targetList, eOpposite, index, copyReferencedEObject);
        if (Boolean.TRUE == add) {
            targetList.addUnique(index, (Object)copyReferencedEObject);
            indexTracker.refreshOnAdd(targetList, index, copyReferencedEObject);
        } else if (Boolean.FALSE == add) {
            int oldIndex = indexTracker.getIndex(copyReferencedEObject);
            targetList.move(index, oldIndex);
            indexTracker.refreshOnMove(targetList, index, oldIndex, copyReferencedEObject);
        }
    }

    private Boolean addOrMoveOrNone(EObject copyEObject, InternalEList<EObject> targetList, EReference eOpposite, int index, EObject copyReferencedEObject) {
        Object oppositeValue = copyReferencedEObject.eGet((EStructuralFeature)eOpposite);
        if (!eOpposite.isMany()) {
            if (oppositeValue != copyEObject) {
                return Boolean.TRUE;
            }
            if (targetList.get(index) != copyReferencedEObject) {
                return Boolean.FALSE;
            }
        } else {
            int targetSize = targetList.size();
            Collection oppositeCollection = (Collection)oppositeValue;
            int oppositeSize = oppositeCollection.size();
            if (oppositeSize <= targetSize && !oppositeCollection.contains(copyEObject)) {
                return Boolean.TRUE;
            }
            if (oppositeSize > targetSize && !targetList.contains((Object)copyReferencedEObject)) {
                return Boolean.TRUE;
            }
            if (index >= targetSize) {
                return Boolean.TRUE;
            }
            if (targetList.get(index) != copyReferencedEObject) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @OpenApiAll
    private static class IndexTracker {
        final Map<EObject, Integer> targetObjIndexMap;

        public IndexTracker(InternalEList<EObject> target) {
            int size = target.size();
            this.targetObjIndexMap = new IdentityHashMap<EObject, Integer>(size);
            int i = 0;
            while (i < size) {
                this.targetObjIndexMap.put((EObject)target.get(i), i);
                ++i;
            }
        }

        public int getIndex(EObject obj) {
            return this.targetObjIndexMap.get(obj);
        }

        private void putIndex(EObject obj, Integer index) {
            this.targetObjIndexMap.put(obj, index);
        }

        public void refreshOnAdd(InternalEList<EObject> targetList, int index, EObject copyReferencedEObject) {
            int start = index + 1;
            int end = targetList.size() - 1;
            this.putIndex(copyReferencedEObject, index);
            this.doRefresh(targetList, start, end);
        }

        public void refreshOnMove(InternalEList<EObject> targetList, int index, int oldIndex, EObject copyReferencedEObject) {
            if (Math.abs(index - oldIndex) < 100) {
                int end;
                int start;
                if (oldIndex < index) {
                    start = oldIndex;
                    end = index - 1;
                } else {
                    start = index + 1;
                    end = oldIndex;
                }
                this.doRefresh(targetList, start, end);
            } else {
                int movedIndex = index + (oldIndex < index ? -1 : 1);
                EObject movedReferencedEObject = (EObject)targetList.get(movedIndex);
                targetList.move(oldIndex, movedIndex);
                this.putIndex(movedReferencedEObject, oldIndex);
            }
            this.putIndex(copyReferencedEObject, index);
        }

        private void doRefresh(InternalEList<EObject> targetList, int start, int end) {
            int i = start;
            while (i <= end) {
                EObject key = (EObject)targetList.get(i);
                this.targetObjIndexMap.put(key, i);
                ++i;
            }
        }
    }
}

