/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.CompatibilityUtil;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Element;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.Property;
import com.nomagic.uml2.ext.magicdraw.metadata.UMLPackage;
import com.nomagic.uml2.impl.jmi.UML2ModelHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

@OpenApiAll
public class UML2ModelUtil {
    public static final String ANNOTATION_SOURCE__UNION = "union";
    public static final String ANNOTATION_SOURCE__SUBSETS = "subsets";
    public static final String ANNOTATION_SOURCE_REDEFINES = "redefines";
    public static final String ANNOTATION_SOURCE__MD_TRANSIENT = "mdTransient";
    public static final String ANNOTATION_SOURCE__MOF = "MOF";
    public static final String ANNOTATION_SOURCE__RENAMED = "renamed";
    public static final String ANNOTATION_SOURCE__MD_CONTAINMENT = "mdContainment";
    private static final Map<EClass, List<EReference>> SORTED_REFERENCES = new IdentityHashMap<EClass, List<EReference>>();
    private static final Map<EClass, Map<EStructuralFeature, EStructuralFeature>> REDEFINITION_CACHE = new IdentityHashMap<EClass, Map<EStructuralFeature, EStructuralFeature>>();
    private static final Map<EClass, List<EStructuralFeature>> SORTED_FEATURES = new IdentityHashMap<EClass, List<EStructuralFeature>>();
    private static final Map<EClass, Map<EStructuralFeature, Boolean>> SUPERSET_CACHE = new IdentityHashMap<EClass, Map<EStructuralFeature, Boolean>>();
    private static Map<EClass, Map<EStructuralFeature, Boolean>> REDEFINES_CACHE = new IdentityHashMap<EClass, Map<EStructuralFeature, Boolean>>();
    private static boolean checkCompatibility = true;
    private static Collection<EStructuralFeature> MD_SINGLE_VALUE = null;

    public static boolean isCheckCompatibility() {
        return checkCompatibility;
    }

    public static void setCheckCompatibility(boolean checkCompatibility) {
        UML2ModelUtil.checkCompatibility = checkCompatibility;
    }

    private static Collection<EStructuralFeature> getMdSingleValueFeatures() {
        if (MD_SINGLE_VALUE == null) {
            IdentityHashMap map = new IdentityHashMap();
            MD_SINGLE_VALUE = Collections.newSetFromMap(map);
            MD_SINGLE_VALUE.addAll(Arrays.asList(UMLPackage.eINSTANCE.getDependency_Client(), UMLPackage.eINSTANCE.getDependency_Supplier(), UMLPackage.eINSTANCE.getDirectedRelationship_Source(), UMLPackage.eINSTANCE.getDirectedRelationship_Target(), UMLPackage.eINSTANCE.getDeployment_DeployedArtifact(), UMLPackage.eINSTANCE.getComponentRealization_RealizingClassifier(), UMLPackage.eINSTANCE.getInformationFlow_InformationTarget(), UMLPackage.eINSTANCE.getInformationFlow_InformationSource()));
        }
        return MD_SINGLE_VALUE;
    }

    private UML2ModelUtil() {
    }

    public static boolean isDerivedUnion(EStructuralFeature feature) {
        return feature.isDerived() && feature.getEAnnotation(ANNOTATION_SOURCE__UNION) != null;
    }

    public static boolean isSubsets(EReference reference) {
        return reference.getEAnnotation(ANNOTATION_SOURCE__SUBSETS) != null;
    }

    public static List<EStructuralFeature> getSubsettedFeatures(EStructuralFeature eStructuralFeature) {
        return UML2ModelUtil.getSubsettedFeatures(eStructuralFeature, false);
    }

    public static List<EStructuralFeature> getSubsettedFeatures(EStructuralFeature eStructuralFeature, boolean recursive) {
        UniqueEList.FastCompare subsettedFeatures = new UniqueEList.FastCompare();
        EAnnotation subsetsAnnotation = eStructuralFeature.getEAnnotation(ANNOTATION_SOURCE__SUBSETS);
        if (subsetsAnnotation != null) {
            for (EObject reference : subsetsAnnotation.getReferences()) {
                EStructuralFeature subsettedFeature = (EStructuralFeature)reference;
                subsettedFeatures.add(subsettedFeature);
                if (!recursive) continue;
                subsettedFeatures.addAll(UML2ModelUtil.getSubsettedFeatures(subsettedFeature, recursive));
            }
        }
        return subsettedFeatures;
    }

    public static List<EStructuralFeature> getSubsetFeatures(EClass eClass, EStructuralFeature supersetFeature, boolean includeDerived, boolean includeMany) {
        LinkedHashMap<String, EStructuralFeature> subsetFeatures = new LinkedHashMap<String, EStructuralFeature>();
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!UML2ModelUtil.getSubsettedFeatures(feature).contains(supersetFeature) || !includeDerived && feature.isDerived() || !includeMany && feature.isMany()) continue;
            subsetFeatures.put(feature.getName(), feature);
        }
        return new ArrayList<EStructuralFeature>(subsetFeatures.values());
    }

    public static boolean isSuperset(EClass eClass, EStructuralFeature eStructuralFeature) {
        Boolean value;
        Map<EStructuralFeature, Boolean> map = SUPERSET_CACHE.get(eClass);
        if (map == null) {
            map = new IdentityHashMap<EStructuralFeature, Boolean>();
            SUPERSET_CACHE.put(eClass, map);
        }
        if ((value = map.get(eStructuralFeature)) == null) {
            value = UML2ModelUtil.isSupersetInternal(eClass, eStructuralFeature);
            map.put(eStructuralFeature, value);
        }
        return value;
    }

    private static boolean isSupersetInternal(EClass eClass, EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature.isDerived()) {
            return false;
        }
        EList eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : eAllStructuralFeatures) {
            if (!UML2ModelUtil.getSubsettedFeatures(feature).contains(eStructuralFeature)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRedefinition(EStructuralFeature feature) {
        return feature.getEAnnotation(ANNOTATION_SOURCE_REDEFINES) != null;
    }

    public static boolean isMDTransient(EStructuralFeature feature) {
        return feature.getEAnnotation(ANNOTATION_SOURCE__MD_TRANSIENT) != null;
    }

    public static boolean isTransient(EStructuralFeature feature) {
        return feature.isTransient() || UML2ModelUtil.isMDTransient(feature);
    }

    @CheckForNull
    public static String getMOFPackageName(EClassifier classifier) {
        if (classifier == null) {
            throw new IllegalArgumentException("The classifier parameter can't be null.");
        }
        EAnnotation annotation = classifier.getEAnnotation(ANNOTATION_SOURCE__MOF);
        if (annotation == null) {
            return null;
        }
        EMap details = annotation.getDetails();
        return (String)details.get((Object)"package");
    }

    @CheckForNull
    public static List<String> getQualifiedMOFPackageName(EClassifier classifier) {
        String mofPackageName = UML2ModelUtil.getMOFPackageName(classifier);
        if (mofPackageName == null) {
            return null;
        }
        String[] parts = mofPackageName.split("\\.");
        return Arrays.asList(parts);
    }

    public static void collectEAllClasses(EPackage root, Collection<EClass> result) {
        EList classifiers = root.getEClassifiers();
        for (EClassifier classifier : classifiers) {
            if (!(classifier instanceof EClass)) continue;
            result.add((EClass)classifier);
        }
        for (EPackage aPackage : root.getESubpackages()) {
            UML2ModelUtil.collectEAllClasses(aPackage, result);
        }
    }

    public static List<EStructuralFeature> getRedefinedFeatures(EStructuralFeature feature) {
        EList references;
        EAnnotation eAnnotation = feature.getEAnnotation(ANNOTATION_SOURCE_REDEFINES);
        if (eAnnotation != null && !(references = eAnnotation.getReferences()).isEmpty()) {
            ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>(references.size());
            for (EObject reference : references) {
                if (!(reference instanceof EStructuralFeature)) continue;
                result.add((EStructuralFeature)reference);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @CheckForNull
    public static EStructuralFeature getRedefinition(EClass eContainingClass, EStructuralFeature feature) {
        Map map = REDEFINITION_CACHE.computeIfAbsent(eContainingClass, k -> new IdentityHashMap());
        if (!map.containsKey(feature)) {
            EStructuralFeature redefinitionCalculate = UML2ModelUtil.getRedefinitionCalculate(eContainingClass, feature);
            map.put(feature, redefinitionCalculate);
            return redefinitionCalculate;
        }
        return (EStructuralFeature)map.get(feature);
    }

    @CheckForNull
    private static EStructuralFeature getRedefinitionCalculate(EClass eContainingClass, EStructuralFeature feature) {
        EList eAllStructuralFeatures = eContainingClass.getEAllStructuralFeatures();
        ArrayList<EStructuralFeature> path = new ArrayList<EStructuralFeature>(3);
        ArrayList<EStructuralFeature> forAnalysis = new ArrayList<EStructuralFeature>(3);
        int i = eAllStructuralFeatures.size() - 1;
        while (i >= 0) {
            EStructuralFeature structuralFeature = (EStructuralFeature)eAllStructuralFeatures.get(i);
            path.clear();
            forAnalysis.clear();
            forAnalysis.add(structuralFeature);
            while (!forAnalysis.isEmpty()) {
                EStructuralFeature current = (EStructuralFeature)forAnalysis.remove(0);
                path.add(current);
                EAnnotation redefines = current.getEAnnotation(ANNOTATION_SOURCE_REDEFINES);
                if (redefines == null) continue;
                EList references = redefines.getReferences();
                if (references.contains((Object)feature)) {
                    return (EStructuralFeature)path.get(0);
                }
                List<EStructuralFeature> redefinedFeatures = UML2ModelUtil.getRedefinedFeatures(current);
                for (EStructuralFeature redefinedFeature : redefinedFeatures) {
                    forAnalysis.add(redefinedFeature);
                }
            }
            --i;
        }
        return null;
    }

    @CheckForNull
    public static EStructuralFeature getOppositeRedefinition(EClass eClass, EStructuralFeature feature) {
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            EReference featureOpposite = reference.getEOpposite();
            EList eAllReferences = eClass.getEAllReferences();
            for (EReference eReference : eAllReferences) {
                EList references;
                EAnnotation redefines;
                EReference eOpposite;
                if (reference == eReference || (eOpposite = eReference.getEOpposite()) == null || (redefines = eOpposite.getEAnnotation(ANNOTATION_SOURCE_REDEFINES)) == null || !(references = redefines.getReferences()).contains((Object)featureOpposite)) continue;
                return eReference;
            }
            return null;
        }
        return null;
    }

    private static EStructuralFeature getActualFeature(EClass eContainingClass, EStructuralFeature structuralFeature, Object value) {
        EStructuralFeature feature = structuralFeature;
        if (UML2ModelUtil.isRedefined(eContainingClass, feature)) {
            feature = UML2ModelUtil.getRedefinition(eContainingClass, feature);
            if (value != null) {
                while (feature != structuralFeature && !feature.getEType().isInstance(value)) {
                    List<EStructuralFeature> redefinedFeatures = UML2ModelUtil.getRedefinedFeatures(feature);
                    feature = redefinedFeatures.iterator().next();
                }
            }
        }
        return feature;
    }

    public static boolean isRedefined(EClass eContainingClass, EStructuralFeature feature) {
        Map redefinedFeatures = REDEFINES_CACHE.computeIfAbsent(eContainingClass, k -> new IdentityHashMap());
        return redefinedFeatures.computeIfAbsent(feature, k -> UML2ModelUtil.calculateIsRedefined(eContainingClass, feature));
    }

    private static boolean calculateIsRedefined(EClass eContainingClass, EStructuralFeature feature) {
        boolean res = false;
        EList eAllStructuralFeatures = eContainingClass.getEAllStructuralFeatures();
        int i = 0;
        while (i < eAllStructuralFeatures.size()) {
            EList references;
            EStructuralFeature other = (EStructuralFeature)eAllStructuralFeatures.get(i);
            EAnnotation redefines = other.getEAnnotation(ANNOTATION_SOURCE_REDEFINES);
            if (redefines != null && (references = redefines.getReferences()).contains((Object)feature)) {
                res = true;
                break;
            }
            ++i;
        }
        return res;
    }

    public static boolean isOppositeRedefined(EClass eClass, EStructuralFeature feature) {
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            EReference featureOpposite = reference.getEOpposite();
            EList eAllReferences = eClass.getEAllReferences();
            for (EReference eReference : eAllReferences) {
                EList references;
                EAnnotation redefines;
                EReference eOpposite;
                if (reference == eReference || (eOpposite = eReference.getEOpposite()) == null || (redefines = eOpposite.getEAnnotation(ANNOTATION_SOURCE_REDEFINES)) == null || !(references = redefines.getReferences()).contains((Object)featureOpposite)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isFullyCompatible(EObject obj, EStructuralFeature feature, Object value) {
        return UML2ModelUtil.isFullyCompatibleInternal(obj, feature, value, new HashSet<EStructuralFeature>());
    }

    private static boolean isFullyCompatibleInternal(EObject obj, EStructuralFeature feature, Object value, Set<EStructuralFeature> visited) {
        if (!visited.add(feature)) {
            return true;
        }
        if (!UML2ModelUtil.isCompatible(obj, feature, value)) {
            return false;
        }
        boolean derivedUnion = UML2ModelUtil.isDerivedUnion(feature);
        if (!derivedUnion) {
            List<EStructuralFeature> subsettedFeatures = UML2ModelUtil.getSubsettedFeatures(feature, true);
            for (EStructuralFeature subsettedFeature : subsettedFeatures) {
                if (subsettedFeature.isDerived() || UML2ModelUtil.isFullyCompatibleInternal(obj, subsettedFeature, value, visited)) continue;
                return false;
            }
        }
        if (feature.isChangeable() && derivedUnion && value instanceof EObject) {
            EStructuralFeature subsetFeature = UML2ModelHelper.findFeature((Element)obj, UML2ModelUtil.getActualFeature(obj.eClass(), feature, value), (EObject)value);
            if (subsetFeature == null) {
                return false;
            }
            return UML2ModelUtil.isFullyCompatibleInternal(obj, subsetFeature, value, visited);
        }
        return true;
    }

    public static boolean isCompatible(EObject obj, EStructuralFeature feature, Object value) {
        if (feature.isMany() && value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object object : collection) {
                if (UML2ModelUtil.isCompatibleSingle(obj, feature, object)) continue;
                return false;
            }
            return true;
        }
        return UML2ModelUtil.isCompatibleSingle(obj, feature, value);
    }

    private static boolean isCompatibleSingle(EObject obj, EStructuralFeature feature, Object value) {
        EReference reference;
        EReference opposite;
        if (obj == null || feature == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (!UML2ModelUtil.isCompatibleInternal(obj, feature, value)) {
            return false;
        }
        if (feature instanceof EReference && (opposite = (reference = (EReference)feature).getEOpposite()) != null && value instanceof EObject) {
            return UML2ModelUtil.isCompatibleInternal((EObject)value, (EStructuralFeature)opposite, obj);
        }
        return true;
    }

    public static void checkCompatibility(EObject object, EStructuralFeature structuralFeature, Object value) {
        if (UML2ModelUtil.isCheckCompatibility() && !UML2ModelUtil.isCompatible(object, structuralFeature, value)) {
            throw new IllegalArgumentException("Invalid element's " + String.valueOf(object) + " feature " + (structuralFeature == null ? "null" : structuralFeature.getName()) + " value " + String.valueOf(value));
        }
    }

    private static boolean isCompatibleInternal(EObject obj, EStructuralFeature feature, Object value) {
        EStructuralFeature redefinitionOfReference;
        if (!feature.getEType().isInstance(value)) {
            return false;
        }
        if (feature instanceof EReference && (redefinitionOfReference = UML2ModelUtil.getRedefinition(obj.eClass(), feature)) != null) {
            return redefinitionOfReference.getEType().isInstance(value);
        }
        return true;
    }

    public static boolean isRenamed(EStructuralFeature feature) {
        return feature.getEAnnotation(ANNOTATION_SOURCE__RENAMED) != null;
    }

    public static String getPublicFeatureName(EStructuralFeature feature) {
        String featureName = feature.getName();
        EAnnotation eAnnotation = feature.getEAnnotation(ANNOTATION_SOURCE__RENAMED);
        if (eAnnotation != null) {
            EMap details = eAnnotation.getDetails();
            return (String)details.get((Object)"name");
        }
        return featureName;
    }

    public static String getPrivateFeatureName(EClass containingClass, String publicFeatureName) {
        return UMLPackage.eINSTANCE.getPrivateFeatureName(containingClass, publicFeatureName);
    }

    public static String getChangePropertyName(EObject target, EStructuralFeature structuralFeature, Object value) {
        EReference redefiningReference;
        EReference redefiningReferenceOpposite;
        EStructuralFeature feature;
        EObject valueEObject;
        EClass valueEClass;
        EReference reference;
        EReference eOpposite;
        String featureName = null;
        EClass eClass = target.eClass();
        if (UML2ModelUtil.isRedefined(eClass, structuralFeature)) {
            EStructuralFeature feature2 = UML2ModelUtil.getActualFeature(eClass, structuralFeature, value);
            featureName = UML2ModelUtil.getPublicFeatureName(feature2);
        } else if (structuralFeature instanceof EReference && value instanceof EObject && (eOpposite = (reference = (EReference)structuralFeature).getEOpposite()) != null && UML2ModelUtil.isRedefined(valueEClass = (valueEObject = (EObject)value).eClass(), (EStructuralFeature)eOpposite) && (feature = UML2ModelUtil.getActualFeature(valueEClass, (EStructuralFeature)eOpposite, target)) instanceof EReference && feature.getEType().isInstance((Object)target) && (redefiningReferenceOpposite = (redefiningReference = (EReference)feature).getEOpposite()) != null && !redefiningReferenceOpposite.isDerived() && redefiningReferenceOpposite.getEType().isInstance(value)) {
            featureName = UML2ModelUtil.getPublicFeatureName((EStructuralFeature)redefiningReferenceOpposite);
        }
        if (featureName == null) {
            featureName = UML2ModelUtil.getPublicFeatureName(structuralFeature);
        }
        return featureName;
    }

    public static EStructuralFeature getEStructuralFeature(EClass eClass, String publicFeatureName) {
        return eClass.getEStructuralFeature(UML2ModelUtil.getPrivateFeatureName(eClass, publicFeatureName));
    }

    public static boolean isContainment(EReference reference) {
        return reference.isContainment() || reference.getEAnnotation(ANNOTATION_SOURCE__MD_CONTAINMENT) != null;
    }

    public static boolean isContainer(EReference reference) {
        EReference opposite = reference.getEOpposite();
        return reference.isContainer() || opposite != null && UML2ModelUtil.isContainment(opposite);
    }

    public static List<EReference> getSortedReferences(EClass eClass) {
        List<EReference> collection = SORTED_REFERENCES.get(eClass);
        if (collection != null) {
            return collection;
        }
        ArrayList<EReference> superSets = new ArrayList<EReference>();
        EList eAllReferences = eClass.getEAllReferences();
        List<EReference> sorted = new ArrayList<EReference>(eAllReferences.size());
        for (EReference eReference : eAllReferences) {
            if (UML2ModelUtil.isSuperset(eClass, (EStructuralFeature)eReference)) {
                superSets.add(eReference);
                continue;
            }
            sorted.add(eReference);
        }
        UML2ModelUtil.sortSupersets(superSets);
        sorted.addAll(superSets);
        sorted = Collections.unmodifiableList(sorted);
        SORTED_REFERENCES.put(eClass, sorted);
        return sorted;
    }

    private static void sortSupersets(List<EReference> supersets) {
        if (supersets.size() <= 1) {
            return;
        }
        supersets.sort(new Comparator<EReference>(){

            @Override
            public int compare(EReference r1, EReference r2) {
                List<EStructuralFeature> r1SubsettedFeatures = UML2ModelUtil.getSubsettedFeatures((EStructuralFeature)r1);
                List<EStructuralFeature> r2SubsettedFeatures = UML2ModelUtil.getSubsettedFeatures((EStructuralFeature)r2);
                if (r1SubsettedFeatures.contains(r2)) {
                    return -1;
                }
                if (r2SubsettedFeatures.contains(r1)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static List<EStructuralFeature> getSortedFeatures(EClass eClass) {
        List<EStructuralFeature> eStructuralFeatures = SORTED_FEATURES.get(eClass);
        if (eStructuralFeatures == null) {
            EList eAllAttributes = eClass.getEAllAttributes();
            EList eAllReferences = eClass.getEAllReferences();
            eStructuralFeatures = new ArrayList<EStructuralFeature>(eAllAttributes.size() + eAllReferences.size());
            eStructuralFeatures.addAll((Collection<EStructuralFeature>)eAllAttributes);
            List<EReference> sortedReferences = UML2ModelUtil.getSortedReferences(eClass);
            eStructuralFeatures.addAll(sortedReferences);
            eStructuralFeatures = Collections.unmodifiableList(eStructuralFeatures);
            SORTED_FEATURES.put(eClass, eStructuralFeatures);
        }
        return eStructuralFeatures;
    }

    public static boolean isDerivedButNotUnion(EStructuralFeature feature) {
        return feature.isDerived() && !UML2ModelUtil.isDerivedUnion(feature);
    }

    public static EList<EClass> getEAllSubClasses(EClass eClass) {
        UniqueEList.FastCompare eAllSubClasses = new UniqueEList.FastCompare();
        for (EClassifier eClassifier : UML2ModelUtil.getAllEClassifiers(eClass.getEPackage())) {
            EClass umlEClass;
            if (!(eClassifier instanceof EClass) || (umlEClass = (EClass)eClassifier).isAbstract() || !eClass.isSuperTypeOf(umlEClass)) continue;
            eAllSubClasses.add((Object)umlEClass);
        }
        return eAllSubClasses;
    }

    public static void collectAllEClassifiers(EPackage ePackage, Collection<EClassifier> result) {
        result.addAll((Collection<EClassifier>)ePackage.getEClassifiers());
        for (EPackage aPackage : ePackage.getESubpackages()) {
            UML2ModelUtil.collectAllEClassifiers(aPackage, result);
        }
    }

    public static Collection<EClassifier> getAllEClassifiers(EPackage aPackage) {
        HashSet<EClassifier> result = new HashSet<EClassifier>();
        UML2ModelUtil.collectAllEClassifiers(aPackage, result);
        return result;
    }

    public static boolean isAssignableFrom(EClassifier a, EClassifier b) {
        return a == b || a.getInstanceClass().isAssignableFrom(b.getInstanceClass());
    }

    public static Collection<EClassifier> getCompatibleTypes(EClass eClass, EStructuralFeature feature) {
        return CompatibilityUtil.getCompatibleTypes(eClass, feature);
    }

    public static String getDefault(Property property) {
        return UML2ModelHelper.getDefault(property);
    }

    public static boolean isMDMultiplicityMany(EStructuralFeature feature) {
        boolean many = feature.isMany();
        if (many && UML2ModelUtil.getMdSingleValueFeatures().contains(feature)) {
            many = false;
        }
        return many;
    }
}

