/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.TimeTracker;
import com.nomagic.magicdraw.uml2.util.TimeTrackerImpl;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

@OpenApiAll
public class TimeTrackerFactory {
    private static final TimeTracker DUMMY_TIME_TRACKER = new DummyTimeTracker();
    public static final int DEFAULT_SINGLE_OPERATION_TIMEOUT = 100;
    public static final int DEFAULT_BATCH_OPERATION_TIMEOUT = 500;

    public static TimeTracker create(String message, Logger log) {
        return log.isInfoEnabled() ? TimeTrackerFactory.createTracker(message, log, 100, 500) : DUMMY_TIME_TRACKER;
    }

    public static TimeTracker create(String message, Logger log, Object ... args) {
        return log.isInfoEnabled() ? TimeTrackerFactory.createTracker(String.format(message, args), log, 100, 500) : DUMMY_TIME_TRACKER;
    }

    public static TimeTracker create(String message, Logger log, int oneOperationTimeout, int batchOperationsTimeout) {
        return log.isInfoEnabled() ? TimeTrackerFactory.createTracker(message, log, oneOperationTimeout, batchOperationsTimeout) : DUMMY_TIME_TRACKER;
    }

    private static TimeTrackerImpl createTracker(String message, Logger log, int oneOperationTimeout, int batchOperationsTimeout) {
        return new TimeTrackerImpl(message, log, oneOperationTimeout, batchOperationsTimeout);
    }

    @OpenApiAll
    private static class DummyTimeTracker
    implements TimeTracker {
        private static TimeTracker.TrackedOperation OPERATION = () -> {};

        private DummyTimeTracker() {
        }

        @Override
        public TimeTracker.TrackedOperation start(Object operationName) {
            return OPERATION;
        }

        @Override
        public TimeTracker.TrackedOperation start(Supplier<Object> operationName) {
            return OPERATION;
        }

        @Override
        public void dumpLongest(int count) {
        }

        @Override
        public long getAllTimePassedMillis() {
            return 0L;
        }
    }
}

